/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import java.security.GeneralSecurityException;
import java.security.Principal;
import javax.security.auth.Subject;

public class WSPrincipal
implements Principal {
    private Subject subject;
    private WSCredential creds;

    public WSPrincipal(Subject subject) {
        this.subject = subject;
        this.creds = SubjectHelper.getWSCredentialFromSubject(subject);
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean equals(Object object) {
        if (this.creds == null && object == null) {
            return true;
        }
        if (this.creds == null || object == null) {
            return false;
        }
        return this.creds.equals(object);
    }

    public String getName() {
        try {
            if (this.creds != null) {
                return this.creds.getRealmSecurityName();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            FFDCFilter.processException((Throwable)generalSecurityException, this.getClass().getName() + ".getName()", "66", this);
        }
        return "???";
    }

    public int hashCode() {
        if (this.creds != null) {
            return this.creds.hashCode();
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("securityName: ");
        stringBuffer.append(this.getName()).append(";accessID: ").append(this.getAccessID());
        return stringBuffer.toString();
    }

    protected String getAccessID() {
        try {
            if (this.creds != null) {
                return this.creds.getAccessId();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            FFDCFilter.processException((Throwable)generalSecurityException, this.getClass().getName() + ".getName()", "93", this);
        }
        return "???";
    }
}

