/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIAccessException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CollaboratorCookie;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.SecurityCookie;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityCollaborator;
import com.ibm.ws.security.core.SecurityCookieImpl;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.delegation.Delegation;
import com.ibm.ws.security.delegation.DelegationFactory;
import com.ibm.ws.security.ejb.SecurityBeanCookie;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ServerIdentityHelper;
import com.ibm.ws.security.zOS.threadid.ThreadIdentityManager;
import com.ibm.ws.util.PlatformHelperFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import javax.ejb.EnterpriseBean;
import javax.security.auth.Subject;

public class EJSSecurityCollaborator
extends SecurityCollaborator {
    private static final TraceComponent tc = Tr.register(EJSSecurityCollaborator.class, "Security", "com.ibm.ejs.resources.security");
    private static HashSet UNPROTECTED = new HashSet();
    protected Delegation delegationPolicy;
    private final ThreadIdentityManager threadIdManager;
    private final boolean isZOS;
    private boolean isAppSecurityOn = true;
    private static EJSSecurityCollaborator securityCollaboratorInstance;

    public static EJSSecurityCollaborator getInstance() {
        return securityCollaboratorInstance;
    }

    public EJSSecurityCollaborator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.initializeUnprotected();
        this.delegationPolicy = DelegationFactory.getDelegation();
        this.isAppSecurityOn = WSSecurityHelper.isServerSecurityEnabled();
        this.isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
        this.threadIdManager = this.isZOS ? ThreadIdentityManager.getThreadIdentityManager() : null;
        securityCollaboratorInstance = this;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public CollaboratorCookie preInvoke(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, CollaboratorCookie collaboratorCookie) throws CSIException {
        throw new CSIException("old preInvoke called");
    }

    public CollaboratorCookie preInvoke(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, CollaboratorCookie collaboratorCookie, EnterpriseBean enterpriseBean, Object[] objectArray) throws CSIException {
        Object object;
        Object object2;
        if (!securityEnabled) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke", new Object[]{eJBKey, eJBMethodInfo, collaboratorCookie, enterpriseBean, objectArray});
        }
        String string = ((SecurityBeanCookie)collaboratorCookie).getAppName();
        boolean bl = WSAccessManager.checkIfAdminApp(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "preInvoke", "app_name=" + string + " isAdminApp=" + bl + " isAppSecurityOn=" + this.isAppSecurityOn);
        }
        if (!this.isAppSecurityOn && !bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "preInvoke", "Skip authorization for non-system apps when app security is disabled.");
            }
            return null;
        }
        Subject subject = null;
        Subject subject2 = null;
        Subject subject3 = null;
        try {
            subject = contextManager.getCallerSubject();
            subject2 = contextManager.getInvocationSubject();
            subject3 = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WSSecurityException {
                    return SecurityCollaborator.contextManager.getServerSubject();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.EJSSecurityCollaborator.preInvoke", "192", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting subjects", exception);
            }
            throw new CSIAccessException(exception.getMessage(), (Throwable)exception);
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.core.EJSSecurityCollaborator.preInvoke", "198", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting subjects", wSSecurityException);
            }
            throw new CSIAccessException(wSSecurityException.getMessage(), (Throwable)wSSecurityException);
        }
        Subject[] subjectArray = new Subject[3];
        subjectArray[0] = subject != null ? subject : null;
        subjectArray[1] = subject2;
        this.SetUnauthenticatedSubjectIfNeeded(subject2, subject);
        Subject[] subjectArray2 = null;
        String string2 = EJSSecurityCollaborator.getMethodWithSignature(eJBMethodInfo.getMethodName(), eJBMethodInfo.getMethodSignature());
        string2 = string2 + ":" + eJBMethodInfo.getInterfaceType().getValue();
        subjectArray2 = this.performAuthorization(eJBKey, eJBMethodInfo, subject3, subject, (SecurityBeanCookie)collaboratorCookie, enterpriseBean, objectArray, string2);
        if (subjectArray2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "performAuthorization returned non null retSubjects");
            }
            subject = subjectArray2[1] != null ? subjectArray2[1] : subjectArray2[0];
        }
        Subject subject4 = subject;
        String string3 = eJBMethodInfo.getHomeName();
        final EJBKey eJBKey2 = eJBKey;
        final EJBMethodInfo eJBMethodInfo2 = eJBMethodInfo;
        final CollaboratorCookie collaboratorCookie2 = collaboratorCookie;
        final Subject subject5 = subject3;
        final Subject subject6 = subject;
        final String string4 = string2;
        if (!this.isUnprotected(((SecurityBeanCookie)collaboratorCookie).getBeanName())) {
            try {
                subject4 = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws CSIException {
                        return EJSSecurityCollaborator.this.delegationPolicy.delegate(eJBKey2, eJBMethodInfo2, subject5, subject6, (SecurityBeanCookie)collaboratorCookie2, string4);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                CSIException cSIException = (CSIException)((Object)privilegedActionException.getException());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error getting delegatedSubject");
                }
                if (cSIException instanceof CSIAccessException) {
                    throw (CSIAccessException)cSIException;
                }
                throw new CSIAccessException(cSIException.getMessage());
            }
        }
        this.setSubjects(subject, subject4);
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.isZOS) {
            object2 = eJBMethodInfo.getEJBComponentMetaData();
            bl2 = object2.isApplicationSyncToOSThreadEnabled();
            bl3 = this.threadIdManager.isThreadLocalApplicationSyncEnabled();
        }
        object2 = null;
        if (bl2) {
            try {
                object = subject4;
                object2 = AccessController.doPrivileged(new PrivilegedExceptionAction((Subject)object){
                    private final /* synthetic */ Subject val$privInvokeSubject;
                    {
                        this.val$privInvokeSubject = subject;
                    }

                    public Object run() throws Exception {
                        return EJSSecurityCollaborator.this.threadIdManager.setLocalOSThreadID(this.val$privInvokeSubject);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Thread identity synchronization error", privilegedActionException);
                }
                throw new CSIException(privilegedActionException.getMessage(), (Throwable)privilegedActionException);
            }
        }
        if (bl3) {
            try {
                object = ServerIdentityHelper.getServerIdentityHelper();
                object2 = ((ServerIdentityHelper)object).push();
            }
            catch (Exception exception) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Thread identity synchronization error", exception);
                }
                throw new CSIException(exception.getMessage(), (Throwable)exception);
            }
        }
        if (this.isZOS) {
            this.threadIdManager.setThreadLocalApplicationSyncEnabled(bl2);
        }
        object = (CollaboratorCookie)EJSSecurityCollaborator.getCookie(subjectArray, object2, bl3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke", object);
        }
        return object;
    }

    private final void initializeUnprotected() {
        UNPROTECTED.add("RemoteSRP");
        UNPROTECTED.add("RemoteSRPHome");
        UNPROTECTED.add("SrdSrvltCtxHome");
        UNPROTECTED.add("SessionBMP");
        UNPROTECTED.add("UPManager");
        UNPROTECTED.add("UP_ReadOnly");
        UNPROTECTED.add("UP_ReadWrite");
    }

    protected boolean isUnprotected(String string) {
        return UNPROTECTED.contains(string);
    }

    protected String resolveHomeMethod(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveHomeMethod", string);
        }
        if (string.startsWith("find")) {
            StringBuffer stringBuffer = new StringBuffer(3 + string.length());
            stringBuffer.append("ejb").append(string);
            stringBuffer.setCharAt(3, 'F');
            string = stringBuffer.toString();
        } else {
            string = super.resolveHomeMethod(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveHomeMethod", string);
        }
        return string;
    }

    public void postInvoke(EJBKey eJBKey, EJBMethodInfo eJBMethodInfo, CollaboratorCookie collaboratorCookie, CollaboratorCookie collaboratorCookie2) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke", new Object[]{eJBKey, eJBMethodInfo, collaboratorCookie, collaboratorCookie2});
        }
        if (collaboratorCookie != null) {
            super.postInvokeCommon(eJBKey, eJBMethodInfo, (SecurityCookie)collaboratorCookie, collaboratorCookie2);
            if (this.isZOS) {
                SecurityCookieImpl securityCookieImpl = (SecurityCookieImpl)collaboratorCookie;
                Object object = ((SecurityCookieImpl)collaboratorCookie).syncToThreadToken;
                if (object != null) {
                    try {
                        final Object object2 = object;
                        object = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                EJSSecurityCollaborator.this.threadIdManager.restoreLocalOSThreadID(object2);
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Unable to restore thread identity", privilegedActionException);
                        }
                        throw new CSIException(privilegedActionException.getMessage(), (Throwable)privilegedActionException);
                    }
                }
                this.threadIdManager.setThreadLocalApplicationSyncEnabled(securityCookieImpl.appSyncToOSThread);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke");
        }
    }

    public CollaboratorCookie beanInstalled(EJBConfigData eJBConfigData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beanInstalled", eJBConfigData);
        }
        CollaboratorCookie collaboratorCookie = this.installBean(eJBConfigData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beanInstalled", collaboratorCookie);
        }
        return collaboratorCookie;
    }

    public void beanUninstalled(CollaboratorCookie collaboratorCookie) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beanUninstalled", collaboratorCookie);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beanUninstalled");
        }
    }
}

