/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth.module;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSAdminClientLoginModuleImpl
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private WSPrincipal principal;
    private WSCredential credential;
    protected boolean debug = false;
    private static final TraceComponent tc = Tr.register(WSAdminClientLoginModuleImpl.class, null, "com.ibm.ejs.resources.security");

    public WSAdminClientLoginModuleImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSAdminClientLoginModuleImpl()");
            Tr.exit(tc, "WSAdminClientLoginModuleImpl()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + map.toString() + "\", options = \"" + map2.toString() + "\")");
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WSAdminClientLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean login() throws LoginException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        if (this.callbackHandler == null) {
            throw new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        String string = null;
        char[] cArray = null;
        try {
            this.callbackHandler.handle(callbackArray);
            string = ((NameCallback)callbackArray[0]).getName();
            object = ((PasswordCallback)callbackArray[1]).getPassword();
            if (object != null) {
                cArray = new char[((char[])object).length];
                System.arraycopy(object, 0, cArray, 0, ((char[])object).length);
                ((PasswordCallback)callbackArray[1]).clearPassword();
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.login", "191", this);
            Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), iOException});
            throw new WSLoginFailedException("java.io.IOException from CallbackHandler.handle()", iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            FFDCFilter.processException((Throwable)unsupportedCallbackException, "com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.login", "196", this);
            Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), unsupportedCallbackException.getCallback().toString(), unsupportedCallbackException});
            throw new WSLoginFailedException(unsupportedCallbackException.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user", unsupportedCallbackException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "uid = " + string);
            Tr.debug(tc, "password = " + (cArray == null ? "<null>" : "XXXXXXXX"));
        }
        if (string == null && cArray == null) {
            throw new WSLoginFailedException("No authentication data.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Successfully gathered authentication information");
        }
        if (string == null && cArray == null) throw new WSLoginFailedException("No authentication data");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using uid and password for authentication");
            object = new StringBuffer("Authenticating \"");
            ((StringBuffer)object).append(string).append("\"");
            Tr.debug(tc, ((StringBuffer)object).toString());
        }
        try {
            if (cArray == null) {
                cArray = new char[]{};
            }
            this.credential = new WSCredentialImpl("", string, String.valueOf(cArray));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Credential after authentication: " + this.credential);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.login", "239", this);
            throw new WSLoginFailedException("LoginFailed.", exception);
        }
        try {
            this.principal = null;
            if (this.credential != null) {
                this.principal = ContextManagerFactory.getInstance().createPrincipal(this.credential);
            }
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, "com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.login", "262", this);
            throw new WSLoginFailedException("Failed to create WSPrincipal", wSSecurityException);
        }
        this.succeeded = true;
        if (!tc.isEntryEnabled()) return this.succeeded;
        Tr.exit(tc, "login(): status = " + this.succeeded);
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bl = false;
        if (!this.succeeded) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bl = false;
        } else {
            if (!this.commitSucceeded) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    if (this.credential != null && this.principal != null) {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                if (!WSAdminClientLoginModuleImpl.this.subject.getPrincipals().contains(WSAdminClientLoginModuleImpl.this.principal)) {
                                    WSAdminClientLoginModuleImpl.this.subject.getPrincipals().add(WSAdminClientLoginModuleImpl.this.principal);
                                }
                                if (!WSAdminClientLoginModuleImpl.this.subject.getPublicCredentials().contains(WSAdminClientLoginModuleImpl.this.credential)) {
                                    WSAdminClientLoginModuleImpl.this.subject.getPublicCredentials().add(WSAdminClientLoginModuleImpl.this.credential);
                                }
                                return null;
                            }
                        });
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.commit", "339", this);
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), exception});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bl = this.commitSucceeded;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit(): status = " + bl);
        }
        return bl;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block9: {
                    try {
                        if (WSAdminClientLoginModuleImpl.this.principal != null && WSAdminClientLoginModuleImpl.this.subject.getPrincipals().contains(WSAdminClientLoginModuleImpl.this.principal)) {
                            WSAdminClientLoginModuleImpl.this.subject.getPrincipals().remove(WSAdminClientLoginModuleImpl.this.principal);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.run", "455", this);
                        Tr.error(tc, "security.jaas.removePrinException", new Object[]{this.getClass().getName(), WSAdminClientLoginModuleImpl.this.principal.getName(), exception});
                    }
                    if (WSAdminClientLoginModuleImpl.this.credential != null) {
                        try {
                            if (WSAdminClientLoginModuleImpl.this.subject.getPublicCredentials().contains(WSAdminClientLoginModuleImpl.this.credential)) {
                                WSAdminClientLoginModuleImpl.this.subject.getPublicCredentials().remove(WSAdminClientLoginModuleImpl.this.credential);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.run", "464", this);
                            Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), exception});
                        }
                        try {
                            WSAdminClientLoginModuleImpl.this.credential.destroy();
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.common.auth.module.WSAdminClientLoginModuleImpl.run", "483", this);
                            if (!tc.isDebugEnabled()) break block9;
                            Tr.debug(tc, "Credential destroy failed");
                            Tr.debug(tc, Util.toString(exception));
                        }
                    }
                }
                return null;
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.principal = null;
        this.credential = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }
}

