/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.security.Result;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.wim.registry.util.UserRegistryValidator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ValidateAdminName
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(ValidateAdminName.class, "ValidateAdminName", "com.ibm.ws.security.admintask");
    private String adminUser = null;
    private String registryType = null;
    private String ldapServerType = null;
    ConfigService cs = null;
    Session session = null;
    static final String ldapUR = "LDAPUserRegistry";
    static final String wimUR = "WIMUserRegistry";
    static final String customUR = "CustomUserRegistry";
    static final String localOSUR = "LocalOSUserRegistry";
    static String ldapPropsFile = "/com/ibm/websphere/security/ldap/LdapConfig.properties";

    public ValidateAdminName(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public ValidateAdminName(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return MessageFormatHelper.getFormattedMessage(resourceBundle, string, objectArray);
    }

    public boolean validUserRegType(String string) {
        return string.equalsIgnoreCase(ldapUR) || string.equalsIgnoreCase(wimUR) || string.equalsIgnoreCase(customUR) || string.equalsIgnoreCase(localOSUR);
    }

    public boolean validLdapServerType(String string) {
        return string.equalsIgnoreCase("IBM_DIRECTORY_SERVER") || string.equalsIgnoreCase("IPLANET") || string.equalsIgnoreCase("NETSCAPE") || string.equalsIgnoreCase("NDS") || string.equalsIgnoreCase("DOMINO502") || string.equalsIgnoreCase("SECUREWAY") || string.equalsIgnoreCase("ACTIVE_DIRECTORY") || string.equalsIgnoreCase("CUSTOM");
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        this.adminUser = (String)this.getParameter("adminUser");
        this.registryType = (String)this.getParameter("registryType");
        if (!this.validUserRegType(this.registryType)) {
            String string = this.getMsg(resBundle, "security.admintask.InvalidUserRegType", null);
            throw new CommandValidationException(string);
        }
        this.ldapServerType = (String)this.getParameter("ldapServerType");
        if (this.ldapServerType != null && !this.validLdapServerType(this.ldapServerType)) {
            String string = this.getMsg(resBundle, "security.admintask.InvalidLDAPServerType", null);
            throw new CommandValidationException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        block94: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "afterStepsExecuted");
            }
            super.afterStepsExecuted();
            TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
            if (!taskCommandResultImpl.isSuccessful()) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "unsuccessful at getting TaskCommandResultImpl afterStepsExecuted");
                }
                return;
            }
            ObjectName objectName = null;
            try {
                Serializable serializable;
                Object object;
                int n;
                Object object2;
                String[] stringArray;
                Object object3;
                ArrayList arrayList;
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Security");
                ConfigService configService = ConfigServiceFactory.getConfigService();
                this.session = this.getConfigSession();
                ObjectName objectName3 = configService.resolve(this.session, "Cell=")[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell = " + objectName3.toString());
                }
                if (objectName3 != null) {
                    objectName = configService.queryConfigObjects(this.session, objectName3, objectName2, null)[0];
                }
                ObjectName[] objectNameArray = null;
                ArrayList arrayList2 = (ArrayList)configService.getAttribute(this.session, objectName, "userRegistries");
                for (int i = 0; i < arrayList2.size(); ++i) {
                    arrayList = (AttributeList)arrayList2.get(i);
                    object3 = ConfigServiceHelper.getAttributeValue((AttributeList)arrayList, "_Websphere_Config_Data_Type");
                    if (!object3.toString().equals(this.registryType)) continue;
                    objectNameArray = configService.queryConfigObjects(this.session, null, ConfigServiceHelper.createObjectName((AttributeList)arrayList), null);
                }
                ArrayList<String> arrayList3 = new ArrayList<String>();
                arrayList = new ArrayList();
                object3 = new Properties();
                AttributeList attributeList = configService.getAttributes(this.session, (ObjectName)objectNameArray[0], null, true);
                for (int i = 0; i < attributeList.size(); ++i) {
                    stringArray = (String[])attributeList.get(i);
                    if (stringArray.getValue() == null) continue;
                    if (tc.isDebugEnabled()) {
                        object2 = stringArray.getName();
                        Tr.debug(tc, "name[" + i + "]:  " + (String)object2);
                        if (((String)object2).indexOf("Password") != -1 || ((String)object2).indexOf("password") != -1) {
                            Tr.debug(tc, "value[" + i + "]: " + "XXXXXX");
                        } else {
                            Tr.debug(tc, "value[" + i + "]: " + stringArray.getValue().toString());
                        }
                    }
                    if (stringArray.getName().equals("properties")) {
                        object2 = (ArrayList)configService.getAttribute(this.session, objectNameArray[0], "properties");
                        for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                            AttributeList attributeList2 = (AttributeList)((ArrayList)object2).get(n);
                            for (int j = 0; j < attributeList2.size(); ++j) {
                                object = (Attribute)attributeList2.get(j);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "c = " + object.toString());
                                }
                                if (((Attribute)object).getValue() == null) continue;
                                if (((Attribute)object).getName().equals("name")) {
                                    arrayList3.add(((Attribute)object).getValue().toString());
                                    if (!tc.isDebugEnabled()) continue;
                                    Tr.debug(tc, "cNameProps:add: " + ((Attribute)object).getValue().toString());
                                    continue;
                                }
                                if (!((Attribute)object).getName().equals("value")) continue;
                                arrayList.add(((Attribute)object).getValue().toString());
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "cValueProps:add: " + ((Attribute)object).getValue().toString());
                            }
                        }
                    }
                    ((Properties)object3).setProperty(stringArray.getName(), stringArray.getValue().toString());
                }
                String[] stringArray2 = new String[10];
                stringArray = new String[10];
                object2 = new Properties();
                if (this.registryType.equals(ldapUR)) {
                    n = 0;
                    int n2 = 0;
                    ArrayList arrayList4 = (ArrayList)configService.getAttribute(this.session, objectNameArray[0], "hosts");
                    for (int i = 0; i < arrayList4.size(); ++i) {
                        AttributeList attributeList3 = (AttributeList)arrayList4.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " hostAttrs.size = " + attributeList3.size());
                        }
                        for (int j = 0; j < attributeList3.size(); ++j) {
                            serializable = (Attribute)attributeList3.get(j);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "h = " + serializable.toString());
                            }
                            if (((Attribute)serializable).getValue() == null) continue;
                            if (((Attribute)serializable).getName().equals("host")) {
                                stringArray2[n++] = ((Attribute)serializable).getValue().toString();
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "host[" + (n - 1) + "]: " + ((Attribute)serializable).getValue().toString());
                                continue;
                            }
                            if (!((Attribute)serializable).getName().equals("port")) continue;
                            stringArray[n2++] = ((Attribute)serializable).getValue().toString();
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "port[" + (n2 - 1) + "]: " + ((Attribute)serializable).getValue().toString());
                        }
                    }
                    object = (ArrayList)configService.getAttribute(this.session, objectNameArray[0], "searchFilter");
                    for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                        Attribute attribute = (Attribute)((ArrayList)object).get(i);
                        if (attribute.getValue() == null) continue;
                        ((Properties)object2).setProperty(attribute.getName(), attribute.getValue().toString());
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "name[" + i + "]:  " + attribute.getName());
                        Tr.debug(tc, "value[" + i + "]: " + attribute.getValue().toString());
                    }
                }
                Properties properties = null;
                if (this.registryType.equals(wimUR)) {
                    String string = ((Properties)object3).getProperty("registryClassName");
                    properties = new Properties();
                    properties.setProperty("CustUserRegImplClass", string);
                } else if (this.registryType.equals(customUR)) {
                    String string = ((Properties)object3).getProperty("customRegistryClassName");
                    properties = new Properties();
                    properties.setProperty("CustUserRegImplClass", string);
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        properties.put((String)arrayList3.get(i), (String)arrayList.get(i));
                    }
                } else if (this.registryType.equals(ldapUR)) {
                    properties = new Properties();
                    properties.setProperty("security.registry.ldap.searchTimeLimit", ((Properties)object3).getProperty("searchTimeout"));
                    properties.setProperty("LDAP.server.pwd", ((Properties)object3).getProperty("serverPassword"));
                    properties.setProperty("com.ibm.ssl.remotePort", stringArray[0]);
                    properties.setProperty("com.ibm.ssl.remoteHost", stringArray2[0]);
                    if (this.ldapServerType != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ldapServerType = " + this.ldapServerType);
                        }
                        Properties properties2 = null;
                        try {
                            InputStream inputStream = this.getClass().getResourceAsStream(ldapPropsFile);
                            properties2 = new Properties();
                            properties2.load(inputStream);
                        }
                        catch (IOException iOException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "IOException opening ldapPropsFile");
                            }
                            iOException.printStackTrace();
                            taskCommandResultImpl.setResult(new Boolean(false));
                            object = this.getMsg(resBundle, "security.admintask.ExceptionValidAdminName", null);
                            taskCommandResultImpl.setException(new CommandException(iOException, (String)object));
                            return;
                        }
                        if (properties2 != null) {
                            int n3 = 0;
                            if (this.ldapServerType.equalsIgnoreCase("IBM_DIRECTORY_SERVER")) {
                                n3 = 0;
                            } else if (this.ldapServerType.equalsIgnoreCase("SECUREWAY")) {
                                n3 = 1;
                            } else if (this.ldapServerType.equalsIgnoreCase("IPLANET")) {
                                n3 = 2;
                            } else if (this.ldapServerType.equalsIgnoreCase("NETSCAPE")) {
                                n3 = 3;
                            } else if (this.ldapServerType.equalsIgnoreCase("DOMINO502")) {
                                n3 = 4;
                            } else if (this.ldapServerType.equalsIgnoreCase("NDS")) {
                                n3 = 5;
                            } else if (this.ldapServerType.equalsIgnoreCase("ACTIVE_DIRECTORY")) {
                                n3 = 6;
                            } else if (this.ldapServerType.equalsIgnoreCase("CUSTOM")) {
                                n3 = 7;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "ldapServerTypeValue = " + n3);
                            }
                            switch (n3) {
                                case 0: {
                                    properties.setProperty("user.filter", properties2.getProperty("ibm_dir_server.user.filter"));
                                    properties.setProperty("group.filter", properties2.getProperty("ibm_dir_server.group.filter"));
                                    properties.setProperty("user.idmap", properties2.getProperty("ibm_dir_server.user.idmap"));
                                    properties.setProperty("group.idmap", properties2.getProperty("ibm_dir_server.group.idmap"));
                                    properties.setProperty("groupmember.idmap", properties2.getProperty("ibm_dir_server.groupmember.idmap"));
                                    break;
                                }
                                case 1: {
                                    properties.setProperty("user.filter", properties2.getProperty("secureway.user.filter"));
                                    properties.setProperty("group.filter", properties2.getProperty("secureway.group.filter"));
                                    properties.setProperty("user.idmap", properties2.getProperty("secureway.user.idmap"));
                                    properties.setProperty("group.idmap", properties2.getProperty("secureway.group.idmap"));
                                    properties.setProperty("groupmember.idmap", properties2.getProperty("secureway.groupmember.idmap"));
                                    break;
                                }
                                case 2: {
                                    properties.setProperty("user.filter", properties2.getProperty("iplanet.user.filter"));
                                    properties.setProperty("group.filter", properties2.getProperty("iplanet.group.filter"));
                                    properties.setProperty("user.idmap", properties2.getProperty("iplanet.user.idmap"));
                                    properties.setProperty("group.idmap", properties2.getProperty("iplanet.group.idmap"));
                                    properties.setProperty("groupmember.idmap", properties2.getProperty("iplanet.groupmember.idmap"));
                                    break;
                                }
                                case 3: {
                                    properties.setProperty("user.filter", properties2.getProperty("netscape.user.filter"));
                                    properties.setProperty("group.filter", properties2.getProperty("netscape.group.filter"));
                                    properties.setProperty("user.idmap", properties2.getProperty("netscape.user.idmap"));
                                    properties.setProperty("group.idmap", properties2.getProperty("netscape.group.idmap"));
                                    properties.setProperty("groupmember.idmap", properties2.getProperty("netscape.groupmember.idmap"));
                                    break;
                                }
                                case 4: {
                                    properties.setProperty("user.filter", properties2.getProperty("domino50.user.filter"));
                                    properties.setProperty("group.filter", properties2.getProperty("domino50.group.filter"));
                                    properties.setProperty("user.idmap", properties2.getProperty("domino50.user.idmap"));
                                    properties.setProperty("group.idmap", properties2.getProperty("domino50.group.idmap"));
                                    properties.setProperty("groupmember.idmap", properties2.getProperty("domino50.groupmember.idmap"));
                                    break;
                                }
                                case 6: {
                                    properties.setProperty("user.filter", properties2.getProperty("actived.user.filter"));
                                    properties.setProperty("group.filter", properties2.getProperty("actived.group.filter"));
                                    properties.setProperty("user.idmap", properties2.getProperty("actived.user.idmap"));
                                    properties.setProperty("group.idmap", properties2.getProperty("actived.group.idmap"));
                                    properties.setProperty("groupmember.idmap", properties2.getProperty("actived.groupmember.idmap"));
                                    break;
                                }
                                case 5: {
                                    properties.setProperty("user.filter", properties2.getProperty("edirectory.user.filter"));
                                    properties.setProperty("group.filter", properties2.getProperty("edirectory.group.filter"));
                                    properties.setProperty("user.idmap", properties2.getProperty("edirectory.user.idmap"));
                                    properties.setProperty("group.idmap", properties2.getProperty("edirectory.group.idmap"));
                                    properties.setProperty("groupmember.idmap", properties2.getProperty("edirectory.groupmember.idmap"));
                                    break;
                                }
                            }
                        }
                    } else {
                        properties.setProperty("groupmember.idmap", ((Properties)object2).getProperty("groupMemberIdMap"));
                        properties.setProperty("user.filter", ((Properties)object2).getProperty("userFilter"));
                        properties.setProperty("group.idmap", ((Properties)object2).getProperty("groupIdMap"));
                        properties.setProperty("group.filter", ((Properties)object2).getProperty("groupFilter"));
                        properties.setProperty("user.idmap", ((Properties)object2).getProperty("userIdMap"));
                    }
                    properties.setProperty("security.registry.ldap.reuseConn", ((Properties)object3).getProperty("reuseConnection"));
                    properties.setProperty("dirType", ((Properties)object3).getProperty("type"));
                    if (((Properties)object3).getProperty("sslEnabled").equals("true")) {
                        properties.put("sslEnabled", Boolean.TRUE);
                    } else {
                        properties.put("sslEnabled", Boolean.FALSE);
                    }
                    properties.setProperty("ldap.basedn", ((Properties)object3).getProperty("baseDN"));
                    if (((Properties)object3).getProperty("bindDN") != null && ((Properties)object3).getProperty("bindDN").length() > 0) {
                        properties.setProperty("java.naming.security.principal", ((Properties)object3).getProperty("bindDN"));
                    }
                    if (((Properties)object3).getProperty("bindPassword") != null && ((Properties)object3).getProperty("bindPassword").length() > 0) {
                        properties.setProperty("java.naming.security.credentials", ((Properties)object3).getProperty("bindPassword"));
                    }
                    properties.setProperty("LDAP.server.id", ((Properties)object3).getProperty("serverId"));
                    properties.setProperty("LDAP.server.realm", ((Properties)object3).getProperty("realm"));
                    properties.setProperty("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
                    if (((Properties)object2).getProperty("certificateMapMode").equals("EXACT_DN")) {
                        properties.setProperty("certificate.map.mode", "exactDNMode");
                    } else {
                        properties.setProperty("certificate.map.mode", ((Properties)object2).getProperty("certificateMapMode"));
                    }
                    String string = "ldap://";
                    StringBuffer stringBuffer = new StringBuffer();
                    object = new Integer(389);
                    if (stringArray[0] != null) {
                        object = new Integer(stringArray[0]);
                    }
                    if (stringArray2[0].indexOf(":") != -1) {
                        stringBuffer.append(string).append("[" + stringArray2[0] + "]");
                    } else {
                        stringBuffer.append(string).append(stringArray2[0]);
                    }
                    if (object != null && (Integer)object > 0) {
                        stringBuffer.append(":" + (Integer)object);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ldapUrl = " + stringBuffer.toString());
                    }
                    properties.setProperty("java.naming.provider.url", stringBuffer.toString());
                } else if (this.registryType.equals(localOSUR)) {
                    properties = new Properties();
                    properties.setProperty("security.activeUserRegistryType", "LOCALOS");
                }
                if (properties != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "props = " + properties.toString());
                }
                if (this.registryType.equals(wimUR)) {
                    try {
                        UserRegistryValidator userRegistryValidator;
                        Result result;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "sessionId = " + this.session.toString());
                        }
                        if ((result = (userRegistryValidator = new UserRegistryValidator(this.session.toString())).getUsers(this.adminUser, 100)).getList().isEmpty()) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "user " + this.adminUser + " not found in WIM UR");
                            }
                            taskCommandResultImpl.setResult(new Boolean(false));
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "user " + this.adminUser + " found in WIM UR");
                            }
                            taskCommandResultImpl.setResult(new Boolean(true));
                        }
                        break block94;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        taskCommandResultImpl.setResult(new Boolean(false));
                        String string = this.getMsg(resBundle, "security.admintask.ExceptionValidAdminName", null);
                        taskCommandResultImpl.setException(new CommandException(exception, string));
                        return;
                    }
                }
                taskCommandResultImpl.setResult(new Boolean(true));
                int n4 = 0;
                String string = "getUsers";
                try {
                    object = AdminServiceFactory.getAdminService().getProcessName();
                    ObjectName objectName4 = new ObjectName("WebSphere:type=SecurityAdmin,process=" + (String)object + ",*");
                    Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName4, null).iterator();
                    if (!iterator.hasNext()) {
                        taskCommandResultImpl.setResult(new Boolean(false));
                        return;
                    }
                    objectName4 = (ObjectName)iterator.next();
                    serializable = (Result)AdminServiceFactory.getAdminService().invoke(objectName4, string, new Object[]{this.adminUser, new Integer(100), properties}, new String[]{"java.lang.String", "java.lang.Integer", "java.util.Properties"});
                    if (serializable != null && ((Result)serializable).getList() != null) {
                        n4 = ((Result)serializable).getList().size();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "count = " + n4);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "results or results.getList() was null");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    taskCommandResultImpl.setResult(new Boolean(false));
                    String string2 = this.getMsg(resBundle, "security.admintask.ExceptionValidAdminName", null);
                    taskCommandResultImpl.setException(new CommandException(exception, string2));
                    return;
                }
                if (n4 == 0) {
                    taskCommandResultImpl.setResult(new Boolean(false));
                } else {
                    taskCommandResultImpl.setResult(new Boolean(true));
                }
            }
            catch (Exception exception) {
                taskCommandResultImpl.setResult(new Boolean(false));
                String string = this.getMsg(resBundle, "security.admintask.ExceptionValidAdminName", null);
                taskCommandResultImpl.setException(new CommandException(exception, string));
                return;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

