/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminAppClient;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ExtensionHelper;
import com.ibm.ws.scripting.HelpSupport;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminCmdClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.python.core.Py;
import org.python.core.PySystemState;

public class WasxShell
extends AbstractShell {
    private static final String TRACE_PROP = "com.ibm.ws.scripting.traceString";
    private static final String TRACE_FILE_PROP = "com.ibm.ws.scripting.traceFile";
    private static final String WSADMIN_PROPERTIES = "com.ibm.ws.scripting.wsadminprops";
    private static final String APPEND_TRACE_PROP = "com.ibm.ws.scripting.appendTrace";
    private static TraceComponent tc = Tr.register(WasxShell.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static AbstractShell _shell = null;
    private AdminConfigClient configObject = null;
    private static AdminClient _client = null;
    private AdminAppClient appObject = null;
    private AdminCmdClient cmdObject = null;
    private static final String PROFILES_PROP = "com.ibm.ws.scripting.profiles";

    public WasxShell() {
        this.bundle = ResourceBundle.getBundle("com.ibm.ws.scripting.resources.wscpMessage", Locale.getDefault());
        this.prompt = "wsadmin>";
        this.shutdownInit();
    }

    public static AbstractShell getShell() {
        if (_shell == null) {
            _shell = new WasxShell();
        }
        return _shell;
    }

    public Object executeCommand(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCommands");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCommands");
        }
        return null;
    }

    protected boolean parseAndValidateInput(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseAndValidateInput");
        }
        boolean bl = true;
        boolean bl2 = false;
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl2) {
                this.scriptParms.add(stringArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-javaoption")) {
                ++i;
                continue;
            }
            if (stringArray[i].regionMatches(true, 0, "-help", 0, stringArray[i].length()) || stringArray[i].equals("-?")) {
                this.showHelp();
                bl = false;
                break;
            }
            if (stringArray[i].equalsIgnoreCase("-c")) {
                if (i + 1 < stringArray.length) {
                    this.commands.add(stringArray[++i].trim());
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "DASH_C_NEEDS_FOLLOWING_COMMAND", "\"-c\" must be followed by a command.");
                bl = false;
                break;
            }
            if (stringArray[i].equalsIgnoreCase("-f")) {
                if (i + 1 < stringArray.length) {
                    this.targetScript = stringArray[++i].trim();
                    continue;
                }
                returnCode = this.issueMessage(new Object[]{"-f"}, "OPTION_NEEDS_FOLLOWING_FILENAME", "\"-f\" must be followed by a file name.");
                bl = false;
                break;
            }
            if (stringArray[i].equalsIgnoreCase("-p")) {
                if (i + 1 < stringArray.length) {
                    this.propfiles.add(stringArray[++i].trim());
                    continue;
                }
                returnCode = this.issueMessage(new Object[]{"-p"}, "OPTION_NEEDS_FOLLOWING_FILENAME", "\"-p\" must be followed by a file name.");
                bl = false;
                break;
            }
            if (stringArray[i].equalsIgnoreCase("-profile")) {
                if (i + 1 < stringArray.length) {
                    this.profiles.add(stringArray[++i].trim());
                    continue;
                }
                returnCode = this.issueMessage(new Object[]{"-profile"}, "OPTION_NEEDS_FOLLOWING_FILENAME", "\"-profile\" must be followed by a file name.");
                bl = false;
                break;
            }
            if (stringArray[i].equalsIgnoreCase("-internalLang")) {
                if (i + 1 >= stringArray.length) continue;
                string = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-lang")) {
                if (i + 1 >= stringArray.length) {
                    returnCode = this.issueMessage(new Object[0], "DASH_LANG_NEEDS_FOLLOWING_LANGUAGE", "\"-lang\" must be followed by a language identifier.");
                    bl = false;
                    break;
                }
                this.lang = stringArray[++i];
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-conntype")) {
                if (i + 1 < stringArray.length) {
                    ++i;
                    if ((i = this.processConnType(stringArray, i)) >= 0) continue;
                    bl = false;
                    break;
                }
                returnCode = this.issueMessage(new Object[0], "DASH_CONNTYPE_NEEDS_FOLLOWING_CONN", "-conntype must be followed by connection type information.");
                bl = false;
                break;
            }
            if (stringArray[i].equalsIgnoreCase("-host")) {
                if (i + 1 < stringArray.length) {
                    this.argHost = stringArray[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "HOST_REQUIRES_ARG", "The \"-host\" option requires a host name.");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-port")) {
                if (i + 1 < stringArray.length) {
                    this.argPort = stringArray[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "PORT_REQUIRES_ARG", "The \"-port\" option requires a port number.");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-user") || stringArray[i].equalsIgnoreCase("-username")) {
                if (i + 1 < stringArray.length) {
                    this.argUser = stringArray[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "USER_REQUIRES_ARG", "The \"-user\" option requires a userid.");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-password")) {
                if (i + 1 < stringArray.length) {
                    this.argPassword = stringArray[++i];
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "PASSWORD_REQUIRES_ARG", "The \"-password\" option requires a password.");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-wsadmin_classpath")) {
                if (i + 1 < stringArray.length) {
                    this.argClasspath = stringArray[++i].trim();
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "CLASSPATH_REQUIRES_ARG", "WASX7299E: \"-wsadmin_classpath\" option must be followed by a classpath.");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-jobid")) {
                if (i + 1 < stringArray.length) {
                    this.jobid = stringArray[++i].trim();
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "JOB_ID_REQUIRES_ARG", "WASX7445E: \"-jobId\" option must be followed by a job ID string.");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-tracefile")) {
                if (i + 1 < stringArray.length) {
                    this.logfile = stringArray[++i].trim();
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "TRACE_FILE_REQUIRES_ARG", "WASX7446E: \"-tracefile\" option must be followed by a file path.");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-appendtrace")) {
                if (i + 1 < stringArray.length) {
                    this.appendtrace = stringArray[++i].trim();
                    continue;
                }
                returnCode = this.issueMessage(new Object[0], "APPEND_TRACE_REQUIRES_ARG", "WASX7447E: \"-appendtrace\" option must be followed by a 'true' or 'false'.");
                continue;
            }
            if (stringArray[i].equals("--")) {
                bl2 = true;
                continue;
            }
            this.scriptParms.add(stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseAndValidateInput");
        }
        if (bl) {
            if (this.lang == null && string != null) {
                this.lang = string;
            }
            if (this.lang != null) {
                if (string != null && !string.equalsIgnoreCase(this.lang)) {
                    returnCode = this.issueMessage(new Object[0], "WASX7395E", "You have used both -lang and -internalLang options. However, they do not have the same value. Use either -lang or -internalLang option.");
                    bl = false;
                } else if (string == null && !this.lang.equalsIgnoreCase("jacl") && !this.lang.equalsIgnoreCase("jython")) {
                    returnCode = this.issueMessage(new Object[]{this.lang}, "LANGUAGE_NOT_SUPPORTED", "Language \"" + this.lang + "\" is not supported.");
                    bl = false;
                } else if (!BSFManager.isLanguageRegistered(this.lang)) {
                    returnCode = this.issueMessage(new Object[]{this.lang}, "LANGUAGE_NOT_REGISTERED", "Language \"" + this.lang + "\" is not registered to BSF.");
                    bl = false;
                }
            }
        }
        return bl;
    }

    protected boolean declareBeans(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "declareBeans");
        }
        if (this.mgr == null) {
            return false;
        }
        try {
            if (object != null) {
                this.mgr.declareBean("AdminControl", object, object.getClass());
            }
            HelpSupport helpSupport = null;
            try {
                helpSupport = new HelpSupport(this);
            }
            catch (ScriptingException scriptingException) {
                returnCode = this.retcodeFromMessage(scriptingException.getMessage());
            }
            if (helpSupport != null) {
                this.mgr.declareBean("Help", helpSupport, helpSupport.getClass());
            } else {
                Tr.debug(tc, "Help is null");
            }
            if (this.configObject == null) {
                this.configObject = new AdminConfigClient(this);
            }
            if (this.configObject != null) {
                this.mgr.declareBean("AdminConfig", this.configObject, this.configObject.getClass());
            } else {
                Tr.debug(tc, "Config is null");
            }
            if (this.appObject == null) {
                this.appObject = new AdminAppClient(this);
            }
            this.mgr.declareBean("AdminApp", this.appObject, this.appObject.getClass());
            if (this.cmdObject == null) {
                this.cmdObject = new AdminCmdClient(this, helpSupport, this.mgr);
            } else {
                this.cmdObject.setMgr(this.mgr);
            }
            this.cmdObject.generateAdminCmds();
            ExtensionHelper.processRegisterBeansInExtensions(this.mgr);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "declareBeans");
            }
            return true;
        }
        catch (Exception exception) {
            returnCode = this.logAndIssueMessage(new Object[]{"AdminControl", exception}, "EXCEPTION_DECLARING_BEAN", "BSFException received declaring \"AdminControl\": " + exception, exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "declareBeans");
            }
            return false;
        }
    }

    protected void executeProfiles() {
        block25: {
            Object object;
            Object object2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeProfiles");
            }
            if (this.lang != null && this.lang.equalsIgnoreCase("jython")) {
                String string;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Jython cachedir: " + PySystemState.cachedir);
                }
                object2 = new Locale("en", "US");
                if (System.getProperty("os.name").toLowerCase((Locale)object2).indexOf("windows") == -1 && (string = System.getProperty("jython.cachedir.permission")) != null) {
                    this.setCacheDirPermission(PySystemState.cachedir, string);
                }
                Py.defaultSystemState.setClassLoader(Thread.currentThread().getContextClassLoader());
                if (this.argClasspath != null) {
                    System.setProperty("java.class.path", this.saveClasspath);
                }
            }
            object2 = System.getProperty(PROFILES_PROP);
            int n = 0;
            if (object2 != null) {
                object2 = this.normalizeFQPathName((String)object2);
                object = new StringTokenizer((String)object2, File.pathSeparator, false);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string = ((StringTokenizer)object).nextToken();
                    this.profiles.add(n, string);
                    ++n;
                }
            }
            object = null;
            if (this.profiles.size() <= 0) break block25;
            for (int i = 0; i < this.profiles.size(); ++i) {
                String string;
                Object object3;
                String string2;
                block27: {
                    block28: {
                        String string3;
                        block26: {
                            string2 = (String)this.profiles.get(i);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "processing profile: " + string2);
                            }
                            string3 = null;
                            try {
                                string3 = BSFManager.getLangFromFilename(string2);
                            }
                            catch (BSFException bSFException) {
                                returnCode = this.issueMessage(new Object[]{string2}, "CANNOT_FIND_LANG", "Cannot determine scripting language for file: \"" + string2 + "\" -- please specify \"-lang\" option on the command line.");
                                continue;
                            }
                            if (this.lang != null) break block26;
                            this.lang = string3;
                            break block27;
                        }
                        if (this.lang.equalsIgnoreCase(string3)) break block27;
                        if (i >= n) break block28;
                        object3 = new File(string2);
                        string = ((File)object3).getParent();
                        String string4 = File.separator;
                        String string5 = ((File)object3).getName();
                        int n2 = string5.lastIndexOf(".");
                        if (n2 <= -1) break block27;
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(string);
                        stringBuffer.append(string4);
                        stringBuffer.append(string5.substring(0, n2));
                        if (this.lang.equalsIgnoreCase("jacl")) {
                            stringBuffer.append(".jacl");
                        } else if (this.lang.equalsIgnoreCase("jython")) {
                            stringBuffer.append(".py");
                        }
                        string2 = stringBuffer.toString();
                        if (!tc.isDebugEnabled()) break block27;
                        Tr.debug(tc, "converted profile name: " + string2);
                        break block27;
                    }
                    returnCode = this.issueMessage(new Object[]{string2, this.lang}, "WASX7227W", "Profile " + string2 + " is in the wrong language and will not be executed; language used is " + this.lang);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "using language: " + this.lang);
                }
                try {
                    if (this.zos) {
                        object3 = System.getProperty("profile.encoding");
                        if (object3 != null) {
                            object = new InputStreamReader((InputStream)new FileInputStream(string2), (String)object3);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "using encoding: " + (String)object3);
                            }
                        } else {
                            object = new FileReader(string2);
                        }
                    } else {
                        object = new FileReader(string2);
                    }
                    object3 = this.getSanitizedScriptString((Reader)object);
                    this.mgr.exec(this.lang, string2, 0, 0, object3);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    returnCode = this.logAndIssueMessage(new Object[]{string2}, "FILE_NOT_FOUND", "Cannot find file \"" + string2 + "\"", fileNotFoundException);
                    continue;
                }
                catch (IOException iOException) {
                    returnCode = this.logAndIssueMessage(new Object[]{string2, iOException}, "ERROR_READING_FILE", "Cannot read file \"" + string2 + "\"", iOException);
                    continue;
                }
                catch (BSFException bSFException) {
                    string = this.getStringFromException(bSFException);
                    this.logException(bSFException, string);
                    returnCode = this.issueMessage(new Object[]{string2, string}, "ERROR_RUNNING_FILE", "Problem running file \"" + string2 + "\"");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeProfiles");
        }
    }

    public void setCacheDirPermission(File file, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCacheDirPermission " + file);
        }
        boolean bl = false;
        try {
            String string2 = file.getCanonicalPath();
            String string3 = "chmod -R " + string + " " + string2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "executing command: \"" + string3 + "\"");
            }
            Process process = Runtime.getRuntime().exec(string3);
            process.waitFor();
            if (process.exitValue() != 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "command exitcode: " + process.exitValue());
                }
                bl = true;
            }
        }
        catch (IOException iOException) {
            this.logException(iOException);
            bl = true;
        }
        catch (InterruptedException interruptedException) {
            this.logException(interruptedException);
            bl = true;
        }
        if (bl) {
            returnCode = this.issueMessage(new Object[]{string, file}, "UNABLE_TO_SET_PERMISSION", "Unable to set permission \"" + string + "\" for jython cache directory \"" + file + "\"");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCacheDirPermission");
        }
    }

    protected void showHelp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "showHelp");
        }
        Object[] objectArray = new Object[]{};
        String string = this.getFormattedMessage("GENERAL_HELP", objectArray, "Syntax: wsadmin [options]");
        System.out.println(string);
        returnCode = this.retcodeFromMessage(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "showHelp");
        }
    }

    protected String getTargetScript() {
        return this.targetScript;
    }

    protected void initializePropFileSet() {
        Object object;
        Object object2;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializePropFileSet");
        }
        URL uRL = Thread.currentThread().getContextClassLoader().getResource("wsadmin.properties");
        InputStream inputStream = null;
        if (uRL != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attempting to use resource from classloader");
            }
            try {
                inputStream = uRL.openStream();
                System.getProperties().load(inputStream);
                this.loadedPropfiles.add(uRL.getFile());
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "caught exception: " + iOException.toString());
                }
                uRL = null;
            }
        }
        if (uRL == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attempting to use user.install.root/properties");
            }
            if ((string = System.getProperty("user.install.root")) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attempting to use was.install.root/properties");
                }
                string = System.getProperty("was.install.root");
            }
            if (((File)(object2 = new File((String)(object = string + File.separator + "properties" + File.separator + "wsadmin.properties")))).canRead()) {
                try {
                    System.getProperties().load(new FileInputStream((File)object2));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    returnCode = this.issueMessage(new Object[]{object}, "FILE_NOT_FOUND", "Cannot find file " + (String)object);
                }
                catch (IOException iOException) {
                    returnCode = this.issueMessage(new Object[]{object, iOException}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file; exception information: " + iOException);
                }
                this.loadedPropfiles.add(((File)object2).getAbsolutePath());
            }
        }
        if ((string = System.getProperty("user.home")) == null) {
            string = File.separator;
        } else if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + "wsadmin.properties";
        object = new File(string);
        if (((File)object).canRead()) {
            try {
                System.getProperties().load(new FileInputStream((File)object));
            }
            catch (FileNotFoundException fileNotFoundException) {
                returnCode = this.logAndIssueMessage(new Object[]{string}, "FILE_NOT_FOUND", "Cannot find file " + string, fileNotFoundException);
            }
            catch (IOException iOException) {
                returnCode = this.issueMessage(new Object[]{string, iOException}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file; exception information: " + iOException);
            }
            this.loadedPropfiles.add(((File)object).getAbsolutePath());
        }
        if ((object2 = System.getProperty(WSADMIN_PROPERTIES)) != null && ((String)object2).length() > 0) {
            object = new File((String)object2);
            try {
                System.getProperties().load(new FileInputStream((File)object));
            }
            catch (FileNotFoundException fileNotFoundException) {
                returnCode = this.logAndIssueMessage(new Object[]{object2}, "FILE_NOT_FOUND", "Cannot find file " + (String)object2, fileNotFoundException);
            }
            catch (IOException iOException) {
                returnCode = this.issueMessage(new Object[]{object2, iOException}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file; exception information: " + iOException);
            }
            this.loadedPropfiles.add(((File)object).getAbsolutePath());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializePropFileSet");
        }
    }

    protected int retcodeFromMessage(String string) {
        int n = 0;
        if (string.startsWith("WASX")) {
            String string2 = string.substring(4, 8);
            try {
                n = Integer.parseInt(string2);
                n %= 256;
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    protected void setTrace() {
        String string;
        String string2 = System.getProperty(TRACE_PROP);
        Object var2_2 = null;
        if (this.logfile == null) {
            this.logfile = System.getProperty(TRACE_FILE_PROP);
        }
        boolean bl = true;
        if (this.logfile != null && !ManagerAdmin.isLogFileWriteable(this.logfile)) {
            string = new File(this.logfile).getAbsolutePath();
            returnCode = this.issueMessage(new Object[]{string}, "TRACEFILE_NOT_WRITTABLE", "WASX7448E: The trace file cannot be written to location \"" + string + "\" Please specify a different location with -tracefile option.");
            bl = false;
        }
        if (bl) {
            string = null;
            string = this.logfile != null ? "named file" : "stdout";
            if (this.appendtrace == null) {
                this.appendtrace = System.getProperty(APPEND_TRACE_PROP);
            }
            if (this.appendtrace != null && this.appendtrace.trim().equalsIgnoreCase("true")) {
                ManagerAdmin.configureClientTrace(string2, string, this.logfile, false, null, false);
            } else {
                ManagerAdmin.configureClientTrace(string2, string, this.logfile, true, null, false);
            }
        }
    }

    protected void welcome() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "welcome");
        }
        Object[] objectArray = new Object[]{};
        String string = new String();
        if (this.lang == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "welcome -- no lang.");
            }
            return;
        }
        if (this.lang.equalsIgnoreCase("jacl")) {
            string = this.getFormattedMessage("JACL_WELCOME_HELP", objectArray, "For help, enter: \"$Help help\"");
        } else if (this.lang.equalsIgnoreCase("javascript")) {
            string = this.getFormattedMessage("JAVASCRIPT_WELCOME_HELP", objectArray, "For help, enter: \"Help.help()");
        } else if (this.lang.equalsIgnoreCase("jython")) {
            string = this.getFormattedMessage("JYTHON_WELCOME_HELP", objectArray, "For help, enter: \"Help.help()");
        }
        System.out.println(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "welcome");
        }
    }

    protected boolean timeToGo() {
        boolean bl = true;
        try {
            if (this.configObject != null) {
                bl = !this.configObject.hasChanges();
            }
        }
        catch (ScriptingException scriptingException) {
            Tr.audit(tc, "WASX7331I", new Object[]{scriptingException.toString()});
        }
        return bl;
    }

    protected void leaving(boolean bl) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "leaving");
        }
        boolean bl2 = true;
        try {
            if (this.connProps != null && this.connProps.getProperty("type").equalsIgnoreCase("RMI")) {
                string = this.connProps.getProperty("securityEnabled");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "security flag is " + string);
                }
                if (string != null && string.equalsIgnoreCase("true")) {
                    _client = AdminClientFactory.createAdminClient(this.connProps);
                }
            }
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "leaving: connect to adminservice fail" + exception);
            }
            return;
        }
        if (this.configObject != null) {
            try {
                this.configObject.checkService();
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "leaving; config service not running");
                }
                return;
            }
            try {
                bl2 = this.configObject.hasChanges();
                if (bl2) {
                    if (bl) {
                        this.configObject.save();
                    } else {
                        string = this.getTargetScript();
                        if (string != null) {
                            Object[] objectArray = new Object[]{string};
                            Tr.audit(tc, "WASX7309W", objectArray);
                            String string2 = this.getFormattedMessage("WASX7309W", objectArray, "No \"save\" was performed before the script " + string + " exited; configuration changes will not be saved.");
                            System.out.println(string2);
                        } else {
                            Object[] objectArray = new Object[]{};
                            Tr.audit(tc, "WASX7341W", objectArray);
                            String string3 = this.getFormattedMessage("WASX7341W", objectArray, "No \"save\" was performed before the interactive session exited; configuration changes will not be saved.");
                            System.out.println(string3);
                        }
                    }
                }
                this.configObject.reset();
            }
            catch (Exception exception) {
                this.setLastException(exception);
                String string4 = this.getStringFromException(null);
                this.logException(null, string4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "leaving");
        }
    }

    public static void main(String[] stringArray) {
        AbstractShell abstractShell = WasxShell.getShell();
        abstractShell.run(stringArray);
        System.exit(returnCode);
    }

    public void shutdownInit() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                WasxShell.this.leaving(false);
            }
        });
    }
}

