/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.exception.AppRefException;
import com.ibm.ws.exception.WsException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class ExceptionSupport {
    private static TraceComponent tc = Tr.register(ExceptionSupport.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static ResourceBundle bundle = null;
    private static final String nl = System.getProperty("line.separator");

    public static void setBundle(ResourceBundle resourceBundle) {
        bundle = resourceBundle;
    }

    public static String getMessage(Throwable throwable, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessage");
        }
        Object var2_2 = null;
        String string2 = null;
        if (throwable == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getMessage - null");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "class is " + throwable.getClass().getName());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "tostring is " + throwable.toString());
        }
        Throwable throwable2 = null;
        String string3 = null;
        if (throwable instanceof AppRefException) {
            string2 = ExceptionSupport.decodeAppRefException((AppRefException)throwable);
        } else if (throwable instanceof WsException) {
            throwable2 = ((WsException)throwable).getCause();
            if (throwable2 != null) {
                string2 = ExceptionSupport.getMessage(throwable2, string);
            } else {
                string3 = throwable.getMessage();
                if (string != null && string2 != null && !string2.startsWith(string)) {
                    string3 = throwable.toString();
                }
                if (string3 == null) {
                    string3 = throwable.toString();
                }
            }
        } else if (throwable instanceof MBeanException) {
            throwable2 = ((MBeanException)throwable).getTargetException();
            string2 = ExceptionSupport.getMessage(throwable2, string);
        } else if (throwable instanceof AppDeploymentException) {
            string3 = ((AppDeploymentException)throwable).toString();
            throwable2 = ((AppDeploymentException)throwable).getEmbeddedEx();
            if (throwable2 != null) {
                string2 = ExceptionSupport.getMessage(throwable2, string);
            }
        } else if (throwable instanceof ReflectionException) {
            throwable2 = ((ReflectionException)throwable).getTargetException();
            string2 = ExceptionSupport.getMessage(throwable2, string);
        } else if (throwable instanceof JMException) {
            string3 = throwable.getMessage();
            if (string3 == null) {
                string3 = throwable.toString();
            }
        } else if (throwable instanceof RuntimeErrorException) {
            throwable2 = ((RuntimeErrorException)throwable).getTargetError();
            string2 = ExceptionSupport.getMessage(throwable2, string);
        } else if (throwable instanceof RuntimeMBeanException) {
            throwable2 = ((RuntimeMBeanException)throwable).getTargetException();
            string2 = ExceptionSupport.getMessage(throwable2, string);
            if (string2 == null) {
                string2 = ExceptionSupport.decodeRuntimeException((RuntimeException)throwable2);
            }
        } else if (throwable instanceof RuntimeOperationsException) {
            throwable2 = ((RuntimeOperationsException)throwable).getTargetException();
            string2 = ExceptionSupport.getMessage(throwable2, string);
        } else if (throwable instanceof JMRuntimeException) {
            string3 = throwable.getMessage();
            if (string3 == null) {
                string3 = throwable.toString();
            }
        } else {
            string3 = throwable.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(throwable.getClass().getName());
        if (string3 != null) {
            stringBuffer.append(": ");
            stringBuffer.append(string3);
        }
        stringBuffer.append(nl);
        if (string2 != null && !string2.trim().equals("")) {
            stringBuffer.append(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessage " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public static String getDiagnosticInfo(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDiagnosticInfo");
        }
        Object var1_1 = null;
        Object var2_2 = null;
        if (exception == null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getDiagnosticInfo - null");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "class is " + exception.getClass().getName());
        }
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private static String decodeRuntimeException(RuntimeException runtimeException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decodeRuntimeException");
        }
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (runtimeException instanceof UnsupportedOperationException) {
            string = bundle.getString("WASX7130E");
        } else {
            string = bundle.getString("WASX7131E");
            objectArray = new Object[]{runtimeException.getClass().getName()};
        }
        string2 = MessageFormat.format(string, objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodeRuntimeException - " + string2);
        }
        return string2;
    }

    private static String decodeAppRefException(AppRefException appRefException) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decodeRuntimeException");
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = appRefException.getAppListString();
        String string3 = appRefException.getObjectListString();
        if (!string2.equals("")) {
            string = bundle.getString("WASX7398E");
            stringBuffer.append(string);
            stringBuffer.append(string2);
        }
        if (!string3.equals("")) {
            string = bundle.getString("WASX7399E");
            stringBuffer.append(string);
            stringBuffer.append(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodeAppRefException - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

