/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import [Ljava.lang.String;;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.DownloadFile;
import com.ibm.websphere.management.cmdframework.UploadFile;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ObjectNameHelper;
import com.ibm.ws.scripting.ScriptingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class DefaultStringHandler
implements StringHandler {
    private static TraceComponent tc = Tr.register(DefaultStringHandler.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String DOMAIN = "WebSphere";
    protected AbstractShell _shell;
    protected LanguageUtilities _langutils;

    public DefaultStringHandler(LanguageUtilities languageUtilities) {
        this._langutils = languageUtilities;
        this._shell = null;
        this.init();
    }

    public DefaultStringHandler(AbstractShell abstractShell) {
        this._shell = abstractShell;
        this._langutils = this._shell.getLangUtils();
        this.init();
    }

    private void init() {
        HandlerRegistry.registerHandler(this, String.class);
        HandlerRegistry.registerHandler(this, Boolean.class);
        HandlerRegistry.registerHandler(this, Character.class);
        HandlerRegistry.registerHandler(this, Integer.class);
        HandlerRegistry.registerHandler(this, Long.class);
        HandlerRegistry.registerHandler(this, Byte.class);
        HandlerRegistry.registerHandler(this, Short.class);
        HandlerRegistry.registerHandler(this, Float.class);
        HandlerRegistry.registerHandler(this, Double.class);
        HandlerRegistry.registerHandler(this, URL.class);
        HandlerRegistry.registerHandler(this, ObjectName.class);
        HandlerRegistry.registerHandler(this, Properties.class);
        HandlerRegistry.registerHandler(this, Integer.TYPE);
        HandlerRegistry.registerHandler(this, Long.TYPE);
        HandlerRegistry.registerHandler(this, Boolean.TYPE);
        HandlerRegistry.registerHandler(this, Character.TYPE);
        HandlerRegistry.registerHandler(this, Byte.TYPE);
        HandlerRegistry.registerHandler(this, Short.TYPE);
        HandlerRegistry.registerHandler(this, Float.TYPE);
        HandlerRegistry.registerHandler(this, Double.TYPE);
        HandlerRegistry.registerHandler(this, String;.class);
        HandlerRegistry.registerHandler(this, UploadFile.class);
        HandlerRegistry.registerHandler(this, DownloadFile.class);
    }

    public String formDisplayString(Object object, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formDisplayString", new Object[]{object});
        }
        String string2 = new String();
        if (object != null) {
            if (object instanceof Properties) {
                string2 = this._langutils.propertiesToString((Properties)object);
            } else if (object instanceof ObjectName) {
                String string3 = ((ObjectName)object).getKeyProperty("_Websphere_Config_Data_Id");
                string2 = string3 != null ? ObjectNameHelper.getListingName((ObjectName)object) : object.toString();
            } else if (object.getClass().isArray()) {
                string2 = this.formArrayDisplayString(object, string);
            } else if (object instanceof AttributeList) {
                AttributeList attributeList = (AttributeList)object;
                for (int i = 0; i < attributeList.size(); ++i) {
                    String string4 = ((Attribute)attributeList.get(i)).getName();
                    Object object2 = ((Attribute)attributeList.get(i)).getValue();
                    if (object2 != null) {
                        Class<?> clazz = object2.getClass();
                        StringHandler stringHandler = HandlerRegistry.getHandler(clazz);
                        if (stringHandler == null) {
                            stringHandler = this;
                        }
                        attributeList.set(i, new Attribute(string4, stringHandler.formDisplayString(object2, string)));
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attribute name " + string4 + " has no value");
                    }
                    attributeList.set(i, new Attribute(string4, new String()));
                }
                string2 = this._langutils.attributeListToString(attributeList);
            } else {
                string2 = object instanceof Collection ? this.formCollectionDisplayString((Collection)object, string) : object.toString();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formDisplayString - " + string2);
        }
        return string2;
    }

    public Object formValidObject(String string, Class clazz, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formValidObject - ", new Object[]{string, clazz.getName(), string2});
        }
        Object object = null;
        if (string.equalsIgnoreCase("null")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created null");
            }
        } else if (clazz == String;.class) {
            object = this._langutils.stringToStringArray(string);
        } else if (clazz.isArray()) {
            object = this._langutils.stringToObjectArray(string, clazz);
        } else if (clazz == Integer.class || clazz == Integer.TYPE) {
            object = new Integer(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Integer");
            }
        } else if (clazz == Long.class || clazz == Long.TYPE) {
            object = new Long(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Long");
            }
        } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            if (!string.equalsIgnoreCase("true") && !string.equalsIgnoreCase("false")) {
                String string3 = ObjectNameHelper.getFormattedMessage("WASX7435W", "Value " + string + " is converted to a boolean" + " value of false.", new Object[]{string});
                System.out.println(string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string3);
                }
            }
            object = new Boolean(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Boolean");
            }
        } else if (clazz == Character.class || clazz == Character.TYPE) {
            object = new Character(string.charAt(0));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Character");
            }
        } else if (clazz == Byte.class || clazz == Byte.TYPE) {
            object = new Byte(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Byte");
            }
        } else if (clazz == Short.class || clazz == Short.TYPE) {
            object = new Short(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Short");
            }
        } else if (clazz == Float.class || clazz == Float.TYPE) {
            object = new Float(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Float");
            }
        } else if (clazz == Double.class || clazz == Double.TYPE) {
            object = new Double(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Double");
            }
        } else if (clazz == URL.class) {
            if (string.trim().equals("")) {
                object = null;
            } else {
                try {
                    object = new URL(new String(string));
                }
                catch (MalformedURLException malformedURLException) {
                    if (this._shell != null) {
                        this._shell.setAndThrowScriptingException("MALFORMED_URL", "String \"" + string + "\" is malformed; cannot create URL", new Object[]{string});
                    }
                    throw new ScriptingException(ObjectNameHelper.getFormattedMessage("MALFORMED_URL", "String \"" + string + "\" is malformed; cannot create URL", new Object[]{string}));
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created URL");
            }
        } else if (clazz == ObjectName.class) {
            try {
                object = ObjectNameHelper.makeObjectName(string);
            }
            catch (ScriptingException scriptingException) {
                if (this._shell != null) {
                    this._shell.setLastException(scriptingException);
                }
                throw scriptingException;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created ObjectName");
            }
        } else if (clazz == Properties.class) {
            if (string == null || string.trim().equals(this._langutils.getOpenNestedAttribute() + this._langutils.getCloseNestedAttribute())) {
                object = new Properties();
            } else {
                String string4 = null;
                if (string.startsWith("{") && string.endsWith("}") && (string4 = string.substring(1, string.length() - 1).trim()).startsWith("{") && string4.endsWith("}")) {
                    string = string4;
                }
                object = this._langutils.stringToProperties(string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created Properties");
            }
        } else if (clazz == UploadFile.class) {
            object = new UploadFile(string);
        } else if (clazz == DownloadFile.class) {
            object = new DownloadFile(string);
        } else {
            object = new String(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "...created String");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formValidObject");
        }
        return object;
    }

    private String formArrayDisplayString(Object object, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formArrayDisplayString");
        }
        Object[] objectArray = null;
        objectArray = (Object[])object;
        Class<?> clazz = object.getClass().getComponentType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "class of elements is " + (clazz == null ? "null" : clazz.getName()));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "input to formDisplayString - " + objectArray[i].toString());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Class:  - " + objectArray[i].getClass().getName());
                }
                arrayList.add(this.formDisplayString(objectArray[i], string));
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "oarray[" + i + "] is null ");
            }
            arrayList.add(new String());
        }
        String string2 = this._langutils.setToString(arrayList, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formArrayDisplayString - " + string2);
        }
        return string2;
    }

    private String formCollectionDisplayString(Collection collection, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formCollectionDisplayString");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = collection.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "element", e);
            }
            if (e != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Class:  - " + e.getClass().getName());
                }
                arrayList.add(this.formDisplayString(e, string));
                continue;
            }
            arrayList.add(new String());
        }
        object = this._langutils.setToString(arrayList, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formCollectionDisplayString", object);
        }
        return object;
    }
}

