/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.configservice.SystemAttributes;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.ScriptingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ConfigHelper {
    private static TraceComponent tc = Tr.register(ConfigHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private AbstractShell _shell = null;
    private String _domain = null;

    public ConfigHelper(AbstractShell abstractShell, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigHelper");
        }
        this._shell = abstractShell;
        this._domain = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigHelper");
        }
    }

    public Hashtable parseObjectIdString(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseObjectIdString: " + string);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string != null) {
            int n;
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            String string2 = null;
            String string3 = null;
            if (!string.endsWith(")")) {
                this._shell.setAndThrowScriptingException("WASX7077E", "incomplete config id", new Object[]{string});
            }
            if ((n = string.lastIndexOf("(")) < 0) {
                this._shell.setAndThrowScriptingException("WASX7078E", "missing config id", new Object[]{string});
            }
            string3 = string.substring(n + 1, string.length() - 1);
            if (n > 0) {
                string2 = string.substring(0, n);
            }
            hashtable.put("_Websphere_Config_Data_Id", string3);
            if (string2 != null) {
                hashtable.put("_Websphere_Config_Data_Display_Name", string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseObjectIdString:");
        }
        return hashtable;
    }

    public ObjectName stringToObjectName(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stringToObjectName: " + string);
        }
        ObjectName objectName = null;
        Hashtable hashtable = this.parseObjectIdString(string);
        if (hashtable.size() > 0) {
            try {
                objectName = new ObjectName(this._domain, hashtable);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                this._shell.setAndThrowScriptingException("MALFORMED_OBJECT_NAME", "Malformed object name", new Object[]{hashtable.toString()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stringToObjectName:");
        }
        return objectName;
    }

    public String getListingName(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getListingName");
        }
        String string = null;
        if (objectName != null) {
            String string2 = objectName.getKeyProperty("_Websphere_Config_Data_Display_Name");
            String string3 = objectName.getKeyProperty("_Websphere_Config_Data_Id");
            string = string2 != null ? string2 + "(" + string3 + ")" : "(" + string3 + ")";
            if (string.indexOf(" ") >= 0) {
                string = "\"" + string + "\"";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getListingName");
        }
        return string;
    }

    protected String nameToResolveString(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nameToResolveString", new Object[]{string});
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/:", true);
        Object var4_4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            boolean bl4 = true;
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                if (bl4 && !(string2 = stringTokenizer.nextToken()).equals("/")) {
                    this._shell.setAndThrowScriptingException("INVALID_OBJECT_NAME", "Invalid object name: " + string, new Object[]{string});
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("/")) {
                    bl4 = false;
                    string4 = "";
                } else {
                    bl4 = true;
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(":");
                }
                stringBuffer.append(string2);
                stringBuffer.append("=");
                stringBuffer.append(string4);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            bl2 = true;
            bl = true;
        }
        if (bl) {
            this._shell.setAndThrowScriptingException("INVALID_OBJECT_NAME", "Invalid object name: " + string, new Object[]{string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nameToResolveString", new Object[]{stringBuffer.toString()});
        }
        return stringBuffer.toString();
    }

    protected AttributeList stripSystemAttrs(AttributeList attributeList) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stripSystemAttrs");
        }
        AttributeList attributeList2 = new AttributeList();
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            if (!SystemAttributes.isSystemAttribute(attribute.getName())) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Adding: " + attribute.getName());
                }
                attributeList2.add(attribute);
                continue;
            }
            if (!tc.isEntryEnabled()) continue;
            Tr.debug(tc, "Not adding; system attribute: " + attribute.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stripSystemAttrs");
        }
        return attributeList2;
    }

    public String cleanString(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanString");
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanString");
        }
        return string;
    }

    public AttributeList merge(AttributeList attributeList, AttributeList attributeList2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge");
        }
        AttributeList attributeList3 = new AttributeList();
        for (int i = 0; i < attributeList2.size(); ++i) {
            ArrayList arrayList;
            Attribute attribute;
            String string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute number: " + i);
            }
            if (SystemAttributes.isSystemAttribute(string = (attribute = (Attribute)attributeList2.get(i)).getName())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sys attr " + string);
                }
                attributeList3.add(attribute);
                continue;
            }
            Object object = this.findAttribute(attributeList, string);
            if (object == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old value for " + string + " null");
                }
                attributeList3.add(attribute);
                continue;
            }
            if (object instanceof AttributeList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old value  for " + string + " AttributeList");
                }
                arrayList = (AttributeList)attribute.getValue();
                AttributeList attributeList4 = this.innerMerge((AttributeList)object, (AttributeList)arrayList);
                attributeList3.add(new Attribute(string, attributeList4));
                continue;
            }
            if (object instanceof ArrayList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old value  for " + string + " ArrayList");
                }
                if ((arrayList = (ArrayList)attribute.getValue()).size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deleting list because new list has size zero.");
                    }
                    object = arrayList;
                } else {
                    for (int j = 0; j < arrayList.size(); ++j) {
                        ((ArrayList)object).add(arrayList.get(j));
                    }
                }
                attributeList3.add(new Attribute(string, object));
                continue;
            }
            if (object instanceof ObjectName) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old value  for " + string + " ObjectName");
                }
                attributeList3.add(attribute);
                continue;
            }
            if (object.getClass().isArray()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old value  for " + string + " Array");
                }
                attributeList3.add(attribute);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "old value  for " + string + " type " + object.getClass().getName());
            }
            attributeList3.add(attribute);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
        return attributeList3;
    }

    public AttributeList innerMerge(AttributeList attributeList, AttributeList attributeList2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "innerMerge");
        }
        AttributeList attributeList3 = new AttributeList();
        for (int i = 0; i < attributeList.size(); ++i) {
            ArrayList arrayList;
            ArrayList arrayList2;
            Attribute attribute;
            String string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Attribute number: " + i);
            }
            if (SystemAttributes.isSystemAttribute(string = (attribute = (Attribute)attributeList.get(i)).getName())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sys attr " + string);
                }
                attributeList3.add(attribute);
                continue;
            }
            Object object = this.findAttribute(attributeList2, string);
            if (object == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "new value null");
                continue;
            }
            if (object instanceof AttributeList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new value AttributeList");
                }
                arrayList2 = (AttributeList)attribute.getValue();
                arrayList = this.innerMerge((AttributeList)arrayList2, (AttributeList)object);
                attributeList3.add(new Attribute(string, arrayList));
                continue;
            }
            if (object instanceof ArrayList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new value ArrayList");
                }
                arrayList2 = (ArrayList)attribute.getValue();
                arrayList = (ArrayList)object;
                if (arrayList.size() == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deleting list because new list has size zero.");
                    }
                    arrayList2 = arrayList;
                } else {
                    for (int j = 0; j < arrayList.size(); ++j) {
                        arrayList2.add(arrayList.get(j));
                    }
                }
                attributeList3.add(new Attribute(string, arrayList2));
                continue;
            }
            if (object instanceof ObjectName) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new value ObjectName");
                }
                attributeList3.add(new Attribute(string, object));
                continue;
            }
            if (object.getClass().isArray()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new value Array");
                }
                attributeList3.add(new Attribute(string, object));
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "new value type " + object.getClass().getName());
            }
            attributeList3.add(new Attribute(string, object));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "innerMerge");
        }
        return attributeList3;
    }

    Object findAttribute(AttributeList attributeList, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findAttribute", new Object[]{string});
        }
        Object object = null;
        if (attributeList != null) {
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                String string2 = attribute.getName();
                if (!string2.equals(string)) continue;
                object = attribute.getValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findAttribute");
        }
        return object;
    }

    public Object getAttributeValue(AttributeList attributeList, String string) {
        Object object = null;
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getName().equals(string)) continue;
            object = attribute.getValue();
            break;
        }
        return object;
    }

    public Attribute getAttribute(AttributeList attributeList, String string) {
        Attribute attribute = null;
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            Attribute attribute2 = (Attribute)iterator.next();
            if (!attribute2.getName().equals(string)) continue;
            attribute = attribute2;
            break;
        }
        return attribute;
    }

    public void OKToCreate(String string, ObjectName objectName, String string2, ObjectName objectName2) throws ScriptingException {
        if (objectName2 != null) {
            String string3 = objectName.getKeyProperty("_Websphere_Config_Data_Display_Name");
            String string4 = ObjectNameHelper.getNodeName(objectName2);
            if (string.equals("Server") && "DeploymentManager".equals(string2) && string3 != null && string3.equals(string4)) {
                this._shell.setAndThrowScriptingException("WASX7307E", "Cannot create object of type " + string + " on a Network Deployment Manager node.", new Object[]{string});
            }
        }
    }
}

