/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.wsspi.channel.framework.TransportChannelLoader;
import com.ibm.wsspi.channel.framework.exception.ChannelInstalledUnallowed;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TransportChannelLoaderImpl
extends ComponentImpl
implements TransportChannelLoader {
    private static TraceComponent tc = Tr.register(TransportChannelLoaderImpl.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private List fileList = null;
    private File defaultJarLocation = null;
    private boolean channelInstallAllowed = true;

    public synchronized void installTransportChannelJar(String string) throws IOException, ChannelInstalledUnallowed {
        if (!this.channelInstallAllowed) {
            throw new ChannelInstalledUnallowed("Channel install not allowed at this point in the runtime startup.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding channel" + string);
        }
        if (null == this.defaultJarLocation) {
            this.defaultJarLocation = new File(System.getProperty("was.install.root"), "installedChannels");
            if (!this.defaultJarLocation.exists() || !this.defaultJarLocation.isDirectory()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default channel directory is missing " + this.defaultJarLocation);
                }
                this.defaultJarLocation = null;
                throw new IOException("Cannot find default channel directory");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using default directory");
        }
        this.addChannelJar(this.defaultJarLocation, string);
    }

    public synchronized void installTransportChannelJar(String string, String string2) throws IOException, ChannelInstalledUnallowed {
        File file;
        if (!this.channelInstallAllowed) {
            throw new ChannelInstalledUnallowed("Channel install not allowed at this point in the runtime startup.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Adding channel" + string);
        }
        if (!(file = new File(System.getProperty("was.install.root"), string2)).exists() || !file.isDirectory()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string2 + " channel directory is missing " + file);
            }
            file = null;
            throw new IOException("Cannot find channel directory, " + string2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using directory " + string2);
        }
        this.addChannelJar(file, string);
    }

    private void addChannelJar(File file, String string) throws IOException {
        File file2 = new File(this.defaultJarLocation, string);
        if (!file2.exists() || !file2.isFile()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Jar " + string + " to install is missing " + file2 + " in directory " + file);
            }
            this.defaultJarLocation = null;
            throw new IOException("Cannot find channel jar " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Jar " + string + " found");
        }
        if (this.fileList == null) {
            this.fileList = new ArrayList(4);
        }
        this.fileList.add(file2);
    }

    public void initialize(Object object) {
        this.addService(TransportChannelLoader.class);
    }

    public synchronized List unloadChannelList() {
        this.channelInstallAllowed = false;
        List list = this.fileList;
        this.fileList = null;
        this.defaultJarLocation = null;
        return list;
    }
}

