/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.io.Serializable;

public abstract class StatisticImpl
implements SPIStatistic,
Serializable {
    static final long serialVersionUID = 1358353157061734347L;
    protected int id;
    long startTime = 0L;
    long lastSampleTime = 0L;
    protected transient boolean enabled = true;
    transient boolean sync = false;
    transient PmiDataInfo dataInfo = null;
    protected static final int TYPE = 0;

    public int getStatisticType() {
        return 0;
    }

    public StatisticImpl(int n) {
        this.id = n;
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    public StatisticImpl(int n, String string, String string2, String string3, long l, long l2) {
        this.id = n;
        this.startTime = l;
        this.lastSampleTime = l2;
        l = System.currentTimeMillis();
    }

    public String getName() {
        if (this.dataInfo != null) {
            return this.dataInfo.getName();
        }
        return null;
    }

    public String getUnit() {
        if (this.dataInfo != null) {
            return this.dataInfo.getUnit();
        }
        return null;
    }

    public String getDescription() {
        if (this.dataInfo != null) {
            return this.dataInfo.getDescription();
        }
        return null;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    public void enable(int n) {
        this.sync = n >= 15 ? true : PMIImpl.getSynchronizedUpdate();
        if (!this.enabled) {
            this.enabled = true;
            this.reset();
        }
    }

    public void disable() {
        this.enabled = false;
        this.sync = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void reset() {
        this.lastSampleTime = this.startTime = System.currentTimeMillis();
    }

    public void setDataInfo(PmiModuleConfig pmiModuleConfig) {
        if (pmiModuleConfig != null) {
            this.dataInfo = pmiModuleConfig.getDataInfo(this.id);
        }
    }

    public void setDataInfo(PmiDataInfo pmiDataInfo) {
        this.dataInfo = pmiDataInfo;
    }

    public void setLastSampleTime(long l) {
        this.lastSampleTime = l;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public int getId() {
        return this.id;
    }

    public PmiDataInfo getDataInfo() {
        return this.dataInfo;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Statistic id=\"");
        stringBuffer.append(this.id);
        stringBuffer.append("\" name=\"");
        stringBuffer.append(this.getName());
        stringBuffer.append("\" description=\"");
        stringBuffer.append(this.getDescription());
        stringBuffer.append("\" unit=\"");
        stringBuffer.append(this.getUnit());
        stringBuffer.append("\" startTime=\"");
        stringBuffer.append(this.startTime);
        stringBuffer.append("\" lastSampleTime=\"");
        stringBuffer.append(this.lastSampleTime);
        stringBuffer.append("</Statistic>");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("name=").append(this.getName());
        stringBuffer.append(", ID=").append(this.id);
        stringBuffer.append(", description=").append(this.getDescription());
        stringBuffer.append(", unit=").append(this.getUnit());
        return stringBuffer.toString();
    }

    public abstract void update(WSStatistic var1);

    public abstract WSStatistic delta(WSStatistic var1);

    public abstract WSStatistic rateOfChange(WSStatistic var1);

    public abstract WSStatistic copy();

    public abstract void combine(WSStatistic var1);

    public abstract void resetOnClient(WSStatistic var1);

    public abstract void reset(boolean var1);
}

