/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.wsspi.pmi.stat.SPIAverageStatistic;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;
import java.util.Hashtable;

public class WebServicesModule
extends PmiAbstractModule
implements WebServicesPerf {
    private static final long serialVersionUID = -764242698796089589L;
    private static TraceComponent tc = Tr.register(WebServicesModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "webServicesModule";
    public static final int defaultLevel = 0;
    private SPICountStatistic numLoadedServices = null;
    public static final int PMI_ID_NUMBER_LOADED_SERVICES = 1;
    private Hashtable serviceData = new Hashtable();
    private int alreadyLoaded = 0;

    public static final String buildInstanceName(String string, String string2) {
        return string + "." + string2;
    }

    public WebServicesModule(String string, String string2) {
        this(WebServicesModule.buildInstanceName(string, string2));
    }

    public WebServicesModule(String string) {
        super(moduleID, string);
        this.registerModule(this);
        new ModuleAggregate(moduleID, string, "webServicesModule.services");
    }

    public void onServiceLoad(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onServiceLoad(" + string + ")");
        }
        new ServicePMIModule(this.instanceName, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onServiceLoad()");
        }
    }

    public void onServiceUnload(String string) {
        ServicePMIModule servicePMIModule;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onServiceUnload(" + string + ")");
        }
        if ((servicePMIModule = (ServicePMIModule)this.serviceData.get(string)) != null) {
            servicePMIModule.destroy();
        } else {
            Tr.warning(tc, "PMI9999E", "serviceName not found");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onServiceUnload()");
        }
    }

    public WebServicesPerf.ServicePerf getService(String string) {
        ServicePMIModule servicePMIModule;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getService(" + string + ")");
        }
        if ((servicePMIModule = (ServicePMIModule)this.serviceData.get(string)) == null) {
            Tr.warning(tc, "PMI9999E", "onServiceLoad(" + string + ") should have been called already!");
            servicePMIModule = new ServicePMIModule(this.instanceName, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getService()");
        }
        return servicePMIModule;
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.numLoadedServices = (SPICountStatistic)((Object)spdLong.getStatistic());
                this.numLoadedServices.increment(this.alreadyLoaded);
                this.alreadyLoaded = 0;
                return true;
            }
        }
        return false;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    private final void loadService(String string, ServicePMIModule servicePMIModule) {
        this.serviceData.put(string, servicePMIModule);
        if (this.numLoadedServices != null) {
            this.numLoadedServices.increment();
        } else {
            ++this.alreadyLoaded;
        }
    }

    private final void unloadService(String string) {
        this.serviceData.remove(string);
        if (this.numLoadedServices != null) {
            this.numLoadedServices.increment(-1L);
        } else {
            --this.alreadyLoaded;
        }
    }

    class ServicePMIModule
    extends PmiAbstractModule
    implements WebServicesPerf.ServicePerf {
        private static final long serialVersionUID = 3050417530052021410L;
        SPICountStatistic numberReceived;
        SPICountStatistic numberDispatched;
        SPICountStatistic numberSuccessfull;
        SPITimeStatistic responseTime;
        SPITimeStatistic requestResponseTime;
        SPITimeStatistic dispatchResponseTime;
        SPITimeStatistic replyResponseTime;
        SPIAverageStatistic size;
        SPIAverageStatistic requestSize;
        SPIAverageStatistic replySize;
        public static final int PMI_ID_SERVICES = 10;
        public static final int PMI_ID_NUMBER_RECEIVED = 11;
        public static final int PMI_ID_NUMBER_DISPATCHED = 12;
        public static final int PMI_ID_NUMBER_SUCCESSFULL = 13;
        public static final int PMI_ID_AVERAGE_RESPONSE_TIME = 14;
        public static final int PMI_ID_AVERAGE_REQUEST_RESPONSE_TIME = 15;
        public static final int PMI_ID_AVERAGE_DISPATCH_RESPONSE_TIME = 16;
        public static final int PMI_ID_AVERAGE_REPLY_RESPONSE_TIME = 17;
        public static final int PMI_ID_AVERAGE_SIZE = 18;
        public static final int PMI_ID_AVERAGE_REQUEST_SIZE = 19;
        public static final int PMI_ID_AVERAGE_REPLY_SIZE = 20;

        public ServicePMIModule(String string, String string2) {
            super(WebServicesModule.moduleID, string);
            this.numberReceived = null;
            this.numberDispatched = null;
            this.numberSuccessfull = null;
            this.responseTime = null;
            this.requestResponseTime = null;
            this.dispatchResponseTime = null;
            this.replyResponseTime = null;
            this.size = null;
            this.requestSize = null;
            this.replySize = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ServicePMIModule(" + string + "," + string2 + ")");
            }
            this.submoduleName = "webServicesModule.services";
            this.subinstanceName = string2;
            this.type = 16;
            this.registerModule(this);
            WebServicesModule.this.loadService(this.subinstanceName, this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ServicePMIModule()");
            }
        }

        public final boolean isStatisticEnabled(int n) {
            return this.isEnabled(n);
        }

        public void destroy() {
            this.currentLevel = 0;
            Tr.entry(tc, "destroy()");
            this.numberReceived = null;
            this.numberDispatched = null;
            this.numberSuccessfull = null;
            this.responseTime = null;
            this.requestResponseTime = null;
            this.dispatchResponseTime = null;
            this.replyResponseTime = null;
            this.size = null;
            this.requestSize = null;
            this.replySize = null;
            WebServicesModule.this.unloadService(this.subinstanceName);
            this.unregisterModule(this);
            Tr.exit(tc, "destroy()");
        }

        public void onServerReceiveRequest() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.subinstanceName + ".onServerReceiveRequest()");
            }
            this.incrementReceived();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.subinstanceName + ".onServerReceiveRequest()");
            }
        }

        public void onServerForwardRequestToPort(long l) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.subinstanceName + ".onServerForwardRequestToPort()");
            }
            this.incrementDispatched();
            if (l > -1L) {
                this.addRequestResponseTime(l);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.subinstanceName + ".onServerForwardRequestToPort()");
            }
        }

        public void onServerReceiveReplyFromPort(long l) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.subinstanceName + ".onServerReceiveReplyFromPort()");
            }
            this.addDispatchResponseTime(l);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.subinstanceName + ".onServerReceiveReplyFromPort()");
            }
        }

        public void onServerReturnReply(boolean bl, long l, long l2, long l3, long l4) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.subinstanceName + ".onServerReturnReply()");
            }
            if (bl) {
                this.incrementSuccessfull();
            }
            this.addRequestPayloadSize(l);
            this.addReplyPayloadSize(l2);
            this.addPayloadSize(l + l2);
            if (l3 > -1L) {
                this.addReplyResponseTime(l3);
            }
            if (l4 > -1L) {
                this.addResponseTime(l4);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.subinstanceName + ".onServerReturnReply()");
            }
        }

        private final void increment(String string, SPICountStatistic sPICountStatistic) {
            if (sPICountStatistic != null) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "increment(" + string + ")");
                }
                sPICountStatistic.increment();
                Tr.exit(tc, "increment()");
            }
        }

        private final void add(String string, SPIAverageStatistic sPIAverageStatistic, long l) {
            if (sPIAverageStatistic != null) {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "add(" + string + ", time=" + l + ")");
                }
                sPIAverageStatistic.add(l * 1L);
                Tr.exit(tc, "add()");
            }
        }

        private void incrementReceived() {
            this.increment("numberReceived", this.numberReceived);
        }

        private void incrementDispatched() {
            this.increment("numberDispatched", this.numberDispatched);
        }

        private void incrementSuccessfull() {
            this.increment("numberSuccessfull", this.numberSuccessfull);
        }

        private void addResponseTime(long l) {
            this.add("responseTime", this.responseTime, l);
        }

        private void addRequestResponseTime(long l) {
            this.add("requestResponseTime", this.requestResponseTime, l);
        }

        private void addDispatchResponseTime(long l) {
            this.add("dispatchResponseTime", this.dispatchResponseTime, l);
        }

        private void addReplyResponseTime(long l) {
            this.add("replyResponseTime", this.replyResponseTime, l);
        }

        private void addPayloadSize(long l) {
            this.add("payloadSize", this.size, l);
        }

        private void addRequestPayloadSize(long l) {
            this.add("requestPayloadSize", this.requestSize, l);
        }

        private void addReplyPayloadSize(long l) {
            this.add("replyPayloadSize", this.replySize, l);
        }

        protected boolean longCreated(SpdLong spdLong) {
            switch (spdLong.getId()) {
                case 11: {
                    this.numberReceived = (SPICountStatistic)((Object)spdLong.getStatistic());
                    return true;
                }
                case 12: {
                    this.numberDispatched = (SPICountStatistic)((Object)spdLong.getStatistic());
                    return true;
                }
                case 13: {
                    this.numberSuccessfull = (SPICountStatistic)((Object)spdLong.getStatistic());
                    return true;
                }
            }
            return false;
        }

        protected boolean statCreated(SpdStat spdStat) {
            switch (spdStat.getId()) {
                case 14: {
                    this.responseTime = (SPITimeStatistic)((Object)spdStat.getStatistic());
                    return true;
                }
                case 16: {
                    this.dispatchResponseTime = (SPITimeStatistic)((Object)spdStat.getStatistic());
                    return true;
                }
                case 15: {
                    this.requestResponseTime = (SPITimeStatistic)((Object)spdStat.getStatistic());
                    return true;
                }
                case 17: {
                    this.replyResponseTime = (SPITimeStatistic)((Object)spdStat.getStatistic());
                    return true;
                }
                case 18: {
                    this.size = (SPIAverageStatistic)((Object)spdStat.getStatistic());
                    return true;
                }
                case 19: {
                    this.requestSize = (SPIAverageStatistic)((Object)spdStat.getStatistic());
                    return true;
                }
                case 20: {
                    this.replySize = (SPIAverageStatistic)((Object)spdStat.getStatistic());
                    return true;
                }
            }
            return false;
        }

        public String getModuleID() {
            return WebServicesModule.moduleID;
        }

        public int getDefaultLevel() {
            return 0;
        }
    }
}

