/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.CachePerf;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.PmiCallback;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.modules.TemplateModule;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import java.util.HashMap;

public class CachePerfModule
extends PmiAbstractModule
implements CachePerf {
    private static final long serialVersionUID = 9205382809864908020L;
    protected static TraceComponent tc = Tr.register(CachePerfModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    public static final String moduleID = "cacheModule";
    private static final int defaultLevel = 0;
    public static final int cacheModule_maxInMemoryCacheSize = 1;
    public static final int cacheModule_inMemoryCacheSize = 2;
    public static final int cacheModule_totalTimeoutInvalidations = 3;
    public static final int UNSET = 0;
    public static final int DIRECT = 1;
    public static final int LRU = 2;
    public static final int TIMEOUT = 3;
    public static final int MEMORY = 1;
    public static final int REMOTE = 2;
    public static final int DISK = 3;
    public static final int NOOP = 4;
    public static final int LOCAL = 5;
    public static final int cacheModule_template = 20;
    public static final int cacheModule_template_hitsInMemory = 21;
    public static final int cacheModule_template_hitsOnDisk = 22;
    public static final int cacheModule_template_explicitInvalidations = 23;
    public static final int cacheModule_template_lruInvalidations = 24;
    public static final int cacheModule_template_timeoutInvalidations = 25;
    public static final int cacheModule_template_entries = 26;
    public static final int cacheModule_template_hitsRemote = 27;
    public static final int cacheModule_template_misses = 28;
    public static final int cacheModule_template_requestsFromClient = 29;
    public static final int cacheModule_template_requestsFromJVM = 30;
    public static final int cacheModule_template_explicitInvalidationsFromMemory = 31;
    public static final int cacheModule_template_explicitInvalidationsFromDisk = 32;
    public static final int cacheModule_template_explicitInvalidationsNoOp = 33;
    public static final int cacheModule_template_explicitInvalidationsLocal = 34;
    public static final int cacheModule_template_explicitInvalidationsRemote = 35;
    public static final int cacheModule_template_remoteCreations = 36;
    SPICountStatistic maxInMemoryCacheSize = null;
    SPICountStatistic inMemoryCacheSize = null;
    SPICountStatistic totalTimeoutInvalidations = null;
    HashMap templates = new HashMap();
    private String sCacheName;
    private String sCacheType;
    public static final String TYPE_SERVLET = "cache.servlet";
    public static final String TYPE_OBJECT = "cache.object";

    public CachePerfModule(String string, String string2, PmiCallback pmiCallback) {
        super(moduleID, string2);
        DataDescriptor dataDescriptor;
        this.sCacheName = string2;
        this.sCacheType = string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "new CachePerfModule: {cacheType, cacheName} " + string + ", " + string2);
        }
        if (PmiRegistry.findModuleItem(dataDescriptor = new DataDescriptor(new String[]{moduleID, string})) == null) {
            new CacheTypeModule(string);
        }
        this.registerModule(this);
        if (string.equals(TYPE_SERVLET)) {
            new ModuleAggregate(moduleID, string, string2, "cacheModule.template");
        }
    }

    public String[] getPath() {
        return new String[]{moduleID, this.sCacheType, this.sCacheName};
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    protected boolean longCreated(SpdLong spdLong) {
        switch (spdLong.getId()) {
            case 1: {
                this.maxInMemoryCacheSize = (SPICountStatistic)((Object)spdLong.getStatistic());
                return true;
            }
            case 2: {
                this.inMemoryCacheSize = (SPICountStatistic)((Object)spdLong.getStatistic());
                return true;
            }
            case 3: {
                this.totalTimeoutInvalidations = (SPICountStatistic)((Object)spdLong.getStatistic());
                return true;
            }
        }
        Tr.warning(tc, "PMI00008W", "cacheModule, dataID=" + spdLong.getId());
        return false;
    }

    public boolean isPMIEnabled() {
        int n = this.getInstrumentationLevel();
        return n != 1000 && n != -1 && n != 0;
    }

    public void resetPMICounters() {
    }

    public void updateCacheSizes(long l, long l2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "updateCacheSize, max=" + l + ", current=" + l2);
        }
        if (this.maxInMemoryCacheSize != null) {
            this.maxInMemoryCacheSize.setCount(l);
        }
        if (this.inMemoryCacheSize != null) {
            this.inMemoryCacheSize.setCount(l2);
        }
    }

    public void updateDiskCacheStatistics(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10) {
    }

    public void onCacheHit(String string, int n) {
        block13: {
            block12: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "onCacheHit: template=" + string + " locality=" + n);
                }
                if (string == null) break block12;
                TemplateModule templateModule = (TemplateModule)this.templates.get(string);
                if (templateModule == null) {
                    templateModule = this.createTemplateModule(string);
                }
                switch (n) {
                    case 2: {
                        if (templateModule.hitsRemote != null) {
                            templateModule.hitsRemote.increment();
                            templateModule.entries.increment();
                            templateModule.remoteCreations.increment();
                            break;
                        }
                        break block13;
                    }
                    case 1: {
                        if (templateModule.hitsInMemory != null) {
                            templateModule.hitsInMemory.increment();
                            break;
                        }
                        break block13;
                    }
                    case 3: {
                        if (templateModule.hitsOnDisk != null) {
                            templateModule.hitsOnDisk.increment();
                            break;
                        }
                        break block13;
                    }
                    default: {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "onCacheHit() called with unrecognized locality " + n);
                        }
                        return;
                    }
                }
                break block13;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template was null: " + string);
            }
        }
    }

    public void onCacheMiss(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onCacheMiss: template=" + string + " locality=" + n);
        }
        if (string != null) {
            TemplateModule templateModule = (TemplateModule)this.templates.get(string);
            if (templateModule == null) {
                templateModule = this.createTemplateModule(string);
            }
            if (templateModule.misses != null) {
                templateModule.misses.increment();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onCacheMiss: template was null");
        }
    }

    public void onEntryCreation(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onEntryCreation: template=" + string + " source=" + n);
        }
        if (string != null) {
            TemplateModule templateModule = (TemplateModule)this.templates.get(string);
            if (templateModule == null) {
                templateModule = this.createTemplateModule(string);
            }
            if (n == 2 && templateModule.remoteCreations != null) {
                templateModule.remoteCreations.increment();
            }
            if (templateModule.entries != null) {
                templateModule.entries.increment();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onEntryCreation: template was null");
        }
    }

    public void onRequest(String string, int n) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onRequest: template=" + string + "source=" + n);
        }
        if (string != null) {
            TemplateModule templateModule = (TemplateModule)this.templates.get(string);
            if (templateModule == null) {
                templateModule = this.createTemplateModule(string);
            }
            if (n == 5) {
                if (templateModule.requestsFromClient != null) {
                    templateModule.requestsFromClient.increment();
                }
            } else if (n == 2 && templateModule.requestsFromJVM != null) {
                templateModule.requestsFromJVM.increment();
            }
        }
    }

    public void batchOnInvalidate(String string, int n, int n2, int n3, int n4) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "batchOnInvalidate: " + string + ", " + n + ", " + n2 + ", " + n3 + ", " + n4);
        }
        if (string != null) {
            TemplateModule templateModule = (TemplateModule)this.templates.get(string);
            if (templateModule == null) {
                templateModule = this.createTemplateModule(string);
            }
            block0 : switch (n) {
                case 1: {
                    if (templateModule.explicitInvalidations != null) {
                        templateModule.explicitInvalidations.increment(n4);
                    }
                    switch (n2) {
                        case 1: {
                            if (templateModule.explicitInvalidationsFromMemory != null) {
                                templateModule.explicitInvalidationsFromMemory.increment(n4);
                            }
                            if (templateModule.entries == null) break;
                            templateModule.entries.decrement(n4);
                            break;
                        }
                        case 3: {
                            if (templateModule.explicitInvalidationsFromDisk != null) {
                                templateModule.explicitInvalidationsFromDisk.increment(n4);
                            }
                            if (templateModule.entries == null) break;
                            templateModule.entries.decrement(n4);
                        }
                    }
                    switch (n3) {
                        case 5: {
                            if (templateModule.explicitInvalidationsLocal == null) break;
                            templateModule.explicitInvalidationsLocal.increment(n4);
                            break block0;
                        }
                        case 2: {
                            if (templateModule.explicitInvalidationsRemote == null) break;
                            templateModule.explicitInvalidationsRemote.increment(n4);
                        }
                    }
                    break;
                }
                case 2: {
                    if (templateModule.lruInvalidations != null) {
                        templateModule.lruInvalidations.increment(n4);
                    }
                    if (n2 == 3 || templateModule.entries == null) break;
                    templateModule.entries.decrement(n4);
                    break;
                }
                case 3: {
                    if (templateModule.timeoutInvalidations != null) {
                        templateModule.timeoutInvalidations.increment(n4);
                    }
                    if (this.totalTimeoutInvalidations != null) {
                        this.totalTimeoutInvalidations.increment(n4);
                    }
                    if (templateModule.entries == null) break;
                    templateModule.entries.decrement(n4);
                }
            }
        } else if (n == 3 && n2 == 3) {
            if (this.totalTimeoutInvalidations != null) {
                this.totalTimeoutInvalidations.increment(n4);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onInvalidate: template was null");
        }
    }

    public void onInvalidate(String string, int n, int n2, int n3) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "onInvalidate: " + string + ", " + n + ", " + n2 + ", " + n3);
        }
        this.batchOnInvalidate(string, n, n2, n3, 1);
    }

    public void onCacheClear(boolean bl, boolean bl2) {
    }

    private synchronized TemplateModule createTemplateModule(String string) {
        TemplateModule templateModule = (TemplateModule)this.templates.get(string);
        if (templateModule == null) {
            templateModule = new TemplateModule(this.sCacheName, this.sCacheType, string);
            this.templates.put(string, templateModule);
        }
        return templateModule;
    }

    class CacheTypeModule
    extends ModuleAggregate {
        private static final long serialVersionUID = -6403912783689903806L;

        CacheTypeModule(String string) {
            super(CachePerfModule.moduleID, string);
        }
    }
}

