/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.pmi.PmiBean;
import com.ibm.websphere.pmi.PmiBeanFactory;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.modules.BeanModule;
import java.io.Serializable;
import java.util.HashMap;

public class PmiBeanFactoryImpl
implements PmiBeanFactory {
    HashMap allBeanModules = new HashMap();
    protected static TraceComponent tc = Tr.register(PmiBeanFactoryImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public PmiBean createPmiBean(EJBConfigData eJBConfigData, String string) {
        return this.createPmiBean(eJBConfigData.getEJBComponentMetaData(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PmiBean createPmiBean(EJBComponentMetaData eJBComponentMetaData, String string) {
        Serializable serializable;
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        String string2 = this.getUniqueName(eJBComponentMetaData);
        String string3 = this.getModuleName(string2);
        String string4 = this.getBeanName(string2);
        String string5 = this.getBeanType(eJBComponentMetaData);
        DataDescriptor dataDescriptor = new DataDescriptor(new String[]{"beanModule", string3});
        DataDescriptor dataDescriptor2 = new DataDescriptor(new String[]{"beanModule", string3, string5});
        Serializable serializable2 = this.allBeanModules;
        synchronized (serializable2) {
            serializable = PmiRegistry.findModuleItem(dataDescriptor);
            if (serializable == null) {
                new ModuleAggregate(new String[]{"beanModule", string3}, string3, 14);
            }
            if ((serializable = PmiRegistry.findModuleItem(dataDescriptor2)) == null) {
                new ModuleAggregate(new String[]{"beanModule", string3, string5}, string5, 19);
            }
        }
        serializable2 = new BeanModule(string3, string4, string5, eJBComponentMetaData);
        ((BeanModule)serializable2).setFactory(this);
        serializable = this.allBeanModules;
        synchronized (serializable) {
            this.allBeanModules.put(string2, serializable2);
        }
        return serializable2;
    }

    public PmiBean getPmiBean(EJBComponentMetaData eJBComponentMetaData, String string) {
        if (PmiRegistry.isBeanMethodDisabled()) {
            return null;
        }
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        String string2 = this.getUniqueName(eJBComponentMetaData);
        BeanModule beanModule = (BeanModule)this.allBeanModules.get(string2);
        return beanModule;
    }

    public PmiBean getPmiBean(String string, String string2) {
        if (PmiRegistry.isBeanMethodDisabled()) {
            return null;
        }
        if (PmiRegistry.isDisabled()) {
            return null;
        }
        BeanModule beanModule = (BeanModule)this.allBeanModules.get(string);
        return beanModule;
    }

    private String getInstanceName(String string, String string2) {
        return string2;
    }

    private String getUniqueName(EJBComponentMetaData eJBComponentMetaData) {
        return ((Object)eJBComponentMetaData.getJ2EEName()).toString();
    }

    private String getModuleName(String string) {
        int n = string.lastIndexOf(35);
        return string.substring(0, n);
    }

    private String getBeanName(String string) {
        int n = string.lastIndexOf(35);
        return string.substring(n + 1);
    }

    private String getBeanType(EJBComponentMetaData eJBComponentMetaData) {
        String string = null;
        if (eJBComponentMetaData.isStatefulSessionBean()) {
            string = "ejb.stateful";
        } else if (eJBComponentMetaData.isStatelessSessionBean()) {
            string = "ejb.stateless";
        } else if (eJBComponentMetaData.isEntityBean()) {
            string = "ejb.entity";
        } else if (eJBComponentMetaData.isMessageDrivenBean()) {
            string = "ejb.messageDriven";
        }
        return string;
    }

    public void removePmiModule(Object object) {
        String[] stringArray;
        if (object == null) {
            return;
        }
        if (!(object instanceof PmiModule)) {
            Tr.warning(tc, "removePmiModule - parameter should be PmiModule type");
            return;
        }
        PmiModule pmiModule = (PmiModule)object;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removePmiModule " + pmiModule.getModuleID() + ", " + pmiModule.getName());
        }
        if ((stringArray = pmiModule.getPath()).length == 4 && stringArray[0].equals("beanModule")) {
            String string = stringArray[1] + "#" + stringArray[3];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PmiBeanFactoryImpl: removeModule " + string);
            }
            this.allBeanModules.remove(string);
        }
        pmiModule.unregister();
    }
}

