/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.PmiModuleAggregate;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.StatLevelSpec;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.PerfLevelDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.management.ObjectName;

public class ModuleItem
implements Serializable,
PmiConstants {
    private static final long serialVersionUID = 4893797935750745475L;
    PmiModule instance = null;
    Map children = null;
    ModuleItem parent = null;
    int level = -1;
    private static final TraceComponent tc = Tr.register(ModuleItem.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private StatsImpl myStats;
    private StatsImpl myStatsWithChildren;

    public ModuleItem() {
        this(null);
    }

    public ModuleItem(PmiModule pmiModule) {
        this.instance = pmiModule;
    }

    public PmiModule getInstance() {
        return this.instance;
    }

    public ModuleItem find(String string) {
        if (this.children == null) {
            return null;
        }
        return (ModuleItem)this.children.get(string);
    }

    public ModuleItem find(String[] stringArray, int n) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return this;
        }
        ModuleItem moduleItem = this.find(stringArray[n]);
        if (moduleItem == null) {
            return null;
        }
        if (n == stringArray.length - 1) {
            return moduleItem;
        }
        return moduleItem.find(stringArray, n + 1);
    }

    public synchronized ModuleItem add(String[] stringArray, int n) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return this;
        }
        ModuleItem moduleItem = this.find(stringArray[n]);
        if (moduleItem == null) {
            String[] stringArray2 = new String[n + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
            if (stringArray2.length == 1) {
                ModuleAggregate moduleAggregate = new ModuleAggregate(stringArray2[0]);
                moduleItem = this.find(stringArray[n]);
            } else if (stringArray2.length == 3) {
                new ModuleAggregate(stringArray2[0], stringArray2[1], stringArray2[2]);
                moduleItem = this.find(stringArray[n]);
            } else {
                Tr.warning(tc, "PMI9999E", "Parent module not found.");
            }
            this.add(moduleItem);
        }
        if (n == stringArray.length - 1) {
            return moduleItem;
        }
        return moduleItem.add(stringArray, n + 1);
    }

    public synchronized boolean add(ModuleItem moduleItem) {
        String string;
        if (moduleItem == null) {
            return false;
        }
        if (this.children == null) {
            this.children = new TreeMap();
        }
        if (this.find(string = moduleItem.getInstance().getName()) == null) {
            moduleItem.setParent(this);
            this.children.put(string, moduleItem);
            if (this.myStatsWithChildren != null) {
                this.addToStatsTree(moduleItem);
            }
            return true;
        }
        return false;
    }

    public ModuleItem[] children() {
        if (this.children == null) {
            return null;
        }
        ModuleItem[] moduleItemArray = new ModuleItem[this.children.size()];
        this.children.values().toArray(moduleItemArray);
        return moduleItemArray;
    }

    public ModuleItem getParent() {
        return this.parent;
    }

    public void setParent(ModuleItem moduleItem) {
        this.parent = moduleItem;
        this.updateParent();
    }

    private void updateParent() {
        if (this.parent == null) {
            return;
        }
        if (this.instance instanceof PmiModuleAggregate) {
            return;
        }
        PmiModule pmiModule = null;
        for (ModuleItem moduleItem = this.parent; moduleItem != null; moduleItem = moduleItem.getParent()) {
            pmiModule = moduleItem.getInstance();
            if (pmiModule == null || !(pmiModule instanceof PmiModuleAggregate)) continue;
            ((PmiModuleAggregate)((Object)pmiModule)).add(this.getInstance());
            if (pmiModule.isCustomModule()) {
                if (moduleItem.myStatsWithChildren != null) {
                    moduleItem.myStatsWithChildren.setStatsType(pmiModule.getWCCMStatsType());
                }
                if (moduleItem.myStats != null) {
                    moduleItem.myStats.setStatsType(pmiModule.getWCCMStatsType());
                }
            }
            ((PmiAbstractModule)pmiModule).updateDataList();
            ((PmiAbstractModule)pmiModule).updateEnabledByLevel();
            if (!((PmiAbstractModule)this.getInstance()).isStandaloneTree()) continue;
        }
    }

    private void updateChildrenInfo(Map map) {
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ModuleItem moduleItem = (ModuleItem)iterator.next();
                if (!(moduleItem.getInstance() instanceof PmiModuleAggregate)) {
                    ((PmiModuleAggregate)((Object)this.instance)).add(moduleItem.getInstance());
                    ((PmiAbstractModule)this.instance).updateDataList();
                }
                this.updateChildrenInfo(moduleItem.children);
            }
        }
    }

    public synchronized void remove(ModuleItem moduleItem) {
        if (moduleItem == null || this.children == null) {
            return;
        }
        PmiModule pmiModule = moduleItem.getInstance();
        if (!(pmiModule instanceof PmiModuleAggregate)) {
            PmiModule pmiModule2 = null;
            for (ModuleItem moduleItem2 = this; moduleItem2 != null; moduleItem2 = moduleItem2.getParent()) {
                pmiModule2 = moduleItem2.getInstance();
                if (pmiModule2 == null || !(pmiModule2 instanceof PmiModuleAggregate)) continue;
                ((PmiModuleAggregate)((Object)pmiModule2)).remove(pmiModule);
            }
        }
        moduleItem._cleanChildren();
        this.children.remove(moduleItem.getInstance().getName());
        if (this.myStatsWithChildren != null) {
            this.updateStatsTree();
        }
        moduleItem.getInstance().cleanup();
        moduleItem = null;
    }

    public DataDescriptor[] listMembers(DataDescriptor dataDescriptor, boolean bl) {
        int n;
        SpdData[] spdDataArray = null;
        int n2 = 0;
        if (!bl && (spdDataArray = this.instance.listData()) != null) {
            n2 = spdDataArray.length;
        }
        String[] stringArray = null;
        int n3 = 0;
        ModuleItem[] moduleItemArray = this.children();
        if (moduleItemArray != null) {
            n3 = moduleItemArray.length;
            stringArray = new String[n3];
            for (int i = 0; i < n3; ++i) {
                String[] stringArray2 = moduleItemArray[i].getInstance().getPath();
                stringArray[i] = stringArray2[stringArray2.length - 1];
            }
        }
        if (n3 == 0 && n2 == 0) {
            return null;
        }
        DataDescriptor[] dataDescriptorArray = new DataDescriptor[n3 + n2];
        for (n = 0; n < n3; ++n) {
            dataDescriptorArray[n] = new DataDescriptor(dataDescriptor, stringArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            dataDescriptorArray[n + n3] = new DataDescriptor(dataDescriptor, spdDataArray[n].getId());
        }
        return dataDescriptorArray;
    }

    public ArrayList getStatLevelSpec(boolean bl) {
        ModuleItem[] moduleItemArray;
        ArrayList<StatLevelSpec> arrayList = new ArrayList<StatLevelSpec>(1);
        if (this.instance != null) {
            arrayList.add(new StatLevelSpec(this.instance.getPath(), this.instance.getEnabled()));
        }
        if (bl && (moduleItemArray = this.children()) != null) {
            for (int i = 0; i < moduleItemArray.length; ++i) {
                ArrayList arrayList2 = moduleItemArray[i].getStatLevelSpec(bl);
                for (int j = 0; j < arrayList2.size(); ++j) {
                    arrayList.add((StatLevelSpec)arrayList2.get(j));
                }
            }
        }
        return arrayList;
    }

    public ArrayList listChildStatDescriptors(boolean bl) {
        ArrayList<StatDescriptor> arrayList = new ArrayList<StatDescriptor>(1);
        ModuleItem[] moduleItemArray = this.children();
        if (moduleItemArray != null) {
            for (int i = 0; i < moduleItemArray.length; ++i) {
                arrayList.add(moduleItemArray[i].getInstance().get60_StatDescriptor());
                if (!bl) continue;
                ArrayList arrayList2 = moduleItemArray[i].listChildStatDescriptors(bl);
                for (int j = 0; j < arrayList2.size(); ++j) {
                    arrayList.add((StatDescriptor)arrayList2.get(j));
                }
            }
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList getPerfLevelDescriptors(boolean bl) {
        Object object;
        int n;
        Serializable serializable;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.instance == null) {
            if (bl) {
                serializable = PmiRegistry.getServerMBean();
                arrayList.add(new MBeanLevelSpec((ObjectName)serializable, null, this.level));
            } else {
                arrayList.add(new PerfLevelDescriptor(new String[]{"pmi"}, this.level));
            }
        } else {
            serializable = this.getInstance();
            if (bl) {
                if (serializable.getMBeanName() == null) return arrayList;
                n = serializable.getInstrumentationLevel();
                object = new MBeanLevelSpec(serializable.getMBeanName(), serializable.getMSD_StatDescriptor(), n);
                if (n == -2) {
                    ((MBeanLevelSpec)object).setEnabled(serializable.getEnabled());
                }
                arrayList.add(object);
            } else {
                object = serializable.getPath();
                PerfLevelDescriptor perfLevelDescriptor = new PerfLevelDescriptor((String[])object, serializable.getInstrumentationLevel(), serializable.getModuleID());
                arrayList.add(perfLevelDescriptor);
            }
        }
        serializable = this.children();
        if (serializable == null) {
            return arrayList;
        }
        for (n = 0; n < ((Serializable)serializable).length; ++n) {
            object = ((ModuleItem)serializable[n]).getPerfLevelDescriptors(bl);
            if (object == null || ((ArrayList)object).size() == 0) continue;
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                arrayList.add(((ArrayList)object).get(i));
            }
        }
        return arrayList;
    }

    public ArrayList getTreePerfLevelDescriptors(int n) {
        ModuleItem[] moduleItemArray;
        ArrayList<PerfLevelDescriptor> arrayList = new ArrayList<PerfLevelDescriptor>();
        int n2 = this.level;
        if (this.instance == null) {
            arrayList.add(new PerfLevelDescriptor(new String[]{"pmi"}, n2));
        } else {
            moduleItemArray = this.getInstance();
            n2 = moduleItemArray.getInstrumentationLevel();
            if (n2 != -1 && n2 != n) {
                arrayList.add(new PerfLevelDescriptor(moduleItemArray.getPath(), n2, moduleItemArray.getModuleID()));
            }
        }
        moduleItemArray = this.children();
        if (moduleItemArray == null) {
            return arrayList;
        }
        for (int i = 0; i < moduleItemArray.length; ++i) {
            ArrayList arrayList2 = moduleItemArray[i].getTreePerfLevelDescriptors(n2);
            for (int j = 0; j < arrayList2.size(); ++j) {
                arrayList.add((PerfLevelDescriptor)arrayList2.get(j));
            }
        }
        return arrayList;
    }

    private void updateStatisticsForStatsTree(long l) {
        ModuleItem[] moduleItemArray;
        if (this.instance != null) {
            this.instance.updateStatistics();
        }
        if (this.myStatsWithChildren != null) {
            this.myStatsWithChildren.setTime(l);
        }
        if ((moduleItemArray = this.children()) != null) {
            for (int i = 0; i < moduleItemArray.length; ++i) {
                moduleItemArray[i].updateStatisticsForStatsTree(l);
            }
        }
    }

    private void addToStatsTree(ModuleItem moduleItem) {
        ArrayList<StatsImpl> arrayList = this.myStatsWithChildren.subCollections();
        if (arrayList == null) {
            arrayList = new ArrayList<StatsImpl>(1);
            this.myStatsWithChildren.setSubcollections(arrayList);
        }
        arrayList.add(moduleItem.getStats(true));
    }

    private void updateStatsTree() {
        if (this.myStatsWithChildren == null) {
            return;
        }
        ArrayList arrayList = this.myStatsWithChildren.subCollections();
        if (arrayList == null) {
            return;
        }
        arrayList.clear();
        ModuleItem[] moduleItemArray = this.children();
        if (moduleItemArray != null) {
            for (int i = 0; i < moduleItemArray.length; ++i) {
                arrayList.add(moduleItemArray[i].getStats(true));
            }
        }
    }

    public StatsImpl getStats(boolean bl) {
        if (bl) {
            if (this.myStatsWithChildren == null) {
                ArrayList arrayList = null;
                if (this.instance != null) {
                    arrayList = this.instance.listStatistics();
                }
                ArrayList<StatsImpl> arrayList2 = null;
                ModuleItem[] moduleItemArray = this.children();
                if (moduleItemArray != null) {
                    arrayList2 = new ArrayList<StatsImpl>(moduleItemArray.length);
                    for (int i = 0; i < moduleItemArray.length; ++i) {
                        arrayList2.add(moduleItemArray[i].getStats(bl));
                    }
                }
                this.myStatsWithChildren = this.instance != null ? this.instance.getStats(arrayList, arrayList2) : new StatsImpl("server", 12, this.level, null, arrayList2);
            } else {
                this.updateStatisticsForStatsTree(System.currentTimeMillis());
            }
            return this.myStatsWithChildren;
        }
        if (this.myStats == null) {
            this.myStats = this.instance != null ? this.instance.getStats(this.instance.listStatistics(), null) : new StatsImpl("server", 12, this.level, null, null);
        } else {
            if (this.instance != null) {
                this.instance.updateStatistics();
            }
            this.myStats.setTime(System.currentTimeMillis());
        }
        return this.myStats;
    }

    public StatsImpl getJSR77Stats() {
        if (this.instance == null) {
            return null;
        }
        return this.instance.getJSR77Stats(this);
    }

    public StatsImpl getStats(int[] nArray, boolean bl) {
        int n;
        if (nArray == null) {
            return this.getStats(bl);
        }
        if (this.instance == null) {
            return null;
        }
        SpdData[] spdDataArray = this.instance.listData(nArray);
        ModuleItem[] moduleItemArray = this.children();
        ArrayList<StatisticImpl> arrayList = null;
        ArrayList<StatsImpl> arrayList2 = null;
        if (spdDataArray != null) {
            arrayList = new ArrayList<StatisticImpl>(spdDataArray.length);
            for (n = 0; n < spdDataArray.length; ++n) {
                arrayList.add(spdDataArray[n].getStatistic());
            }
        }
        if (bl && moduleItemArray != null) {
            arrayList2 = new ArrayList<StatsImpl>(moduleItemArray.length);
            for (n = 0; n < moduleItemArray.length; ++n) {
                arrayList2.add(moduleItemArray[n].getStats(nArray, bl));
            }
        }
        return this.instance.getStats(arrayList, arrayList2);
    }

    public void setInstanceLevel(int[] nArray, int[] nArray2, int n, boolean bl) {
        if (n != -2) {
            if (n != -1) {
                this.setInstanceLevel_V5(n, bl);
            }
        } else if (nArray != null) {
            this.setInstanceLevel_FG(nArray, nArray2, bl);
        }
        PMIImpl.setStatisticSet("custom");
    }

    private void setInstanceLevel_FG(int[] nArray, int[] nArray2, boolean bl) {
        if (this.instance != null) {
            boolean bl2 = this.instance.setFineGrainedInstrumentation(nArray, nArray2);
            this.updateParent();
        }
        if (bl) {
            ModuleItem[] moduleItemArray = this.children();
            if (moduleItemArray == null) {
                return;
            }
            for (int i = 0; i < moduleItemArray.length; ++i) {
                moduleItemArray[i].setInstanceLevel_FG(nArray, nArray2, bl);
            }
        }
    }

    private void setInstanceLevel_V5(int n, boolean bl) {
        if (this.instance != null) {
            int n2 = this.instance.getInstrumentationLevel();
            this.instance.setInstrumentationLevel(n);
            if (n2 < n) {
                this.updateParent();
            }
        } else {
            this.level = n;
        }
        if (bl) {
            ModuleItem[] moduleItemArray = this.children();
            if (moduleItemArray == null) {
                return;
            }
            for (int i = 0; i < moduleItemArray.length; ++i) {
                moduleItemArray[i].setInstanceLevel_V5(n, bl);
            }
        }
    }

    public void setInstanceLevel_Set(String string, boolean bl) {
        if (this.instance != null) {
            this.instance.setInstrumentationBySet(string);
            this.updateParent();
        }
        if (bl) {
            ModuleItem[] moduleItemArray = this.children();
            if (moduleItemArray == null) {
                return;
            }
            for (int i = 0; i < moduleItemArray.length; ++i) {
                moduleItemArray[i].setInstanceLevel_Set(string, bl);
            }
        }
    }

    public void turnOnOffData(int n, boolean bl, boolean bl2) {
        ModuleItem[] moduleItemArray;
        if (this.instance != null) {
            if (bl) {
                this.instance.enableData(n);
            } else {
                this.instance.disableData(n);
            }
        }
        if (bl2 && (moduleItemArray = this.children()) != null) {
            for (int i = 0; i < moduleItemArray.length; ++i) {
                moduleItemArray[i].turnOnOffData(n, bl, bl2);
            }
        }
    }

    public ObjectName getParentMBean() {
        if (this.parent.getInstance() == null) {
            return PmiRegistry.getServerMBean();
        }
        ObjectName objectName = this.parent.getInstance().getMBeanName();
        if (objectName == null) {
            return this.parent.getParentMBean();
        }
        return objectName;
    }

    public boolean isStatisticsProvider() {
        return this.instance.isJ2EEStatisticProvider();
    }

    private void _cleanChildren() {
        if (this.children != null) {
            Iterator iterator = this.children.values().iterator();
            while (iterator.hasNext()) {
                ModuleItem moduleItem = (ModuleItem)iterator.next();
                moduleItem.getInstance().cleanup();
                moduleItem._cleanChildren();
                moduleItem = null;
            }
            this.children.clear();
        }
    }
}

