/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.InvalidNameSyntaxException;
import com.ibm.ws.naming.util.WsnNameEnumeration;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.omg.CosNaming.NameComponent;

public class WsnName
implements Name {
    private static final long serialVersionUID = 1L;
    private static final String SYNTAX = "com.ibm.websphere.naming.name.syntax";
    private static final String SYNTAX_JNDI = "jndi";
    private static final String SYNTAX_INS = "ins";
    private static final int JNDI = 0;
    private static final int INS = 1;
    private static final char SEP_DEFAULT = '.';
    private static final char _pathSep = '/';
    private static final char _esc = '\\';
    private static final NameComponent EMPTY_COSNAME_COMPONENT = new NameComponent("", "");
    private static final TraceComponent _tc = Tr.register(WsnName.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private Hashtable _env;
    private int _syntax = 0;
    private char _sep;
    private NameComponent[] _name;
    private String _syntaxName;

    public WsnName(NameComponent[] nameComponentArray, Hashtable hashtable) throws InvalidNameException, InvalidNameSyntaxException {
        try {
            this.init(hashtable);
            this.setName(nameComponentArray);
        }
        catch (InvalidNameException invalidNameException) {
            FFDCFilter.processException((Throwable)invalidNameException, "com.ibm.ws.naming.util.WsnName.WsnName", "104", this);
            Tr.debug(_tc, "WsnName(NameComponent[], Hashtable): InvalidNameException");
            throw invalidNameException;
        }
        catch (InvalidNameSyntaxException invalidNameSyntaxException) {
            FFDCFilter.processException((Throwable)invalidNameSyntaxException, "com.ibm.ws.naming.util.WsnName.WsnName", "110", this);
            Tr.debug(_tc, "WsnName(Name,Component[] Hashtable): InvalidNameSyntaxException");
            throw invalidNameSyntaxException;
        }
    }

    public WsnName(Name name, Hashtable hashtable) throws InvalidNameException, InvalidNameSyntaxException {
        try {
            this.init(hashtable);
            this.setName(name);
        }
        catch (InvalidNameException invalidNameException) {
            FFDCFilter.processException((Throwable)invalidNameException, "com.ibm.ws.naming.util.WsnName.WsnName", "149", this);
            Tr.debug(_tc, "WsnName(Name, Hashtable): InvalidNameException");
            throw invalidNameException;
        }
        catch (InvalidNameSyntaxException invalidNameSyntaxException) {
            FFDCFilter.processException((Throwable)invalidNameSyntaxException, "com.ibm.ws.naming.util.WsnName.WsnName", "155", this);
            Tr.debug(_tc, "WsnName(Name, Hashtable): InvalidNameSyntaxException");
            throw invalidNameSyntaxException;
        }
    }

    public WsnName(String string, Hashtable hashtable) throws InvalidNameException, InvalidNameSyntaxException {
        try {
            this.init(hashtable);
            this.setName(string);
        }
        catch (InvalidNameException invalidNameException) {
            FFDCFilter.processException((Throwable)invalidNameException, "com.ibm.ws.naming.util.WsnName.WsnName", "192", this);
            Tr.debug(_tc, "WsnName(String, Hashtable): InvalidNameException");
            throw invalidNameException;
        }
        catch (InvalidNameSyntaxException invalidNameSyntaxException) {
            FFDCFilter.processException((Throwable)invalidNameSyntaxException, "com.ibm.ws.naming.util.WsnName.WsnName", "198", this);
            Tr.debug(_tc, "WsnName(String, Hashtable): InvalidNameSyntaxException");
            throw invalidNameSyntaxException;
        }
    }

    private void init(Hashtable hashtable) throws InvalidNameSyntaxException {
        this.setEnvironment(hashtable);
        this.setSyntax(hashtable);
    }

    private void setEnvironment(Hashtable hashtable) {
        this._env = hashtable != null ? (Hashtable)hashtable.clone() : null;
    }

    private void setSyntax(Hashtable hashtable) throws InvalidNameSyntaxException {
        this._syntax = 0;
        this._syntaxName = "JNDI";
        String string = WsnName.syntaxProperty(hashtable);
        if (string.equals(SYNTAX_INS)) {
            this._syntax = 1;
            this._syntaxName = "INS";
            this._sep = (char)46;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String syntaxProperty(Hashtable hashtable) throws InvalidNameSyntaxException {
        String string = SYNTAX_JNDI;
        if (hashtable != null) {
            String string2 = (String)hashtable.get(SYNTAX);
            if (string2 == null) return string;
            if (string2.equals(SYNTAX_JNDI)) return string2;
            if (string2.equals(SYNTAX_INS)) {
                return string2;
            }
            String string3 = "The name syntax property com.ibm.websphere.naming.name.syntax is set to an unrecognized value of " + string2 + ".";
            InvalidNameSyntaxException invalidNameSyntaxException = new InvalidNameSyntaxException(string3);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Invalid name syntax property; ", invalidNameSyntaxException);
            }
            Tr.warning(_tc, "badNameSyntax", (Object)new Object[]{SYNTAX, string2});
            throw invalidNameSyntaxException;
        }
        Tr.debug(_tc, "syntaxProperty: null environment");
        return string;
    }

    public NameComponent[] toCosName() throws InvalidNameException {
        if (this._name.length == 0) {
            throw new InvalidNameException("This name cannot be represented as a CORBA CosNaming name because a CosNaming name cannot be empty.");
        }
        return this.cloneCosName(this._name);
    }

    public Name toJndiName() {
        return (WsnName)this.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        int n = this._name.length - 1;
        for (int i = 0; i < n; ++i) {
            this.cosComponentToString(this._name[i], stringBuffer);
            stringBuffer.append('/');
        }
        if (n >= 0) {
            this.cosComponentToString(this._name[n], stringBuffer);
        } else {
            this.cosComponentToString(EMPTY_COSNAME_COMPONENT, stringBuffer);
        }
        return stringBuffer.toString();
    }

    public Name add(int n, String string) throws InvalidNameException, ArrayIndexOutOfBoundsException {
        NameComponent[] nameComponentArray = new NameComponent[]{this.parseJndiNameComponentString(string)};
        this.insertComponents(nameComponentArray, n);
        return this;
    }

    public Name add(String string) throws InvalidNameException {
        NameComponent[] nameComponentArray = new NameComponent[]{this.parseJndiNameComponentString(string)};
        try {
            this.insertComponents(nameComponentArray, this._name.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            FFDCFilter.processException((Throwable)arrayIndexOutOfBoundsException, "com.ibm.ws.naming.util.WsnName.add", "426", this);
        }
        return this;
    }

    public Name addAll(int n, Name name) throws InvalidNameException, ArrayIndexOutOfBoundsException {
        NameComponent[] nameComponentArray = this.jndiNameToCosName(name);
        this.insertComponents(nameComponentArray, n);
        return this;
    }

    public Name addAll(Name name) throws InvalidNameException {
        NameComponent[] nameComponentArray = this.jndiNameToCosName(name);
        try {
            this.insertComponents(nameComponentArray, this._name.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            FFDCFilter.processException((Throwable)arrayIndexOutOfBoundsException, "com.ibm.ws.naming.util.WsnName.addAll", "495", this);
        }
        return this;
    }

    public Object clone() {
        WsnName wsnName = null;
        try {
            wsnName = this._name.length > 0 ? new WsnName(this._name, this._env) : new WsnName("", this._env);
        }
        catch (InvalidNameException invalidNameException) {
            FFDCFilter.processException((Throwable)invalidNameException, "com.ibm.ws.naming.util.WsnName.clone", "526", this);
        }
        catch (InvalidNameSyntaxException invalidNameSyntaxException) {
            FFDCFilter.processException((Throwable)invalidNameSyntaxException, "com.ibm.ws.naming.util.WsnName.clone", "531", this);
        }
        return wsnName;
    }

    public int compareTo(Object object) {
        Name name = (Name)object;
        int n = this._name.length;
        int n2 = name.size();
        for (int i = 0; i < n && i < n2; ++i) {
            int n3;
            try {
                NameComponent nameComponent = this.parseJndiNameComponentString(name.get(i));
                n3 = this._name[i].id.compareTo(nameComponent.id);
                if (n3 != 0) {
                    return n3;
                }
                n3 = this._name[i].kind.compareTo(nameComponent.kind);
                if (n3 == 0) continue;
                return n3;
            }
            catch (InvalidNameException invalidNameException) {
                StringBuffer stringBuffer = new StringBuffer(64);
                this.cosComponentToString(this._name[i], stringBuffer);
                String string = stringBuffer.toString();
                String string2 = name.get(i);
                n3 = string.compareTo(string2);
                if (n3 == 0) continue;
                return n3;
            }
        }
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return 0;
    }

    public boolean endsWith(Name name) {
        try {
            NameComponent[] nameComponentArray = this.jndiNameToCosName(name);
            boolean bl = this.compareName(this._name.length - nameComponentArray.length, nameComponentArray);
            return bl;
        }
        catch (InvalidNameException invalidNameException) {
            return false;
        }
    }

    public String get(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this._name.length) {
            throw new ArrayIndexOutOfBoundsException("Specified prefix position of " + n + " is out of range.  The current name length is " + this._name.length + ".");
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        this.cosComponentToString(this._name[n], stringBuffer);
        return stringBuffer.toString();
    }

    public Enumeration getAll() {
        WsnNameEnumeration wsnNameEnumeration = new WsnNameEnumeration(this);
        return wsnNameEnumeration;
    }

    public Name getPrefix(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this._name.length) {
            throw new ArrayIndexOutOfBoundsException("Specified prefix position of " + n + " is out of range.  The current name length is " + this._name.length + ".");
        }
        WsnName wsnName = null;
        try {
            if (n == 0) {
                wsnName = new WsnName("", this._env);
            } else {
                NameComponent[] nameComponentArray = this.subname(0, n);
                wsnName = new WsnName(nameComponentArray, this._env);
            }
        }
        catch (InvalidNameException invalidNameException) {
            FFDCFilter.processException((Throwable)invalidNameException, "com.ibm.ws.naming.util.WsnName.getPrefix", "706", this);
        }
        catch (InvalidNameSyntaxException invalidNameSyntaxException) {
            FFDCFilter.processException((Throwable)invalidNameSyntaxException, "com.ibm.ws.naming.util.WsnName.getPrefix", "711", this);
        }
        return wsnName;
    }

    public Name getSuffix(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this._name.length) {
            throw new ArrayIndexOutOfBoundsException("Specified prefix position of " + n + " is out of range.  The current name length is " + this._name.length + ".");
        }
        WsnName wsnName = null;
        try {
            if (n == this._name.length) {
                wsnName = new WsnName("", this._env);
            } else {
                NameComponent[] nameComponentArray = this.subname(n, this._name.length);
                wsnName = new WsnName(nameComponentArray, this._env);
            }
        }
        catch (InvalidNameException invalidNameException) {
            FFDCFilter.processException((Throwable)invalidNameException, "com.ibm.ws.naming.util.WsnName.getSuffix", "754", this);
        }
        catch (InvalidNameSyntaxException invalidNameSyntaxException) {
            FFDCFilter.processException((Throwable)invalidNameSyntaxException, "com.ibm.ws.naming.util.WsnName.getSuffix", "759", this);
        }
        return wsnName;
    }

    public boolean isEmpty() {
        return this._name.length == 0;
    }

    public Object remove(int n) throws InvalidNameException, ArrayIndexOutOfBoundsException {
        int n2;
        String string = this.get(n);
        NameComponent[] nameComponentArray = new NameComponent[this._name.length - 1];
        for (n2 = 0; n2 < n; ++n2) {
            nameComponentArray[n2] = this._name[n2];
        }
        for (n2 = n + 1; n2 < this._name.length; ++n2) {
            nameComponentArray[n2 - 1] = this._name[n2];
        }
        this._name = nameComponentArray;
        return string;
    }

    public int size() {
        return this._name.length;
    }

    public boolean startsWith(Name name) {
        try {
            NameComponent[] nameComponentArray = this.jndiNameToCosName(name);
            boolean bl = this.compareName(0, nameComponentArray);
            return bl;
        }
        catch (InvalidNameException invalidNameException) {
            return false;
        }
    }

    public void setName(NameComponent[] nameComponentArray) throws InvalidNameException {
        if (nameComponentArray == null || nameComponentArray.length == 0) {
            throw new InvalidNameException("Null or empty CosNaming names are not allowed.");
        }
        if (_tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(64);
            for (int i = 0; i < nameComponentArray.length; ++i) {
                stringBuffer.append("id=");
                stringBuffer.append(nameComponentArray[i].id);
                stringBuffer.append(", kind=");
                stringBuffer.append(nameComponentArray[i].kind);
                stringBuffer.append(";");
            }
            Tr.debug(_tc, "Name info:", "syntax=" + this._syntaxName + ", size=" + nameComponentArray.length + ", " + stringBuffer.toString());
        }
        for (int i = 0; i < nameComponentArray.length; ++i) {
            if (this._syntax != 0 || nameComponentArray[i].kind.equals("")) continue;
            throw new InvalidNameException("JNDI name syntax is being used and  the kind field in element " + i + " is not empty.");
        }
        this._name = this.cloneCosName(nameComponentArray);
    }

    public void setName(Name name) throws InvalidNameException {
        if (name == null) {
            throw new InvalidNameException("Null names are not allowed.");
        }
        int n = name.size();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Name info:", "syntax=" + this._syntaxName + ", size=" + n + ", name=\"" + name.toString() + "\"");
        }
        this._name = new NameComponent[n];
        for (int i = 0; i < n; ++i) {
            this._name[i] = this.parseJndiNameComponentString(name.get(i));
        }
    }

    public void setName(String string) throws InvalidNameException {
        if (string == null) {
            throw new InvalidNameException("Null names are not allowed.");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Name info:", "syntax=" + this._syntaxName + ", name=\"" + string + "\"");
        }
        String[] stringArray = this.separateNameComponents(string);
        int n = stringArray.length;
        this._name = new NameComponent[n];
        for (int i = 0; i < n; ++i) {
            this._name[i] = this.parseJndiNameComponentString(stringArray[i]);
        }
    }

    public void clearName() {
        this._name = new NameComponent[0];
    }

    private String[] separateNameComponents(String string) throws InvalidNameException {
        int n;
        int n2;
        int n3 = string.length();
        if (n3 == 0) {
            return new String[0];
        }
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        int n4 = 1;
        for (int i = 0; i < n3; ++i) {
            n2 = cArray[i];
            if (n2 == 47) {
                ++n4;
                continue;
            }
            if (n2 != 92) continue;
            ++i;
        }
        String[] stringArray = new String[n4];
        n4 = 0;
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            char c = cArray[n];
            if (c == '/') {
                stringArray[n4++] = string.substring(n2, n);
                n2 = n + 1;
                continue;
            }
            if (c == '\\' && ++n >= n3) break;
        }
        stringArray[n4] = string.substring(n2, n);
        return stringArray;
    }

    private NameComponent parseJndiNameComponentString(String string) throws InvalidNameException {
        char c;
        int n;
        int n2 = string.length();
        if (this._syntax == 1 && n2 == 0) {
            throw new InvalidNameException("The name component \"\" violates INS syntax.  An empty name component in INS syntax is represented as \".\".");
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = 0;
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            c = cArray[n];
            if (this._syntax == 1 && c == this._sep) {
                if (++n <= 1 || n < n2) break;
                throw new InvalidNameException("The name component \"" + string + "\" violates INS name syntax.  The non-empty id value ends with an " + "unescaped ID/KIND separator (\"" + this._sep + "\") and there is no kind value.");
            }
            if (c == '\\') {
                bl = true;
                if (++n >= n2) {
                    throw new InvalidNameException("Escape character (\\) occurred at end of the name component, \"" + string + "\".");
                }
                c = cArray[n];
                this.validateEscapedCharacter(c, string);
            }
            if (bl) {
                cArray[n3] = c;
            }
            ++n3;
        }
        String string2 = new String(cArray, 0, n3);
        int n4 = n3 = n;
        bl = false;
        while (n < n2) {
            c = cArray[n];
            if (c == this._sep) {
                throw new InvalidNameException("The name component \"" + string + "\" violates INS name syntax.  " + "There is more than one unescaped ID/KIND separator (\"" + this._sep + "\").");
            }
            if (c == '\\') {
                bl = true;
                if (++n >= n2) {
                    throw new InvalidNameException("Escape character (\\) occurred at end of the name component, \"" + string + "\".");
                }
                c = cArray[n];
                this.validateEscapedCharacter(c, string);
            }
            if (bl) {
                cArray[n3] = c;
            }
            ++n3;
            ++n;
        }
        String string3 = new String(cArray, n4, n3 - n4);
        return new NameComponent(string2, string3);
    }

    private void validateEscapedCharacter(char c, String string) throws InvalidNameException {
        switch (this._syntax) {
            case 0: {
                if (c == '\\' || c == '/') break;
                throw new InvalidNameException("Escape character (\\) was followed by a character other than \"/\" or \"\\\" in the name component, \"" + string + "\".");
            }
            case 1: {
                if (c == '\\' || c == '/' || c == this._sep) break;
                throw new InvalidNameException("Escape character (\\) was followed by a character other than \"/\", \"\\\", or \"" + this._sep + "\" in the " + "name component, \"" + string + "\".");
            }
        }
    }

    private NameComponent[] jndiNameToCosName(Name name) throws InvalidNameException {
        int n = name.size();
        NameComponent[] nameComponentArray = new NameComponent[n];
        for (int i = 0; i < n; ++i) {
            nameComponentArray[i] = this.parseJndiNameComponentString(name.get(i));
        }
        return nameComponentArray;
    }

    private void cosComponentToString(NameComponent nameComponent, StringBuffer stringBuffer) {
        this.insertEscapes(nameComponent.id, stringBuffer);
        if (this._syntax != 0) {
            if (nameComponent.id.length() == 0 || nameComponent.kind.length() > 0) {
                stringBuffer.append(this._sep);
            }
            this.insertEscapes(nameComponent.kind, stringBuffer);
        }
    }

    private void insertEscapes(String string, StringBuffer stringBuffer) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '/' || c == '\\') {
                stringBuffer.append('\\');
            } else if (this._syntax != 0 && c == this._sep) {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
    }

    private NameComponent[] subname(int n, int n2) {
        NameComponent[] nameComponentArray = new NameComponent[n2 - n];
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            nameComponentArray[n4] = new NameComponent(this._name[n3].id, this._name[n3].kind);
            ++n3;
            ++n4;
        }
        return nameComponentArray;
    }

    private boolean compareName(int n, NameComponent[] nameComponentArray) {
        if (n < 0 || n + nameComponentArray.length > this._name.length) {
            return false;
        }
        int n2 = 0;
        int n3 = n;
        while (n2 < nameComponentArray.length) {
            if (!this._name[n3].id.equals(nameComponentArray[n2].id) || !this._name[n3].kind.equals(nameComponentArray[n2].kind)) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    private NameComponent[] cloneCosName(NameComponent[] nameComponentArray) {
        NameComponent[] nameComponentArray2 = new NameComponent[nameComponentArray.length];
        for (int i = 0; i < nameComponentArray.length; ++i) {
            nameComponentArray2[i] = new NameComponent(nameComponentArray[i].id, nameComponentArray[i].kind);
        }
        return nameComponentArray2;
    }

    private void insertComponents(NameComponent[] nameComponentArray, int n) throws ArrayIndexOutOfBoundsException {
        int n2;
        if (n < 0 || n > this._name.length) {
            throw new ArrayIndexOutOfBoundsException("Name component insertion position of " + n + " is out of range.  The current name length is " + this._name.length + ".");
        }
        NameComponent[] nameComponentArray2 = new NameComponent[this._name.length + nameComponentArray.length];
        for (n2 = 0; n2 < n; ++n2) {
            nameComponentArray2[n2] = this._name[n2];
        }
        n2 = 0;
        int n3 = n;
        while (n2 < nameComponentArray.length) {
            nameComponentArray2[n3] = nameComponentArray[n2];
            ++n2;
            ++n3;
        }
        n2 = n;
        n3 = n + nameComponentArray.length;
        while (n2 < this._name.length) {
            nameComponentArray2[n3] = this._name[n2];
            ++n2;
            ++n3;
        }
        this._name = nameComponentArray2;
    }
}

