/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.util.IndirectJndiLookupObjectFactory;
import com.ibm.ws.naming.util.JndiLookupInfo;
import com.ibm.ws.naming.util.JndiLookupInfoRefAddr;
import com.ibm.ws.naming.util.Serialization;
import java.io.IOException;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;

public class IndirectJndiLookup
implements Referenceable {
    public static final String REF_ADDR_TYPE_PROPERTIES = "IndirectJndiLookupAdditionalProperties";
    private static final TraceComponent tc = Tr.register(IndirectJndiLookup.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String REF_CLASS_NAME = "java.lang.Object";
    private JndiLookupInfo _info;
    private String _refClassName;
    private Properties _props;
    private static final String METHOD_init = "init(String, String, String, String, Properties)";
    private static final String METHOD_getReference = "getReference()";

    public IndirectJndiLookup(String string, String string2, String string3, boolean bl, String string4, Properties properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String, boolean, String, Properties)", "jndiName = " + string);
        }
        this.init(string, string2, string3, string4, properties);
    }

    public IndirectJndiLookup(String string, String string2, String string3, String string4, Properties properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String, String, Properties)", "jndiName = " + string);
        }
        this.init(string, string2, string3, string4, properties);
    }

    public IndirectJndiLookup(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String)", "jndiName = " + string);
        }
        this.init(string, "", "", REF_CLASS_NAME, null);
    }

    public IndirectJndiLookup(String string, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, boolean)", "jndiName = " + string);
        }
        this.init(string, "", "", REF_CLASS_NAME, null);
    }

    public IndirectJndiLookup(String string, String string2, String string3) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String)", "jndiName = " + string);
        }
        this.init(string, string2, string3, REF_CLASS_NAME, null);
    }

    public IndirectJndiLookup(String string, String string2, String string3, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String, boolean)", "jndiName = " + string);
        }
        this.init(string, string2, string3, REF_CLASS_NAME, null);
    }

    public IndirectJndiLookup(String string, String string2, String string3, boolean bl, String string4) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String, boolean, String)", "jndiName = " + string);
        }
        this.init(string, string2, string3, string4, null);
    }

    public IndirectJndiLookup(String string, String string2, String string3, String string4) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "IndirectJndiLookup(String, String, String, String)", "jndiName = " + string);
        }
        this.init(string, string2, string3, string4, null);
    }

    private void init(String string, String string2, String string3, String string4, Properties properties) {
        Tr.entry(tc, METHOD_init);
        if (string == null || string.equals("")) {
            Tr.warning(tc, "indJndiLookupEmptyName", new Throwable());
        }
        this._info = new JndiLookupInfo(string, string2, string3);
        if (string4 == null || string4.equals("")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null or empty Reference class name specified.  Defaulting to java.lang.Object");
            }
            string4 = REF_CLASS_NAME;
        }
        this._refClassName = string4;
        this._props = properties;
        Tr.exit(tc, METHOD_init);
    }

    public Reference getReference() throws NamingException {
        Tr.entry(tc, METHOD_getReference);
        Reference reference = null;
        reference = new Reference(this._refClassName, new JndiLookupInfoRefAddr(this._info), IndirectJndiLookupObjectFactory.class.getName(), null);
        if (this._props != null) {
            byte[] byArray = null;
            try {
                byArray = Serialization.serializeObject(this._props);
            }
            catch (IOException iOException) {
                NamingException namingException = new NamingException("Could not serialize Properties object.");
                namingException.setRootCause(iOException);
                throw namingException;
            }
            BinaryRefAddr binaryRefAddr = new BinaryRefAddr(REF_ADDR_TYPE_PROPERTIES, byArray);
            reference.add(binaryRefAddr);
        }
        Tr.exit(tc, METHOD_getReference);
        return reference;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/ws/naming/util/IndirectJndiLookup.java, WAS.naming, WAS61.SERV1, cf130745.06, ver. 1.17");
        }
    }
}

