/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.management.Notification;

public class PushRemoteReceiver
extends RemoteReceiver
implements PushNotificationListener {
    private static TraceComponent _tc = Tr.register(PushRemoteReceiver.class, "Admin", "com.ibm.ws.management.resources.event");
    private final List _notificationList = new ArrayList();
    private NotificationHandlerThread _nhThread;

    public PushRemoteReceiver(AdminServiceProxy adminServiceProxy) {
        super(adminServiceProxy);
    }

    public void setRunLocally() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotifications(Notification[] notificationArray) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Received " + notificationArray.length + " notifications");
        }
        PushRemoteReceiver pushRemoteReceiver = this;
        synchronized (pushRemoteReceiver) {
            if (this._nhThread == null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "This PushRemoteReceiver is currently not subscribed.  The handleNotifications method is ignoring notifications.");
                }
                return;
            }
            List list = this._notificationList;
            synchronized (list) {
                for (int i = 0; i < notificationArray.length; ++i) {
                    this._notificationList.add(notificationArray[i]);
                }
            }
            this._nhThread.wakeHandlerThread(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribe() throws ConnectorException {
        PushRemoteReceiver pushRemoteReceiver = this;
        synchronized (pushRemoteReceiver) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "subscribe");
            }
            super.subscribe();
            if (this._nhThread == null) {
                this._nhThread = new NotificationHandlerThread();
                this._nhThread.start();
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "subscribe");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribe() throws ReceiverNotFoundException, ConnectorException {
        PushRemoteReceiver pushRemoteReceiver = this;
        synchronized (pushRemoteReceiver) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "unsubscribe");
            }
            super.unsubscribe();
            this._nhThread.wakeHandlerThread(true);
            this._nhThread = null;
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "unsubscribe");
            }
        }
    }

    class NotificationHandlerThread
    extends Thread {
        private Notification[] notifs;
        private boolean wakeUpSignaled = false;
        private boolean stopThread = false;

        NotificationHandlerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl;
            do {
                bl = this.waitForMoreNotifications();
                List list = PushRemoteReceiver.this._notificationList;
                synchronized (list) {
                    if (!PushRemoteReceiver.this._notificationList.isEmpty()) {
                        this.notifs = PushRemoteReceiver.this._notificationList.toArray(new Notification[PushRemoteReceiver.this._notificationList.size()]);
                        PushRemoteReceiver.this._notificationList.clear();
                    }
                }
                if (this.notifs != null) {
                    for (int i = 0; i < this.notifs.length; ++i) {
                        PushRemoteReceiver.this.handleNotification(this.notifs[i]);
                    }
                }
                this.notifs = null;
            } while (!bl);
        }

        private synchronized boolean waitForMoreNotifications() {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "waitForMoreNotifications");
            }
            if (!this.wakeUpSignaled) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.wakeUpSignaled = false;
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "waitForMoreNotifications", "stopThread=" + this.stopThread);
            }
            return this.stopThread;
        }

        private synchronized void wakeHandlerThread(boolean bl) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "wakeHandlerThread", "stopThread=" + bl);
            }
            this.stopThread = bl;
            this.wakeUpSignaled = true;
            this.notify();
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "wakeHandlerThread");
            }
        }
    }
}

