/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.ListenerInfo;
import com.ibm.ws.management.event.NotificationInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ListenerCollection {
    private static TraceComponent tc = Tr.register(ListenerCollection.class, "Admin", "com.ibm.ws.management.resources.event");
    private Map listenersByObjectName = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ListenerInfo listenerInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add", listenerInfo);
        }
        boolean bl = false;
        Map map = this.listenersByObjectName;
        synchronized (map) {
            List list = (List)this.listenersByObjectName.get(listenerInfo.getObjectName());
            if (list == null) {
                this.insertList(listenerInfo);
                bl = true;
            } else if (!list.contains(listenerInfo)) {
                list.add(listenerInfo);
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add", new Boolean(bl));
        }
        return bl;
    }

    private void insertList(ListenerInfo listenerInfo) {
        List<ListenerInfo> list = Collections.synchronizedList(new ArrayList());
        list.add(listenerInfo);
        this.listenersByObjectName.put(listenerInfo.getObjectName(), list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ListenerInfo listenerInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", listenerInfo);
        }
        boolean bl = false;
        Map map = this.listenersByObjectName;
        synchronized (map) {
            ObjectName objectName = listenerInfo.getObjectName();
            List list = (List)this.listenersByObjectName.get(objectName);
            if (list != null && (bl = list.remove(listenerInfo)) && list.isEmpty()) {
                this.listenersByObjectName.remove(objectName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(ObjectName objectName, NotificationListener notificationListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAll", new Object[]{objectName, notificationListener});
        }
        boolean bl = false;
        Map map = this.listenersByObjectName;
        synchronized (map) {
            if (objectName == null) {
                Iterator iterator = this.listenersByObjectName.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    boolean bl2 = this.removeMatchingNotificationListeners((List)entry.getValue(), (ObjectName)entry.getKey(), notificationListener);
                    if (!bl2) continue;
                    if (((List)entry.getValue()).isEmpty()) {
                        iterator.remove();
                    }
                    bl = true;
                }
            } else {
                List list = (List)this.listenersByObjectName.get(objectName);
                bl = this.removeMatchingNotificationListeners(list, objectName, notificationListener);
                if (bl && list.isEmpty()) {
                    this.listenersByObjectName.remove(objectName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAll", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMatchingNotificationListeners(List list, ObjectName objectName, NotificationListener notificationListener) {
        boolean bl = false;
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ListenerInfo listenerInfo = (ListenerInfo)iterator.next();
                    if (!listenerInfo.getNotificationListener().equals(notificationListener)) continue;
                    iterator.remove();
                    bl = true;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getListeners(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getListeners", notification);
        }
        ArrayList arrayList = null;
        Map map = this.listenersByObjectName;
        synchronized (map) {
            arrayList = new ArrayList();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Number of lists: " + this.listenersByObjectName.size());
            }
            Iterator iterator = this.listenersByObjectName.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Examining ObjectName " + entry.getKey());
                    }
                    if (!NotificationInfo.containsName((ObjectName)entry.getKey(), (ObjectName)notification.getSource())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding list");
                    }
                    arrayList.add(entry.getValue());
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException((Throwable)classCastException, "com.ibm.ws.management.event.ListenerInfo.getListeners", "209", this);
                }
            }
            if (arrayList.isEmpty()) {
                arrayList = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getListeners", arrayList);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int n = 0;
        Map map = this.listenersByObjectName;
        synchronized (map) {
            Iterator iterator = this.listenersByObjectName.values().iterator();
            while (iterator.hasNext()) {
                n += ((List)iterator.next()).size();
            }
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map map = this.listenersByObjectName;
        synchronized (map) {
            return "ListenerCollection: " + this.listenersByObjectName.toString();
        }
    }
}

