/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.rmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorAuthenticationException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.connector.rmi.RMIConnector;
import com.ibm.ws.management.connector.rmi.RMINotificationListener;
import com.ibm.ws.management.connector.rmi.RMINotificationListenerService;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.PushRemoteReceiver;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.wsspi.ssl.RetrieveSignersHelper;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;

public class RMIConnectorClient
implements AdminServiceProxy {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(RMIConnectorClient.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private RMIConnector connector;
    private RMINotificationListener rmiListener;
    private Properties proxyProps;
    private boolean online = false;

    public RMIConnectorClient(Properties properties) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>" + this.getPropsString(properties));
        }
        this.proxyProps = new Properties();
        this.proxyProps.setProperty("type", "RMI");
        this.proxyProps.setProperty("host", properties.getProperty("host"));
        this.proxyProps.setProperty("port", properties.getProperty("port"));
        if (properties.getProperty("autoAcceptSignerForThisConnectionOnly") != null) {
            this.proxyProps.setProperty("autoAcceptSignerForThisConnectionOnly", properties.getProperty("autoAcceptSignerForThisConnectionOnly"));
        }
        this.proxyProps.setProperty("securityEnabled", properties.getProperty("securityEnabled", "false"));
        if (properties.getProperty("isInternal") != null) {
            this.proxyProps.setProperty("isInternal", properties.getProperty("isInternal"));
        }
        this.proxyProps.setProperty("com.ibm.websphere.naming.jndicache.cacheobject", "none");
        String string = this.proxyProps.getProperty("host", "localhost");
        if (string.indexOf(58) > -1 && string.indexOf(91) < 0) {
            string = "[" + string + "]";
        }
        String string2 = "iiop://" + string + ":" + this.proxyProps.getProperty("port", "2809");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using PROVIDER_URL " + string2);
        }
        this.proxyProps.setProperty("java.naming.provider.url", string2);
        boolean bl = properties.getProperty("username") != null & properties.getProperty("password") != null;
        if (bl) {
            this.reconnect(properties);
        } else {
            this.reconnect();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupSecurityCredentials(Properties properties) throws ConnectorAuthenticationException {
        boolean bl;
        boolean bl2 = bl = new Boolean(properties.getProperty("isInternal")) == false;
        if (bl) {
            String string = properties.getProperty("username");
            String string2 = properties.getProperty("password");
            if (tc.isDebugEnabled() && string == null) {
                Tr.debug(tc, "username not specified");
            }
            if (tc.isDebugEnabled() && string2 == null) {
                Tr.debug(tc, "password not specified");
            }
            try {
                if (string == null || string2 == null) return;
                Subject subject = SecurityHelper.authenticate(string, string2);
                SecurityHelper.setInvocationSubject(subject);
                return;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to login", exception);
                }
                if (!tc.isEntryEnabled()) throw new ConnectorAuthenticationException(nls.getString("ADMC0039E", "RMI Connector login failed"), exception);
                Tr.exit(tc, "<init> - exception");
                throw new ConnectorAuthenticationException(nls.getString("ADMC0039E", "RMI Connector login failed"), exception);
            }
        } else {
            this.setupInternalSecurityCredentials();
        }
    }

    public RMIConnector getRMIConnector() {
        return this.connector;
    }

    public String getType() {
        return "RMI";
    }

    public Properties getProxyProperties() {
        return this.proxyProps;
    }

    private void reconnect() throws ConnectorException, ConnectorNotAvailableException {
        this.reconnect(null);
    }

    private void reconnect(Properties properties) throws ConnectorException, ConnectorNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reconnect " + this.getPropsString(properties));
        }
        try {
            Properties properties2 = new Properties();
            String string = this.proxyProps.getProperty("host", "localhost");
            if (string.indexOf(58) > -1 && string.indexOf(91) < 0) {
                string = "[" + string + "]";
            }
            properties2.put("java.naming.provider.url", "corbaloc:iiop:" + string + ":" + this.proxyProps.getProperty("port", "2809") + "/" + "WsnAdminNameService");
            InitialContext initialContext = new InitialContext(properties2);
            if (properties != null) {
                try {
                    initialContext.lookup("");
                    this.setupSecurityCredentials(properties);
                }
                catch (Exception exception) {
                    throw new ConnectorException(exception);
                }
            }
            this.connector = (RMIConnector)PortableRemoteObject.narrow((Object)initialContext.lookup("RMIConnector"), (Class)RMIConnector.class);
            this.online = true;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.reconnect", "237", this);
            this.online = false;
            throw new ConnectorNotAvailableException(namingException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnect");
        }
    }

    public RemoteReceiver openRemoteNotificationChannel(AdminServiceProxy adminServiceProxy) {
        PushRemoteReceiver pushRemoteReceiver = new PushRemoteReceiver(adminServiceProxy);
        try {
            this.rmiListener = (RMINotificationListener)PortableRemoteObject.toStub((Remote)new RMINotificationListenerService(pushRemoteReceiver));
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.createRemoteReceiver", "258", this);
        }
        return pushRemoteReceiver;
    }

    private void handleRemoteException(RemoteException remoteException) throws ConnectorException {
        this.online = false;
        throw new ConnectorException("RemoteException received", remoteException);
    }

    public Session isAlive() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isAlive");
        }
        if (!this.online) {
            this.reconnect();
        }
        Session session = null;
        try {
            session = this.connector.isAlive();
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                session = this.connector.isAlive();
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.isAlive", "292", this);
                this.handleRemoteException(remoteException);
            }
        }
        return session;
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking queryNames");
        }
        if (!this.online) {
            this.reconnect();
        }
        Set set = null;
        try {
            set = this.connector.queryNames(objectName, queryExp);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                set = this.connector.queryNames(objectName, queryExp);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.queryNames", "326", this);
                this.handleRemoteException(remoteException);
            }
        }
        return set;
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getAttribute");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean bl = false;
        if (this.proxyProps.getProperty("isInternal") != null) {
            bl = new Boolean(this.proxyProps.getProperty("isInternal"));
        }
        if (bl) {
            this.setupInternalSecurityCredentials();
        }
        Object object = null;
        try {
            object = this.connector.getAttribute(objectName, string);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                object = this.connector.getAttribute(objectName, string);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getAttribute", "357", this);
                this.handleRemoteException(remoteException);
            }
        }
        return object;
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getAttributes");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean bl = false;
        if (this.proxyProps.getProperty("isInternal") != null) {
            bl = new Boolean(this.proxyProps.getProperty("isInternal"));
        }
        if (bl) {
            this.setupInternalSecurityCredentials();
        }
        AttributeList attributeList = null;
        try {
            attributeList = this.connector.getAttributes(objectName, stringArray);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                attributeList = this.connector.getAttributes(objectName, stringArray);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getAttributes", "386", this);
                this.handleRemoteException(remoteException);
            }
        }
        return attributeList;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking setAttribute");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean bl = false;
        if (this.proxyProps.getProperty("isInternal") != null) {
            bl = new Boolean(this.proxyProps.getProperty("isInternal"));
        }
        if (bl) {
            this.setupInternalSecurityCredentials();
        }
        try {
            this.connector.setAttribute(objectName, attribute);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                this.connector.setAttribute(objectName, attribute);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.setAttribute", "417", this);
                this.handleRemoteException(remoteException);
            }
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking setAttributes");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean bl = false;
        if (this.proxyProps.getProperty("isInternal") != null) {
            bl = new Boolean(this.proxyProps.getProperty("isInternal"));
        }
        if (bl) {
            this.setupInternalSecurityCredentials();
        }
        AttributeList attributeList2 = null;
        try {
            attributeList2 = this.connector.setAttributes(objectName, attributeList);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                attributeList2 = this.connector.setAttributes(objectName, attributeList);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.setAttributes", "445", this);
                this.handleRemoteException(remoteException);
            }
        }
        return attributeList2;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking invoke");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean bl = false;
        if (this.proxyProps.getProperty("isInternal") != null) {
            bl = new Boolean(this.proxyProps.getProperty("isInternal"));
        }
        if (bl) {
            this.setupInternalSecurityCredentials();
        }
        Object object = null;
        try {
            object = this.connector.invoke(objectName, string, objectArray, stringArray);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                object = this.connector.invoke(objectName, string, objectArray, stringArray);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.invoke", "475", this);
                this.handleRemoteException(remoteException);
            }
        }
        return object;
    }

    public String getDefaultDomain() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getDefaultDomain");
        }
        if (!this.online) {
            this.reconnect();
        }
        String string = null;
        try {
            string = this.connector.getDefaultDomain();
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                string = this.connector.getDefaultDomain();
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getDefaultDomain", "503", this);
                this.handleRemoteException(remoteException);
            }
        }
        return string;
    }

    public String getDomainName() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getDomainName");
        }
        if (!this.online) {
            this.reconnect();
        }
        String string = null;
        try {
            string = this.connector.getDomainName();
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                string = this.connector.getDomainName();
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getDomainName", "530", this);
                this.handleRemoteException(remoteException);
            }
        }
        return string;
    }

    public Integer getMBeanCount() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getMBeanCount");
        }
        if (!this.online) {
            this.reconnect();
        }
        Integer n = null;
        try {
            n = this.connector.getMBeanCount();
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                n = this.connector.getMBeanCount();
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getMBeanCount", "557", this);
                this.handleRemoteException(remoteException);
            }
        }
        return n;
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getMBeanInfo");
        }
        if (!this.online) {
            this.reconnect();
        }
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = this.connector.getMBeanInfo(objectName);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                mBeanInfo = this.connector.getMBeanInfo(objectName);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getMBeanInfo", "587", this);
                this.handleRemoteException(remoteException);
            }
        }
        return mBeanInfo;
    }

    public boolean isRegistered(ObjectName objectName) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isRegistered");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean bl = false;
        try {
            bl = this.connector.isRegistered(objectName);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                bl = this.connector.isRegistered(objectName);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.isRegistered", "615", this);
                this.handleRemoteException(remoteException);
            }
        }
        return bl;
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isInstanceOf");
        }
        if (!this.online) {
            this.reconnect();
        }
        boolean bl = false;
        try {
            bl = this.connector.isInstanceOf(objectName, string);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                bl = this.connector.isInstanceOf(objectName, string);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.isInstanceOf", "644", this);
                this.handleRemoteException(remoteException);
            }
        }
        return bl;
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter consolidatedFilter, PushNotificationListener pushNotificationListener) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking addNotificationListener");
        }
        if (!this.online) {
            this.reconnect();
        }
        ListenerIdentifier listenerIdentifier = null;
        try {
            if (pushNotificationListener != null) {
                RMINotificationListener rMINotificationListener = this.createRMIWrapperForListener(pushNotificationListener);
                if (rMINotificationListener != null) {
                    listenerIdentifier = this.connector.addRMINotificationListener(consolidatedFilter, rMINotificationListener);
                }
            } else {
                listenerIdentifier = this.connector.addRMINotificationListener(consolidatedFilter, this.rmiListener);
            }
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                listenerIdentifier = this.connector.addRMINotificationListener(consolidatedFilter, this.rmiListener);
                if (pushNotificationListener != null) {
                    RMINotificationListener rMINotificationListener = this.createRMIWrapperForListener(pushNotificationListener);
                    if (rMINotificationListener != null) {
                        listenerIdentifier = this.connector.addRMINotificationListener(consolidatedFilter, rMINotificationListener);
                    }
                } else {
                    listenerIdentifier = this.connector.addRMINotificationListener(consolidatedFilter, this.rmiListener);
                }
            }
            catch (RemoteException remoteException2) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception received from connector.addRMINotificationListener:", remoteException2);
                }
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.addNotificationListener", "716", this);
                this.handleRemoteException(remoteException);
            }
        }
        return listenerIdentifier;
    }

    private RMINotificationListener createRMIWrapperForListener(PushNotificationListener pushNotificationListener) throws RemoteException {
        RMINotificationListenerService rMINotificationListenerService = null;
        try {
            rMINotificationListenerService = new RMINotificationListenerService(pushNotificationListener);
        }
        catch (RemoteException remoteException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "createRMIWrapperForListener:  Exception received:", remoteException);
            }
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.createRMIWrapperForListener", "765", this);
        }
        return rMINotificationListenerService;
    }

    public void removeNotificationListener(ListenerIdentifier listenerIdentifier) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking removeNotificationListener");
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.removeNotificationListener(listenerIdentifier);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                this.connector.removeNotificationListener(listenerIdentifier);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.removeNotificationListener", "795", this);
                this.handleRemoteException(remoteException);
            }
        }
    }

    public void resetFilter(ListenerIdentifier listenerIdentifier, ConsolidatedFilter consolidatedFilter) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking resetFilter");
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.resetFilter(listenerIdentifier, consolidatedFilter);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                this.connector.resetFilter(listenerIdentifier, consolidatedFilter);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.resetFilter", "823", this);
                this.handleRemoteException(remoteException);
            }
        }
    }

    public Notification[] pullNotifications(ListenerIdentifier listenerIdentifier, Integer n) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking pullNotifications");
        }
        if (!this.online) {
            this.reconnect();
        }
        Notification[] notificationArray = null;
        try {
            notificationArray = this.connector.pullNotifications(listenerIdentifier, n);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                notificationArray = this.connector.pullNotifications(listenerIdentifier, n);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getEvents", "854", this);
                this.handleRemoteException(remoteException);
            }
        }
        return notificationArray;
    }

    public ObjectName getServerMBean() throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getServerMBean");
        }
        if (!this.online) {
            this.reconnect();
        }
        ObjectName objectName = null;
        try {
            objectName = this.connector.getServerMBean();
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                objectName = this.connector.getServerMBean();
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getServerMBean", "882", this);
                this.handleRemoteException(remoteException);
            }
        }
        return objectName;
    }

    private String getPropsString(Properties properties) {
        String string = "props: {";
        int n = 0;
        if (properties == null) {
            string = string + "null";
        } else {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration != null && enumeration.hasMoreElements()) {
                if (n > 0) {
                    string = string + ",";
                }
                ++n;
                String string2 = (String)enumeration.nextElement();
                if (string2.equals("password") || string2.endsWith("Password")) {
                    string = string + " " + string2 + "=" + "*****";
                    continue;
                }
                string = string + " " + string2 + "=" + properties.get(string2);
            }
        }
        string = string + "}";
        return string;
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws ConnectorException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking queryMBeans");
        }
        if (!this.online) {
            this.reconnect();
        }
        Set set = null;
        try {
            set = this.connector.queryMBeans(objectName, queryExp);
        }
        catch (RemoteException remoteException) {
            this.reconnect();
            try {
                set = this.connector.queryMBeans(objectName, queryExp);
            }
            catch (RemoteException remoteException2) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.queryMBeans", "928", this);
                this.handleRemoteException(remoteException);
            }
        }
        return set;
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoaderFor", objectName);
        }
        if (!this.online) {
            this.reconnect();
        }
        ClassLoader classLoader = null;
        try {
            classLoader = this.connector.getClassLoaderFor(objectName);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getClassLoaderFor", "951", this);
            this.handleRemoteException(remoteException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoaderFor", classLoader);
        }
        return classLoader;
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoader", objectName);
        }
        if (!this.online) {
            this.reconnect();
        }
        ClassLoader classLoader = null;
        try {
            classLoader = this.connector.getClassLoader(objectName);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getClassLoader", "976", this);
            this.handleRemoteException(remoteException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoader", classLoader);
        }
        return classLoader;
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance", objectName);
        }
        if (!this.online) {
            this.reconnect();
        }
        ObjectInstance objectInstance = null;
        try {
            objectInstance = this.connector.getObjectInstance(objectName);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.getObjectInstance", "1002", this);
            this.handleRemoteException(remoteException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance", objectInstance);
        }
        return objectInstance;
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{objectName, objectName2, notificationFilter, object});
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.addNotificationListener(objectName, objectName2, notificationFilter, object);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.addNotificationListener", "1029", this);
            this.handleRemoteException(remoteException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener");
        }
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener_2", new Object[]{objectName, objectName2});
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.removeNotificationListener_2(objectName, objectName2);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.removeNotificationListener", "1053", this);
            this.handleRemoteException(remoteException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener_2");
        }
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener_4", new Object[]{objectName, objectName2, notificationFilter, object});
        }
        if (!this.online) {
            this.reconnect();
        }
        try {
            this.connector.removeNotificationListener_4(objectName, objectName2, notificationFilter, object);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorClient.removeNotificationListener", "1077", this);
            this.handleRemoteException(remoteException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener_4");
        }
    }

    private void setupInternalSecurityCredentials() {
        block7: {
            boolean bl = new Boolean(this.proxyProps.getProperty("securityEnabled"));
            Tr.debug(tc, "setupInternalSecurityCredentials " + bl);
            if (!bl) {
                return;
            }
            boolean bl2 = new Boolean(this.proxyProps.getProperty("autoAcceptSignerForThisConnectionOnly"));
            if (bl2) {
                Tr.debug(tc, "autoAcceptSignerForThisConnectionOnly");
                RetrieveSignersHelper.getInstance().autoAcceptSignerForThisConnectionOnly();
            }
            Subject subject = null;
            try {
                subject = SecurityHelper.getInvocationSubject();
                if (subject == null) {
                    subject = SecurityHelper.getReceivedSubject();
                }
                if (subject != null) {
                    SecurityHelper.setInvocationSubject(subject);
                } else {
                    Tr.service(tc, "ADMC0032W");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "exception occurred setting invocation credential", exception);
            }
        }
    }
}

