/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.interop;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.management.util.UtilsClient;
import java.util.Vector;
import org.apache.soap.Header;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.util.xml.QName;

public class JMXVersionValidation {
    private static TraceComponent tc = Tr.register(JMXVersionValidation.class, "Admin", "com.ibm.ws.management.connector");
    public static final String jmxVersion = "1.2.0";
    public static final String oldJmxVersion = "1.0.0";
    private static ThreadLocal clientVersion = new ThreadLocal();

    public static void setClientVersion(String string) {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "setClientVersion to " + string);
        }
        if (string == null) {
            string = "5";
        }
        clientVersion.set(string);
    }

    public String getClientVersion() {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getClientVersion: " + clientVersion.get());
        }
        return (String)clientVersion.get();
    }

    public static Header getJmxVersionHeader(Header header, String string) {
        Header header2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJmxVersionHeader", new Object[]{header, string});
        }
        if ((header2 = header) == null) {
            header2 = new Header();
        }
        header2.setAttribute(new QName("admin", "JMXVersion"), jmxVersion);
        if (string != null) {
            header2.setAttribute(new QName("admin", "JMXMessageVersion"), string);
        }
        String string2 = null;
        try {
            string2 = UtilsClient.getProductVersion();
        }
        catch (Exception exception) {
            string2 = "6.0.0.0";
        }
        if (string2 != null) {
            header2.setAttribute(new QName("admin", "WASRemoteRuntimeVersion"), string2);
        }
        if (tc.isDebugEnabled()) {
            header2.setAttribute(new QName("admin", "ProcessVersion"), JMXVersionValidation.getLocalWASVersion());
        }
        if (header2.getHeaderEntries() == null) {
            header2.setHeaderEntries(new Vector());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJmxVersionHeader", new Object[]{header2});
        }
        return header2;
    }

    public static String getLocalWASVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalVersion");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (string == null) {
            string4 = "client";
            string2 = System.getProperty("local.cell");
            string3 = System.getProperty("local.node");
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (adminService != null) {
                string4 = AdminServiceFactory.getAdminService().getProcessName();
                string2 = AdminServiceFactory.getAdminService().getCellName();
                string3 = AdminServiceFactory.getAdminService().getNodeName();
            }
            try {
                string5 = UtilsClient.getProductVersion();
            }
            catch (NullPointerException nullPointerException) {
                string5 = "6.0.0.0";
            }
            string = new String(string2 + ":" + string3 + ":" + string4 + ":" + string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalVersion " + string);
        }
        return string;
    }

    public static String getRemoteVersion(RPCMessage rPCMessage) {
        Header header = null;
        if (rPCMessage != null) {
            header = rPCMessage.getHeader();
        }
        return JMXVersionValidation.getRemoteVersion(header);
    }

    public static String getRemoteVersion(Header header) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteVersion", new Object[]{header});
        }
        String string = oldJmxVersion;
        if (header != null) {
            string = header.getAttribute(new QName("admin", "JMXVersion"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "got remote version from header = " + string);
            }
        }
        if (string == null) {
            string = oldJmxVersion;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remote version from header was null, set to old version " + string);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getRemoteVersion " + string);
        }
        return string;
    }

    public static boolean isRemoteVersionTmx4j(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRemoteVersionTmx4j(" + string + ")");
        }
        boolean bl = false;
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "isRemoteVersionTmx4j(String) - version is null");
            }
            string = oldJmxVersion;
        }
        if (string != null && jmxVersion.compareTo(string) > 0) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRemoteVersionTmx4j? " + bl);
        }
        return bl;
    }
}

