/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.InstallSchedulerImpl;
import com.ibm.ws.management.application.UninstallSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class SystemAppsConfigureTask
extends AbstractTask {
    private RepositoryContext _appC = null;
    private static final String systemAppsFileName = "systemapps.xml";
    private static TraceComponent tc = Tr.register(SystemAppsConfigureTask.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        this._appC = null;
        try {
            Vector vector = null;
            RepositoryContext repositoryContext = this.scheduler.getWorkSpace().findContext("cells/" + this.scheduler.getProperties().get("cell.name"));
            Hashtable hashtable = this.scheduler.getProperties();
            vector = ConfigRepoHelper.getServerNames(AppUtils.getTargetStr(hashtable), AppUtils.getTargetStr(hashtable), false, repositoryContext, this.scheduler.getWorkSpace());
            this.checkDeploymentXML();
            String string = this.updateSystemAppSIEntries(vector);
            AppNotification appNotification = this.createNotification("Completed", "ADMA5005I", new String[]{this.scheduler.getAppName()});
            Properties properties = new Properties();
            if (string != null) {
                properties.setProperty("nodes", string);
            }
            appNotification.setProperties(properties);
            this.scheduler.propagateTaskEvent(appNotification);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.SystemAppsConfigureTask.performTask", "108", this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), throwable.toString()}));
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0066E"));
        }
    }

    private void checkDeploymentXML() throws Exception {
        if (this.scheduler instanceof InstallScheduler && !this.scheduler.getProperties().containsKey("systemApp")) {
            AppUtils.dbg(tc, "check for deployment.xml");
            InstallScheduler installScheduler = (InstallScheduler)this.scheduler;
            EARFile eARFile = installScheduler.getEarFile(false, true);
            if (!eARFile.containsFile("deployment.xml")) {
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA5111E"));
            }
        }
    }

    private String updateSystemAppSIEntries(Vector vector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSystemAppSIEntries: " + vector);
        }
        Vector vector2 = vector;
        Hashtable hashtable = null;
        if (this.scheduler instanceof UninstallSchedulerImpl && (hashtable = this.updateSystemAppsXMLDocs(this._appC, this.scheduler.getWorkSpace(), vector2, false, this.getResourceBundle())) != null) {
            this.scheduler.getProperties().put("nodesvr.removed", hashtable);
        }
        if (this.scheduler instanceof InstallSchedulerImpl && (hashtable = this.updateSystemAppsXMLDocs(this._appC, this.scheduler.getWorkSpace(), vector2, true, this.getResourceBundle())) != null) {
            this.scheduler.getProperties().put("nodesvr.added", hashtable);
        }
        String string = "";
        if (hashtable != null) {
            RepositoryContext repositoryContext = this.scheduler.getWorkSpace().findContext("cells/" + this.scheduler.getProperties().get("cell.name"));
            string = ConfigRepoHelper.getNodeStrFromNodeSvrTable(hashtable, repositoryContext.getName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSystemAppSIEntries: " + string);
        }
        return string;
    }

    public Hashtable updateSystemAppsXMLDocs(RepositoryContext repositoryContext, WorkSpace workSpace, Vector vector, boolean bl, ResourceBundle resourceBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSystemAppsXMLDocs: " + vector);
        }
        Hashtable hashtable = ConfigRepoHelper.getNodeServerRelation(workSpace, vector);
        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6018I", new Object[]{hashtable}));
        Hashtable hashtable2 = this.getSystemAppsXMLDocs(workSpace, hashtable.keys());
        if (hashtable2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server index docs not found!!");
            }
            return new Hashtable();
        }
        Enumeration enumeration = hashtable.keys();
        Hashtable hashtable3 = new Hashtable();
        String string = "";
        String string2 = "";
        try {
            RepositoryContext repositoryContext2 = this.scheduler.getWorkSpace().findContext("cells/" + this.scheduler.getProperties().get("cell.name"));
            repositoryContext2.extract("variables.xml", false);
            while (enumeration.hasMoreElements()) {
                int n;
                Object object;
                RepositoryContext repositoryContext3 = (RepositoryContext)enumeration.nextElement();
                repositoryContext3.extract("variables.xml", false);
                Vector vector2 = (Vector)hashtable.get(repositoryContext3);
                Vector<String> vector3 = new Vector<String>();
                for (int i = 0; i < vector2.size(); ++i) {
                    object = (RepositoryContext)vector2.elementAt(i);
                    vector3.addElement(object.getName());
                    object.extract("variables.xml", false);
                }
                Resource resource = (Resource)hashtable2.get(repositoryContext3);
                if (resource.getContents().size() == 0) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5070E", new Object[]{repositoryContext3.getName()}));
                }
                object = (ServerIndex)resource.getContents().get(0);
                ArrayList<String> arrayList = new ArrayList<String>();
                hashtable3.put(repositoryContext3.getName(), arrayList);
                string = repositoryContext3.getName();
                string2 = repositoryContext3.getParent().getName();
                AppUtils.dbg(tc, "xxx cellName = " + string2);
                EList eList = object.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "servers for " + repositoryContext3.getName() + " are " + vector3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serversEntries for " + repositoryContext3.getName() + " are " + eList);
                }
                List list = ConfigRepoHelper.getServerNameForServerEntries(eList);
                if (bl) {
                    for (n = 0; n < vector3.size(); ++n) {
                        if (list.contains(vector3.get(n))) continue;
                        ConfigRepoHelper.createServerEntry((ServerIndex)object, vector3.get(n).toString());
                    }
                }
                eList = object.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "serversEntries for " + repositoryContext3.getName() + " are " + eList);
                }
                for (n = 0; n < eList.size(); ++n) {
                    String string3;
                    String string4;
                    Object object2;
                    Object object3;
                    Object object4;
                    ServerEntry serverEntry = (ServerEntry)eList.get(n);
                    if (!vector3.contains(serverEntry.getServerName())) continue;
                    if (bl) {
                        String string5;
                        object4 = (String)this.scheduler.getProperties().get("appname");
                        object3 = serverEntry.getDeployedApplications();
                        for (int i = 0; i < object3.size(); ++i) {
                            string5 = (String)object3.get(i);
                            object2 = string5.substring(string5.lastIndexOf("/") + 1);
                            if (!((String)(object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(".ear")))).equals(object4)) continue;
                            throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA0066E"));
                        }
                        String string6 = ((InstallScheduler)this.scheduler).getEarPath().replace('\\', '/');
                        string5 = workSpace.getPath();
                        object2 = AppUtils.createVarMap(string5, string2, string, serverEntry.getServerName());
                        string4 = object2.expand("${WAS_INSTALL_ROOT}").replace('\\', '/');
                        AppUtils.dbg(tc, "configRoot = " + string5);
                        AppUtils.dbg(tc, "deployedPath = " + string6);
                        AppUtils.dbg(tc, "${WAS_INSTALL_ROOT} = " + string4);
                        if (string6.toLowerCase().startsWith(string4.toLowerCase())) {
                            string3 = null;
                            string3 = string4.endsWith("/") ? string6.substring(string4.length()) : string6.substring(string4.length() + 1);
                            AppUtils.dbg(tc, "installRelativePath = " + string3);
                            AppUtils.dbg(tc, "deployedPath startsWith matching ${WAS_INSTALL_ROOT} value");
                            string6 = "${WAS_INSTALL_ROOT}/" + string3;
                            AppUtils.dbg(tc, "new deployedPath = " + string6);
                        }
                        object3.add(string6);
                        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6020I", new Object[]{repositoryContext, serverEntry.getServerName(), repositoryContext3.getName()}));
                    } else {
                        object4 = serverEntry.getDeployedApplications();
                        object3 = null;
                        boolean bl2 = false;
                        for (int i = 0; i < object4.size(); ++i) {
                            object2 = (String)object4.get(i);
                            if (!((String)object2).endsWith(".ear")) continue;
                            string4 = ((String)object2).substring(((String)object2).lastIndexOf("/") + 1);
                            if (!(string4 = string4.substring(0, string4.lastIndexOf(".ear"))).equals(string3 = this.scheduler.getAppName())) continue;
                            serverEntry.getDeployedApplications().remove(i);
                            serverEntry.eResource().save(new HashMap());
                            object3 = object2;
                            bl2 = true;
                        }
                        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6021I", new Object[]{object3, serverEntry.getServerName(), repositoryContext3.getName(), "" + bl2}));
                    }
                    arrayList.add(serverEntry.getServerName());
                }
                HashMap hashMap = new HashMap();
                resource.save(hashMap);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateSystemAppsXMLDocs: " + hashtable3);
            }
            return hashtable3;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.SystemAppConfigureTask.updateSystemAppsXMLDocs", "304");
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, "Server Index update failed at  the last node of " + string);
        }
    }

    private Hashtable getSystemAppsXMLDocs(WorkSpace workSpace, Enumeration enumeration) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSystemAppsXMLDocs");
        }
        Hashtable<RepositoryContext, Resource> hashtable = new Hashtable<RepositoryContext, Resource>();
        while (enumeration.hasMoreElements()) {
            Object object;
            Resource resource;
            Object object2;
            RepositoryContext repositoryContext = (RepositoryContext)enumeration.nextElement();
            AppUtils.dbg(tc, "rCtx.getPath()", repositoryContext.getPath());
            File file = new File(repositoryContext.getPath() + "/" + systemAppsFileName);
            if (!file.exists()) {
                object2 = this.scheduler.getProperties();
                resource = object2 == null ? null : (String)((Hashtable)object2).get("cell.name");
                object = (String)((Hashtable)object2).get("node.name");
                repositoryContext.findContext("cells/" + (String)((Object)resource) + "/nodes/" + (String)object);
                WorkSpaceFile workSpaceFile = null;
                if (object != null) {
                    try {
                        workSpaceFile = repositoryContext.getFile(systemAppsFileName);
                    }
                    catch (Throwable throwable) {
                        Tr.warning(tc, "ADMA0164W", (Object)new Object[]{resource, object});
                    }
                }
                if (workSpaceFile != null) {
                    repositoryContext.extract(systemAppsFileName, false);
                } else {
                    ConfigRepoHelper.createSystemAppsXML(repositoryContext, workSpace, this.scheduler.getProperties());
                }
            }
            object2 = URI.createURI(systemAppsFileName);
            resource = repositoryContext.getResourceSet().createResource((URI)object2);
            object = new HashMap();
            resource.load((Map)object);
            if (resource == null) {
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5031E", new Object[]{systemAppsFileName, repositoryContext}));
            }
            hashtable.put(repositoryContext, resource);
        }
        Tr.debug(tc, "retVal: " + hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSystemAppsXMLDocs");
        }
        return hashtable;
    }

    private void badError() {
        String string = null;
        Tr.audit(tc, "bad error" + string.length());
    }
}

