/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public class SetApplicationInfoTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register(SetApplicationInfoTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    public static final String AllTasks = "SetApplicationInfo.AllTasks";
    public static final String UniqueModuleURI = "SetApplicationInfo.UniqueModuleURI";

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask");
        }
        try {
            EditScheduler editScheduler = (EditScheduler)this.scheduler;
            EARFile eARFile = editScheduler.getEarFile();
            File file = new File(eARFile.getURI());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ear uri: " + file);
            }
            if (!file.isDirectory()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a dir so useMetadataFromBinaries");
                }
                eARFile.saveNoReopen();
                editScheduler.getAppContext().getParent().notifyChanged(1, editScheduler.getAppContext().getParent().getName());
            } else {
                SetApplicationInfoTask.saveEarFileToDeployment(eARFile, editScheduler.getAppContext());
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.task.FileMergeTask.performTask", "130", this);
            throw new AdminException(throwable, "Exception in setApplicationInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask");
        }
        return true;
    }

    private static void collectFiles(Collection collection, ArrayList arrayList, String string) throws Exception {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = (string == null ? "" : string + "/") + ((Resource)iterator.next()).getURI().toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Saving uri: " + string2);
            }
            arrayList.add(string2);
        }
    }

    public static void saveEarFileToDeployment(EARFile eARFile, RepositoryContext repositoryContext) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveEarFileToDeployment");
        }
        ArrayList arrayList = new ArrayList();
        Collection collection = eARFile.getLoadedMofResources();
        SetApplicationInfoTask.collectFiles(collection, arrayList, null);
        List list = eARFile.getModuleFiles();
        for (int i = 0; i < list.size(); ++i) {
            object = (Archive)list.get(i);
            SetApplicationInfoTask.collectFiles(object.getLoadedMofResources(), arrayList, object.getURI());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loaded resources are: " + arrayList);
        }
        Set set = repositoryContext.getFiles();
        eARFile.extract(126);
        object = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        String string = repositoryContext.getPath() + File.separator;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (new File(string + e).exists()) {
                if (set.contains(e)) {
                    arrayList2.add(e);
                    continue;
                }
                object.add(e);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "error?? " + e + " was loaded as a resource but never saved.");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "edit added files: " + object);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "edit updated: " + arrayList2);
        }
        repositoryContext.notifyChanged(1, arrayList2);
        repositoryContext.notifyChanged(0, (List)object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveEarFileToDeployment");
        }
    }
}

