/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.application.sync.AppData;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public class AppSyncEventsTask
extends AbstractAppSyncTask {
    private static TraceComponent tc = Tr.register(AppSyncEventsTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String[] NTFY_PARAMS = new String[]{"java.lang.String", "java.lang.String", "java.lang.Object"};
    private Hashtable _props;
    private AppData _cachedAd;
    private AppData _newAd;

    public boolean performTask(AppData appData, AppData appData2, Hashtable hashtable) throws Exception {
        if (this._isLocal) {
            return true;
        }
        if (!this.appIsDeployedOnNode(appData2.getAppName()) && !this.appWasDeployedOnNode(appData.getAppName())) {
            return true;
        }
        this._cachedAd = appData;
        this._newAd = appData2;
        String string = "";
        int n = this._newAd.getOperations();
        string = (n & 1) != 0 ? "installsync" : ((n & 0x10) != 0 ? "uninstallsync" : "updatesync");
        if (hashtable == null) {
            throw new Exception("props is null");
        }
        this._props = hashtable;
        String string2 = (Boolean)hashtable.get("syncstatus") != false ? "Completed" : "Failed";
        String string3 = (Boolean)hashtable.get("syncstatus") != false ? "completed" : "failed";
        this.propagateEvent(appData.getAppName(), new AppNotification(string, "", string2, "", string3), string3);
        return true;
    }

    public boolean performTask(Hashtable hashtable, Hashtable hashtable2) throws Exception {
        if (this._isLocal) {
            return true;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        String string = null;
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            String string2 = (Boolean)hashtable.get(string) != false ? "Completed" : "Failed";
            String string3 = (String)hashtable2.get(string);
            if (string2.equalsIgnoreCase("Completed")) {
                hashMap.put(string, string3);
                continue;
            }
            hashMap2.put(string, string3);
        }
        if (hashMap2.size() > 0 || hashMap.size() > 0) {
            this.propagateEvent(hashMap, hashMap2, new AppNotification("appsync", "", "Completed", "", "completed"), "completed");
        }
        return true;
    }

    private void propagateEvent(String string, AppNotification appNotification, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propagateTaskEvent");
        }
        Properties properties = null;
        if (appNotification.props != null) {
            properties = appNotification.props;
        } else {
            properties = new Properties();
            appNotification.setProperties(properties);
        }
        properties.put("appname", string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending notification: " + appNotification);
        }
        this.emitNotification(string2, appNotification);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propagateTaskEvent");
        }
    }

    private void propagateEvent(Map map, Map map2, AppNotification appNotification, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propagateTaskEvent");
        }
        Properties properties = null;
        if (appNotification.props != null) {
            properties = appNotification.props;
        } else {
            properties = new Properties();
            appNotification.setProperties(properties);
        }
        properties.put("Completed", map);
        properties.put("Failed", map2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending notification: " + appNotification);
        }
        this.emitNotification(string, appNotification);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "propagateTaskEvent");
        }
    }

    public static String getNotifTypeFromOP(int n) {
        String string = null;
        string = (n & 1) != 0 ? "installsync" : ((n & 0x10) != 0 ? "uninstallsync" : "updatesync");
        return string;
    }

    private void emitNotification(String string, AppNotification appNotification) {
        String string2 = "WebSphere:*,type=NotificationService,process=" + AdminServiceFactory.getAdminService().getProcessName();
        try {
            Set set = AdminServiceFactory.getAdminService().queryNames(new ObjectName(string2), null);
            if (set.isEmpty()) {
                Tr.error(tc, "ADMU0008E", new Object[]{string2, "none"});
            }
            AdminServiceFactory.getAdminService().invoke((ObjectName)set.iterator().next(), "emitNotification", new Object[]{"websphere.admin.appmgmt.sync", string, appNotification}, NTFY_PARAMS);
        }
        catch (Exception exception) {
            Tr.error(tc, "ADMU0008E", new Object[]{string2, exception});
        }
    }
}

