/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppManagementBaseFactory;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.wsspi.profile.WSProfile;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class MapModulesToServersHelper
implements AppDeploymentTaskHelper {
    private static TraceComponent tc = Tr.register(MapModulesToServersHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public AppDeploymentTask createTask(AppDeploymentController appDeploymentController, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTask");
        }
        try {
            String string2 = this.getClass().getName();
            int n = string2.lastIndexOf("Helper");
            Class<?> clazz = Class.forName(string2.substring(0, n));
            Constructor<?> constructor = clazz.getDeclaredConstructor(AppDeploymentController.class);
            return (AppDeploymentTask)constructor.newInstance(appDeploymentController);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error instantiating task" + exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTask");
            }
            return null;
        }
    }

    private String getCellName(Hashtable hashtable) {
        String string = (String)hashtable.get("cell.name");
        if (AppUtils.isEmpty(string)) {
            String string2 = AppDeploymentInfo.getLocalHost();
            return string2 == null ? "BaseApplicationServerCell" : string2;
        }
        return string;
    }

    private String createDefaultCNSName(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDefaultCNSName");
        }
        Hashtable hashtable = appDeploymentInfo.getAppOptions();
        String string = (String)hashtable.get("target");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "depl target option specified = " + string);
        }
        if (!AppUtils.isEmpty(string)) {
            return string;
        }
        String string2 = null;
        String string3 = (String)hashtable.get("cell.name");
        String string4 = (String)hashtable.get("server.name");
        String string5 = (String)hashtable.get("node.name");
        String string6 = (String)hashtable.get("cluster.name");
        String string7 = null;
        if (AppUtils.isEmpty(string3) || AppUtils.isEmpty(string5)) {
            string7 = AppDeploymentInfo.getLocalHost();
        }
        if (AppUtils.isEmpty(string3)) {
            String string8 = string3 = string7 != null ? string7 : "BaseApplicationServerCell";
        }
        if (AppUtils.isEmpty(string5)) {
            String string9 = string5 = string7 != null ? string7 : "DefaultNode";
        }
        if (AppUtils.isEmpty(string4)) {
            if (System.getProperty("os.name").equals("OS/400")) {
                string4 = "server1";
                AppDeploymentController appDeploymentController = appDeploymentTask.getAppDeploymentController();
                if (appDeploymentController != null && (AdminServiceFactory.getAdminService() == null || appDeploymentController.getAdminClient() == null)) {
                    try {
                        String string10 = AppManagementBaseFactory.getTempExtractDir();
                        String string11 = string10.substring(0, string10.length() - 7);
                        File file = new File(string11);
                        string4 = WSProfile.getProfileName((File)file);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "profile path=" + file + " server=" + string4);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                string4 = "server1";
            }
        }
        string2 = !AppUtils.isEmpty(string6) ? "WebSphere:cell=" + string3 + ",cluster=" + string6 : "WebSphere:cell=" + string3 + ",node=" + string5 + ",server=" + string4;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultCNSName");
        }
        return string2;
    }

    private String getCNSName(Hashtable hashtable, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCNSName");
        }
        if (hashtable == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCNSName: no tbl " + string2);
            }
            return string2;
        }
        String string3 = (String)hashtable.get(util.createUniqueModuleNameFromUriString(string));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "uri: " + string + " sName: " + string3);
        }
        if (string3 == null) {
            string3 = string2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCNSName: " + string3);
        }
        return string3;
    }

    public void prepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        AppDeploymentMessages appDeploymentMessages;
        String string;
        int n;
        Object object;
        Cloneable cloneable;
        Object object2;
        Object object3;
        AppDeploymentController appDeploymentController;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask");
        }
        if (appDeploymentTask.getTaskData() != null) {
            return;
        }
        Hashtable hashtable = (Hashtable)appDeploymentInfo.getAppOptions().get("moduleToServer");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mod2svr in prefs: " + hashtable);
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if ((appDeploymentController = appDeploymentTask.getAppDeploymentController()) == null || (appDeploymentController.getDeploymentMode() & 0x110L) != 0L) {
            try {
                boolean bl = true;
                if (appDeploymentController != null) {
                    bl = appDeploymentController.getSelectedOptions().contains("processEmbeddedConfig");
                }
                if ((object3 = ((ArchiveDeploymentInfo)appDeploymentInfo).getAppDeploymentObject(bl)) != null) {
                    object2 = null;
                    if (appDeploymentController == null) {
                        cloneable = appDeploymentInfo.getAppOptions();
                        object2 = (String)((Hashtable)cloneable).get("cell.name");
                        object2 = AppManagementImpl.getCellName();
                    } else {
                        object2 = this.getCellName(appDeploymentInfo.getAppOptions());
                    }
                    cloneable = ConfigRepoHelper.getCNP((String)appDeploymentInfo.getAppOptions().get("EditModuleOnly"), (ApplicationDeployment)object3, (String)object2);
                    object = ((Hashtable)cloneable).keys();
                    while (object.hasMoreElements()) {
                        Object e = object.nextElement();
                        if (hashtable.get(e) != null) continue;
                        hashtable.put(e, ((Hashtable)cloneable).get(e));
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.client.MapModulesToServersHelper.prepareTask", "149", this);
                Tr.warning(tc, "Unable to get deployment.xml from EAR: " + throwable);
            }
        }
        Vector vector = appDeploymentInfo.getModuleConfig("JAR_DD");
        object3 = appDeploymentInfo.getModuleConfig("WAR_DD");
        object2 = appDeploymentInfo.getModuleConfig("RAR_DD");
        cloneable = new Vector();
        object = appDeploymentTask.getColumnNames();
        boolean bl = !"5".equals(appDeploymentTask.getCallerVersion()) && !"6".equals(appDeploymentTask.getCallerVersion());
        String string2 = this.createDefaultCNSName(appDeploymentInfo, appDeploymentTask);
        for (n = 0; n < ((Object)object).length; ++n) {
            ((Vector)cloneable).addElement(object[n]);
        }
        for (n = 0; n < vector.size(); ++n) {
            ((Vector)cloneable).addElement(util.getModuleName(appDeploymentInfo, (EJBJar)vector.elementAt(n)));
            string = util.formUriString(appDeploymentInfo, (EObject)vector.elementAt(n));
            ((Vector)cloneable).addElement(string);
            ((Vector)cloneable).addElement(this.getCNSName(hashtable, string, string2));
            if (!bl) continue;
            ((Vector)cloneable).addElement("" + ((XMLResource)((EObject)vector.elementAt(n)).eResource()).getVersionID());
            ((Vector)cloneable).addElement("moduletype.ejb");
            appDeploymentMessages = appDeploymentTask.getTaskMessages();
            if (appDeploymentMessages != null) {
                ((Vector)cloneable).addElement(appDeploymentMessages.getMessage("moduletype.ejb"));
                continue;
            }
            ((Vector)cloneable).addElement(null);
        }
        for (n = 0; n < ((Vector)object3).size(); ++n) {
            ((Vector)cloneable).addElement(util.getModuleName(appDeploymentInfo, (WebApp)((Vector)object3).elementAt(n)));
            string = util.formUriString(appDeploymentInfo, (EObject)((Vector)object3).elementAt(n));
            ((Vector)cloneable).addElement(string);
            ((Vector)cloneable).addElement(this.getCNSName(hashtable, string, string2));
            if (!bl) continue;
            ((Vector)cloneable).addElement("" + ((XMLResource)((EObject)((Vector)object3).elementAt(n)).eResource()).getVersionID());
            ((Vector)cloneable).addElement("moduletype.web");
            appDeploymentMessages = appDeploymentTask.getTaskMessages();
            if (appDeploymentMessages != null) {
                ((Vector)cloneable).addElement(appDeploymentMessages.getMessage("moduletype.web"));
                continue;
            }
            ((Vector)cloneable).addElement(null);
        }
        for (n = 0; n < ((Vector)object2).size(); ++n) {
            ((Vector)cloneable).addElement(util.getModuleName(appDeploymentInfo, (Connector)((Vector)object2).elementAt(n)));
            string = util.formUriString(appDeploymentInfo, (EObject)((Vector)object2).elementAt(n));
            ((Vector)cloneable).addElement(string);
            ((Vector)cloneable).addElement(this.getCNSName(hashtable, string, string2));
            if (!bl) continue;
            ((Vector)cloneable).addElement("" + ((XMLResource)((EObject)((Vector)object2).elementAt(n)).eResource()).getVersionID());
            ((Vector)cloneable).addElement("moduletype.connector");
            appDeploymentMessages = appDeploymentTask.getTaskMessages();
            if (appDeploymentMessages != null) {
                ((Vector)cloneable).addElement(appDeploymentMessages.getMessage("moduletype.connector"));
                continue;
            }
            ((Vector)cloneable).addElement(null);
        }
        appDeploymentTask.setTaskData(util.buildTaskData((Vector)cloneable, ((Object)object).length));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    public void completeTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeTask");
        }
        if (!appDeploymentTask.isTaskEmpty()) {
            String[][] stringArray = appDeploymentTask.getTaskData();
            Hashtable hashtable = new Hashtable();
            AppDeploymentController appDeploymentController = appDeploymentTask.getAppDeploymentController();
            hashtable = appDeploymentController.getServerTable();
            appDeploymentInfo.getAppOptions().put("moduleToServer", hashtable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTask");
        }
    }
}

