/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.filetransfer.client.FileTransferClient;
import com.ibm.websphere.management.filetransfer.client.TransferFailedException;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.PartialDeploymentInfo;
import com.ibm.ws.management.application.cdfj2eebridge.CDFBridgeExtensionHelper;
import com.ibm.ws.management.application.client.ArchiveValidator;
import com.ibm.ws.management.fileservice.FileTransferFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.J2EEEObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ZipStreamSaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class AppInstallHelper {
    private static TraceComponent tc = Tr.register(AppInstallHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    public static final String STANDALONE_WEB_MARKER = "META-INF/was.webmodule";
    public static final String STANDALONE_EJB_MARKER = "META-INF/was.ejbmodule";
    private static final String MOF_PATH_SEPERATOR = "/";
    public static boolean _tempDirCreated = false;

    public static EARFile getEarFile(String string, boolean bl, ResourceBundle resourceBundle) throws AppDeploymentException {
        return AppInstallHelper.getEarFile(string, bl, false, resourceBundle);
    }

    public static EARFile getEarFile(String string, boolean bl, boolean bl2, ResourceBundle resourceBundle) throws AppDeploymentException {
        return (EARFile)AppInstallHelper.getArchive(string, bl, bl2, resourceBundle, true);
    }

    public static Archive getArchive(String string, boolean bl, boolean bl2, ResourceBundle resourceBundle, boolean bl3) throws AppDeploymentException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getArchive " + string);
            }
            Archive archive = null;
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setUseJavaReflection(bl);
            archiveOptions.setIsReadOnly(bl2);
            String string2 = null;
            if (!_tempDirCreated) {
                _tempDirCreated = true;
                string2 = System.getProperty("user.install.root");
                if (string2 != null) {
                    string2 = string2 + "/wstemp/appdepl" + Long.toHexString(System.currentTimeMillis());
                    try {
                        ArchiveUtil.setTempDirectoryName(string2);
                    }
                    catch (ArchiveException archiveException) {
                        Tr.debug(tc, "Unable to create temp directory: " + string2);
                    }
                }
            }
            string2 = ArchiveUtil.getTempDirectoryName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "temp is:  " + (string2 != null ? string2 : "using default temp"));
            }
            if ((archive = bl3 ? commonarchiveFactory.openEARFile(archiveOptions, string) : commonarchiveFactory.openArchive(archiveOptions, string)) instanceof EARFile && new File(string).isFile() && archive.containsFile("META-INF/ibm-application-sa.props")) {
                throw new AppDeploymentException("This is an EAR file which is a system application.  The system application should always be installed from an expanded directory.", null);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getArchive " + archive);
            }
            return archive;
        }
        catch (OpenFailureException openFailureException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Throwing new AppDeploymentException from AppInstallHelper::getEarFile " + openFailureException);
            }
            throw new AppDeploymentException("", openFailureException);
        }
    }

    public static AppDeploymentInfo getAppDeploymentInfo(String string, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDeploymentInfo");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Archive is: " + string);
        }
        Archive archive = null;
        try {
            Object object;
            archive = hashtable.get("earfile") != null ? (EARFile)hashtable.get("earfile") : AppInstallHelper.getEarFile(string, true, false, AppUtils.getBundle(hashtable));
            if (hashtable.get("jsr88") != null) {
                object = archive.getWebModuleRefs();
                for (int i = 0; i < object.size(); ++i) {
                    ArchiveValidator archiveValidator = new ArchiveValidator((ModuleRef)object.get(i));
                    archiveValidator.validate(true);
                }
            }
            object = AppInstallHelper.getAppDeploymentInfo((EARFile)archive, hashtable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentInfo");
            }
            return object;
        }
        catch (AppDeploymentException appDeploymentException) {
            if (archive != null) {
                archive.close();
            }
            throw appDeploymentException;
        }
    }

    public static AppDeploymentInfo getAppDeploymentInfo(EARFile eARFile) throws AppDeploymentException {
        return AppInstallHelper.getAppDeploymentInfo(eARFile, new Hashtable());
    }

    public static AppDeploymentInfo getAppDeploymentInfo(EARFile eARFile, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDeploymentInfo");
        }
        ArchiveDeploymentInfo archiveDeploymentInfo = new ArchiveDeploymentInfo(eARFile, hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppDeploymentInfo");
        }
        return archiveDeploymentInfo;
    }

    public static AppDeploymentInfo getPartialDeploymentInfo(EARFile eARFile, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPartialDeploymentInfo");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Archive is: " + eARFile);
        }
        PartialDeploymentInfo partialDeploymentInfo = new PartialDeploymentInfo(eARFile, hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPartialDeploymentInfo");
        }
        return partialDeploymentInfo;
    }

    public static AppDeploymentInfo getAppDeploymentInfoForUpdate(String string, String string2, Hashtable hashtable, boolean bl) throws AppDeploymentException {
        if (bl) {
            return AppInstallHelper.getAppDeploymentInfo(string, hashtable);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAppDeploymentInfoForUpdate");
            }
            File file = File.createTempFile("ibm-app", "wrap");
            String string3 = AppInstallHelper.createEarWrapper(string, file.getPath(), string2, (String)hashtable.get("contextroot"));
            hashtable.put("ibm.update.mod.path", string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentInfoForUpdate");
            }
            return AppInstallHelper.getAppDeploymentInfo(string3, hashtable);
        }
        catch (Throwable throwable) {
            if (throwable instanceof AppDeploymentException) {
                throw (AppDeploymentException)throwable;
            }
            throw new AppDeploymentException(null, throwable);
        }
    }

    public static AppDeploymentInfo getAppDeploymentInfoGenericRead(String string, String string2, Hashtable hashtable) throws AppDeploymentException {
        Archive archive = null;
        boolean bl = false;
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAppDeploymentInfoGeneric");
            }
            if ((archive = AppInstallHelper.getArchive(string, false, true, null, false)) instanceof EARFile) {
                AppDeploymentInfo appDeploymentInfo = AppInstallHelper.getAppDeploymentInfo((EARFile)archive, hashtable);
                return appDeploymentInfo;
            }
            File file = File.createTempFile("ibm-app", "wrap");
            String string3 = AppInstallHelper.createEarWrapper((ModuleFile)archive, file.getPath(), string2, (String)hashtable.get("contextroot"));
            hashtable.put("ibm.update.mod.path", string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentInfoForUpdate");
            }
            AppDeploymentInfo appDeploymentInfo = AppInstallHelper.getAppDeploymentInfo(string3, hashtable);
            return appDeploymentInfo;
        }
        catch (Throwable throwable) {
            bl = true;
            if (throwable instanceof AppDeploymentException) {
                throw (AppDeploymentException)throwable;
            }
            throw new AppDeploymentException(null, throwable);
        }
        finally {
            if (bl && archive != null) {
                archive.close();
            }
        }
    }

    public static String createEarWrapper(String string, String string2, String string3) throws AppDeploymentException {
        return AppInstallHelper.createEarWrapper(string, string2, null, string3);
    }

    public static String createEarWrapper(String string, String string2, String string3, String string4) throws AppDeploymentException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string4 != null) {
            hashtable.put("contextroot", string4);
        }
        return AppInstallHelper.createEarWrapper(string, string2, string3, hashtable);
    }

    public static String createEarWrapper(String string, String string2, String string3, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEarWrapper");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moduleFile: " + string + ", earName: " + string2 + ", prefs: " + hashtable);
        }
        CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
        Archive archive = null;
        try {
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setUseJavaReflection(true);
            archiveOptions.setIsReadOnly(true);
            archive = commonarchiveFactory.openArchive(archiveOptions, string);
            String string4 = AppInstallHelper.createEarWrapperExtension(archive, string2, string3, hashtable);
            if (string4 == null && archive.isModuleFile()) {
                string4 = AppInstallHelper.createEarWrapper((ModuleFile)archive, string2, string3, hashtable);
            }
            if (string4 == null) {
                throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0157E"), null);
            }
            AppUtils.dbg(tc, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0155I", new String[]{string4}));
            String string5 = string4;
            return string5;
        }
        catch (OpenFailureException openFailureException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Throwing new AppDeploymentException from AppInstallHelper::createEarWrapper:1 " + openFailureException);
            }
            throw new AppDeploymentException("", openFailureException);
        }
        finally {
            if (archive != null) {
                archive.close();
            }
        }
    }

    public static String createEarWrapper(ModuleFile moduleFile, String string, String string2, String string3) throws AppDeploymentException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string3 != null) {
            hashtable.put("contextroot", string3);
        }
        return AppInstallHelper.createEarWrapper(moduleFile, string, string2, hashtable);
    }

    public static String createEarWrapperExtension(Archive archive, String string, String string2, Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createEarWrapperExtension");
        }
        String string3 = null;
        Vector vector = new Vector();
        vector = ExtensionHelper.processEarWrapperExtensions(vector, archive, string, string2, hashtable);
        CDFBridgeExtensionHelper.processEarWrapperExtension(vector, archive, string, string2, hashtable);
        string3 = CDFBridgeExtensionHelper.executeEarWrapperExtension(vector, archive, string, string2, hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEarWrapperExtension");
        }
        return string3;
    }

    public static String createEarWrapper(ModuleFile moduleFile, String string, String string2, Hashtable hashtable) throws AppDeploymentException {
        String string3;
        block38: {
            String string4;
            block37: {
                J2EEEObject j2EEEObject;
                Object object;
                if (!(moduleFile.isEJBJarFile() || moduleFile.isWARFile() || moduleFile.isApplicationClientFile() || moduleFile.isRARFile())) {
                    throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0084E", new String[]{moduleFile.getURI()}), null);
                }
                String string5 = hashtable != null ? (String)hashtable.get("contextroot") : null;
                CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                string3 = string;
                if (string3 == null) {
                    object = new File(moduleFile.getURI());
                    string3 = ((File)object).getName().replace('.', '_') + ".ear";
                    if (((File)object).getParent() != null) {
                        string3 = ((File)object).getParent() + (((File)object).getParent().endsWith(File.separator) ? "" : File.separator) + string3;
                    }
                }
                if (((String)(object = string3.substring(string3.lastIndexOf(File.separator) + 1, string3.length()))).lastIndexOf(".") > 0) {
                    object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "earFileName: " + string3 + ", appDisplayName: " + (String)object);
                }
                EARFile eARFile = commonarchiveFactory.createEARFileInitialized(string3);
                Application application = eARFile.getDeploymentDescriptor();
                try {
                    ((XMLResource)application.eResource()).setVersionID(((XMLResource)moduleFile.getDeploymentDescriptorResource()).getVersionID());
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception getting version of old module file: " + throwable);
                    }
                    ((XMLResource)application.eResource()).setVersionID(14);
                }
                if (((XMLResource)application.eResource()).getVersionID() < 14) {
                    application.setDisplayName((String)object);
                } else {
                    j2EEEObject = CommonPackage.eINSTANCE.getCommonFactory().createDisplayName();
                    j2EEEObject.setValue((String)object);
                    application.getDisplayNames().add(j2EEEObject);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Ear file opened and display name of app is set.");
                }
                j2EEEObject = null;
                String string6 = string2;
                if (string6 == null) {
                    string6 = new File(moduleFile.getURI()).getName();
                }
                try {
                    j2EEEObject = eARFile.addCopyRef(moduleFile);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added copy of module file to the ear.");
                    }
                }
                catch (DuplicateObjectException duplicateObjectException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Throwing new AppDeploymentException from AppInstallHelper::createEarWrapper:2 " + duplicateObjectException);
                    }
                    throw new AppDeploymentException("", duplicateObjectException);
                }
                j2EEEObject.setURI(string6);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "New URI for module file is set to " + string6);
                }
                try {
                    if (j2EEEObject.isWeb()) {
                        if (string5 == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Null Context root. Setting to /");
                            }
                            string5 = MOF_PATH_SEPERATOR;
                        }
                        ((WebModule)j2EEEObject.getModule()).setContextRoot(string5);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New context root for web module set.");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Module is not a web module, so can not set context root.");
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Throwing new AppDeploymentException from AppInstallHelper::createEarWrapper:3 " + exception);
                    }
                    throw new AppDeploymentException("", exception);
                }
                ClassLoader classLoader = AppInstallHelper.class.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream("was.policy");
                String string7 = null;
                if (inputStream != null) {
                    string7 = ArchiveDeploymentInfo.saveAsFile(eARFile, null, "META-INF/was.policy", inputStream);
                }
                String string8 = j2EEEObject.isWeb() ? STANDALONE_WEB_MARKER : STANDALONE_EJB_MARKER;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string8.getBytes());
                string4 = ArchiveDeploymentInfo.saveAsFile(eARFile, null, string8, byteArrayInputStream);
                eARFile.rollUpRoles();
                SaveStrategy saveStrategy = eARFile.getSaveStrategy();
                try {
                    eARFile.save(new ZipStreamSaveStrategyImpl(new FileOutputStream(string3)));
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Throwing new AppDeploymentException from AppInstallHelper::createEarWrapper:4 " + exception);
                    }
                    throw new AppDeploymentException("", exception);
                }
                moduleFile.close();
                eARFile.close();
                if (string7 != null) {
                    try {
                        AppUtils.deleteDirTree(string7);
                    }
                    catch (IOException iOException) {
                        if (!tc.isDebugEnabled()) break block37;
                        Tr.debug(tc, "Error deleting temp dir: " + string7 + "," + iOException);
                    }
                }
            }
            if (string4 != null) {
                try {
                    AppUtils.deleteDirTree(string4);
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) break block38;
                    Tr.debug(tc, "Error deleting temp dir: " + string4 + "," + iOException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEarWrapper");
        }
        return string3;
    }

    public static Hashtable createDefaultDeployEJBOptions() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("deployejb.codegen", AppConstants.APPDEPL_DEPLOYEJB_CODEGEN_OPTION_DEFAULT);
        hashtable.put("deployejb.validate", AppConstants.APPDEPL_DEPLOYEJB_VALIDATE_OPTION_DEFAULT);
        hashtable.put("deployejb.rmic", "");
        hashtable.put("deployejb.dbtype", AppConstants.APPDEPL_DEPLOYEJB_DBTYPE_OPTION_DEFAULT);
        hashtable.put("deployejb.dbname", "");
        hashtable.put("deployejb.dbschema", "");
        hashtable.put("deployejb.classpath", "");
        return hashtable;
    }

    public static String getAppDisplayName(EARFile eARFile, Hashtable hashtable) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDisplayName");
        }
        if ((string = eARFile.getDeploymentDescriptor().getDisplayName()) == null || string.trim().length() == 0) {
            int n;
            String string2 = (String)hashtable.get("app.original.uri");
            if (string2 == null || string2.trim().length() == 0) {
                string2 = eARFile.getURI();
            }
            if ((n = (string = new File(string2).getName()).lastIndexOf(46)) > 0) {
                string = string.substring(0, n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppDisplayName - " + string);
        }
        return string;
    }

    public static String copyToServer(AdminClient adminClient, String string) throws TransferFailedException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyToServer: " + string);
        }
        String string2 = new String();
        FileTransferClient fileTransferClient = FileTransferFactory.getFileTransferClient(adminClient);
        File file = new File(string);
        String string3 = "upload" + File.separator + Long.toHexString(System.currentTimeMillis()) + file.getName();
        fileTransferClient.uploadFile(file, string3);
        String string4 = fileTransferClient.getServerStagingLocation();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Staging location: " + string4);
        }
        if (string4.indexOf(MOF_PATH_SEPERATOR) >= 0) {
            if (!string4.endsWith(MOF_PATH_SEPERATOR)) {
                string4 = string4 + MOF_PATH_SEPERATOR;
            }
            string2 = string4 + string3.replace('\\', '/');
        } else {
            if (!string4.endsWith("\\")) {
                string4 = string4 + "\\";
            }
            string2 = string4 + string3.replace('/', '\\');
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyToServer: " + string2);
        }
        return string2;
    }

    public static boolean isHiddenApp(String string) throws AppDeploymentException {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        File file = new File(string);
        if (file.isDirectory()) {
            bl = file.exists() && new File(string + MOF_PATH_SEPERATOR + "META-INF/ibm-application-ha.props").exists();
        } else {
            EARFile eARFile = AppInstallHelper.getEarFile(string, true, true, null);
            bl = eARFile.containsFile("META-INF/ibm-application-ha.props");
            eARFile.close();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isHiddenApp = " + bl);
        }
        return bl;
    }
}

