/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.cbe;

import com.ibm.websphere.logging.cbe.WsEventFactoryHomeImpl;
import com.ibm.websphere.logging.cbe.WsTemplateEventFactoryHomeImpl;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryHome;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl;

public class EventFactoryHelper {
    private static final String svDefaultEventFactoryName = "com.ibm.ws.logging.cbe.DefaultEventFactory";
    private static final String svClassName = EventFactoryHelper.class.getName();
    private static EventFactoryHome svEventFactoryHome = null;
    private static EventFactoryHome svDefaultEventFactoryHome = null;
    private static Logger svLogger = null;

    private EventFactoryHelper() {
    }

    public static EventFactory getPlainEventFactory() {
        return EventFactoryImpl.getInstance();
    }

    public static EventFactory getDefaultEventFactory() {
        EventFactory eventFactory = null;
        eventFactory = EventFactoryHelper.getEventFactory(svDefaultEventFactoryHome, svDefaultEventFactoryName);
        return eventFactory;
    }

    public static EventFactory getEventFactory(String string) {
        EventFactory eventFactory = null;
        if (string != null && (eventFactory = EventFactoryHelper.getEventFactory(svEventFactoryHome, string)) != null && eventFactory.getContentHandler() == null) {
            svEventFactoryHome.releaseEventFactory(string);
            eventFactory = null;
        }
        if (eventFactory == null) {
            eventFactory = EventFactoryHelper.getDefaultEventFactory();
        }
        return eventFactory;
    }

    private static EventFactory getEventFactory(final EventFactoryHome eventFactoryHome, final String string) {
        EventFactory eventFactory = null;
        if (eventFactoryHome != null && string != null) {
            try {
                eventFactory = (EventFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return eventFactoryHome.getEventFactory(string);
                    }
                });
            }
            catch (Throwable throwable) {
                svLogger.throwing(svClassName, "getEventFactory", throwable);
            }
        }
        return eventFactory;
    }

    static {
        svEventFactoryHome = new WsTemplateEventFactoryHomeImpl();
        svDefaultEventFactoryHome = new WsEventFactoryHomeImpl();
        svLogger = Logger.getLogger("com.ibm.ws.logging.cbe.EventFactoryHelper");
    }
}

