/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.CallbackIDs;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundLink;
import com.ibm.ws.http.channel.inbound.impl.HttpInboundServiceContextImpl;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;

public class HttpICLReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpICLReadCallback.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static HttpICLReadCallback myInstance = null;

    private HttpICLReadCallback() {
    }

    private static synchronized void createSingleton() {
        if (null == myInstance) {
            myInstance = new HttpICLReadCallback();
        }
    }

    public static final HttpICLReadCallback getRef() {
        if (null == myInstance) {
            HttpICLReadCallback.createSingleton();
        }
        return myInstance;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "complete() called: " + virtualConnection);
        }
        if (null == virtualConnection) {
            return;
        }
        HttpInboundLink httpInboundLink = (HttpInboundLink)((Object)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        if (null == httpInboundLink) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: null ICL in complete()");
            }
            return;
        }
        do {
            httpInboundLink.handleNewInformation();
            if (httpInboundLink.isPartiallyParsed()) continue;
            return;
        } while (null != (virtualConnection = tCPReadRequestContext.read(1L, (TCPReadCompletedCallback)this, false, httpInboundLink.getHTTPContext().getReadTimeout())));
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "error() called: " + virtualConnection);
        }
        if (null == virtualConnection) {
            return;
        }
        HttpInboundLink httpInboundLink = (HttpInboundLink)((Object)virtualConnection.getStateMap().get(CallbackIDs.CALLBACK_HTTPICL));
        if (null == httpInboundLink) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: null ICL in error()");
            }
            return;
        }
        HttpInboundServiceContextImpl httpInboundServiceContextImpl = httpInboundLink.getHTTPContext();
        httpInboundServiceContextImpl.setPersistent(false);
        httpInboundLink.setFilterCloseExceptions(true);
        if (httpInboundLink.isFirstRequest() || httpInboundLink.isPartiallyParsed()) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error, sending 408 timeout back");
                }
                if (httpInboundServiceContextImpl.getHttpConfig().isErrorLoggingEnabled()) {
                    httpInboundServiceContextImpl.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_WARN, "A read during the connection failed due to a socket exception.", (HttpServiceContext)httpInboundServiceContextImpl);
                }
                httpInboundServiceContextImpl.setHeadersParsed();
                httpInboundServiceContextImpl.sendError(HttpConstants.STATUS_REQ_TIMEOUT.getHttpError());
            }
            catch (MessageSentException messageSentException) {
                FFDCFilter.processException(messageSentException, this.getClass().getName() + ".error", "152");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "MessageSent error during ICL read error");
                }
                httpInboundLink.close(virtualConnection, iOException);
            }
        } else {
            httpInboundLink.close(virtualConnection, iOException);
        }
    }
}

