/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.BNFHeadersImpl;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.matcher.impl.HttpHeaderMatcher;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpTrailerGenerator;
import com.ibm.wsspi.http.channel.HttpTrailers;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HttpTrailersImpl
extends BNFHeadersImpl
implements HttpTrailers {
    private static final TraceComponent tc = Tr.register(HttpTrailersImpl.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final long serialVersionUID = -4872702714523122647L;
    private transient HttpObjectFactory myFactory = null;
    private transient Map knownTGs = new HashMap();
    private transient Map unknownTGs = new HashMap();

    public HttpTrailersImpl() {
        super(HttpHeaderMatcher.getRef(), HttpConstants.NUM_HDRS);
    }

    public void init(boolean bl, int n, int n2, int n3) {
        super.init(bl, n, n2, n3);
    }

    public final void setFactory(HttpObjectFactory httpObjectFactory) {
        this.myFactory = httpObjectFactory;
    }

    private final HttpObjectFactory getFactory() {
        return this.myFactory;
    }

    public boolean containsDeferredTrailer(String string) {
        if (null == string) {
            return false;
        }
        HeaderKeys headerKeys = HttpTrailersImpl.getKey(string);
        if (null != headerKeys) {
            return this.containsDeferredTrailer(headerKeys);
        }
        Iterator iterator = this.unknownTGs.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.equalsIgnoreCase(string)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown deferred Trailer found: " + string);
            }
            return true;
        }
        return false;
    }

    public boolean containsDeferredTrailer(HeaderKeys headerKeys) {
        if (null != headerKeys) {
            Iterator iterator = this.knownTGs.keySet().iterator();
            while (iterator.hasNext()) {
                HeaderKeys headerKeys2 = (HeaderKeys)iterator.next();
                if (!headerKeys2.equals(headerKeys)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Known deferred Trailer found: " + headerKeys);
                }
                return true;
            }
        }
        return false;
    }

    public void setDeferredTrailer(HeaderKeys headerKeys, HttpTrailerGenerator httpTrailerGenerator) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDeferredTrailer(HeaderKeys): " + headerKeys);
        }
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null header name");
        }
        if (null == httpTrailerGenerator) {
            throw new IllegalArgumentException("Null value generator");
        }
        this.knownTGs.put(headerKeys, httpTrailerGenerator);
    }

    public void setDeferredTrailer(String string, HttpTrailerGenerator httpTrailerGenerator) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setDeferredTrailer(String): " + string);
        }
        if (null == string) {
            throw new IllegalArgumentException("Null header name");
        }
        if (null == httpTrailerGenerator) {
            throw new IllegalArgumentException("Null value generator");
        }
        HeaderKeys headerKeys = HttpTrailersImpl.getKey(string);
        if (null != headerKeys) {
            this.knownTGs.put(headerKeys, httpTrailerGenerator);
        } else {
            this.unknownTGs.put(string, httpTrailerGenerator);
        }
    }

    public void removeDeferredTrailer(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDeferredTrailer(String): " + string);
        }
        if (null == string) {
            throw new IllegalArgumentException("Null header name");
        }
        HeaderKeys headerKeys = HttpTrailersImpl.getKey(string);
        if (null != headerKeys) {
            this.knownTGs.remove(headerKeys);
        } else {
            this.unknownTGs.remove(string);
        }
    }

    public void removeDeferredTrailer(HeaderKeys headerKeys) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDeferredTrailer(HeaderKeys): " + headerKeys);
        }
        if (null == headerKeys) {
            throw new IllegalArgumentException("Null header name");
        }
        this.knownTGs.remove(headerKeys);
    }

    public void computeRemainingTrailers() {
        byte[] byArray;
        HttpTrailerGenerator httpTrailerGenerator;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "computeRemainingTrailers");
        }
        Iterator iterator = this.knownTGs.keySet().iterator();
        while (iterator.hasNext()) {
            object = (HeaderKeys)iterator.next();
            httpTrailerGenerator = (HttpTrailerGenerator)this.knownTGs.get(object);
            byArray = httpTrailerGenerator.generateTrailerValue((HeaderKeys)object, (HttpTrailers)this);
            this.setHeader((HeaderKeys)object, byArray);
        }
        iterator = this.unknownTGs.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            httpTrailerGenerator = (HttpTrailerGenerator)this.unknownTGs.get(object);
            byArray = httpTrailerGenerator.generateTrailerValue((String)object, (HttpTrailers)this);
            this.setHeader((String)object, byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "computeRemainingTrailers");
        }
    }

    public void destroy() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroy trailers: " + this);
        }
        super.destroy();
        if (null != this.getFactory()) {
            this.getFactory().releaseTrailers(this);
        }
    }

    public HttpTrailersImpl duplicate() {
        if (null == this.getFactory()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Null factory, unable to duplicate: " + this);
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Duplicating the trailer headers: " + this);
        }
        this.computeRemainingTrailers();
        HttpTrailersImpl httpTrailersImpl = this.getFactory().getTrailers();
        super.duplicate(httpTrailersImpl);
        return httpTrailersImpl;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.computeRemainingTrailers();
        super.writeExternal(objectOutput);
    }

    private static final HeaderKeys getKey(String string) {
        return (HeaderKeys)HttpHeaderMatcher.getRef().match(string);
    }
}

