/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.cookies.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.HttpDateFormat;
import com.ibm.ws.timeutils.QuickApproxTime;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.util.Date;
import javax.servlet.http.Cookie;

public class CookieUtils {
    private static final TraceComponent tc = Tr.register(CookieUtils.class, "HTTPChannel", "com.ibm.ws.http.channel.resources.httpchannelmessages");
    private static final String TSPECIALS = "\"()<>@,;:\\/[]?={} \t";
    private static final String longAgo = "; Expires=Thu, 01 Dec 1994 16:00:00 GMT";

    private CookieUtils() {
    }

    public static String toString(Cookie cookie, HeaderKeys headerKeys) {
        if (null == cookie) {
            throw new NullPointerException("Null cookie input");
        }
        if (null == headerKeys) {
            throw new NullPointerException("Null header input");
        }
        try {
            if (0 == cookie.getVersion()) {
                if (HttpConstants.HDR_COOKIE.equals(headerKeys)) {
                    return CookieUtils.convertV0Cookie(cookie);
                }
                if (HttpConstants.HDR_SET_COOKIE.equals(headerKeys)) {
                    return CookieUtils.convertV0SetCookie(cookie);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid header: " + headerKeys);
                }
            } else if (1 == cookie.getVersion()) {
                if (HttpConstants.HDR_COOKIE.equals(headerKeys)) {
                    return CookieUtils.convertV1Cookie(cookie);
                }
                if (HttpConstants.HDR_COOKIE2.equals(headerKeys)) {
                    return CookieUtils.convertV1Cookie2(cookie);
                }
                if (HttpConstants.HDR_SET_COOKIE.equals(headerKeys)) {
                    return CookieUtils.convertV1SetCookie(cookie);
                }
                if (HttpConstants.HDR_SET_COOKIE2.equals(headerKeys)) {
                    return CookieUtils.convertV1SetCookie2(cookie);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid header: " + headerKeys);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid Cookie version: " + cookie.getVersion());
            }
            return CookieUtils.convertV0Cookie(cookie);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, CookieUtils.class.getName() + ".toString", "1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception while converting the cookie; " + cookie);
            }
            return null;
        }
    }

    private static boolean needsQuote(String string) {
        int n;
        int n2 = n = null == string ? 0 : string.length();
        if (0 == n) {
            return true;
        }
        if ('\"' == string.charAt(0)) {
            return '\"' != string.charAt(n - 1);
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u007f' && TSPECIALS.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    private static void maybeQuote(StringBuffer stringBuffer, String string) {
        if (null == string || 0 == string.length()) {
            stringBuffer.append("\"\"");
        } else if (CookieUtils.needsQuote(string)) {
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
        } else {
            stringBuffer.append(string);
        }
    }

    private static String convertV0Cookie(Cookie cookie) {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(cookie.getName());
        String string = cookie.getValue();
        if (null != string && 0 != string.length()) {
            stringBuffer.append('=');
            stringBuffer.append(string);
        } else {
            stringBuffer.append("=\"\"");
        }
        string = cookie.getPath();
        if (null != string && 0 != string.length()) {
            stringBuffer.append("; $Path=");
            stringBuffer.append(string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v0 Cookie: [" + stringBuffer.toString() + "]");
        }
        return stringBuffer.toString();
    }

    private static String convertV1Cookie(Cookie cookie) {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(cookie.getName());
        stringBuffer.append('=');
        CookieUtils.maybeQuote(stringBuffer, cookie.getValue());
        stringBuffer.append("; $Version=1");
        String string = cookie.getPath();
        if (null != string && 0 != string.length()) {
            stringBuffer.append("; $Path=");
            CookieUtils.maybeQuote(stringBuffer, string);
        }
        if (null != (string = cookie.getDomain()) && 0 != string.length()) {
            stringBuffer.append("; $Domain=");
            CookieUtils.maybeQuote(stringBuffer, string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v1 Cookie: [" + stringBuffer.toString() + "]");
        }
        return stringBuffer.toString();
    }

    private static String convertV1Cookie2(Cookie cookie) {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(cookie.getName());
        stringBuffer.append('=');
        CookieUtils.maybeQuote(stringBuffer, cookie.getValue());
        stringBuffer.append("; $Version=1");
        String string = cookie.getPath();
        if (null != string && 0 != string.length()) {
            stringBuffer.append("; $Path=");
            CookieUtils.maybeQuote(stringBuffer, string);
        }
        if (null != (string = cookie.getDomain()) && 0 != string.length()) {
            stringBuffer.append("; $Domain=");
            CookieUtils.maybeQuote(stringBuffer, string);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v1 Cookie2: [" + stringBuffer.toString() + "]");
        }
        return stringBuffer.toString();
    }

    private static String convertV0SetCookie(Cookie cookie) {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(cookie.getName());
        String string = cookie.getValue();
        if (null != string && 0 != string.length()) {
            stringBuffer.append('=');
            stringBuffer.append(string);
        } else {
            stringBuffer.append("=\"\"");
        }
        int n = cookie.getMaxAge();
        if (-1 < n) {
            if (0 == n) {
                stringBuffer.append(longAgo);
            } else {
                stringBuffer.append("; Expires=");
                stringBuffer.append(HttpDateFormat.getRef().getRFC1123Time(new Date(QuickApproxTime.getRef().getApproxTime() + (long)n * 1000L)));
            }
        }
        if (null != (string = cookie.getPath()) && 0 != string.length()) {
            stringBuffer.append("; Path=");
            stringBuffer.append(string);
        }
        if (null != (string = cookie.getDomain()) && 0 != string.length()) {
            stringBuffer.append("; Domain=");
            stringBuffer.append(string);
        }
        if (cookie.getSecure()) {
            stringBuffer.append("; Secure");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v0 Set-Cookie: [" + stringBuffer.toString() + "]");
        }
        return stringBuffer.toString();
    }

    private static String convertV1SetCookie(Cookie cookie) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(cookie.getName());
        stringBuffer.append('=');
        CookieUtils.maybeQuote(stringBuffer, cookie.getValue());
        stringBuffer.append("; Version=1");
        String string = cookie.getComment();
        if (null != string && 0 != string.length()) {
            stringBuffer.append("; Comment=");
            CookieUtils.maybeQuote(stringBuffer, string);
        }
        if (null != (string = cookie.getDomain()) && 0 != string.length()) {
            stringBuffer.append("; Domain=");
            CookieUtils.maybeQuote(stringBuffer, string);
        }
        if (-1 < (n = cookie.getMaxAge())) {
            stringBuffer.append("; Max-Age=");
            stringBuffer.append(n);
        }
        if (null != (string = cookie.getPath()) && 0 != string.length()) {
            stringBuffer.append("; Path=");
            CookieUtils.maybeQuote(stringBuffer, string);
        }
        if (cookie.getSecure()) {
            stringBuffer.append("; Secure");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v1 Set-Cookie: [" + stringBuffer.toString() + "]");
        }
        return stringBuffer.toString();
    }

    private static String convertV1SetCookie2(Cookie cookie) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(cookie.getName());
        stringBuffer.append('=');
        CookieUtils.maybeQuote(stringBuffer, cookie.getValue());
        stringBuffer.append("; Version=1");
        String string = cookie.getComment();
        if (null != string && 0 != string.length()) {
            stringBuffer.append("; Comment=");
            CookieUtils.maybeQuote(stringBuffer, string);
        }
        if (null != (string = cookie.getDomain()) && 0 != string.length()) {
            stringBuffer.append("; Domain=");
            CookieUtils.maybeQuote(stringBuffer, string);
        }
        if (-1 < (n = cookie.getMaxAge())) {
            stringBuffer.append("; Max-Age=");
            stringBuffer.append(n);
        }
        if (null != (string = cookie.getPath()) && 0 != string.length()) {
            stringBuffer.append("; Path=");
            CookieUtils.maybeQuote(stringBuffer, string);
        }
        if (cookie.getSecure()) {
            stringBuffer.append("; Secure");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Created v1 Set-Cookie2: [" + stringBuffer.toString() + "]");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Cookie cookie = new Cookie("CustomerName", "WILE_E_COYOTE");
        cookie.setMaxAge(60);
        cookie.setComment("Great Cookie!");
        cookie.setPath("/acme");
        cookie.setDomain("www.ibm.com");
        cookie.setSecure(true);
        System.out.println("Creating a V0 Cookie:");
        cookie.setVersion(0);
        System.out.println(CookieUtils.toString(cookie, HttpConstants.HDR_COOKIE));
        System.out.println();
        System.out.println("Creating a V1 Cookie:");
        cookie.setVersion(1);
        System.out.println(CookieUtils.toString(cookie, HttpConstants.HDR_COOKIE));
        System.out.println();
        System.out.println("Creating a V0 Set-Cookie:");
        cookie.setVersion(0);
        cookie.setMaxAge(Integer.MAX_VALUE);
        System.out.println(CookieUtils.toString(cookie, HttpConstants.HDR_SET_COOKIE));
        System.out.println();
        System.out.println("Creating a V1 Set-Cookie2:");
        cookie.setVersion(1);
        System.out.println(CookieUtils.toString(cookie, HttpConstants.HDR_SET_COOKIE2));
        System.out.println();
        System.out.println("Testing invalid header");
        System.out.println(CookieUtils.toString(cookie, HttpConstants.HDR_AGE));
        System.out.println();
        System.out.println("Testing invalid version");
        cookie.setVersion(5);
        System.out.println(CookieUtils.toString(cookie, HttpConstants.HDR_SET_COOKIE));
        System.out.println();
        cookie = new Cookie("testempty", "");
        System.out.println(CookieUtils.toString(cookie, HttpConstants.HDR_SET_COOKIE));
        cookie = new Cookie("testnull", null);
        System.out.println(CookieUtils.toString(cookie, HttpConstants.HDR_SET_COOKIE));
        cookie.setVersion(1);
        System.out.println(CookieUtils.toString(cookie, HttpConstants.HDR_SET_COOKIE2));
    }
}

