/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ffdc;

import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.omg.CORBA.portable.UnknownException;

public class FFDCHelper {
    private static String svServerName = "";
    private static String svDefaultLoggingDirectory;
    private static String svDatabaseDirectory;
    private static final String SERVERIDENTITYHELPER_CLASS_NAME = "com.ibm.ws.security.util.ServerIdentityHelper";
    private static final String GETSERVERIDENTITYHELPER_METHOD_NAME = "getServerIdentityHelper";
    private static final String PUSH_METHOD_NAME = "push";
    private static final String POP_METHOD_NAME = "pop";
    private static Class svClassServerIndetityHelper;
    private static Object svInstanceOfServerIndetityHelper;
    private static Method svPushMethod;
    private static Method svPopMethod;
    private static final String classname;
    private static Logger logger;
    private static boolean svServer;

    private static void initializePushAndPopMethods() {
        if (svInstanceOfServerIndetityHelper == null) {
            try {
                svClassServerIndetityHelper = Class.forName(SERVERIDENTITYHELPER_CLASS_NAME);
                Method method2 = svClassServerIndetityHelper.getMethod(GETSERVERIDENTITYHELPER_METHOD_NAME, null);
                svInstanceOfServerIndetityHelper = method2.invoke(null, null);
            }
            catch (Exception exception) {
                logger.logp(Level.SEVERE, classname, "initializePushAndPopMethods", "FFDCHELPER_GET_SERVERIDENTITYHELPER_INSTANCE_FAILED", exception);
                svClassServerIndetityHelper = null;
                svInstanceOfServerIndetityHelper = null;
            }
        }
        try {
            svPushMethod = svClassServerIndetityHelper.getMethod(PUSH_METHOD_NAME, null);
            svPopMethod = svClassServerIndetityHelper.getMethod(POP_METHOD_NAME, Object.class);
        }
        catch (Exception exception) {
            logger.logp(Level.SEVERE, classname, "initializePushAndPopMethods", "FFDCHELPER_GET_SERVERIDENTITYHELPER_METHODS_FAILED", exception);
            svPushMethod = null;
            svPopMethod = null;
        }
    }

    static Object invokeServerIdentityHelperPushMethod() {
        if (svPushMethod == null) {
            FFDCHelper.initializePushAndPopMethods();
        }
        if (svPushMethod != null) {
            try {
                return svPushMethod.invoke(svInstanceOfServerIndetityHelper, null);
            }
            catch (Exception exception) {
                logger.logp(Level.SEVERE, classname, "initializePushAndPopMethods", "FFDCHLEPER_INVOKE_SERVERIDENTITYHELPER_METHOD_FAILED", new Object[]{SERVERIDENTITYHELPER_CLASS_NAME, PUSH_METHOD_NAME});
            }
        } else {
            logger.logp(Level.SEVERE, classname, "initializePushAndPopMethods", "FFDCHLEPER_SERVERIDENTITYHELPER_METHOD_NOT_INITIALIZED", new Object[]{SERVERIDENTITYHELPER_CLASS_NAME, PUSH_METHOD_NAME});
        }
        return null;
    }

    static void invokeServerIdentityHelperPopMethod(Object object) {
        if (svPopMethod == null) {
            FFDCHelper.initializePushAndPopMethods();
        }
        if (svPopMethod != null) {
            try {
                Object[] objectArray = new Object[]{object};
                svPopMethod.invoke(svInstanceOfServerIndetityHelper, objectArray);
            }
            catch (Exception exception) {
                logger.logp(Level.SEVERE, classname, "initializePushAndPopMethods", "FFDCHLEPER_INVOKE_SERVERIDENTITYHELPER_METHOD_FAILED", new Object[]{SERVERIDENTITYHELPER_CLASS_NAME, POP_METHOD_NAME});
            }
        } else {
            logger.logp(Level.SEVERE, classname, "initializePushAndPopMethods", "FFDCHLEPER_SERVERIDENTITYHELPER_METHOD_NOT_INITIALIZED", new Object[]{SERVERIDENTITYHELPER_CLASS_NAME, POP_METHOD_NAME});
        }
    }

    public static boolean isServer() {
        return svServer;
    }

    public static void setServer() {
        svServer = true;
    }

    public static String getServerName() {
        return svServerName;
    }

    public static void setServerName(String string) {
        if (string != null) {
            svServerName = string;
        }
    }

    public static final String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        FFDCHelper.printStackTrace(throwable, printWriter);
        return stringWriter.toString();
    }

    private static final void printStackTrace(Throwable throwable, PrintWriter printWriter) {
        if (throwable == null) {
            printWriter.println("none");
            return;
        }
        throwable.printStackTrace(printWriter);
        if (throwable instanceof UnknownException || throwable instanceof NamingException || throwable instanceof RemoteException || throwable instanceof InvocationTargetException) {
            boolean bl = true;
            Throwable throwable2 = null;
            while (bl) {
                throwable2 = throwable.getCause();
                if (throwable2 != null) {
                    throwable = throwable2;
                    continue;
                }
                throwable2 = FFDCHelper.getNestedThrowable(throwable);
                if (throwable2 == null) {
                    return;
                }
                if (!(throwable instanceof UnknownException) && !(throwable instanceof NamingException)) {
                    throwable = throwable2;
                    continue;
                }
                bl = false;
            }
            printWriter.println("---- Begin backtrace for Nested Throwables");
            FFDCHelper.printStackTrace(throwable2, printWriter);
        }
    }

    private static final Throwable getNestedThrowable(Throwable throwable) {
        if (throwable instanceof UnknownException) {
            return ((UnknownException)throwable).originalEx;
        }
        if (throwable instanceof RemoteException) {
            return ((RemoteException)throwable).detail;
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        if (throwable instanceof NamingException) {
            return ((NamingException)throwable).getRootCause();
        }
        return null;
    }

    static String[] split(String string, int n) {
        if (string == null || string.equals("")) {
            return new String[0];
        }
        int n2 = 0;
        int n3 = 0;
        while (true) {
            n3 = string.indexOf(n, n3);
            ++n2;
            if (n3 == -1) break;
            ++n3;
        }
        String[] stringArray = new String[n2];
        int n4 = 0;
        int n5 = string.indexOf(n, 0);
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = i + 1 == n2 ? string.substring(n4) : string.substring(n4, n5);
            n4 = n5 + 1;
            n5 = string.indexOf(n, n4);
        }
        return stringArray;
    }

    static String generateOutputFileName(String string, String string2) throws WsException {
        String string3;
        int n;
        String string4 = null;
        string4 = string == null || string.equals("") ? FFDCHelper.generateFilename(string2) : string;
        File file = new File(string4);
        if (!file.isAbsolute()) {
            try {
                string4 = file.getPath();
                if (string4.startsWith(".")) {
                    string4 = string4.substring(1);
                }
                if (string4.startsWith(File.separator)) {
                    string4 = string4.substring(1);
                }
                if ((n = string4.lastIndexOf(":")) != -1) {
                    string4 = string4.substring(n + 1);
                }
                if (string4 == null || string4.equals("")) {
                    string4 = FFDCHelper.generateFilename(string2);
                } else {
                    string3 = FFDCHelper.getDefaultLoggingDirectory();
                    string4 = string3 + File.separator + string4;
                }
            }
            catch (WsException wsException) {
                throw wsException;
            }
            catch (Throwable throwable) {
                string4 = FFDCHelper.generateFilename(string2);
            }
            file = new File(string4);
        }
        string4 = file.getPath();
        if (!FFDCHelper.fileExists(file)) {
            n = string4.lastIndexOf(File.separator);
            if (n == -1) {
                throw new WsException("Incoherent file name of " + string4);
            }
            string3 = string4.substring(0, n);
            file = new File(string3);
            if (!FFDCHelper.fileExists(file) && !FFDCHelper.makeDirectories(file)) {
                throw new WsException("Unable to create directory  " + string3 + " for file " + string4);
            }
        }
        if (!FFDCHelper.canWriteFile(file)) {
            throw new WsException("FFDC does not have necessary permission to write file " + string4);
        }
        return string4;
    }

    private static String generateFilename(String string) {
        try {
            Date date = new Date(System.currentTimeMillis());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yy.MM.dd_HH.mm.ss");
            String string2 = simpleDateFormat.format(date);
            String string3 = FFDCHelper.getDefaultLoggingDirectory();
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(string3);
            stringBuffer.append(File.separatorChar);
            if (FFDC.isZos()) {
                stringBuffer.append(FFDC.getFullServerName().trim());
                stringBuffer.append('_');
                stringBuffer.append(FFDC.getzOSjobName().trim());
                stringBuffer.append('_');
                stringBuffer.append(FFDC.getzOSjobNumber().trim());
            } else {
                stringBuffer.append(svServerName);
                stringBuffer.append('_');
                stringBuffer.append(string);
            }
            stringBuffer.append('_');
            stringBuffer.append(string2);
            stringBuffer.append("_0");
            stringBuffer.append(FFDC.getExceptionFileExtension());
            return new String(stringBuffer);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static synchronized String getDefaultLoggingDirectory() throws WsException {
        if (svDefaultLoggingDirectory == null) {
            String string = FFDC.getLogRoot();
            if (string == null) {
                throw new WsException("FFDCHelper - unable to obtain the install directory");
            }
            File file = new File(string = string.endsWith(File.separator) ? string + "ffdc" : string + File.separator + "ffdc");
            if (!FFDCHelper.fileExists(file) && !FFDCHelper.makeDirectories(file)) {
                throw new WsException("FFDCHelper - Unable to create directory  " + file.getPath());
            }
            svDefaultLoggingDirectory = file.getPath();
        }
        return svDefaultLoggingDirectory;
    }

    static synchronized String getQualifiedDatabaseName(String string) throws WsException {
        if (svDatabaseDirectory == null) {
            String string2 = FFDCHelper.getSystemProperty("user.install.root");
            if (string2 == null) {
                throw new WsException("FFDCHelper - unable to obtain the install directory");
            }
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            svDatabaseDirectory = string2 = "properties" + File.separator + "logbr" + File.separator + "ffdc" + File.separator + "adv" + File.separator + string;
        }
        return svDatabaseDirectory;
    }

    static FileOutputStream createFileOutputStream(String string, boolean bl) throws PrivilegedActionException {
        final String string2 = string;
        final boolean bl2 = bl;
        FileOutputStream fileOutputStream = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return new FileOutputStream(string2, bl2);
            }
        });
        return fileOutputStream;
    }

    static String getSystemProperty(String string) {
        final String string2 = string;
        try {
            String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string2);
                }
            });
            return string3;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    static InputStream getResourceAsStream(String string) throws PrivilegedActionException {
        final String string2 = string;
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(string2);
            }
        });
        return inputStream;
    }

    static boolean deleteFile(File file) {
        try {
            final File file2 = file;
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.delete());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static boolean fileExists(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.exists());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static boolean canReadFile(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.canRead());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static long fileLastModified(File file) {
        final File file2 = file;
        Long l = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(file2.lastModified());
            }
        });
        long l2 = l;
        return l2;
    }

    static long getFileLength(File file) {
        final File file2 = file;
        try {
            Long l = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Long(file2.length());
                }
            });
            return l;
        }
        catch (SecurityException securityException) {
            return 0L;
        }
    }

    static boolean canWriteFile(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.canWrite());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static boolean createNewFile(File file) throws PrivilegedActionException {
        final File file2 = file;
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return new Boolean(file2.createNewFile());
            }
        });
        return bl;
    }

    static boolean makeDirectories(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.mkdirs());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static boolean renameFile(File file, File file2) {
        final File file3 = file;
        final File file4 = file2;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file3.renameTo(file4));
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static boolean isFile(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.isFile());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static String[] listFileNames(File file) {
        final File file2 = file;
        try {
            String[] stringArray = (String[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return file2.list();
                }
            });
            return stringArray;
        }
        catch (SecurityException securityException) {
            return new String[0];
        }
    }

    static boolean isDirectory(File file) {
        final File file2 = file;
        try {
            Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(file2.isDirectory());
                }
            });
            return bl;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static File[] listFiles(File file, FileFilter fileFilter) {
        final File file2 = file;
        final FileFilter fileFilter2 = fileFilter;
        try {
            File[] fileArray = (File[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return file2.listFiles(fileFilter2);
                }
            });
            return fileArray;
        }
        catch (SecurityException securityException) {
            return new File[0];
        }
    }

    static DateFormat getBasicDateFormatter() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
            String string = simpleDateFormat.toPattern();
            int n = string.length();
            int n2 = string.lastIndexOf(115) + 1;
            String string2 = string.substring(0, n2) + ":SSS z";
            if (n2 < n) {
                string2 = string2 + string.substring(n2, n);
            }
            string2 = string2.replace('h', 'H');
            string2 = string2.replace('K', 'H');
            string2 = string2.replace('k', 'H');
            string2 = string2.replace('a', ' ');
            string2 = string2.trim();
            simpleDateFormat.applyPattern(string2);
            dateFormat = simpleDateFormat;
        } else {
            dateFormat = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
        }
        return dateFormat;
    }

    public static String getThreadId() {
        LogRecord logRecord = new LogRecord(Level.FINE, "x");
        return FFDCHelper.getThreadId(logRecord);
    }

    public static String getThreadId(LogRecord logRecord) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(16);
        String string = Integer.toHexString(logRecord.getThreadID());
        for (int i = n = string.length(); i < 8; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static {
        svDatabaseDirectory = null;
        classname = FFDCHelper.class.getName();
        logger = Logger.getLogger(classname, "com.ibm.ws.ffdc.resources.FFDCMessages");
        svServer = false;
    }
}

