/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.ssl.WSNotification;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class WSNotifier {
    private static final TraceComponent tc = Tr.register(WSNotifier.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    String name = null;
    boolean logToSystemOut = false;
    boolean sendEmail = false;
    String emailList = null;

    public WSNotifier(WSNotification wSNotification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSNotifier");
        }
        this.name = wSNotification.getName();
        this.logToSystemOut = wSNotification.isLogToSystemOut();
        this.sendEmail = wSNotification.isSendEmail();
        this.emailList = wSNotification.getEmailList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSNotifier", new Object[]{this.toString()});
        }
    }

    public void notify(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notify", string);
        }
        if (this.logToSystemOut) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Logging to message log.");
            }
            Tr.info(tc, "ssl.notification.send.info.CWPKI0037I", new Object[]{string});
        }
        if (this.sendEmail) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sending email(s).");
            }
            this.sendMail(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notify");
        }
    }

    public void sendMail(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendMail");
        }
        String string2 = null;
        String string3 = null;
        String[] stringArray = this.emailList.split("\\|");
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i].trim();
            int n = string4.indexOf("(");
            if (n == -1) {
                string3 = string4;
                n = string4.indexOf("@");
                if (n != -1) {
                    string2 = "smtp-server." + string4.substring(n + 1);
                }
            } else {
                string2 = string4.substring(n + 1, string4.length() - 1);
                string3 = string4.substring(0, n);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sending email to " + string3 + " at smtp server " + string2 + ".");
            }
            this.send(string3, string2, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendMail");
        }
    }

    public void send(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "send");
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("mail.transport.protocol", "smtp");
            properties.setProperty("mail.host", string2);
            properties.setProperty("mail.user", string);
            properties.setProperty("mail.password", "");
            Session session = Session.getDefaultInstance(properties, null);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom(new InternetAddress("WebSphereNotification@ibm.com"));
            mimeMessage.setContent(string3, "text/plain");
            mimeMessage.addRecipient(Message.RecipientType.TO, new InternetAddress(string));
            mimeMessage.setSubject("WebSphere Notification from process: " + ManagementScopeManager.getInstance().getProcessScopeName());
            Transport transport = session.getTransport();
            transport.connect();
            transport.sendMessage(mimeMessage, mimeMessage.getRecipients(Message.RecipientType.TO));
            transport.close();
        }
        catch (Exception exception) {
            Tr.error(tc, "ssl.notification.send.error.CWPKI0036E", new Object[]{string, string2, exception.getMessage()});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception sending email to user.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.crypto.config.WSNotifier.send", "156", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send");
        }
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WSNotifier.toString() {\n");
        stringBuffer.append("name = ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        stringBuffer.append("logToSystemOut = ");
        stringBuffer.append(this.logToSystemOut);
        stringBuffer.append("\n");
        stringBuffer.append("sendEmail = ");
        stringBuffer.append(this.sendEmail);
        stringBuffer.append("\n");
        stringBuffer.append("emailList = ");
        stringBuffer.append(this.emailList);
        stringBuffer.append("\n}");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toString");
        }
        return stringBuffer.toString();
    }
}

