/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.validation;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.OutboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.GenericChannelFactory;
import com.ibm.websphere.validation.base.config.MOFValidator;
import com.ibm.websphere.validation.base.config.WebSphereDelegateValidator;
import com.ibm.ws.channel.framework.ChannelTypeManager;
import com.ibm.ws.channel.framework.ctm.ValidationChannelTypeManager;
import com.ibm.ws.channel.validation.ChannelTypeValidatorManager;
import com.ibm.ws.channel.validation.ChannelValidationCollector;
import com.ibm.wsspi.channel.ChannelFactoryTypeValidator;
import com.ibm.wsspi.channel.ChannelTypeValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.validation.internal.core.ValidationException;

public class ChannelFrameworkValidator
extends WebSphereDelegateValidator {
    private static final TraceComponent tc = Tr.register(ChannelFrameworkValidator.class, "ChannelFrameworkService", "com.ibm.ws.channel.resources.channelframeworkservice");
    private ChannelTypeManager _typeManager = new ValidationChannelTypeManager();
    private ChannelTypeValidatorManager _validatorManager = new ChannelTypeValidatorManager((MOFValidator)this, this._typeManager);

    public ChannelFrameworkValidator(MOFValidator mOFValidator) {
        super(mOFValidator);
    }

    protected String getLocalBundleID() {
        return "com.ibm.ws.channel.resources.channelframeworkvalidation";
    }

    protected String getLocalTraceName() {
        return "ChannelFrameworkValidator";
    }

    protected final void visitNonList(Object object) throws ValidationException {
        this.visitNonTraversing(object);
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "basicValidate");
        }
        if (!(object instanceof TransportChannelService)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "basicValidate");
            }
            return super.basicValidate(object);
        }
        try {
            TransportChannelService transportChannelService = (TransportChannelService)object;
            EList eList = transportChannelService.getFactories();
            if (eList != null && !eList.isEmpty()) {
                this.validateFactories(transportChannelService.getFactories());
            }
            if (!this.testNullOrEmptyWarning(transportChannelService.getTransportChannels(), "no.channels", transportChannelService)) {
                this.validateChannels(transportChannelService.getTransportChannels());
            }
            if (!this.testNullOrEmptyWarning(transportChannelService.getChains(), "no.chains", transportChannelService)) {
                this.validateChains(transportChannelService.getChains());
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught exception in ChannelFrameworkValidator.basicValidate:", exception);
            }
            this.addError("generic.validation.exception", new String[]{exception.getMessage()}, object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "basicValidate");
        }
        return true;
    }

    private void validateFactories(List list) throws ValidationException {
        Iterator iterator = list.iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            this.validateFactory((TransportChannelFactory)iterator.next(), hashSet);
        }
    }

    private void validateFactory(TransportChannelFactory transportChannelFactory, Set set) throws ValidationException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validating " + ChannelFrameworkValidator.getID(transportChannelFactory));
        }
        if (set.contains(transportChannelFactory.getClass())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "multiple factories of type: " + transportChannelFactory.getClass().getName());
            }
            this.addError("duplicate.channel.factory", new String[]{transportChannelFactory.getClass().getName()}, transportChannelFactory);
        } else if (!(transportChannelFactory instanceof GenericChannelFactory)) {
            set.add(transportChannelFactory.getClass());
        }
        ChannelFactoryTypeValidator channelFactoryTypeValidator = this._validatorManager.getChannelFactoryTypeValidator(transportChannelFactory);
        if (channelFactoryTypeValidator == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "could not find extension validator for type " + transportChannelFactory.getClass().getName());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validating factory with " + ((Object)((Object)channelFactoryTypeValidator)).getClass().getName());
            }
            channelFactoryTypeValidator.validate(transportChannelFactory);
        }
    }

    private void validateChannels(List list) throws ValidationException {
        ChannelValidationCollector channelValidationCollector = new ChannelValidationCollector(this._typeManager);
        Iterator iterator = list.iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            TransportChannel transportChannel = (TransportChannel)iterator.next();
            this.validateChannel(transportChannel, hashSet);
            channelValidationCollector.collectChannel(transportChannel);
        }
        iterator = channelValidationCollector.getChannelTypes().iterator();
        while (iterator.hasNext()) {
            ChannelTypeManager.ChannelMetaData channelMetaData = (ChannelTypeManager.ChannelMetaData)iterator.next();
            this.validateAllChannels(channelMetaData, channelValidationCollector.getChannels(channelMetaData));
        }
    }

    private void validateAllChannels(ChannelTypeManager.ChannelMetaData channelMetaData, List list) throws ValidationException {
        if (list == null) {
            return;
        }
        try {
            TransportChannel[] transportChannelArray = list.toArray(new TransportChannel[list.size()]);
            ChannelTypeValidator channelTypeValidator = (ChannelTypeValidator)this._validatorManager.getValidator(channelMetaData.getClass(channelMetaData.getValidatorClass()));
            channelTypeValidator.validateAll(transportChannelArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void validateChannel(TransportChannel transportChannel, Set set) throws ValidationException {
        ChannelTypeValidator channelTypeValidator;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validating " + ChannelFrameworkValidator.getID(transportChannel));
        }
        if (transportChannel.getName() == null) {
            this.addError("nameless.channel", new String[]{ChannelFrameworkValidator.getID(transportChannel)}, transportChannel);
        } else if (set.contains(transportChannel.getName())) {
            this.addError("duplicate.channel.name", new String[]{transportChannel.getName()}, transportChannel);
        } else {
            set.add(transportChannel.getName());
        }
        if (transportChannel instanceof InboundTransportChannel) {
            boolean bl = false;
            ChannelTypeManager.ChannelMetaData channelMetaData = this._typeManager.getChannelType(transportChannel);
            if (channelMetaData != null && channelMetaData.getKind() == ChannelTypeManager.ChannelKind.CONNECTOR) {
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found connector channel, " + transportChannel.getName() + " so no disc weight validation");
                }
            }
            if (!bl) {
                InboundTransportChannel inboundTransportChannel = (InboundTransportChannel)transportChannel;
                if (!inboundTransportChannel.isSetDiscriminationWeight()) {
                    this.addError("channel.inbound.weight.unset", new String[]{transportChannel.getName()}, transportChannel);
                } else if (inboundTransportChannel.getDiscriminationWeight() < 0) {
                    this.addError("channel.inbound.weight.invalid", new String[]{transportChannel.getName(), String.valueOf(inboundTransportChannel.getDiscriminationWeight())}, transportChannel);
                }
            }
        }
        if ((channelTypeValidator = this._validatorManager.getChannelTypeValidator(transportChannel)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "could not find extension validator for type " + transportChannel.getClass().getName());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validating channel with " + ((Object)((Object)channelTypeValidator)).getClass().getName());
            }
            channelTypeValidator.validate(transportChannel);
        }
    }

    private void validateChains(List list) throws ValidationException {
        Iterator iterator = list.iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            this.validateChain((Chain)iterator.next(), hashSet);
        }
    }

    private void validateChain(Chain chain, Set set) throws ValidationException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validating " + ChannelFrameworkValidator.getID(chain));
        }
        if (chain.getName() == null) {
            this.addError("nameless.chain", new String[]{ChannelFrameworkValidator.getID(chain)}, chain);
        } else if (set.contains(chain.getName())) {
            this.addError("duplicate.chain.name", new String[]{chain.getName()}, chain);
        } else {
            set.add(chain.getName());
        }
        EList eList = chain.getTransportChannels();
        if (eList == null || eList.isEmpty()) {
            this.addError("empty.chain", new String[]{chain.getName()}, chain);
        } else {
            this.validateChainFlow(chain);
            this.validateChainEnds(chain);
            this.validateChainCoherency(chain);
            this.validateChainChannels(chain);
        }
    }

    private void validateChainFlow(Chain chain) {
        EList eList = chain.getTransportChannels();
        TransportChannel transportChannel = (TransportChannel)eList.get(0);
        FlowType flowType = this.getFlowType(transportChannel);
        HashSet<TransportChannel> hashSet = new HashSet<TransportChannel>();
        hashSet.add(transportChannel);
        for (int i = 1; i < eList.size(); ++i) {
            transportChannel = (TransportChannel)eList.get(i);
            if (flowType != this.getFlowType(transportChannel)) {
                this.addError("chain.flow.mismatch", new String[]{chain.getName(), transportChannel.getName()}, chain);
            }
            if (hashSet.contains(transportChannel)) {
                this.addError("chain.duplicate.channel", new String[]{transportChannel.getName(), chain.getName()}, chain);
                continue;
            }
            hashSet.add(transportChannel);
        }
    }

    private void validateChainEnds(Chain chain) {
        TransportChannel transportChannel = (TransportChannel)chain.getTransportChannels().get(0);
        TransportChannel transportChannel2 = (TransportChannel)chain.getTransportChannels().get(chain.getTransportChannels().size() - 1);
        boolean bl = transportChannel instanceof InboundTransportChannel;
        if (bl) {
            ChannelTypeManager.ChannelKind channelKind = this.getChannelKind(chain, transportChannel);
            if (channelKind == null) {
                this.addError("missing.channel.kind", new String[]{transportChannel.getName()}, chain);
            } else if (channelKind != ChannelTypeManager.ChannelKind.CONNECTOR) {
                this.addError("channel.kind.connector.mismatch", new String[]{transportChannel.getName(), chain.getName()}, chain);
            }
            channelKind = this.getChannelKind(chain, transportChannel2);
            if (channelKind == null) {
                this.addError("missing.channel.kind", new String[]{transportChannel2.getName()}, chain);
            } else if (channelKind != ChannelTypeManager.ChannelKind.ACCEPTOR) {
                this.addError("channel.kind.acceptor.mismatch", new String[]{transportChannel2.getName(), chain.getName()}, chain);
            }
        } else {
            ChannelTypeManager.ChannelKind channelKind = this.getChannelKind(chain, transportChannel2);
            if (channelKind == null) {
                this.addError("missing.channel.kind", new String[]{transportChannel2.getName()}, chain);
            } else if (channelKind != ChannelTypeManager.ChannelKind.CONNECTOR) {
                this.addError("channel.kind.connector.mismatch", new String[]{transportChannel.getName(), chain.getName()}, chain);
            }
        }
    }

    private void validateChainCoherency(Chain chain) {
        List list = chain.getTransportChannels();
        if (list.get(0) instanceof OutboundTransportChannel) {
            list = new ArrayList(list);
            Collections.reverse(list);
        }
        ChannelTypeManager.ChannelMetaData channelMetaData = this._typeManager.getChannelType(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            ChannelTypeManager.ChannelMetaData channelMetaData2 = channelMetaData;
            channelMetaData = this._typeManager.getChannelType(list.get(i));
            if (channelMetaData2 == null || channelMetaData == null) {
                this.addError("coherency.check.aborted", new String[]{chain.getName()}, chain);
                return;
            }
            if (Collections.binarySearch(channelMetaData.getDeviceInterface(), channelMetaData2.getApplicationInterface()) >= 0) continue;
            this.addError("channel.interface.mismatch", new String[]{chain.getName(), channelMetaData2.getConfigurationClass(), channelMetaData.getConfigurationClass()}, chain);
        }
    }

    private void validateChainChannels(Chain chain) {
        EList eList = chain.getTransportChannels();
        for (int i = 0; i < eList.size(); ++i) {
            try {
                TransportChannel transportChannel = (TransportChannel)eList.get(i);
                ChannelTypeValidator channelTypeValidator = this._validatorManager.getChannelTypeValidator(transportChannel);
                if (channelTypeValidator == null) continue;
                channelTypeValidator.validateInChain(transportChannel, chain);
                continue;
            }
            catch (ValidationException validationException) {
                Tr.debug(tc, "caught exception in validateChainChannels (Chain): ", validationException);
            }
        }
    }

    private ChannelTypeManager.ChannelKind getChannelKind(Chain chain, TransportChannel transportChannel) {
        ChannelTypeManager.ChannelMetaData channelMetaData = this._typeManager.getChannelType(transportChannel);
        if (channelMetaData == null) {
            this.addError("unknown.channel.type", new String[]{transportChannel.getName()}, chain);
            return null;
        }
        return channelMetaData.getKind();
    }

    private FlowType getFlowType(TransportChannel transportChannel) {
        return transportChannel == null ? null : (transportChannel instanceof InboundTransportChannel ? FlowType.INBOUND : FlowType.OUTBOUND);
    }

    protected static String getID(EObject eObject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(eObject.eResource().getURI());
        stringBuffer.append('#');
        stringBuffer.append(eObject.eResource().getURIFragment(eObject));
        return stringBuffer.toString();
    }
}

