/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.xml;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CalendarUtil {
    public static final String pgmVersion = "1.1";
    public static final String pgmUpdate = "9/3/02";
    public static final int HOURS_OFFSET = 0;
    public static final int MINUTES_OFFSET = 1;
    public static final int SECONDS_OFFSET = 2;
    public static final String XML_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final int XML_DATE_FORMAT_LENGTH = 19;
    public static final DateFormat XML_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final String FILE_DATE_FORMAT = "yyyyMMdd_HHmmss";
    public static final DateFormat FILE_DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd_HHmmss");
    public static final String SIMPLE_DATE_FORMAT = "yyyy-MM-dd";
    public static final SimpleDateFormat SIMPLE_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");

    public static Calendar getTimeStamp() {
        return Calendar.getInstance();
    }

    public static String getTimeStampAsString() {
        return CalendarUtil.formatXMLTimeStamp(CalendarUtil.getTimeStamp());
    }

    public static int[] splitMillisec(int n) {
        int n2;
        if ((n -= (n2 = n / 1000) * 1000) >= 500) {
            ++n2;
        }
        int n3 = n2 / 3600;
        int n4 = (n2 -= n3 * 3600) / 60;
        return new int[]{n3, n4, n2 -= n4 * 60};
    }

    public static void adjustByMillisec(Calendar calendar, int n) {
        if (n == 0) {
            return;
        }
        boolean bl = n < 0;
        if (bl) {
            n *= -1;
        }
        int[] nArray = CalendarUtil.splitMillisec(n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        if (bl) {
            n *= -1;
            n4 *= -1;
            n3 *= -1;
            n2 *= -1;
        }
        calendar.add(13, n4);
        calendar.add(12, n3);
        calendar.add(10, n2);
    }

    public static String formatXMLZone(int n) {
        String string;
        if (n == 0) {
            return "Z";
        }
        if (n < 0) {
            string = "-";
            n *= -1;
        } else {
            string = "+";
        }
        int[] nArray = CalendarUtil.splitMillisec(n);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        String string2 = Integer.toString(n2);
        if (n2 < 10) {
            string2 = "0" + string2;
        }
        string = string + string2;
        String string3 = Integer.toString(n3);
        if (n3 < 10) {
            string3 = "0" + string3;
        }
        string = string + ':' + string3;
        if (n4 > 0) {
            String string4 = Integer.toString(n4);
            if (n4 < 10) {
                string4 = "0" + string4;
            }
            string = string + ':' + string4;
        }
        return string;
    }

    public static int[] parseXMLZone(String string) {
        int n;
        int n2;
        int n3;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (!string.startsWith("Z")) {
            n3 = string.indexOf(58);
            if (n3 == -1) {
                string2 = string;
            } else {
                string2 = string.substring(0, n3);
                int n4 = (string = string.substring(n3, string.length())).indexOf(58);
                if (n4 == -1) {
                    string3 = string;
                } else {
                    string3 = string.substring(0, n4);
                    string4 = string.substring(n4, string.length());
                }
            }
        }
        if (string2 != null) {
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 0;
            }
        } else {
            n3 = 0;
        }
        if (string3 != null) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        if (string4 != null) {
            try {
                n = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        } else {
            n = 0;
        }
        return new int[]{n3, n2, n};
    }

    public static String formatXMLTimeStamp(Calendar calendar) {
        Date date = calendar.getTime();
        String string = XML_DATE_FORMATTER.format(date);
        int n = calendar.get(15) + calendar.get(16);
        String string2 = CalendarUtil.formatXMLZone(n);
        string = string + string2;
        return string;
    }

    public static Calendar recoverCalendar(String string) {
        Date date;
        if (string == null) {
            return null;
        }
        int n = 19;
        String string2 = string.substring(0, n);
        String string3 = string.substring(n, string.length());
        try {
            date = XML_DATE_FORMATTER.parse(string2);
        }
        catch (ParseException parseException) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n2 = calendar.get(15) + calendar.get(16);
        int[] nArray = CalendarUtil.parseXMLZone(string3);
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = nArray[2];
        int n6 = ((n3 * 60 + n4) * 60 + n5) * 1000;
        int n7 = n2 - n6;
        CalendarUtil.adjustByMillisec(calendar, n7);
        return calendar;
    }

    public static String fileFormat(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        int n = calendar2.get(15) + calendar2.get(16);
        CalendarUtil.adjustByMillisec(calendar2, -1 * n);
        Date date = calendar2.getTime();
        String string = FILE_DATE_FORMATTER.format(date);
        return string;
    }

    public static String fileFormat(String string) {
        Calendar calendar = CalendarUtil.recoverCalendar(string);
        String string2 = calendar == null ? null : CalendarUtil.fileFormat(calendar);
        return string2;
    }

    public static String formatSimple(Calendar calendar) {
        return SIMPLE_DATE_FORMATTER.format(calendar);
    }

    public static Calendar recoverSimple(String string) {
        Date date;
        try {
            date = SIMPLE_DATE_FORMATTER.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }
}

