/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.deployment.deploywrapper.DeployUtil;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.dfltbndngs.BindEarCmd;
import com.ibm.ws.management.application.dfltbndngs.BindingError;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.component.InstallRAHelper;
import com.ibm.ws.management.configarchive.EnhancedEarConfigurator;
import com.ibm.ws.management.configarchive.EnhancedEarReader;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.common.CompatibilityDescriptionGroup;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class ArchiveDeploymentInfo
extends AppDeploymentInfo {
    public static final String destModPath = "ibm.update.mod.path";
    protected EARFile archive;
    protected String archivePath;
    protected Vector saveAsFileTempDirs;
    protected String j2ee12SecurityWarning;
    protected Hashtable moduleForDD;
    protected ApplicationDeployment appDepl;
    protected String modPath = null;
    protected List enhancedEarWorkspaces = new ArrayList();
    protected List enhancedEarConfigurators = new ArrayList();
    private static long saveAsTempDirBase = System.currentTimeMillis();
    protected Resource deplResource;
    protected Resource enh_deplResource;
    private static TraceComponent tc = Tr.register(ArchiveDeploymentInfo.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");

    public ArchiveDeploymentInfo(EARFile eARFile) throws AppDeploymentException {
        this(eARFile, new Hashtable());
    }

    public ArchiveDeploymentInfo(EARFile eARFile, Hashtable hashtable) throws AppDeploymentException {
        super(hashtable);
        this.archive = eARFile;
        this.j2ee12SecurityWarning = null;
        this.moduleForDD = null;
        this.modPath = (String)hashtable.get(destModPath);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ArchiveDeploymentInfo");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ear is: " + eARFile.getURI());
        }
        this.setApplication(this.archive.getDeploymentDescriptor());
        this.setApplicationBindings(this.archive.getBindings());
        this.setApplicationExtensions(this.archive.getExtensions());
        if (this.appBinding == null) {
            throw new AppDeploymentException("Null application bindings. Possibly corrupt ear file.", null);
        }
        if (this.appExtension == null) {
            throw new AppDeploymentException("Null application extension. Possibly corrupt ear file.", null);
        }
        if (this.appBinding.getApplication() == null) {
            throw new AppDeploymentException("Application bindings file does not contain a reference to the deployment descriptor.  Corrupt ear file. Check if META-INF/ibm-application-bnd.xmi uri in the ear file contains a valid application href tag.", null);
        }
        if (this.appExtension.getApplication() == null) {
            throw new AppDeploymentException("Application extensions file does not contain a reference to the deployment descriptor.  Corrupt ear file. Check if META-INF/ibm-application-ext.xmi uri in the ear file contains a valid application href tag.", null);
        }
        eARFile.rollUpRoles();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ArchiveDeploymentInfo");
        }
    }

    protected Vector createModuleConfig(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createModuleConfig");
        }
        if (this.archive == null) {
            return null;
        }
        Vector<EObject> vector = new Vector<EObject>();
        EList eList = this.archive.getDeploymentDescriptor().getModules();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            if (!(string.startsWith("JAR") && module.isEjbModule() || string.startsWith("WAR") && module.isWebModule()) && (!string.startsWith("RAR") || !module.isConnectorModule())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing JAR/WAR/RAR module " + module.getUri());
            }
            try {
                CompatibilityDescriptionGroup compatibilityDescriptionGroup;
                String string2;
                EObject eObject;
                if (string.endsWith("DD")) {
                    vector.addElement(this.archive.getDeploymentDescriptor(module));
                    continue;
                }
                if (string.endsWith("BND")) {
                    eObject = this.archive.getBindings(module);
                    string2 = eObject.eResource().getURI().toString();
                    if (string.equals("JAR_BND") && ((compatibilityDescriptionGroup = ((EJBJarBinding)eObject).getEjbJar()) == null || compatibilityDescriptionGroup.eIsProxy())) {
                        Tr.warning(tc, "ADMA0091E", (Object)new String[]{string2, string2, module.getUri(), "" + compatibilityDescriptionGroup});
                        ((EJBJarBinding)eObject).setEjbJar((EJBJar)this.archive.getDeploymentDescriptor(module));
                    }
                    if (string.equals("WAR_BND") && ((compatibilityDescriptionGroup = ((WebAppBinding)eObject).getWebapp()) == null || compatibilityDescriptionGroup.eIsProxy())) {
                        Tr.warning(tc, "ADMA0091E", (Object)new String[]{string2, string2, module.getUri(), "" + compatibilityDescriptionGroup});
                        ((WebAppBinding)eObject).setWebapp((WebApp)this.archive.getDeploymentDescriptor(module));
                    }
                    vector.addElement(eObject);
                    continue;
                }
                if (!string.endsWith("EXT") || string.startsWith("RAR")) continue;
                eObject = this.archive.getExtensions(module);
                string2 = eObject.eResource().getURI().toString();
                if (string.equals("JAR_EXT") && ((compatibilityDescriptionGroup = ((EJBJarExtension)eObject).getEjbJar()) == null || compatibilityDescriptionGroup.eIsProxy())) {
                    Tr.warning(tc, "ADMA0091E", (Object)new String[]{string2, string2, module.getUri(), "" + compatibilityDescriptionGroup});
                    ((EJBJarExtension)eObject).setEjbJar((EJBJar)this.archive.getDeploymentDescriptor(module));
                }
                if (string.equals("WAR_EXT") && ((compatibilityDescriptionGroup = ((WebAppExtension)eObject).getWebApp()) == null || compatibilityDescriptionGroup.eIsProxy())) {
                    Tr.warning(tc, "ADMA0091E", (Object)new String[]{string2, string2, module.getUri(), "" + compatibilityDescriptionGroup});
                    ((WebAppExtension)eObject).setWebApp((WebApp)this.archive.getDeploymentDescriptor(module));
                }
                vector.addElement(eObject);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Throwing new AppDeploymentException from AppInstallHelper::getModuleConfig " + exception);
                }
                if (exception instanceof AppDeploymentException) {
                    throw (AppDeploymentException)exception;
                }
                throw new AppDeploymentException("", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createModuleConfig: " + vector);
        }
        return vector;
    }

    public Module getModuleForDD(EObject eObject) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleForDD");
        }
        Module module = null;
        if (this.moduleForDD == null) {
            this.moduleForDD = new Hashtable();
            EList eList = this.archive.getDeploymentDescriptor().getModules();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Module module2 = (Module)iterator.next();
                if (module2.isJavaModule()) continue;
                try {
                    this.moduleForDD.put(this.archive.getDeploymentDescriptor(module2), module2);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got Exception in getting module dd " + module2 + " -- exc: " + exception);
                    }
                    throw new AppDeploymentException("", exception);
                }
            }
        }
        module = (Module)this.moduleForDD.get(eObject);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The returned module is: " + module);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleForDDLocal");
        }
        return module;
    }

    public ModuleFile getModuleFileForDD(EObject eObject) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleFileForDD");
        }
        ModuleFile moduleFile = null;
        Module module = this.getModuleForDD(eObject);
        if (module != null) {
            try {
                moduleFile = this.archive.getModuleRef(module).getModuleFile();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got Exception in getting module file for module  " + module + " -- exc: " + exception);
                }
                throw new AppDeploymentException("", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleFileForDD");
        }
        return moduleFile;
    }

    public void close(boolean bl) throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        if (this.archive == null) {
            Tr.warning(tc, "ADMA0142W", "Trying to close the archive that is already closed.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close");
            }
            return;
        }
        java.io.File file = new java.io.File(this.archive.getURI());
        try {
            int n2 = n = file.exists() && file.isDirectory() ? 1 : 0;
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isDir: " + (n != 0));
                }
                if (n == 0) {
                    this.archive.save();
                } else {
                    this.archive.extractNoReopen(66);
                }
            }
            if (n == 0 && this.modPath != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "modPath =  " + this.modPath);
                }
                ModuleFile moduleFile = (ModuleFile)this.archive.getModuleFiles().get(0);
                moduleFile.saveAs(this.modPath);
            }
            if (this.deplResource != null) {
                this.deplResource.unload();
            }
            if (this.enh_deplResource != null) {
                this.enh_deplResource.unload();
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Throwing new AppDeploymentException from AppInstallHelper::closeLocal " + throwable);
            }
            throw new AppDeploymentException("", throwable);
        }
        finally {
            this.archive.close();
            this.archive = null;
            if (this.modPath != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting " + file.getPath());
                }
                file.delete();
            }
        }
        this.moduleData.clear();
        if (this.saveAsFileTempDirs != null) {
            for (n = 0; n < this.saveAsFileTempDirs.size(); ++n) {
                try {
                    AppUtils.deleteDirTree((String)this.saveAsFileTempDirs.elementAt(n));
                    continue;
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Error deleting temp dir: " + (String)this.saveAsFileTempDirs.elementAt(n) + ", " + exception);
                }
            }
            this.saveAsFileTempDirs = null;
        }
        if (this.enhancedEarWorkspaces.size() > 0) {
            try {
                for (n = 0; n < this.enhancedEarWorkspaces.size(); ++n) {
                    if (this.enhancedEarWorkspaces.get(n) == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "workspace to be removed: " + this.enhancedEarWorkspaces.get(n));
                    }
                    ConfigRepoHelper.removeWorkSpace(false, (WorkSpace)this.enhancedEarWorkspaces.get(n));
                    ((EnhancedEarConfigurator)this.enhancedEarConfigurators.get(n)).cleanup();
                }
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMA0077W", throwable);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Archive closed. moduleData cleared");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public Hashtable getSavedResults() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.options.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, this.options.get(string));
        }
        if (this.archivePath != null) {
            hashtable.put("original.ear.location", this.archivePath);
        }
        return hashtable;
    }

    public void createDefaultBindings(Preferences preferences) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDefaultBindings" + preferences);
        }
        try {
            Vector vector = this.getModuleConfig("JAR_BND");
            Vector vector2 = this.getModuleConfig("WAR_BND");
            Vector vector3 = this.getModuleConfig("JAR_EXT");
            Vector vector4 = this.getModuleConfig("WAR_EXT");
            BindEarCmd bindEarCmd = null;
            bindEarCmd = preferences != null ? new BindEarCmd(this.archive, preferences) : new BindEarCmd(this.archive, true);
            bindEarCmd.bind();
        }
        catch (BindingError bindingError) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception during creation of default bindings: " + bindingError);
            }
            Throwable throwable = this.getRootError(bindingError);
            throw new AppDeploymentException(bindingError.toString(), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultBindings");
        }
    }

    public String getSecurityPolicyData(ResourceBundle resourceBundle) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityPolicyData");
        }
        String string = null;
        InputStream inputStream = null;
        if (this.archive != null) {
            try {
                Object object;
                try {
                    inputStream = this.archive.getResourceInputStream("META-INF/was.policy");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    inputStream = null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Input stream: " + inputStream);
                }
                if (inputStream == null) {
                    object = this.getJ2EEAppVersion();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "App Version: " + (String)object);
                    }
                    if (object != null && ((String)object).equals(AppConstants.APPDEPL_APP_VERSION_1_2)) {
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        inputStream = classLoader.getResourceAsStream("was.policy");
                        if (inputStream != null) {
                            this.saveAsFile(null, "META-INF/was.policy", inputStream);
                            this.j2ee12SecurityWarning = AppUtils.getMessage(resourceBundle, "ADMA0080W");
                            Tr.warning(tc, "ADMA0080W");
                            try {
                                inputStream = this.archive.getResourceInputStream("META-INF/was.policy");
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                inputStream = null;
                            }
                        } else {
                            this.j2ee12SecurityWarning = AppUtils.getMessage(resourceBundle, "ADMA0081W");
                            Tr.warning(tc, "ADMA0081W");
                        }
                    }
                }
                if (inputStream != null) {
                    byte[] byArray;
                    int n;
                    object = new ByteArrayOutputStream();
                    int n2 = inputStream.available();
                    while (n2 > 0 && (n = inputStream.read(byArray = new byte[n2])) != -1) {
                        ((ByteArrayOutputStream)object).write(byArray, 0, n);
                        n2 = inputStream.available();
                    }
                    ((OutputStream)object).flush();
                    string = ((ByteArrayOutputStream)object).toString();
                    ((ByteArrayOutputStream)object).close();
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                AppUtils.dbg(tc, "Unexpected exception caught while: " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityPolicyData - " + string);
        }
        return string;
    }

    public String getSecurityPolicyWarning() {
        return this.j2ee12SecurityWarning;
    }

    public void saveAsFile(String string, String string2, InputStream inputStream) throws AppDeploymentException {
        String string3 = ArchiveDeploymentInfo.saveAsFile(this.archive, string, string2, inputStream);
        if (string3 != null) {
            if (this.saveAsFileTempDirs == null) {
                this.saveAsFileTempDirs = new Vector();
            }
            this.saveAsFileTempDirs.addElement(string3);
        }
    }

    public static String saveAsFile(EARFile eARFile, String string, String string2, InputStream inputStream) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveAsFile");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moduleUri: " + string + ", fileUri: " + string2);
        }
        String string3 = null;
        if (inputStream == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "inputStream is null");
            }
        } else {
            Object object;
            if (eARFile == null) {
                return null;
            }
            Archive archive = null;
            if (string == null || string.trim().equals("")) {
                archive = eARFile;
            } else {
                object = eARFile.getArchiveFiles().iterator();
                while (object.hasNext() && !(archive = (Archive)object.next()).getURI().equals(string)) {
                    archive = null;
                }
            }
            if (archive != null) {
                Exception exception;
                block37: {
                    FileOutputStream fileOutputStream;
                    block36: {
                        java.io.File file;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "found matching archive: " + archive);
                        }
                        ArchiveInit.init();
                        object = CommonarchiveFactoryImpl.getActiveFactory();
                        exception = null;
                        String string4 = AppUtils.getTempDir();
                        while ((file = new java.io.File(string3 = string4 + "save_" + String.valueOf(++saveAsTempDirBase))).exists()) {
                        }
                        file.mkdirs();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "temp dirname: " + string3);
                        }
                        String string5 = string3;
                        if (string2 != null && !string2.equals("")) {
                            string5 = string5 + java.io.File.separator + string2;
                        }
                        file = new java.io.File(string5);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "save file location: " + string5);
                        }
                        file = new java.io.File(file.getParent());
                        fileOutputStream = null;
                        try {
                            if (file.exists()) {
                                AppUtils.deleteDirTree(file);
                            }
                            file.mkdirs();
                            fileOutputStream = new FileOutputStream(string5);
                            if (fileOutputStream != null) {
                                int n = 0;
                                byte[] byArray = new byte[1024];
                                while ((n = inputStream.read(byArray)) != -1) {
                                    fileOutputStream.write(byArray, 0, n);
                                }
                                fileOutputStream.close();
                                fileOutputStream = null;
                                ReadOnlyDirectory readOnlyDirectory = object.openReadOnlyDirectory(string3);
                                File file2 = null;
                                try {
                                    file2 = readOnlyDirectory.getFileInSelfOrSubdirectory(string2);
                                }
                                catch (Throwable throwable) {
                                    file2 = null;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "file in readDir: " + file2);
                                }
                                if (file2 != null && archive.isDuplicate(string2)) {
                                    FileIterator fileIterator = archive.getFilesForSave();
                                    while (fileIterator.hasNext()) {
                                        File file3 = fileIterator.next();
                                        if (!file3.getURI().equals(string2)) continue;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, ".... Removing existing file");
                                        }
                                        archive.remove(file3);
                                        break;
                                    }
                                }
                                if (file2 != null) {
                                    archive.addCopy(file2);
                                }
                                break block36;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Not able to create the input stream as a file");
                            }
                        }
                        catch (Exception exception2) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "File IO exception: " + exception2);
                            }
                            exception = exception2;
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!tc.isDebugEnabled()) break block37;
                            Tr.debug(tc, "Error closing save file: " + fileOutputStream + ", " + iOException);
                        }
                    }
                }
                if (exception != null) {
                    throw new AppDeploymentException(exception.toString(), exception);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not able to find matching module: " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveAsFile");
        }
        return string3;
    }

    public String getAppDisplayName() {
        Object v = this.options.get("appname");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "app name from options " + v);
        }
        if (v != null && v instanceof String) {
            return (String)v;
        }
        return AppInstallHelper.getAppDisplayName(this.archive, this.options);
    }

    public String getURI() {
        return this.archive.getURI();
    }

    private Throwable getRootError(BindingError bindingError) {
        Throwable throwable;
        for (throwable = bindingError; throwable != null && throwable instanceof BindingError && throwable.getChainedEx() != null; throwable = throwable.getChainedEx()) {
        }
        return throwable;
    }

    public Resource getResource(String string, String string2, String string3) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource", new Object[]{string, string2, string3});
        }
        if (this.archive.containsFile(string2)) {
            InputStream inputStream = this.archive.getInputStream(string2);
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createURI(string3);
            Resource resource = wASResourceSetImpl.createResource(uRI);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res is: " + resource);
            }
            HashMap hashMap = new HashMap();
            resource.load(inputStream, hashMap);
            return resource;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource: null");
        }
        return null;
    }

    public Resource getAppDeploymentResource(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDeploymentResoource", new Object[]{new Boolean(bl)});
        }
        Resource resource = super.getAppDeploymentResource(bl);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deplres in memory: " + resource);
        }
        if (resource != null) {
            return resource;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deplResource: " + this.deplResource);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enh_deplResource: " + this.enh_deplResource);
        }
        if (this.deplResource != null) {
            return this.deplResource;
        }
        try {
            if (bl && this.enh_deplResource != null) {
                return this.enh_deplResource;
            }
            this.deplResource = this.getResource(null, "deployment.xml", "deployment.xml");
            if (this.deplResource == null && EnhancedEarReader.isEnhancedEar(this.archive)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "null root deployment.xml. Get deployment.xml from enhanced ear");
                }
                this.enh_deplResource = EnhancedEarReader.getDeployment(this.archive);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getAppDeploymentResource", new Object[]{this.enh_deplResource});
                }
                return this.enh_deplResource;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentResource", new Object[]{this.deplResource});
            }
            return this.deplResource;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception loading depl resource: " + throwable);
            }
            FFDCFilter.processException(throwable, this.getClass().getName() + ".getAppDeploymentResource", "784", this);
            return null;
        }
    }

    public ApplicationDeployment getAppDeploymentObject(boolean bl) {
        Resource resource = this.getAppDeploymentResource(bl);
        if (resource != null) {
            return (ApplicationDeployment)((Deployment)resource.getContents().get(0)).getDeployedObject();
        }
        return null;
    }

    public boolean checkIfEarDeployed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfEarDeployed");
        }
        try {
            try {
                Class.forName("com.ibm.etools.ejbdeploy.EJBDeploymentException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ejbdeploy is not packaged in the install");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfEarDeployed: return true");
                }
                return true;
            }
            List list = this.archive.getEJBJarFiles();
            if (list.size() == 0) {
                return true;
            }
            for (int i = 0; i < list.size(); ++i) {
                boolean bl = DeployUtil.isEJBJarDeployed((EJBJarFile)list.get(i));
                if (bl) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, ((EJBJarFile)list.get(i)).getURI() + " not deployed. Default will be set to run EJBDeploy.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfEarDeployed");
                }
                return false;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkIfEarDeployed: return true");
            }
            return true;
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "ADMA0143W", (Object)new Object[]{throwable});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkIfEarDeployed: return true after exception");
            }
            return true;
        }
    }

    public boolean checkIfEnhancedEar() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfEnhancedEar");
        }
        boolean bl = true;
        try {
            bl = EnhancedEarReader.isEnhancedEar(this.archive);
            if (bl) {
                this.enh_deplResource = EnhancedEarReader.getDeployment(this.archive);
            }
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "ADMA0104W", throwable);
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfEnhancedEar: return" + bl);
        }
        return bl;
    }

    public boolean isStandaloneDeployment() {
        if (this.archive == null) {
            return false;
        }
        return this.archive.containsFile("META-INF/was.ejbmodule") || this.archive.containsFile("META-INF/was.webmodule");
    }

    public InputStream getInputStream(String string, String string2) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInputStream: " + string + ", " + string2);
        }
        InputStream inputStream = null;
        try {
            if (string == null) {
                inputStream = this.archive.getInputStream(string2);
            } else {
                List list = this.archive.getModuleFiles();
                for (int i = 0; i < list.size(); ++i) {
                    ModuleFile moduleFile = (ModuleFile)list.get(i);
                    if (!moduleFile.getURI().equals(string)) continue;
                    inputStream = moduleFile.getInputStream(string2);
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInputStream: " + inputStream);
            }
            return inputStream;
        }
        catch (IOException iOException) {
            throw new AppDeploymentException("", iOException);
        }
    }

    public boolean containsURI(String string, String string2) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsURI: " + string + ", " + string2);
        }
        if (string == null) {
            return this.archive.containsFile(string2);
        }
        List list = this.archive.getModuleFiles();
        for (int i = 0; i < list.size(); ++i) {
            ModuleFile moduleFile = (ModuleFile)list.get(i);
            if (!moduleFile.getURI().equals(string)) continue;
            return moduleFile.containsFile(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsURI: moduleURI did not match");
        }
        return false;
    }

    public Class loadClass(EObject eObject, String string, String string2) {
        Class clazz;
        block11: {
            ModuleFile moduleFile;
            block10: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "loadClass: " + eObject + " className : " + string + " type : " + string2);
                }
                ResourcesPackage resourcesPackage = (ResourcesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi");
                ResourcesFactory resourcesFactory = resourcesPackage.getResourcesFactory();
                clazz = null;
                moduleFile = null;
                try {
                    moduleFile = this.getModuleFileForDD(eObject);
                }
                catch (AppDeploymentException appDeploymentException) {
                    if (!tc.isDebugEnabled()) break block10;
                    Tr.debug(tc, "Failed to get DD" + appDeploymentException);
                }
            }
            if (moduleFile == null) {
                return null;
            }
            ClassLoader classLoader = ExtClassLoader.getInstance();
            if (classLoader == null) {
                classLoader = InstallRAHelper.class.getClassLoader();
            }
            ArchiveFileDynamicClassLoader archiveFileDynamicClassLoader = new ArchiveFileDynamicClassLoader(moduleFile, classLoader, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "module is : " + moduleFile + " classLoader : " + archiveFileDynamicClassLoader);
            }
            if (archiveFileDynamicClassLoader == null) {
                return null;
            }
            try {
                clazz = J2CAppUtils.getDefinedClass((String)string, (ClassLoader)archiveFileDynamicClassLoader);
            }
            catch (AdminException adminException) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Failed to getDefinedClass" + adminException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Class: " + clazz);
        }
        return clazz;
    }

    public ArchiveManifest getEarManifest() {
        return this.archive.getManifest();
    }

    public Resource getEnhancedEarDeploymentResource(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEnhancedEarDeploymentResource", new Object[]{string});
        }
        boolean bl = true;
        EnhancedEarConfigurator enhancedEarConfigurator = null;
        WorkSpace workSpace = null;
        Resource resource = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(null);
            enhancedEarConfigurator = new EnhancedEarConfigurator(workSpace, this.archive, true, "default", "appName", "appName.ear_");
            bl = enhancedEarConfigurator.isEnhancedEar();
            if (bl && (resource = enhancedEarConfigurator.getDeploymentResource(string)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding enhanced ear workspace " + workSpace + " to list to be deleted");
                }
                this.enhancedEarWorkspaces.add(workSpace);
                this.enhancedEarConfigurators.add(enhancedEarConfigurator);
            }
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "ADMA0104W", throwable);
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEnhancedEarDeploymentResource", new Object[]{resource});
        }
        return resource;
    }
}

