/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAdminClientTypeException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.WSGUICallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSStdinCallbackHandlerImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminDataHolder;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfig;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public abstract class AdminClientFactory {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(AdminClientFactory.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS connectorNLS = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private static final String SOAP_PROXY_CLASS = "com.ibm.ws.management.connector.soap.SOAPConnectorClient";
    private static final String RMI_PROXY_CLASS = "com.ibm.ws.management.connector.rmi.RMIConnectorClient";
    private static final String ADMIN_CLIENT_IMPL_CLASS = "com.ibm.ws.management.AdminClientImpl";
    private static final String ADMIN_SERVICE_PROXY_CLASS = "com.ibm.ws.management.connector.AdminServiceProxy";
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    private static Hashtable cachedClients = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static AdminClient createAdminClient(Properties var0) throws ConnectorException {
        if (AdminClientFactory.tc.isEntryEnabled()) {
            Tr.entry(AdminClientFactory.tc, "createAdminClient");
        }
        var1_1 = null;
        if (SecurityContext.isServerProcess() && (var2_2 = System.getSecurityManager()) != null) {
            var2_2.checkPermission(AdminClientFactory.adminPermission);
        }
        if ((var2_2 = (String)var0.get("type")) == null) {
            if (AdminClientFactory.tc.isEntryEnabled()) {
                Tr.exit(AdminClientFactory.tc, "createAdminClient");
            }
            throw new InvalidAdminClientTypeException();
        }
        var3_3 = null;
        if (AdminClientFactory.tc.isDebugEnabled()) {
            Tr.debug(AdminClientFactory.tc, "Checking for cache Key");
        }
        var4_4 = AdminClientFactory.getCacheKey((String)var2_2, (Properties)var0);
        var5_5 = AdminClientFactory.cachedClients;
        synchronized (var5_5) {
            var1_1 = (AdminClient)AdminClientFactory.cachedClients.get(var4_4);
        }
        if (var1_1 != null) {
            if (AdminClientFactory.tc.isDebugEnabled()) {
                Tr.debug(AdminClientFactory.tc, "Cached admin client found");
            }
            try {
                var5_5 = (String)var0.get("username");
                var6_9 = (String)var0.get("password");
                if (!SecurityContext.isServerProcess() && "RMI".equalsIgnoreCase((String)var2_2) && SecurityContext.getContextManager().getInvocationSubject() == null && var5_5 != null && var5_5.trim().length() > 0 && var6_9 != null && var6_9.trim().length() > 0) {
                    var7_12 = SubjectHelper.createBasicAuthSubject(null, (String)var5_5, var6_9);
                    SecurityContext.getContextManager().setInvocationSubject(var7_12);
                    var1_1.getConnectorProperties().put("username", var5_5);
                    var1_1.getConnectorProperties().put("password", var6_9);
                }
                var1_1.isAlive();
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit(AdminClientFactory.tc, "createAdminClient - in cache");
                }
                return var1_1;
            }
            catch (Exception var5_6) {
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "invalid cached client, try to recreate", var5_6);
                }
                var6_10 = AdminClientFactory.cachedClients;
                synchronized (var6_10) {
                    AdminClientFactory.cachedClients.remove(var4_4);
                }
                var1_1 = null;
            }
        }
        if (var2_2.equalsIgnoreCase("SOAP")) {
            var6_10 = null;
            if (!new Boolean(var0.getProperty("isInternal")).booleanValue()) {
                var7_13 = var0.getProperty("com.ibm.SOAP.ConfigURL");
                if (var7_13 == null) {
                    var7_13 = System.getProperty("com.ibm.SOAP.ConfigURL");
                }
                if (var7_13 == null) {
                    var8_17 = System.getProperty("user.install.root");
                    if (var8_17 == null) {
                        var8_17 = System.getProperty("was.install.root");
                    }
                    var7_13 = "file:" + (String)var8_17 + "/properties/soap.client.props";
                }
                if (var7_13 != null) {
                    var8_17 = var7_13;
                    var6_10 = (Properties)AccessController.doPrivileged(new PrivilegedAction((String)var8_17){
                        private final /* synthetic */ String val$url;
                        {
                            this.val$url = string;
                        }

                        public Object run() {
                            Properties properties = AdminClientFactory.loadPropertiesFromFile(this.val$url);
                            return properties;
                        }
                    });
                }
            }
            if ((var7_13 = var0.getProperty("securityEnabled")) == null && var6_10 != null) {
                var7_13 = var6_10.getProperty("securityEnabled");
                var8_17 = var6_10.getProperty("com.ibm.ssl.alias");
                if (var8_17 != null) {
                    var6_10.setProperty("sslConfig", (String)var8_17);
                }
                if (var8_17 == null) {
                    var6_10.setProperty("sslConfig", "ADMIN_SOAP");
                }
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "soap ssl alias: " + (String)var8_17);
                }
            }
            if (var6_10 != null) {
                var6_10.putAll((Map<?, ?>)var0);
                var0 = var6_10;
            }
            var8_17 = (Properties)var0.clone();
            var5_7 = new Boolean((String)var7_13);
            if (var5_7) {
                var8_17.remove("securityEnabled");
            } else {
                var8_17.setProperty("securityEnabled", "true");
            }
            try {
                var9_19 = Class.forName("com.ibm.ws.management.connector.soap.SOAPConnectorClient");
                var10_23 = Class.forName("com.ibm.ws.management.AdminClientImpl");
                var11_25 = new Class[]{Properties.class};
                var12_27 = var9_19.getConstructor(var11_25);
                try {
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug(AdminClientFactory.tc, "Before 1st attempt to new up com.ibm.ws.management.connector.soap.SOAPConnectorClient");
                    }
                    AdminClientFactory.showDebugInfo((Properties)var0);
                    var13_30 = (InvocationHandler)var12_27.newInstance(new Object[]{var0});
                }
                catch (Exception var14_33) {
                    block101: {
                        var15_36 = AdminClientFactory.getAltCacheKey(var4_4);
                        var16_38 = AdminClientFactory.cachedClients;
                        synchronized (var16_38) {
                            var1_1 = (AdminClient)AdminClientFactory.cachedClients.get(var15_36);
                        }
                        if (var1_1 != null) {
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "Alternate cached admin client found");
                            }
                            try {
                                var1_1.isAlive();
                                if (AdminClientFactory.tc.isEntryEnabled()) {
                                    Tr.exit(AdminClientFactory.tc, "createAdminClient - alternate in cache");
                                }
                                return var1_1;
                            }
                            catch (Throwable var16_39) {
                                if (!AdminClientFactory.tc.isDebugEnabled()) break block101;
                                Tr.debug(AdminClientFactory.tc, "Alternate cached admin client is not available", var16_39);
                            }
                        }
                    }
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug(AdminClientFactory.tc, "Try to new up the com.ibm.ws.management.connector.soap.SOAPConnectorClient instance again using alternative Properties after the 1st attempt failed with", var14_33);
                    }
                    var3_3 = var14_33;
                    AdminClientFactory.showDebugInfo((Properties)var8_17);
                    var13_30 = (InvocationHandler)var12_27.newInstance(new Object[]{var8_17});
                    v0 = var5_7 = var5_7 == false;
                }
                if (!SecurityContext.isServerProcess() && var5_7) {
                    var14_34 = (String)var0.get("username");
                    var15_36 = (String)var0.get("password");
                    var16_38 = (String)var0.get("loginsource");
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug(AdminClientFactory.tc, "User: " + (String)var14_34);
                    }
                    if (var14_34 != null && var14_34.length() > 0 && var15_36 != null && var15_36.length() > 0) {
                        var17_42 = SubjectHelper.createBasicAuthSubject(null, (String)var14_34, (String)var15_36);
                        AdminDataHolder.setData("wsSubject", var17_42);
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "Saving the Subject for Soap connector. ValueNull:" + (var17_42 == null));
                        }
                    } else if (var16_38 != null && (var16_38.equals("stdin") || var16_38.equals("prompt"))) {
                        block102: {
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "About to login using JAAS");
                            }
                            var17_43 = null;
                            var18_44 = null;
                            try {
                                var17_43 = AdminClientFactory.jaas_login((String)var16_38);
                                if (var17_43 == null) break block102;
                                AdminDataHolder.setData("wsSubject", var17_43);
                                var18_44 = SubjectHelper.getWSCredentialFromSubject(var17_43);
                                var14_34 = var18_44.getSecurityName();
                                if (var14_34.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                                    var14_34 = RealmSecurityName.getSecurityName((String)var14_34);
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "New username: " + (String)var14_34);
                                    }
                                }
                                var15_36 = StringBytesConversion.getConvertedString(var18_44.getCredentialToken());
                                var0.put("username", var14_34);
                                var0.put("password", var15_36);
                                var8_17.put("username", var14_34);
                                var8_17.put("password", var15_36);
                                var19_45 = var9_19.getDeclaredMethod("setUserAndPwd", new Class[]{String.class, String.class});
                                var19_45.invoke((Object)var13_30, new Object[]{var14_34, var15_36});
                            }
                            catch (WSLoginFailedException var19_47) {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "WSLoginFailedException occurred: ", new Object[]{var19_47});
                                }
                                FFDCFilter.processException(var19_47, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "330");
                            }
                            catch (Exception var19_48) {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "Exception occurred during JAAS login: ", new Object[]{var19_48});
                                }
                                FFDCFilter.processException(var19_48, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "336");
                            }
                        }
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "Saving the wscredential for Soap connector. ValueNull:" + (var18_44 == null));
                        }
                    }
                }
                var11_25[0] = InvocationHandler.class;
                var14_34 = var10_23.getConstructor(var11_25);
                var1_1 = (AdminClient)var14_34.newInstance(new Object[]{var13_30});
                if (var0.getProperty("username") != null && var0.getProperty("password") != null) {
                    var1_1.getConnectorProperties().setProperty("username", var0.getProperty("username"));
                    var1_1.getConnectorProperties().setProperty("password", var0.getProperty("password"));
                }
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "soap client props now = " + DebugUtils.createPropertiesMaskPlainTextPassword(var1_1.getConnectorProperties()));
                }
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl275
                Tr.debug(AdminClientFactory.tc, "SOAPConnectorClient is created");
            }
            catch (Exception var9_20) {
                FFDCFilter.processException(var9_20, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "215");
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit(AdminClientFactory.tc, "createAdminClient - failed", var9_20);
                }
                if (var3_3 != null) {
                    var9_21 = var3_3;
                }
                if (var5_7) {
                    throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0053E", new Object[]{var0.getProperty("host"), var0.getProperty("port")}, "Could not create SOAP Connector to connect to host {0} at port {1} with SOAP Connector security enabled"), var9_21);
                }
                throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0016E", new Object[]{var0.getProperty("host"), var0.getProperty("port")}, "Could not create SOAP Connector to connect to host {0} at port {1}"), var9_21);
            }
        } else if (var2_2.equalsIgnoreCase("RMI")) {
            var5_7 = new Boolean(var0.getProperty("securityEnabled"));
            var6_10 = (Properties)var0.clone();
            if (var5_7) {
                var6_10.remove("securityEnabled");
            } else {
                var6_10.setProperty("securityEnabled", "true");
            }
            try {
                block103: {
                    var7_13 = Class.forName("com.ibm.ws.management.connector.rmi.RMIConnectorClient");
                    var8_18 = Class.forName("com.ibm.ws.management.AdminClientImpl");
                    var9_22 = new Class[]{Properties.class};
                    var10_24 = var7_13.getConstructor(var9_22);
                    try {
                        AdminClientFactory.showDebugInfo((Properties)var0);
                        var11_26 = var10_24.newInstance(new Object[]{var0});
                    }
                    catch (Exception var12_28) {
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "try alternative connector properties after receiving the following exception", var12_28);
                        }
                        var3_3 = var12_28;
                        AdminClientFactory.showDebugInfo((Properties)var6_10);
                        var11_26 = var10_24.newInstance(new Object[]{var6_10});
                        var5_7 = var5_7 == false;
                    }
                    var9_22[0] = Class.forName("com.ibm.ws.management.connector.AdminServiceProxy");
                    var12_29 = var8_18.getConstructor(var9_22);
                    var1_1 = (AdminClient)var12_29.newInstance(new Object[]{var11_26});
                    try {
                        if (!SecurityContext.isServerProcess() && ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "trying to get security user/pw info from rmi connector if security is enabled");
                            }
                            if ((var13_31 = ContextManagerFactory.getInstance().getInvocationSubject()) == null) {
                                var13_31 = ContextManagerFactory.getInstance().getOwnSubject();
                            }
                            if (var13_31 != null) {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "subject is not null");
                                }
                                var14_35 = null;
                                var14_35 = SubjectHelper.getWSCredentialFromSubject(var13_31);
                                if (var14_35 != null) {
                                    var15_37 = var14_35.getSecurityName();
                                    if (var15_37.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                                        var15_37 = RealmSecurityName.getSecurityName(var15_37);
                                        if (AdminClientFactory.tc.isDebugEnabled()) {
                                            Tr.debug(AdminClientFactory.tc, "RMI New username: " + var15_37);
                                        }
                                    }
                                    var16_40 = StringBytesConversion.getConvertedString(var14_35.getCredentialToken());
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "RMI New password: " + var16_40);
                                    }
                                    var1_1.getConnectorProperties().setProperty("username", var15_37);
                                    var1_1.getConnectorProperties().setProperty("password", var16_40);
                                }
                            }
                        }
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "rmi client props now = " + var1_1.getConnectorProperties());
                        }
                    }
                    catch (Exception var13_32) {
                        if (!AdminClientFactory.tc.isDebugEnabled()) break block103;
                        Tr.debug(AdminClientFactory.tc, "exception while trying to get security user/pw info from rmi connector", var13_32);
                    }
                }
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl275
                Tr.debug(AdminClientFactory.tc, "RMIConnectorClient is created");
            }
            catch (Exception var7_14) {
                FFDCFilter.processException(var7_14, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "267");
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit(AdminClientFactory.tc, "createAdminClient - failed", var7_14);
                }
                if (var3_3 != null) {
                    var7_15 = var3_3;
                }
                throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0017E", new Object[]{var0.getProperty("host"), var0.getProperty("port")}, "Could not create RMI Connector to connect to host {0} at port {1}"), var7_15);
            }
        } else {
            if (AdminClientFactory.tc.isEntryEnabled()) {
                Tr.exit(AdminClientFactory.tc, "createAdminClient");
            }
            throw new InvalidAdminClientTypeException();
        }
lbl275:
        // 4 sources

        if (AdminClientFactory.tc.isDebugEnabled()) {
            Tr.debug(AdminClientFactory.tc, "Getting Cache Disabled property");
        }
        var6_11 = new Boolean(var0.getProperty("cacheDisabled"));
        if (var1_1 != null) {
            if (var6_11) {
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "Caching disabled for this admin client");
                }
            } else {
                var4_4.setProperty("securityEnabled", var5_7 != false ? "true" : "false");
                AdminClientFactory.showDebugInfo(var4_4);
                var7_13 = AdminClientFactory.cachedClients;
                synchronized (var7_13) {
                    AdminClientFactory.cachedClients.put(var4_4, var1_1);
                }
            }
        }
        if (AdminClientFactory.tc.isEntryEnabled()) {
            Tr.exit(AdminClientFactory.tc, "createAdminClient");
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromFile(String string) {
        Object object;
        if (!string.startsWith("file:")) {
            string = "file:".concat(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFromFile", string);
        }
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            object = new URL(string);
            inputStream = ((URL)object).openStream();
            properties.load(inputStream);
            properties = AdminClientFactory.decodePasswordsAndExpandVariables(properties);
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.websphere.management.AdminClientFactory.loadPropertiesFromFile", "313");
            Tr.warning(tc, "ADMC0046W", (Object)new Object[]{string});
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.websphere.management.AdminClientFactory.loadPropertiesFromFile", "322");
                }
            }
        }
        if (!properties.isEmpty()) {
            object = (String)properties.remove("com.ibm.SOAP.loginUserid");
            String string2 = (String)properties.remove("com.ibm.SOAP.loginPassword");
            String string3 = (String)properties.remove("com.ibm.SOAP.loginSource");
            String string4 = (String)properties.remove("com.ibm.SOAP.securityEnabled");
            if (string3 != null && string3.length() > 0) {
                properties.setProperty("loginsource", string3);
            }
            if (object != null) {
                properties.setProperty("username", (String)object);
            }
            if (string2 != null) {
                properties.setProperty("password", string2);
            }
            if (string4 != null) {
                properties.setProperty("securityEnabled", string4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadPropertisFromFile");
        }
        return properties;
    }

    private static Properties decodePasswordsAndExpandVariables(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decodePasswords");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 != null && string2.indexOf("${USER_INSTALL_ROOT}") != -1) {
                string2 = KeyStoreManager.getInstance().expand(string2);
            }
            if (string.toLowerCase().indexOf("password") == -1 || string2 == null) continue;
            String string3 = SSLConfig.decodePassword(string2);
            properties.setProperty(string, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodePasswords");
        }
        return properties;
    }

    private static void showDebugInfo(Properties properties) {
        if (tc.isDebugEnabled()) {
            Set<Map.Entry<Object, Object>> set = properties.entrySet();
            Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                String string = (String)entry.getKey();
                Object object = entry.getValue();
                if (string.equals("password") || string.endsWith("Password")) {
                    Tr.debug(tc, "[key, value]", new Object[]{string, "********"});
                    continue;
                }
                Tr.debug(tc, "[key, value]", new Object[]{string, object});
            }
        }
    }

    private static Properties getCacheKey(String string, Properties properties) throws ConnectorException {
        Properties properties2 = new Properties();
        String string2 = properties.getProperty("host");
        String string3 = properties.getProperty("port");
        String string4 = properties.getProperty("loginsource");
        String string5 = properties.getProperty("securityEnabled");
        String string6 = properties.getProperty("autoAcceptSignerForThisConnectionOnly");
        String string7 = properties.getProperty("username");
        if (string7 != null && string7.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In getCacheKey, stripping realm from username.");
            }
            string7 = RealmSecurityName.getSecurityName(string7);
            properties.setProperty("username", string7);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In getCacheKey, new username: " + string7);
            }
        }
        String string8 = properties.getProperty("password");
        if (string2 == null) {
            throw new ConnectorException(connectorNLS.getString("ADMC0041E"));
        }
        String string9 = string2;
        try {
            string2 = InetAddress.getByName(string2).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException(unknownHostException, "com.ibm.websphere.management.AdminClientFactory.getCacheKey", "432");
            string2 = string9;
        }
        if (string3 == null) {
            throw new ConnectorException(connectorNLS.getString("ADMC0042E"));
        }
        string3 = string3.trim();
        properties2.setProperty("type", string.toUpperCase());
        properties2.setProperty("host", string2);
        properties2.setProperty("port", string3);
        if (string5 != null) {
            properties2.setProperty("securityEnabled", string5);
        } else {
            properties2.setProperty("securityEnabled", "false");
        }
        if (string7 != null && string8 != null) {
            properties2.setProperty("username", string7);
            properties2.setProperty("password", string8);
        }
        if (string4 != null) {
            properties2.setProperty("loginsource", string4);
        }
        if (string6 != null) {
            properties2.setProperty("autoAcceptSignerForThisConnectionOnly", string6);
        }
        return properties2;
    }

    protected static Subject jaas_login(String string) throws WSLoginFailedException {
        LoginContext loginContext;
        Subject subject;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "jaas_login(" + string + ")");
            }
            subject = null;
            loginContext = null;
            try {
                if (string != null && string.equalsIgnoreCase("prompt")) {
                    try {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "creating GraphicsEnvironment");
                        }
                        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        loginContext = new LoginContext("WSAdminClientLogin", new WSGUICallbackHandlerImpl());
                        loginContext.login();
                        break block14;
                    }
                    catch (WSLoginFailedException wSLoginFailedException) {
                        throw wSLoginFailedException;
                    }
                    catch (LoginException loginException) {
                        FFDCFilter.processException(loginException, "com.ibm.websphere.management.AdminClientFactory.jaas_login", "173");
                        if (loginException instanceof WSLoginFailedException) {
                            throw (WSLoginFailedException)loginException;
                        }
                        throw new WSLoginFailedException(loginException.getMessage(), loginException);
                    }
                    catch (Throwable throwable) {
                        loginContext = new LoginContext("WSAdminClientLogin", new WSStdinCallbackHandlerImpl());
                        loginContext.login();
                        break block14;
                    }
                }
                loginContext = new LoginContext("WSAdminClientLogin", new WSStdinCallbackHandlerImpl());
                loginContext.login();
            }
            catch (LoginException loginException) {
                FFDCFilter.processException(loginException, "com.ibm.websphere.management.AdminClientFactory.jaas_login", "152");
                if (loginException instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)loginException;
                }
                throw new WSLoginFailedException(loginException.getMessage(), loginException);
            }
            catch (SecurityException securityException) {
                FFDCFilter.processException(securityException, "com.ibm.websphere.management.AdminClientFactory.jaas_login", "162");
                throw new WSLoginFailedException(securityException.getMessage(), securityException);
            }
        }
        subject = loginContext.getSubject();
        if (subject == null) {
            Tr.debug(tc, "Subject is null.", new Object[]{string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(loginSource)");
        }
        return subject;
    }

    private static Properties getAltCacheKey(Properties properties) {
        Properties properties2 = (Properties)properties.clone();
        if (properties.getProperty("securityEnabled").equals("true")) {
            properties2.setProperty("securityEnabled", "false");
        } else {
            properties2.setProperty("securityEnabled", "true");
        }
        return properties2;
    }
}

