/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.server;

import com.ibm.ras.RASMessageCatalog;
import com.ibm.ras.RASUtil;
import com.ibm.ras.server.RASConnectionHandler;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class RASLogServer
implements Runnable {
    private static final String s = "(C) Copyright IBM Corp. 1998.";
    private static final int DEFAULT_PORT = 9991;
    private boolean toFile = false;
    private int port = 9991;
    private PrintWriter pWriter = null;
    private RASMessageCatalog cat = new RASMessageCatalog("com.ibm.ras.server.RASLogServerMsgs");
    private String filename = null;

    public static void main(String[] stringArray) {
        Object object;
        int n = 0;
        String string = null;
        switch (stringArray.length) {
            case 0: {
                n = 9991;
                break;
            }
            case 1: {
                n = Integer.valueOf(stringArray[0]);
                break;
            }
            case 2: {
                n = Integer.valueOf(stringArray[0]);
                string = stringArray[1];
                break;
            }
            default: {
                object = new RASMessageCatalog("com.ibm.ras.server.RASLogServerMsgs");
                RASUtil.errorMsg(((RASMessageCatalog)object).getMessage("USAGE"));
                System.exit(1);
            }
        }
        object = new RASLogServer(n, string);
    }

    public RASLogServer(int n, String string) {
        this.port = n;
        this.filename = string;
        Thread thread2 = new Thread(this);
        thread2.start();
    }

    public void run() {
        if (this.filename != null) {
            this.toFile = true;
            try {
                this.pWriter = new PrintWriter(new FileOutputStream(this.filename), true);
            }
            catch (IOException iOException) {
                RASUtil.errorMsg(this.cat.getMessage("ERR_OPEN_FILE", this.filename));
                iOException.printStackTrace();
            }
        } else {
            this.toFile = false;
        }
        try {
            this.write(this.cat.getMessage("START_SERVER"));
            this.write(this.cat.getMessage("CREATE_SOCKET", new Integer(this.port).toString()));
            if (this.toFile) {
                this.write(this.cat.getMessage("OUTPUT_TO_FILE", this.filename));
            } else {
                this.write(this.cat.getMessage("OUTPUT_TO_CONSOLE"));
            }
            ServerSocket serverSocket = new ServerSocket(this.port);
            while (true) {
                Socket socket = serverSocket.accept();
                RASConnectionHandler rASConnectionHandler = new RASConnectionHandler(socket, this.toFile, this.pWriter);
                Thread thread2 = new Thread(rASConnectionHandler);
                thread2.start();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void write(String string) {
        if (this.toFile) {
            this.pWriter.println(string);
        }
        System.out.println(string);
    }
}

