/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.utilities;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class UtilsReflection {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String defaultFieldToDelete = "serialVersionUID";

    public static final boolean compareMethods(Method method2, Method method3) {
        Class<?>[] classArray;
        if (!method2.getName().equals(method3.getName())) {
            return false;
        }
        Class<?>[] classArray2 = method2.getParameterTypes();
        int n = classArray2.length;
        if (n != (classArray = method3.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (classArray2[i] == classArray[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean compareMethodsWithoutName(Method method2, Method method3) {
        Class<?>[] classArray;
        if (method2 == null || method3 == null) {
            return false;
        }
        Class<?>[] classArray2 = method2.getParameterTypes();
        int n = classArray2.length;
        if (n != (classArray = method3.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (classArray2[i] == classArray[i]) continue;
            return false;
        }
        return true;
    }

    public static final String getClassDisplayName(Class clazz) {
        Class<?> clazz2 = clazz;
        String string = "";
        while (clazz2.isArray()) {
            string = string + "[]";
            clazz2 = clazz2.getComponentType();
        }
        return clazz2.getName() + string;
    }

    public static final String getClassShortName(Class clazz) {
        String string = UtilsReflection.getClassDisplayName(clazz);
        int n = string.lastIndexOf(46);
        if (n != -1) {
            try {
                string = string.substring(n + 1);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return string;
    }

    public static final String getConstructorDisplayString(Constructor constructor) {
        Class<?>[] classArray = constructor.getParameterTypes();
        Class clazz = constructor.getDeclaringClass();
        String string = UtilsReflection.getClassShortName(clazz) + "(";
        for (int i = 0; i < classArray.length; ++i) {
            string = string + UtilsReflection.getClassShortName(classArray[i]);
            if (i >= classArray.length - 1) continue;
            string = string + ", ";
        }
        string = string + ")";
        return string;
    }

    public static final Method[] getMatchingMethods(Class clazz, Class clazz2) {
        int n;
        Method[] methodArray = clazz.getDeclaredMethods();
        int n2 = 0;
        int n3 = methodArray.length;
        Method[] methodArray2 = new Method[n3];
        for (n = 0; n < n3; ++n) {
            Method method2;
            try {
                method2 = clazz2.getDeclaredMethod(methodArray[n].getName(), methodArray[n].getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            catch (SecurityException securityException) {
                continue;
            }
            if (!UtilsReflection.compareMethods(methodArray[n], method2)) continue;
            methodArray2[n2++] = method2;
        }
        Method[] methodArray3 = new Method[n2];
        for (n = 0; n < n2; ++n) {
            methodArray3[n] = methodArray2[n];
        }
        return methodArray3;
    }

    public static final String getMethodDisplayString(Method method2) {
        Class<?>[] classArray = method2.getParameterTypes();
        String string = method2.getName() + "(";
        for (int i = 0; i < classArray.length; ++i) {
            string = string + UtilsReflection.getClassShortName(classArray[i]);
            if (i >= classArray.length - 1) continue;
            string = string + ", ";
        }
        string = string + ")";
        return string;
    }

    public static final Method[] getMethods(Class clazz, Class clazz2) {
        int n;
        Vector<Method> vector = new Vector<Method>();
        Method[] methodArray = clazz2.getMethods();
        int n2 = methodArray.length;
        if (clazz2 == null || clazz2 == Object.class || !clazz.isAssignableFrom(clazz2)) {
            return methodArray;
        }
        for (n = 0; n < n2; ++n) {
            Method method2 = methodArray[n];
            Class<?> clazz3 = method2.getDeclaringClass();
            if (clazz3.isAssignableFrom(clazz)) continue;
            vector.addElement(method2);
        }
        methodArray = new Method[vector.size()];
        for (n = 0; n < methodArray.length; ++n) {
            methodArray[n] = (Method)vector.elementAt(n);
        }
        return methodArray;
    }

    public static final String getMethodSelector(Method method2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method2.getReturnType().getName());
        stringBuffer.append(" ");
        stringBuffer.append(method2.getName());
        stringBuffer.append("(");
        Class<?>[] classArray = method2.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(classArray[i].getName());
            if (i >= classArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static final Method[] getPublicMemberMethods(Class clazz) {
        int n;
        Vector<Method> vector = new Vector<Method>();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n2 = methodArray.length;
        for (n = 0; n < n2; ++n) {
            Method method2 = methodArray[n];
            int n3 = method2.getModifiers();
            if (!Modifier.isPublic(n3) || Modifier.isStatic(n3)) continue;
            vector.addElement(method2);
        }
        methodArray = new Method[vector.size()];
        for (n = 0; n < methodArray.length; ++n) {
            methodArray[n] = (Method)vector.elementAt(n);
        }
        return methodArray;
    }

    public static final boolean isWrapper(Class clazz) {
        if (clazz == Integer.class) {
            return true;
        }
        if (clazz == String.class) {
            return true;
        }
        if (clazz == Boolean.class) {
            return true;
        }
        if (clazz == Character.class) {
            return true;
        }
        if (clazz == Byte.class) {
            return true;
        }
        if (clazz == Short.class) {
            return true;
        }
        if (clazz == Long.class) {
            return true;
        }
        if (clazz == Float.class) {
            return true;
        }
        if (clazz == Double.class) {
            return true;
        }
        return clazz == Void.class;
    }

    public static final Field[] stripField(Field[] fieldArray) {
        return UtilsReflection.stripField(fieldArray, defaultFieldToDelete);
    }

    public static final Field[] stripField(Field[] fieldArray, String string) {
        int n = -1;
        Field[] fieldArray2 = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return fieldArray;
        }
        fieldArray2 = new Field[fieldArray.length - 1];
        System.arraycopy(fieldArray, 0, fieldArray2, 0, n);
        System.arraycopy(fieldArray, n + 1, fieldArray2, n, fieldArray.length - (n + 1));
        return fieldArray2;
    }
}

