/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasContextManager;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.logging.ZRasHelper;

public abstract class RasEvent6 {
    public static final int AUDIT = 1;
    public static final int DEBUG = 2;
    public static final int DUMP = 3;
    public static final int ERROR = 4;
    public static final int EVENT = 5;
    public static final int ENTRY = 6;
    public static final int EXIT = 7;
    public static final int FATAL = 8;
    public static final int SERVICE = 9;
    public static final int WARNING = 10;
    public static final int INFO = 11;
    public static final int UNCOND = 12;
    public static final int SYSOUT = 13;
    public static final int SYSERR = 14;
    public static final int UNKNOWN = 15;
    public static final int FIRST_EVENT = 1;
    public static final int LAST_EVENT = 15;
    static final String[] svTypePrefixes = new String[]{" A ", " d ", " m ", " E ", " e ", " > ", " < ", " F ", " S ", " W ", " I ", " u ", " O ", " R ", " Z "};
    static final String[] typeNames = new String[]{"AUDIT", "DEBUG", "DUMP", "ERROR", "EVENT", "ENTRY", "EXIT", "FATAL", "SERVICE", "WARNING", "INFO", "UNCOND", "SYSTEMOUT", "SYSTEMERR", "UNKNOWN"};
    static final String ibm = "IBM";
    static final String webSphere = "WebSphere";
    static final String appServer = "Application Server";
    static final String emptyString = "";
    static final String nullParamString = "<null>";
    static final String badParamString = "<malformed parameter>";
    private static ThreadLocal sThreadId = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return RasHelper.getThreadId();
        }
    };
    public String ivOrganization;
    public String ivProduct;
    public String ivComponent;
    public String ivVersion;
    public String ivEventSource;
    public String ivClassName;
    public String ivMethodName;
    public String ivThreadId;
    public String ivProcessId;
    public String ivServerName;
    public String ivThreadName;
    public long ivTimeStamp;
    public int ivType;
    public String ivMsgKey;
    public byte[] ivRawData = null;
    public String ivExtendedMessage;
    public String ivUnitOfWork;
    transient boolean tivIsJras = false;

    static String getTypeString(int n) {
        if (n < 1 || n > 15) {
            return new String("unknown Type");
        }
        return typeNames[n - 1];
    }

    RasEvent6() {
    }

    RasEvent6(int n, TraceComponent traceComponent, String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl) {
        this.ivType = n < 1 || n > 15 ? 15 : n;
        this.ivEventSource = traceComponent.getName();
        this.tivIsJras = bl;
        this.ivOrganization = string4;
        this.ivProduct = string5;
        this.ivComponent = string6;
        this.ivExtendedMessage = string7;
        this.ivClassName = string;
        this.ivMethodName = string2;
        this.ivMsgKey = string3 == null ? "NULL_MESSAGE_KEY_PASSED" : string3;
        this.ivVersion = RasHelper.getVersionId();
        this.ivProcessId = !WSLauncher.isZOS() ? RasHelper.getProcessId() : ZRasHelper.ProcessInfo.getPId();
        this.ivServerName = RasHelper.getServerName();
        this.ivThreadName = Thread.currentThread().getName();
        this.ivTimeStamp = System.currentTimeMillis();
        Thread thread2 = Thread.currentThread();
        this.ivThreadId = (String)sThreadId.get();
        this.ivUnitOfWork = RasContextManager.getUnitOfWork();
    }

    public final long getTimeStamp() {
        return this.ivTimeStamp;
    }

    public String getThreadId() {
        return this.ivThreadId;
    }
}

