/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;

class ExtendedTraceLogger
extends TraceLogger {
    private static final String svSpace = " ";
    private static final String svEquals = "=";
    private static final String svEqualsQuote = "=\"";
    private static final String svQuote = "\"";
    private static final String svQuoteSpace = "\" ";
    private static final String svXmlStart = "<";
    private static final String svXmlEnd = "/>";
    private static final String emptyString = "";
    private static final String svBundle = "com.ibm.ejs.resources.RasMessages";
    private String manufacturerLabel;
    private String productLabel;
    private String versionLabel;
    private String compIDLabel;
    private String processIDLabel;
    private String threadIDLabel;
    private String threadNameLabel;
    private String sourceIDLabel;
    private String classNameLabel;
    private String methodNameLabel;
    private String serverNameLabel;
    private String timeStampLabel;
    private String uowLabel;
    private String severityLabel;
    private String categoryLabel;
    private String primMessageLabel;
    private String extMessageLabel;
    private NumberFormat numberFormat;
    private Date ivDate = new Date();
    protected FieldPosition ivFieldPos = new FieldPosition(0);
    private SimpleDateFormat ivFormatter;
    private int paddingCounter = 0;
    private long previousTimestamp = -1L;
    private String ivLineSep;
    private StringBuffer ivTimeBuffer = new StringBuffer();
    private StringBuffer ivNormalizeBuffer = new StringBuffer();
    ByteArrayOutputStream ivBaos = null;
    PrintStream ivPs = null;
    private boolean ivOutputXML = false;
    private Locale ivLocale;

    ExtendedTraceLogger(OutputStream outputStream) {
        this(outputStream, false, Locale.getDefault());
    }

    ExtendedTraceLogger(OutputStream outputStream, boolean bl, Locale locale) {
        super(outputStream);
        this.constructorHelper(outputStream, bl, locale);
        this.ivBaos = new ByteArrayOutputStream();
        this.ivPs = new PrintStream(this.ivBaos);
    }

    ExtendedTraceLogger(OutputStream outputStream, boolean bl, Locale locale, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
        this.constructorHelper(outputStream, bl, locale);
        this.ivBaos = new ByteArrayOutputStream();
        this.ivPs = new PrintStream((OutputStream)this.ivBaos, false, string);
        this.ivCharEncoding = string;
    }

    private void constructorHelper(OutputStream outputStream, boolean bl, Locale locale) {
        this.ivOutputXML = bl;
        this.ivLocale = locale;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMaximumIntegerDigits(6);
        this.numberFormat.setMinimumIntegerDigits(6);
        this.ivFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.ivLineSep = RasHelper.getSystemProperty("line.separator");
        if (this.ivOutputXML) {
            this.manufacturerLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_MANUFAC", this.ivLocale, "Manufacturer");
            this.productLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRODUCT", this.ivLocale, "Product");
            this.versionLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_VERSION", this.ivLocale, "Version");
            this.compIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_COMPID", this.ivLocale, "ComponentId");
            this.processIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PROCESSID", this.ivLocale, "ProcessId");
            this.threadIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADID", this.ivLocale, "ThreadId");
            this.threadNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADNAME", this.ivLocale, "ThreadName");
            this.sourceIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SOURCEID", this.ivLocale, "SourceId");
            this.classNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CLASSNAME", this.ivLocale, "ClassName");
            this.methodNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_METHODNAME", this.ivLocale, "MethodName");
            this.serverNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SERVNAME", this.ivLocale, "ServerName");
            this.timeStampLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_TIMESTMP", this.ivLocale, "TimeStamp");
            this.uowLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_UOW", this.ivLocale, "UnitOfWork");
            this.severityLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SEVERITY", this.ivLocale, "Severity");
            this.categoryLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CATEGORY", this.ivLocale, "Category");
            this.primMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRIMMSG", this.ivLocale, "PrimaryMessage");
            this.extMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_EXTMSG", this.ivLocale, "ExtendedMessage");
        } else {
            this.manufacturerLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_MANUFAC", this.ivLocale, "Manufacturer") + ":\t ";
            this.productLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRODUCT", this.ivLocale, "Product") + ":\t ";
            this.versionLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_VERSION", this.ivLocale, "Version") + ":\t ";
            this.compIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_COMPID", this.ivLocale, "ComponentId") + ":\t ";
            this.processIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PROCESSID", this.ivLocale, "ProcessId") + ":\t ";
            this.threadIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADID", this.ivLocale, "ThreadId") + ":\t ";
            this.threadNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_THREADNAME", this.ivLocale, "ThreadName") + ":\t ";
            this.sourceIDLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SOURCEID", this.ivLocale, "SourceId") + ":\t ";
            this.classNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CLASSNAME", this.ivLocale, "ClassName") + ":\t ";
            this.methodNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_METHODNAME", this.ivLocale, "MethodName") + ":\t ";
            this.serverNameLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SERVNAME", this.ivLocale, "ServerName") + ":\t ";
            this.timeStampLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_TIMESTMP", this.ivLocale, "TimeStamp") + ":\t ";
            this.uowLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_UOW", this.ivLocale, "UnitOfWork") + ":\t ";
            this.severityLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_SEVERITY", this.ivLocale, "Severity") + ":\t ";
            this.categoryLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_CATEGORY", this.ivLocale, "Category") + ":\t ";
            this.primMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_PRIMMSG", this.ivLocale, "PrimaryMessage") + ":\t ";
            this.extMessageLabel = TraceNLS.getStringFromBundle(svBundle, "TAG_EXTMSG", this.ivLocale, "ExtendedMessage") + ": ";
        }
    }

    void printHeader() {
        String string;
        String string2 = this.ivLocale.getLanguage();
        String string3 = this.ivLocale.getCountry();
        String string4 = string = this.ivCharEncoding == null ? RasHelper.getSystemProperty("file.encoding") : this.ivCharEncoding;
        if (this.ivOutputXML) {
            this.ivOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.ivOut.println("<WASActivityLogFile>");
            this.ivOut.println("<encoding language=\"" + string2 + "_" + string3 + svQuoteSpace + "codeset=\"" + string + svQuote + svXmlEnd);
        } else {
            this.ivOut.println("$LANG = " + string2 + "_" + string3);
            this.ivOut.println("$CODESET = " + string);
        }
    }

    synchronized void printFooter(int n) {
        String string = Integer.toString(n);
        if (this.ivOutputXML) {
            this.ivOut.println("<total records=\"" + string + svQuote + svXmlEnd);
            this.ivOut.println("</WASActivityLogFile>");
        } else {
            this.ivOut.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG006", this.ivLocale, new Object[]{string}, "{0} records found and printed."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLog(LogRecord logRecord) {
        if (logRecord == null) {
            return;
        }
        String string = TraceLogFormatter.formatMessage(logRecord, this.ivLocale, 1);
        ExtendedTraceLogger extendedTraceLogger = this;
        synchronized (extendedTraceLogger) {
            this.ivBaos.reset();
            if (this.ivOutputXML) {
                this.ivPs.println(this.formatMessageInXML(string, logRecord));
            } else {
                this.ivPs.println(this.formatEntryHeader(logRecord));
                this.ivPs.println(this.primMessageLabel + string);
                this.ivPs.println(this.formatEntryTrailer(logRecord));
            }
            this.ivPs.flush();
            try {
                this.ivOs.write(this.ivBaos.toByteArray());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    synchronized void logSystemStream(LogRecord logRecord) {
    }

    private String formatEntryHeader(LogRecord logRecord) {
        long l;
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
        String string = emptyString;
        String string2 = emptyString;
        String string3 = emptyString;
        String string4 = "000000";
        String string5 = emptyString;
        String string6 = emptyString;
        String string7 = emptyString;
        String string8 = emptyString;
        String string9 = emptyString;
        String string10 = emptyString;
        String string11 = emptyString;
        String string12 = emptyString;
        String string13 = logRecord.getSourceClassName();
        if (string13 != null) {
            string12 = string13;
        }
        if ((string13 = logRecord.getSourceMethodName()) != null) {
            string = string13;
        }
        if ((string13 = logRecord.getLoggerName()) != null) {
            string3 = string13;
        }
        if (wsLogRecord != null) {
            string13 = wsLogRecord.getCorrelationId();
            if (string13 != null) {
                string2 = string13;
            }
            if ((string13 = wsLogRecord.getComponent()) != null) {
                string5 = string13;
            }
            if ((string13 = wsLogRecord.getOrganization()) != null) {
                string6 = string13;
            }
            if ((string13 = wsLogRecord.getProduct()) != null) {
                string7 = string13;
            }
            if ((string13 = wsLogRecord.getVersion()) != null) {
                string8 = string13;
            }
            if ((string13 = wsLogRecord.getProcessName()) != null) {
                string9 = string13;
            }
            if ((string13 = wsLogRecord.getProcessId()) != null) {
                string10 = string13;
            }
            if ((string13 = wsLogRecord.getReporterOrSourceThreadName()) != null) {
                string11 = string13;
            }
        }
        if ((l = logRecord.getMillis()) == this.previousTimestamp) {
            ++this.paddingCounter;
            string4 = this.numberFormat.format(this.paddingCounter);
        } else {
            this.previousTimestamp = l;
            this.paddingCounter = 0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("---------------------------------------------------------------");
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.compIDLabel);
        stringBuffer.append(string5);
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.processIDLabel);
        stringBuffer.append(string10);
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.threadIDLabel);
        stringBuffer.append(RasHelper.getThreadId(logRecord));
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.threadNameLabel);
        stringBuffer.append(string11);
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.sourceIDLabel);
        stringBuffer.append(string3);
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.classNameLabel);
        stringBuffer.append(string12);
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.methodNameLabel);
        stringBuffer.append(string);
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.manufacturerLabel);
        stringBuffer.append(string6);
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.productLabel);
        stringBuffer.append(string7);
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.versionLabel);
        stringBuffer.append(string8);
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.serverNameLabel);
        stringBuffer.append(string9);
        stringBuffer.append(this.ivLineSep);
        this.ivDate.setTime(l);
        this.ivTimeBuffer.setLength(0);
        this.ivTimeBuffer = this.ivFormatter.format(this.ivDate, this.ivTimeBuffer, this.ivFieldPos);
        stringBuffer.append(this.timeStampLabel);
        stringBuffer.append(this.ivTimeBuffer.toString() + string4);
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.uowLabel);
        stringBuffer.append(string2);
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.severityLabel);
        stringBuffer.append(ExtendedTraceLogger.getSeverity(logRecord.getLevel()));
        stringBuffer.append(this.ivLineSep);
        stringBuffer.append(this.categoryLabel);
        stringBuffer.append(logRecord.getLevel().getName());
        return stringBuffer.toString();
    }

    private String formatEntryTrailer(LogRecord logRecord) {
        String string;
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
        String string2 = emptyString;
        if (wsLogRecord != null && (string = wsLogRecord.getStackTrace()) != null) {
            string2 = string;
        }
        return this.extMessageLabel + string2;
    }

    private String formatMessageInXML(String string, LogRecord logRecord) {
        long l;
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
        String string2 = emptyString;
        String string3 = emptyString;
        String string4 = emptyString;
        String string5 = "000000";
        String string6 = emptyString;
        String string7 = emptyString;
        String string8 = emptyString;
        String string9 = emptyString;
        String string10 = emptyString;
        String string11 = emptyString;
        String string12 = emptyString;
        String string13 = emptyString;
        String string14 = emptyString;
        string = this.normalize(string);
        String string15 = logRecord.getSourceClassName();
        if (string15 != null) {
            string12 = this.normalize(string15);
        }
        if ((string15 = logRecord.getSourceMethodName()) != null) {
            string2 = this.normalize(string15);
        }
        if ((string15 = logRecord.getLoggerName()) != null) {
            string4 = this.normalize(string15);
        }
        if (wsLogRecord != null) {
            string15 = wsLogRecord.getCorrelationId();
            if (string15 != null) {
                string3 = this.normalize(string15);
            }
            if ((string15 = wsLogRecord.getComponent()) != null) {
                string6 = this.normalize(string15);
            }
            if ((string15 = wsLogRecord.getOrganization()) != null) {
                string7 = this.normalize(string15);
            }
            if ((string15 = wsLogRecord.getProduct()) != null) {
                string8 = this.normalize(string15);
            }
            if ((string15 = wsLogRecord.getVersion()) != null) {
                string9 = this.normalize(string15);
            }
            if ((string15 = wsLogRecord.getProcessName()) != null) {
                string10 = this.normalize(string15);
            }
            if ((string15 = wsLogRecord.getProcessId()) != null) {
                string11 = this.normalize(string15);
            }
            if ((string15 = wsLogRecord.getStackTrace()) != null) {
                string13 = this.normalize(string15);
            }
            if ((string15 = wsLogRecord.getReporterOrSourceThreadName()) != null) {
                string14 = this.normalize(string15);
            }
        }
        if ((l = logRecord.getMillis()) == this.previousTimestamp) {
            ++this.paddingCounter;
            string5 = this.numberFormat.format(this.paddingCounter);
        } else {
            this.previousTimestamp = l;
            this.paddingCounter = 0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<WASActivityLogEntry");
        stringBuffer.append(svSpace);
        stringBuffer.append(this.compIDLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string6);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.processIDLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string11);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.threadIDLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(RasHelper.getThreadId(logRecord));
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.threadNameLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string14);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.sourceIDLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string4);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.classNameLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string12);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.methodNameLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string2);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.manufacturerLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string7);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.productLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string8);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.versionLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string9);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.serverNameLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string10);
        stringBuffer.append(svQuoteSpace);
        this.ivDate.setTime(l);
        this.ivTimeBuffer.setLength(0);
        this.ivTimeBuffer = this.ivFormatter.format(this.ivDate, this.ivTimeBuffer, this.ivFieldPos);
        stringBuffer.append(this.timeStampLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(this.ivTimeBuffer.toString() + string5);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.uowLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string3);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.severityLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(ExtendedTraceLogger.getSeverity(logRecord.getLevel()));
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.categoryLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(logRecord.getLevel().getName());
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.primMessageLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string);
        stringBuffer.append(svQuoteSpace);
        stringBuffer.append(this.extMessageLabel);
        stringBuffer.append(svEqualsQuote);
        stringBuffer.append(string13);
        stringBuffer.append(svQuote);
        stringBuffer.append(svXmlEnd);
        return stringBuffer.toString();
    }

    private String normalize(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        this.ivNormalizeBuffer.setLength(0);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                this.ivNormalizeBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                this.ivNormalizeBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                this.ivNormalizeBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                this.ivNormalizeBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                this.ivNormalizeBuffer.append("&apos;");
                continue;
            }
            if (c == '\t') {
                this.ivNormalizeBuffer.append("&#x9;");
                continue;
            }
            if (c == '\n') {
                this.ivNormalizeBuffer.append("&#xA;");
                continue;
            }
            if (c == '\r') {
                this.ivNormalizeBuffer.append("&#xD;");
                continue;
            }
            this.ivNormalizeBuffer.append(c);
        }
        return this.ivNormalizeBuffer.toString();
    }

    private static int getSeverity(Level level) {
        int n = level.intValue();
        int n2 = n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[13]] ? 1 : (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[12]] ? 2 : 3);
        return n2;
    }
}

