/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.MessageDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.zip.InflaterInputStream;

public class ByteBufferParser {
    private static final int EYE_CATCHER_VALUE = -1430532899;
    static final int SERVICE_RC_SIZE = 20;
    private int eofStream;
    private int isLogStreamOpen = 1;
    private int messageReturnCode;
    private int messageReasonCode;
    private byte[] service = new byte[20];
    private int remDropped;
    private long endTime;
    private int msgCount;
    MessageDataObject[] mdObject = null;

    public int getEofStream() {
        return this.eofStream;
    }

    public void setEofStream(int n) {
        this.eofStream = n;
    }

    public int getIsLogStreamOpen() {
        return this.isLogStreamOpen;
    }

    public void setIsLogStreamOpen(int n) {
        this.isLogStreamOpen = n;
    }

    public int getMessageReturnCode() {
        return this.messageReturnCode;
    }

    public void setMessageReturnCode(int n) {
        this.messageReturnCode = n;
    }

    public int getMessageReasonCode() {
        return this.messageReasonCode;
    }

    public void setMessageReasonCode(int n) {
        this.messageReasonCode = n;
    }

    public byte[] getService() {
        return this.service;
    }

    public void setService(byte[] byArray) {
        this.service = byArray;
    }

    public int getRemDropped() {
        return this.remDropped;
    }

    public void setRemDropped(int n) {
        this.remDropped = n;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public int getMsgCount() {
        return this.msgCount;
    }

    public void setMsgCount(int n) {
        this.msgCount = n;
    }

    public MessageDataObject[] parseByteBuffer(ByteBuffer byteBuffer) throws BufferUnderflowException {
        try {
            this.messageReturnCode = byteBuffer.getInt();
            this.messageReasonCode = byteBuffer.getInt();
            this.eofStream = byteBuffer.getInt();
            byte[] byArray = new byte[20];
            byteBuffer.get(byArray);
            this.service = byArray;
            this.remDropped = byteBuffer.getInt();
            this.msgCount = byteBuffer.getInt();
            this.mdObject = new MessageDataObject[this.msgCount];
            int n = 0;
            for (int i = 0; i < this.msgCount; ++i) {
                this.mdObject[i] = new MessageDataObject();
                this.mdObject[i].setDropCounts(byteBuffer.getInt());
                n = byteBuffer.getInt();
                byte[] byArray2 = new byte[n - 8];
                long l = byteBuffer.getLong();
                this.mdObject[i].setMsgTimeStamps(l);
                boolean bl = false;
                if (-1430532899 != byteBuffer.getInt()) {
                    // empty if block
                }
                int n2 = byteBuffer.getInt();
                byteBuffer.get(byArray2, 0, n - 8);
                byteBuffer.get();
                if (n2 == 1) {
                    bl = true;
                    this.mdObject[i].setEBCDIC(false);
                } else {
                    bl = false;
                    this.mdObject[i].setEBCDIC(true);
                }
                if (bl) {
                    try {
                        byArray2 = ByteBufferParser.unzip(byArray2);
                        n = byArray2.length;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.mdObject[i].setMsgLen(n);
                this.mdObject[i].setMsg(byArray2);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            bufferUnderflowException.printStackTrace();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return this.mdObject;
    }

    private static byte[] unzip(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        int n2 = 1024;
        int n3 = 0;
        byte[] byArray2 = new byte[1024];
        while (n3 >= 0) {
            n3 = inflaterInputStream.read(byArray2, 0, 1024);
            if (n3 <= 0) continue;
            byteArrayOutputStream.write(byArray2, 0, n3);
            n += n3;
            n2 -= n3;
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }
}

