/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.services.redirector;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.services.redirector.Redirector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;

public class RedirectorController {
    protected Hashtable connections = new Hashtable();
    private static final String thisClassName = RedirectorController.class.getName();
    private long timeStamp;
    private int maxOpenSockets;
    private int requestTimeoutMillis = 0;
    private long staleSocketThreshold = 300L;
    private static final long connectionTableCleanupIntervalMins = 5L;
    private static final long connectionTableCleanupIntervalMillis = 300000L;
    private boolean cleanupInProgress = false;
    private long timeLastCleaned = 0L;
    private Random rand = null;

    public RedirectorController() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "RedirectorController()");
        }
        this.timeStamp = System.currentTimeMillis();
        this.rand = new Random(this.timeStamp);
        this.timeLastCleaned = this.timeStamp;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "RedirectorController()");
        }
    }

    public synchronized Redirector getRedirector(String string, int n) throws IOException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "getRedirector (" + string + "," + n + ")");
        }
        Redirector redirector = null;
        for (long i = 0L; i < (long)this.maxOpenSockets && redirector == null; ++i) {
            redirector = (Redirector)this.connections.get(Redirector.buildID(string, n, i));
            if (redirector == null) {
                redirector = new Redirector(string, n, i, this);
                this.connections.put(Redirector.buildID(string, n, i), redirector);
                continue;
            }
            if (!redirector.busy) continue;
            redirector = null;
        }
        if (redirector == null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getRedirector", "All connections are in use for " + string + ":" + n + ".  Opening a new temporary connection.");
            }
            this.timeStamp = System.currentTimeMillis();
            String string2 = Redirector.buildID(string, n, this.timeStamp);
            while (this.connections.get(string2) != null) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "getRedirector", "timeStamp " + this.timeStamp + " is in use for " + string + ":" + n + ".  Regenerating.");
                }
                this.timeStamp = this.timeStamp / (long)this.rand.nextInt() + (long)this.rand.nextInt();
                if (this.timeStamp < 0L) {
                    this.timeStamp *= -1L;
                }
                string2 = Redirector.buildID(string, n, this.timeStamp);
            }
            redirector = new Redirector(string, n, this.timeStamp, this);
            this.connections.put(string2, redirector);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "getRedirector(), returning " + redirector.getID());
        }
        return redirector;
    }

    public synchronized Redirector getRedirector(String string) {
        Redirector redirector = (Redirector)this.connections.get(string);
        return redirector;
    }

    public synchronized void addRedirector(String string, Redirector redirector) {
        this.connections.put(string, redirector);
    }

    public synchronized void removeRedirector(String string) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "removeRedirector(" + string + ")");
        }
        Redirector redirector = (Redirector)this.connections.remove(string);
        redirector.terminateServerConnection();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "removeRedirector()");
        }
    }

    public synchronized void cleanupConnectionTable() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(2064L, thisClassName, "cleanupConnectionTable()");
        }
        Redirector redirector = null;
        Enumeration enumeration = this.connections.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            redirector = (Redirector)enumeration.nextElement();
            if (redirector.busy) continue;
            try {
                bl = redirector.cleanupStaleConnection();
                if (!bl) continue;
                this.connections.remove(redirector.getID());
            }
            catch (Exception exception) {}
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(2064L, thisClassName, "cleanupConnectionTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConnectionTable() {
        if (this.cleanupInProgress) {
            return;
        }
        long l = this.checkDeltaTime(this.timeLastCleaned, 300000L);
        if (l > 0L) {
            RedirectorController redirectorController = this;
            synchronized (redirectorController) {
                this.cleanupInProgress = true;
                if (l < this.timeLastCleaned) {
                    this.cleanupInProgress = false;
                    return;
                }
                this.timeLastCleaned = System.currentTimeMillis();
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, (Object)this, "checkConnectionTable", "More than 5 minutes has elapsed since the last HTTP Tunnel connection table cleanup.  Cleanup starting...");
                }
                try {
                    this.cleanupConnectionTable();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.cleanupInProgress = false;
            }
        }
    }

    public void setMaxOpenSockets(int n) {
        this.maxOpenSockets = n;
    }

    public int maxOpenSockets() {
        return this.maxOpenSockets;
    }

    public void setRequestTimeout(int n) {
        this.requestTimeoutMillis = n;
    }

    public int getRequestTimeout() {
        return this.requestTimeoutMillis;
    }

    public long getStaleSocketThreshold() {
        return this.staleSocketThreshold;
    }

    public long checkDeltaTime(long l, long l2) {
        long l3 = System.currentTimeMillis();
        if (l3 - l >= l2) {
            return l3;
        }
        return 0L;
    }
}

