/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.util.BuildLevel;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.Utility;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;

public class Version {
    private static final String CLASS = Version.class.getName();
    public static final String PROJECT_NAME = "IBM Java ORB";
    public static final String BUILD = BuildLevel.getValue();
    public static final String FULL = "IBM Java ORB build " + BUILD + " (SR2)";
    public static final String CFW_VERSION = "IBM CFW level " + com.ibm.ws.channel.framework.Version.versionString;
    public static final String PARTNER_VERSION = Integer.toHexString(Version.getVersionMajor()) + ":" + Version.getVersionMinor();
    public static final String MAIN = FULL + " version " + PARTNER_VERSION;
    private static final String sdkFullVersion = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            String string = System.getProperty("java.fullversion");
            if (string != null) {
                string = string.replaceAll("\r?\n", Utility.LINE_SEP);
            }
            return string;
        }
    });
    private static final String sdkVersion = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("java.version");
        }
    });
    private static final int sdkMajor;
    private static final int sdkMinor;
    private static final int sdkRev;
    private static final int sdkRel;

    public static String asString() {
        return FULL;
    }

    public static String getBuildLevel() {
        return BUILD;
    }

    public static short getVersionMajor() {
        return PartnerVersionUtil.getORB_MAJOR();
    }

    public static short getVersionMinor() {
        return PartnerVersionUtil.getORB_MINOR();
    }

    public static boolean sdkVersionLowerThan(int n, int n2, int n3) {
        return sdkMajor < n || sdkMajor == n && (sdkMinor < n2 || sdkMinor == n2 && sdkRev < n3);
    }

    public static boolean sdkVersionHigherThan(int n, int n2, int n3) {
        return sdkMajor > n || sdkMajor == n && (sdkMinor > n2 || sdkMinor == n2 && sdkRev > n3);
    }

    public static void logVersions() {
        Trc.info(FULL, CLASS, "logVersions:163");
        Trc.info(CFW_VERSION, CLASS, "logVersions:165");
        Trc.info(sdkFullVersion, CLASS, "logVersions:167");
        Trc.info("SDK major=", Trc.str(sdkMajor), ", minor=", Trc.str(sdkMinor), ", revision=", Trc.str(sdkRev), ", release=", Trc.str(sdkRel), CLASS, "logVersions:171");
    }

    public static void checkVersions() {
        String string = "";
        short s = Version.getVersionMajor();
        short s2 = Version.getVersionMinor();
        try {
            string = "Cannot use ORB '" + BUILD + "' with JDK '" + sdkVersion + "'";
            if (PartnerVersionUtil.isORB14OrGreater(s, s2)) {
                if (Version.sdkVersionLowerThan(1, 4, 0)) {
                    System.err.println(string);
                    throw new IllegalStateException(string);
                }
            } else if (!Version.sdkVersionLowerThan(1, 4, 0)) {
                System.err.println(string);
                throw new IllegalStateException(string);
            }
        }
        catch (IllegalStateException illegalStateException) {
            Trc.ffdc(illegalStateException, CLASS, "checkVersions:201");
            throw new INITIALIZE(illegalStateException.toString(), 1229124869, CompletionStatus.COMPLETED_NO);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(MAIN);
    }

    static {
        Pattern pattern = Pattern.compile("(\\d+)(?:\\D+(\\d+)(?:\\D+(\\d+)(?:\\D+(\\d+))?)?)?.*");
        Matcher matcher = pattern.matcher(sdkVersion);
        if (!matcher.matches()) {
            throw new IllegalStateException("Unable to parse java.version: '" + sdkVersion + "' - expected format: " + "'major[.minor[.revision[.release]]]'");
        }
        sdkMajor = Integer.parseInt(matcher.group(1));
        sdkMinor = matcher.group(2) == null ? 0 : Integer.parseInt(matcher.group(2));
        sdkRev = matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3));
        sdkRel = matcher.group(4) == null ? 0 : Integer.parseInt(matcher.group(4));
    }
}

