/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class SourcedProperties
extends Properties {
    public static final String SPI_SETTER = "SPI setter method";
    public static final String DEFAULT_ERROR = "Default (following error)";
    public static final String DEFAULT = "Default (no value specified)";
    public static final String INTERNAL = "Set internally";
    public static final String SYSTEM = "System properties";
    public static final String APPLET_PARAM = "Applet parameter";
    public static final String INIT = "ORB.init";
    public static final String ARGS = "Command line args";
    public static final String UNKNOWN = "[unknown]";
    private final Properties src = new Properties();
    private final Set unusedProps = new TreeSet();
    private String currentSource = "[unknown]";
    private String latestSource = null;

    public SourcedProperties() {
    }

    public SourcedProperties(Properties properties, String string) {
        this();
        this.putAll(properties, string);
        this.unusedProps.addAll(properties.keySet());
    }

    public Object setProperty(String string, String string2, String string3) {
        return this.put(string, string2, string3);
    }

    public Object put(Object object, Object object2, String string) {
        if (!this.containsKey(object)) {
            this.unusedProps.add(object);
        }
        Object object3 = super.put(object, object2);
        this.src.put(object, string);
        return object3;
    }

    public Object setProperty(String string, String string2) {
        return this.setProperty(string, string2, this.currentSource);
    }

    public Object put(Object object, Object object2) {
        return this.put(object, object2, this.currentSource);
    }

    public String getProperty(String string) {
        this.unusedProps.remove(string);
        this.latestSource = this.src.getProperty(string);
        return super.getProperty(string);
    }

    public Object get(Object object) {
        this.unusedProps.remove(object);
        this.latestSource = (String)this.src.get(object);
        return super.get(object);
    }

    public Set getUnusedProperties() {
        return this.unusedProps;
    }

    public void setDynamicProperty(String string) {
        this.unusedProps.remove(string);
    }

    public void setDefaultSource(String string) {
        this.currentSource = string == null ? UNKNOWN : string;
    }

    public void putAll(Map map) {
        this.putAll(map, this.currentSource);
    }

    private void putAll(Map map, String string) {
        this.unusedProps.addAll(map.keySet());
        super.putAll((Map<?, ?>)map);
        for (String string2 : map.keySet()) {
            this.src.setProperty(string2, string);
        }
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this);
        return properties;
    }

    public String getSource(String string) {
        return this.src.getProperty(string);
    }

    public String getLatestSource() {
        return this.latestSource;
    }

    public void load(InputStream inputStream, String string) throws IOException {
        Properties properties = new Properties();
        String string2 = "File: " + string;
        properties.load(inputStream);
        this.putAll(properties, string2);
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(inputStream, this.currentSource);
    }
}

