/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.map.DataValueListEntry;
import com.ibm.jtc.orb.map.Value;
import com.ibm.jtc.orb.map.WeakDataValueListEntry;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.util.ClassInfo;
import com.ibm.rmi.util.IdentityHashtable;
import com.ibm.rmi.util.JDKBridge;
import com.ibm.rmi.util.RepositoryIdCache;
import com.ibm.rmi.util.Utility;
import com.ibm.rmi.util.Version;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.rmi.CORBA.ClassDesc;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ValueBase;

public class RepositoryId {
    private static final String CLASS = RepositoryId.class.getName();
    private static final int[] charConversion = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final String IDL_IDENTIFIER_CHARS = ".0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ\\_abcdefghijklmnopqrstuvwxyz";
    private static final boolean[] IS_VALID_IDL_IDENTIFIER_CHAR = new boolean[128];
    private static final Pattern UNICODE_ESCAPES_WITHOUT_DOLLAR;
    private static final long serialVersionUID = 123456789L;
    private static final String defaultServerURL;
    private static Map classToRepStr;
    private static Map classIDLToRepStr;
    private static Map classSeqToRepStr;
    private static Map classToCustomRepStr;
    private static IdentityHashtable repStrToByteArray;
    private static Hashtable repStrToClass;
    private String repId = null;
    private boolean isSupportedFormat = true;
    private String typeString = null;
    private String versionString = null;
    private boolean isSequence = false;
    private boolean isRMIValueType = false;
    private boolean isIDLType = false;
    private boolean isProxy = false;
    private String completeClassName = null;
    private String unqualifiedName = null;
    private String definedInId = null;
    private Class clazz = null;
    private String suid = null;
    private String rmiHashCode = null;
    private static final String kSequenceKeyword = "seq";
    private static final String kValuePrefix = "RMI:";
    private static final String kIDLPrefix = "IDL:";
    private static final String kIDLNamePrefix = "omg.org/";
    private static final String kIDLClassnamePrefix = "org.omg.";
    private static final String kSequencePrefix = "[";
    private static final String kCORBAPrefix = "CORBA/";
    private static final String kArrayPrefix = "RMI:[CORBA/";
    private static final String kCustomRMIPrefix = "RMI:org.omg.customRMI.";
    private static final int kValuePrefixLength;
    private static final int kIDLPrefixLength;
    private static final int kSequencePrefixLength;
    private static final String kInterfaceHashCode = ":0000000000000000";
    private static final String kInterfaceOnlyHashStr = "0000000000000000";
    private static final String kExternalizableHashStr = "0000000000000001";
    public static final int kInitialValueTag = 0x7FFFFF00;
    public static final int kNoTypeInfo = 0;
    public static final int kSingleRepTypeInfo = 2;
    public static final int kPartialListTypeInfo = 6;
    public static final int kChunkedMask = 8;
    public static final int kPreComputed_StandardRMIUnchunked;
    public static final int kPreComputed_CodeBaseRMIUnchunked;
    public static final int kPreComputed_StandardRMIChunked;
    public static final int kPreComputed_CodeBaseRMIChunked;
    public static final int kPreComputed_StandardRMIUnchunked_NoRep;
    public static final int kPreComputed_CodeBaseRMIUnchunked_NoRep;
    public static final int kPreComputed_StandardRMIChunked_NoRep;
    public static final int kPreComputed_CodeBaseRMIChunked_NoRep;
    public static final String kWStringValueVersion = "1.0";
    public static final String kWStringValueHash = ":1.0";
    public static final String kWStringStubValue = "WStringValue";
    public static final String kWStringTypeStr = "omg.org/CORBA/WStringValue";
    public static final String kWStringValueRepID = "IDL:omg.org/CORBA/WStringValue:1.0";
    public static final String kAnyRepID = "IDL:omg.org/CORBA/Any";
    public static final String kClassDescValueHash;
    public static final String kClassDescStubValue = "ClassDesc";
    public static final String kClassDescTypeStr = "javax.rmi.CORBA.ClassDesc";
    public static final String kClassDescValueRepID;
    public static final String kObjectValueHash = ":1.0";
    public static final String kObjectStubValue = "Object";
    public static final String kSequenceValueHash = ":1.0";
    public static final String kPrimitiveSequenceValueHash = ":0000000000000000";
    public static final String kSerializableValueHash = ":1.0";
    public static final String kSerializableStubValue = "Serializable";
    public static final String kExternalizableValueHash = ":1.0";
    public static final String kExternalizableStubValue = "Externalizable";
    public static final String kRemoteValueHash = "";
    public static final String kRemoteStubValue = "";
    public static final String kRemoteTypeStr = "";
    public static final String kRemoteValueRepID = "";
    public static final Hashtable kSpecialCasesClasses;
    private static final byte[] ASCII_HEX;
    public static final RepositoryIdCache cache;
    public static final String kjava_rmi_Remote;
    public static final String korg_omg_CORBA_Object;
    private static final Class[] kNoParamTypes;
    private static final java.lang.Object[] kNoArgs;
    private static final boolean preJDK50;
    private static final HashMap primeClasses;

    RepositoryId() {
    }

    RepositoryId(String string) {
        this.init(string);
    }

    private void init(String string) {
        this.repId = string;
        Trc.info(Trc.str(string), CLASS, "init:380");
        if (string.length() == 0) {
            this.clazz = Remote.class;
            this.typeString = "";
            this.isRMIValueType = true;
            this.suid = kInterfaceOnlyHashStr;
        } else if (string.equals(kWStringValueRepID)) {
            this.clazz = String.class;
            this.typeString = kWStringTypeStr;
            this.isIDLType = true;
            this.completeClassName = "java.lang.String";
            this.versionString = ":1.0";
        } else {
            String string2 = RepositoryId.convertFromISOLatin1(string);
            this.versionString = string2.substring(string2.indexOf(58, string2.indexOf(58) + 1));
            if (string2.startsWith(kIDLPrefix)) {
                this.typeString = string2.substring(kIDLPrefixLength, string2.indexOf(58, kIDLPrefixLength));
                this.isIDLType = true;
                this.completeClassName = this.typeString.startsWith(kIDLNamePrefix) ? kIDLClassnamePrefix + this.typeString.substring(kIDLNamePrefix.length()).replace('/', '.') : this.typeString.replace('/', '.');
                this.clazz = (Class)kSpecialCasesClasses.get(this.completeClassName);
            } else if (string2.startsWith(kValuePrefix)) {
                this.typeString = string2.substring(kValuePrefixLength, string2.indexOf(58, kValuePrefixLength));
                if (this.typeString.startsWith("$Proxy")) {
                    this.isProxy = true;
                }
                this.isRMIValueType = true;
                this.clazz = (Class)kSpecialCasesClasses.get(this.typeString);
                if (this.versionString.indexOf(46) == -1) {
                    this.suid = this.rmiHashCode = this.versionString.substring(1);
                    if (this.rmiHashCode.indexOf(58) != -1) {
                        int n = this.rmiHashCode.indexOf(58) + 1;
                        this.suid = this.rmiHashCode.substring(n);
                        this.rmiHashCode = this.rmiHashCode.substring(0, n - 1);
                    }
                    if (this.suid.length() < 16) {
                        Trc.info("Non-compliant RepId, SUID is not 16 digits", " long, hence padding it with 0", CLASS, "init:440");
                    }
                    while (this.suid.length() < 16) {
                        this.suid = "0" + this.suid;
                    }
                }
            } else {
                this.isSupportedFormat = false;
            }
            if (this.typeString.startsWith(kSequencePrefix)) {
                this.isSequence = true;
            }
        }
    }

    public final String getUnqualifiedName() {
        if (this.unqualifiedName == null) {
            String string = this.getClassName();
            int n = string.lastIndexOf(46);
            if (n == -1) {
                this.unqualifiedName = string;
                this.definedInId = "IDL::1.0";
            } else {
                this.unqualifiedName = string.substring(n);
                this.definedInId = kIDLPrefix + string.substring(0, n).replace('.', '/') + ":1.0";
            }
        }
        return this.unqualifiedName;
    }

    public final String getDefinedInId() {
        if (this.definedInId == null) {
            this.getUnqualifiedName();
        }
        return this.definedInId;
    }

    public final String getTypeString() {
        return this.typeString;
    }

    public final String getVersionString() {
        return this.versionString;
    }

    public final String getSerialVersionUID() {
        return this.suid;
    }

    public final boolean isRMIValueType() {
        return this.isRMIValueType;
    }

    public final boolean isIDLType() {
        return this.isIDLType;
    }

    public final boolean isProxy() {
        return this.isProxy;
    }

    public final String getRepositoryId() {
        return this.repId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getByteArray(String string) {
        IdentityHashtable identityHashtable = repStrToByteArray;
        synchronized (identityHashtable) {
            return (byte[])repStrToByteArray.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setByteArray(String string, byte[] byArray) {
        IdentityHashtable identityHashtable = repStrToByteArray;
        synchronized (identityHashtable) {
            repStrToByteArray.put(string, byArray);
        }
    }

    public final boolean isSequence() {
        return this.isSequence;
    }

    public final boolean isSupportedFormat() {
        return this.isSupportedFormat;
    }

    public final String getClassName() {
        if (this.isRMIValueType) {
            return this.typeString;
        }
        if (this.isIDLType) {
            return this.completeClassName;
        }
        return null;
    }

    public final Class getClassFromRepId() throws ClassNotFoundException {
        if (this.clazz != null) {
            return this.clazz;
        }
        Class clazz = (Class)repStrToClass.get(this.repId);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.getClassFromType();
        String string = RepositoryId.createForJavaType(clazz, false);
        if (!this.repId.equals(string)) {
            throw new ClassNotFoundException("Unknown repId " + this.repId);
        }
        return clazz;
    }

    public final Class getClassFromType() throws ClassNotFoundException {
        if (this.clazz != null) {
            return this.clazz;
        }
        return this.checkClassCache(defaultServerURL, null);
    }

    public final Class getClassFromType(Class clazz, String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (this.clazz != null && (clazz == null || clazz.isAssignableFrom(this.clazz))) {
            return this.clazz;
        }
        Class clazz2 = this.checkClassCache(string, classLoader);
        if (clazz != null && clazz2 != null && !clazz.isAssignableFrom(clazz2)) {
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz2);
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, CLASS, "getClassFromType:618", clazz2.getName() + " hasReadResolve=" + objectStreamClass.hasReadResolve() + ", CL:" + clazz2.getClassLoader() + " and is not assignable to:" + clazz.getName() + ", CL:" + clazz.getClassLoader());
            }
            if (!objectStreamClass.hasReadResolve()) {
                throw new ClassNotFoundException(clazz2.getName() + " has no readResolve and is not assignable to:" + clazz.getName());
            }
        }
        return clazz2;
    }

    public final Class getClassFromType(String string, ClassLoader classLoader) throws ClassNotFoundException {
        return this.checkClassCache(string, classLoader);
    }

    private Class checkClassCache(String string, ClassLoader classLoader) throws ClassNotFoundException {
        String string2 = this.getClassName();
        Class clazz = (Class)primeClasses.get(string2);
        if (clazz == null) {
            clazz = ClassNameToClassCache.get(string2, string, classLoader, this);
        }
        return clazz;
    }

    private Class loadClass(final String string, final ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz;
        if (preJDK50) {
            try {
                clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws ClassNotFoundException {
                        return Utility.loadClassOfType(RepositoryId.this.getClassName(), string, null, null, null, classLoader);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (ClassNotFoundException)privilegedActionException.getException();
            }
        } else {
            clazz = Utility.loadClassOfType(this.getClassName(), string, null, null, null, classLoader);
        }
        return clazz;
    }

    public final String toString() {
        return this.repId;
    }

    public static boolean useFullValueDescription(Class clazz, String string, boolean bl) throws IOException {
        String string2 = RepositoryId.createForAnyType(clazz, bl);
        if (string2.equals(string)) {
            return false;
        }
        RepositoryId repositoryId = cache.getId(string);
        RepositoryId repositoryId2 = bl ? new RepositoryId(string2) : cache.getId(string2);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (repositoryId.isRMIValueType() && repositoryId2.isRMIValueType()) {
            if (!repositoryId.getSerialVersionUID().equals(repositoryId2.getSerialVersionUID())) {
                if (repositoryId2.isProxy() || repositoryId.isProxy()) {
                    return false;
                }
                throw new IOException("Mismatched serialization UIDs : Source (RepId " + repositoryId2 + ") = " + repositoryId2.getSerialVersionUID() + " whereas Target (RepId " + string + ") = " + repositoryId.getSerialVersionUID());
            }
            return true;
        }
        throw new IOException("The RepId is not of an RMI value type (Expected RepId = " + string2 + "; Received RepId = " + string + ")");
    }

    private static String createHashString(Serializable serializable, boolean bl) {
        return RepositoryId.createHashString(serializable.getClass(), bl);
    }

    private static String createHashString(Class clazz, boolean bl) {
        if (clazz.isInterface() || !Serializable.class.isAssignableFrom(clazz)) {
            return ":0000000000000000";
        }
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        long l = objectStreamClass.getRMIHashCode(bl);
        String string = null;
        string = l == 0L ? kInterfaceOnlyHashStr : (l == 1L ? kExternalizableHashStr : Long.toHexString(l).toUpperCase());
        while (string.length() < 16) {
            string = "0" + string;
        }
        long l2 = objectStreamClass.getSerialVersionUID(bl);
        String string2 = null;
        string2 = l2 == 0L ? kInterfaceOnlyHashStr : (l2 == 1L ? kExternalizableHashStr : Long.toHexString(l2).toUpperCase());
        while (string2.length() < 16) {
            string2 = "0" + string2;
        }
        return ":" + string + ":" + string2;
    }

    public static String createSequenceRepID(java.lang.Object object) {
        return RepositoryId.createSequenceRepID(object.getClass(), false);
    }

    public static String createSequenceRepID(java.lang.Object object, boolean bl) {
        return RepositoryId.createSequenceRepID(object.getClass(), bl);
    }

    public static String createSequenceRepID(Class clazz) {
        return RepositoryId.createSequenceRepID(clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createSequenceRepID(Class clazz, boolean bl) {
        Map map = classSeqToRepStr;
        synchronized (map) {
            String string = (String)classSeqToRepStr.get(clazz);
            if (string != null) {
                return string;
            }
            Class<?> clazz2 = clazz;
            Class<?> clazz3 = null;
            int n = 0;
            while ((clazz3 = clazz.getComponentType()) != null) {
                ++n;
                clazz = clazz3;
            }
            if (clazz.isPrimitive()) {
                string = kValuePrefix + clazz2.getName() + ":0000000000000000";
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(kValuePrefix);
                while (n-- > 0) {
                    stringBuffer.append(kSequencePrefix);
                }
                stringBuffer.append("L");
                stringBuffer.append(RepositoryId.convertToISOLatin1(clazz.getName()));
                stringBuffer.append(";");
                stringBuffer.append(RepositoryId.createHashString(clazz, bl));
                string = stringBuffer.toString();
            }
            classSeqToRepStr.put(clazz2, string);
            return string;
        }
    }

    public static String createForSpecialCase(Class clazz) {
        if (clazz.equals(String.class)) {
            return kWStringValueRepID;
        }
        if (clazz.equals(Class.class)) {
            return kClassDescValueRepID;
        }
        if (clazz.equals(Remote.class)) {
            return "";
        }
        if (clazz.isArray()) {
            return RepositoryId.createSequenceRepID(clazz);
        }
        return null;
    }

    public static String createForSpecialCase(Serializable serializable) {
        return RepositoryId.createForSpecialCase(serializable.getClass());
    }

    public static String createForJavaType(Serializable serializable) {
        return RepositoryId.createForJavaType(serializable, false);
    }

    public static String createForJavaType(Serializable serializable, boolean bl) {
        return RepositoryId.createForJavaType(serializable.getClass(), bl);
    }

    public static String createForJavaType(Class clazz) {
        return RepositoryId.createForJavaType(clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createForJavaType(Class clazz, boolean bl) {
        Map map = classToRepStr;
        synchronized (map) {
            String string;
            if (!bl && (string = (String)classToRepStr.get(clazz)) != null) {
                return string;
            }
            string = RepositoryId.createForSpecialCase(clazz);
            if (string == null) {
                string = kValuePrefix + RepositoryId.convertToISOLatin1(clazz.getName()) + RepositoryId.createHashString(clazz, bl);
            }
            if (!bl) {
                classToRepStr.put(clazz, string);
                repStrToClass.put(string, clazz);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createForCustomJavaType(Class clazz) {
        Map map = classToCustomRepStr;
        synchronized (map) {
            String string = (String)classToCustomRepStr.get(clazz);
            if (string == null) {
                String string2 = RepositoryId.createForJavaType(clazz);
                string = kCustomRMIPrefix + string2.substring(4);
                classToCustomRepStr.put(clazz, string);
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createForIDLType(Class clazz, int n, int n2) {
        Map map = classIDLToRepStr;
        synchronized (map) {
            String string = (String)classIDLToRepStr.get(clazz);
            if (string != null) {
                return string;
            }
            string = kIDLPrefix + RepositoryId.convertToISOLatin1(clazz.getName()).replace('.', '/') + ":" + n + "." + n2;
            classIDLToRepStr.put(clazz, string);
            return string;
        }
    }

    private static String getIdFromHelper(Class clazz) {
        try {
            final Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", null, clazz.getClassLoader(), clazz, clazz.getClassLoader());
            Method method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NoSuchMethodException {
                    return clazz2.getMethod("id", kNoParamTypes);
                }
            });
            return (String)method.invoke(null, kNoArgs);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, CLASS, "getIdFromHelper:979", clazz.getName() + "Helper:" + classNotFoundException.toString());
            }
            return null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            ORBRas.orbTrcLogger.exception(4104L, CLASS, "getIdFromHelper:989", exception);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, CLASS, "getIdFromHelper:998", (Exception)throwable);
            } else {
                ORBRas.orbTrcLogger.trace(4104L, CLASS, "getIdFromHelper:1002", clazz.getName() + "Helper.id:", (java.lang.Object)throwable);
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            ORBRas.orbTrcLogger.exception(4104L, CLASS, "getIdFromHelper:1009", (Exception)illegalAccessException);
            return null;
        }
    }

    public static String createForAnyType(Class clazz) {
        return RepositoryId.createForAnyType(clazz, false);
    }

    public static String createForAnyType(Class clazz, boolean bl) {
        if (clazz.isArray()) {
            return RepositoryId.createSequenceRepID(clazz, bl);
        }
        if (IDLEntity.class.isAssignableFrom(clazz)) {
            try {
                String string = RepositoryId.getIdFromHelper(clazz);
                if (string != null) {
                    return string;
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, CLASS, "createForAnyType:1042", exception);
            }
            catch (Error error) {
                ORBRas.orbTrcLogger.trace(4104L, CLASS, "createForAnyType:1046", clazz.getName(), (java.lang.Object)error);
            }
            return RepositoryId.createForIDLType(clazz, 1, 0);
        }
        return RepositoryId.createForJavaType(clazz, bl);
    }

    public static boolean isAbstractBase(Class clazz) {
        return clazz.isInterface() && IDLEntity.class.isAssignableFrom(clazz) && !ValueBase.class.isAssignableFrom(clazz) && !Object.class.isAssignableFrom(clazz);
    }

    public static boolean isAnyRequired(Class clazz) {
        return clazz == java.lang.Object.class || clazz == Serializable.class || clazz == Externalizable.class;
    }

    public static long fromHex(String string) {
        if (string.startsWith("0x")) {
            return Long.valueOf(string.substring(2), 16);
        }
        return Long.valueOf(string, 16);
    }

    public static String escape(String string) {
        if (string.startsWith(kValuePrefix)) {
            int n = string.indexOf(58, 4);
            String string2 = string.substring(4, n);
            String string3 = string.substring(n);
            string2 = RepositoryId.convertToISOLatin1(string2);
            return kValuePrefix + string2 + string3;
        }
        return string;
    }

    public static String unescape(String string) {
        Matcher matcher = UNICODE_ESCAPES_WITHOUT_DOLLAR.matcher(string);
        StringWriter stringWriter = new StringWriter();
        String string2 = "";
        int n = 0;
        while (matcher.find()) {
            stringWriter.write(string, n, matcher.start() - n);
            string2 = matcher.group(1);
            String string3 = string2.substring(2);
            char c = (char)Integer.parseInt(string3, 16);
            stringWriter.append(c);
            n = matcher.end();
        }
        if (n < string.length()) {
            stringWriter.write(string, n, string.length() - n);
        }
        return stringWriter.toString();
    }

    private static String convertToISOLatin1(String string) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u007f' || !IS_VALID_IDL_IDENTIFIER_CHAR[c]) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, i));
                }
                stringBuffer.append("\\U" + (char)ASCII_HEX[(c & 0xF000) >>> 12] + (char)ASCII_HEX[(c & 0xF00) >>> 8] + (char)ASCII_HEX[(c & 0xF0) >>> 4] + (char)ASCII_HEX[c & 0xF]);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        if (stringBuffer != null) {
            string = stringBuffer.toString();
        }
        return string;
    }

    private static String convertFromISOLatin1(String string) {
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((n = stringBuffer.toString().indexOf("\\U")) != -1) {
            int n2;
            String string2 = "0000" + stringBuffer.toString().substring(n + 2, n + 6);
            byte[] byArray = new byte[(string2.length() - 4) / 2];
            int n3 = 0;
            for (n2 = 4; n2 < string2.length(); n2 += 2) {
                byArray[n3] = (byte)(RepositoryId.hexOf(string2.charAt(n2)) << 4 & 0xF0);
                int n4 = n3++;
                byArray[n4] = (byte)(byArray[n4] | (byte)(RepositoryId.hexOf(string2.charAt(n2 + 1)) << 0 & 0xF));
            }
            stringBuffer = new StringBuffer(RepositoryId.delete(stringBuffer.toString(), n, n + 6));
            n2 = (char)(byArray[0] << 8 | byArray[1] & 0xFF);
            stringBuffer.insert(n, (char)n2);
        }
        return stringBuffer.toString();
    }

    private static int hexOf(char c) {
        int n = charConversion[c];
        if (n < 0) {
            throw new Error("Bad hex digit: 0x" + Integer.toHexString(c));
        }
        return n;
    }

    private static String delete(String string, int n, int n2) {
        return string.substring(0, n) + string.substring(n2, string.length());
    }

    public static int computeValueTag(boolean bl, int n, boolean bl2) {
        int n2 = 0x7FFFFF00;
        if (bl) {
            n2 |= 1;
        }
        n2 |= n;
        if (bl2) {
            n2 |= 8;
        }
        return n2;
    }

    public static boolean isCodeBasePresent(int n) {
        return (n & 1) == 1;
    }

    public static int getTypeInfo(int n) {
        return n & 6;
    }

    public static boolean isChunkedEncoding(int n) {
        return (n & 8) != 0;
    }

    public static String getServerURL() {
        return defaultServerURL;
    }

    static {
        char[] cArray = IDL_IDENTIFIER_CHARS.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            RepositoryId.IS_VALID_IDL_IDENTIFIER_CHAR[cArray[i]] = true;
        }
        UNICODE_ESCAPES_WITHOUT_DOLLAR = Pattern.compile("(\\\\U[0-9A-Fa-f]{4}(?<!\\\\U0024))");
        classToRepStr = new WeakHashMap();
        classIDLToRepStr = new WeakHashMap();
        classSeqToRepStr = new WeakHashMap();
        classToCustomRepStr = new WeakHashMap();
        repStrToByteArray = new IdentityHashtable();
        repStrToClass = new Hashtable();
        kValuePrefixLength = kValuePrefix.length();
        kIDLPrefixLength = kIDLPrefix.length();
        kSequencePrefixLength = kSequencePrefix.length();
        kPreComputed_StandardRMIUnchunked = RepositoryId.computeValueTag(false, 2, false);
        kPreComputed_CodeBaseRMIUnchunked = RepositoryId.computeValueTag(true, 2, false);
        kPreComputed_StandardRMIChunked = RepositoryId.computeValueTag(false, 2, true);
        kPreComputed_CodeBaseRMIChunked = RepositoryId.computeValueTag(true, 2, true);
        kPreComputed_StandardRMIUnchunked_NoRep = RepositoryId.computeValueTag(false, 0, false);
        kPreComputed_CodeBaseRMIUnchunked_NoRep = RepositoryId.computeValueTag(true, 0, false);
        kPreComputed_StandardRMIChunked_NoRep = RepositoryId.computeValueTag(false, 0, true);
        kPreComputed_CodeBaseRMIChunked_NoRep = RepositoryId.computeValueTag(true, 0, true);
        kClassDescValueHash = RepositoryId.createHashString(ClassDesc.class, false);
        kClassDescValueRepID = "RMI:javax.rmi.CORBA.ClassDesc" + kClassDescValueHash;
        kSpecialCasesClasses = new Hashtable();
        ASCII_HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        cache = new RepositoryIdCache();
        kNoParamTypes = new Class[0];
        kNoArgs = new java.lang.Object[0];
        preJDK50 = Version.sdkVersionLowerThan(1, 5, 0);
        primeClasses = new HashMap(9, 1.0f);
        defaultServerURL = JDKBridge.getLocalCodebase();
        kSpecialCasesClasses.put(kWStringTypeStr, String.class);
        kSpecialCasesClasses.put(kClassDescTypeStr, Class.class);
        kSpecialCasesClasses.put("", Remote.class);
        kSpecialCasesClasses.put("java.lang.String", String.class);
        primeClasses.put("boolean", Boolean.TYPE);
        primeClasses.put("byte", Byte.TYPE);
        primeClasses.put("char", Character.TYPE);
        primeClasses.put("short", Short.TYPE);
        primeClasses.put("int", Integer.TYPE);
        primeClasses.put("float", Float.TYPE);
        primeClasses.put("long", Long.TYPE);
        primeClasses.put("double", Double.TYPE);
        primeClasses.put("void", Void.TYPE);
        kjava_rmi_Remote = RepositoryId.createForAnyType(Remote.class);
        korg_omg_CORBA_Object = RepositoryId.createForAnyType(Object.class);
    }

    private static final class ClassNameToClassCache {
        private static Map map = new HashMap();
        private static ReferenceQueue queue = new ReferenceQueue();

        private ClassNameToClassCache() {
        }

        private static void processQueue() {
            Value value = (Value)((java.lang.Object)queue.poll());
            while (value != null) {
                value.remove(map, value.getKey());
                value = (Value)((java.lang.Object)queue.poll());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized Class get(String string, String string2, ClassLoader classLoader, RepositoryId repositoryId) throws ClassNotFoundException {
            java.lang.Object object;
            java.lang.Object object2;
            ClassNameToClassCache.processQueue();
            Class clazz = null;
            DataValueListEntry dataValueListEntry = (DataValueListEntry)map.get(string);
            ClassInfo classInfo = null;
            for (object2 = dataValueListEntry; object2 != null; object2 = object2.getNext()) {
                object = (ClassInfo)object2.getData();
                if (!((ClassInfo)object).matches(null, string2, null, classLoader)) continue;
                classInfo = object;
                break;
            }
            if (classInfo != null) {
                if (classInfo.isActualClassFindable()) {
                    clazz = classInfo.getActualClass();
                } else {
                    throw new ClassNotFoundException(string);
                }
            }
            if (clazz == null) {
                try {
                    clazz = repositoryId.loadClass(string2, classLoader);
                }
                finally {
                    classInfo = new ClassInfo(clazz, null, string2, null, classLoader);
                    object2 = clazz == null ? classLoader : clazz;
                    object = new WeakDataValueListEntry(string, classInfo, dataValueListEntry, object2, queue);
                    map.put(string, object);
                }
            }
            return clazz;
        }
    }
}

