/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.rmi.util.ReadOnlyCollection;
import com.ibm.rmi.util.ReadOnlySet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RcuMap
implements Map,
Cloneable {
    private volatile Map currentMap;

    public RcuMap(HashMap hashMap) {
        this.currentMap = (Map)hashMap.clone();
    }

    public RcuMap(IdentityHashMap identityHashMap) {
        this.currentMap = (Map)identityHashMap.clone();
    }

    public RcuMap(RcuMap rcuMap) {
        this.currentMap = rcuMap.currentMap instanceof HashMap ? (Map)((HashMap)rcuMap.currentMap).clone() : (Map)((IdentityHashMap)rcuMap.currentMap).clone();
    }

    public int size() {
        return this.currentMap.size();
    }

    public boolean isEmpty() {
        return this.currentMap.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.currentMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.currentMap.containsValue(object);
    }

    public Object get(Object object) {
        return this.currentMap.get(object);
    }

    private Map cloneCurrentMap() {
        Map map = this.currentMap instanceof HashMap ? (Map)((HashMap)this.currentMap).clone() : (Map)((IdentityHashMap)this.currentMap).clone();
        return map;
    }

    public synchronized Object put(Object object, Object object2) {
        Map map = this.cloneCurrentMap();
        Object object3 = map.put(object, object2);
        this.currentMap = map;
        return object3;
    }

    public synchronized Object remove(Object object) {
        Map map = this.cloneCurrentMap();
        Object v = map.remove(object);
        this.currentMap = map;
        return v;
    }

    public synchronized void putAll(Map map) {
        Map map2 = this.cloneCurrentMap();
        map2.putAll(map);
        this.currentMap = map2;
    }

    public synchronized void clear() {
        this.currentMap = this.currentMap instanceof HashMap ? new HashMap(0) : new IdentityHashMap(0);
    }

    public Set keySet() {
        return new ReadOnlySet(this.currentMap.keySet());
    }

    public Collection values() {
        return new ReadOnlyCollection(this.currentMap.values());
    }

    public Set entrySet() {
        return new ReadOnlySet(this.currentMap.entrySet());
    }

    public int hashCode() {
        return ((Object)this.currentMap).hashCode();
    }

    public boolean equals(Object object) {
        return ((Object)this.currentMap).equals(object);
    }

    public Object clone() {
        return new RcuMap(this);
    }

    private void printObject(Object object, PrintWriter printWriter) {
        if (object == null) {
            printWriter.print("null");
        } else {
            printWriter.print(object.getClass().getName());
            printWriter.print("@");
            printWriter.print(System.identityHashCode(object));
        }
    }

    private void printEntry(Map.Entry entry, PrintWriter printWriter) {
        printWriter.print("\t");
        this.printObject(entry.getKey(), printWriter);
        printWriter.print(" -> ");
        this.printObject(entry.getValue(), printWriter);
        printWriter.println();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Iterator iterator = this.entrySet().iterator();
        if (!iterator.hasNext()) {
            printWriter.println("\tEmpty.");
        } else {
            printWriter.println();
            while (iterator.hasNext()) {
                this.printEntry((Map.Entry)iterator.next(), printWriter);
            }
        }
        return stringWriter.toString();
    }
}

