/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.ras;

import com.ibm.CORBA.ras.ORBRas;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;

public final class Utility {
    private static final String thisClassName = "com.ibm.rmi.ras.Utility";
    private static ResourceBundle bundle = null;
    public static final String TRC_FILE = "orbtrc";
    public static final String MSG_FILE = "orbmsg";
    private static String tmpDir;
    private static DateFormat customTimestamp;

    public static String getMessage(String string) {
        return bundle.getString(string);
    }

    public static String getMessage(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return MessageFormat.format(bundle.getString(string), objectArray);
    }

    public static String getMessage(String string, String[] stringArray) {
        return MessageFormat.format(bundle.getString(string), stringArray);
    }

    public static void setLocaleSpecificResourceBundle(Locale locale) {
        if (locale != null) {
            bundle = ResourceBundle.getBundle("com.ibm.rmi.ras.ORBMessages.properties", locale);
        }
    }

    private static FileWriter newFileWriter(File file, String string) throws IOException {
        final File file2 = file = file.getAbsoluteFile();
        if (((Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file2.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
        })).booleanValue()) {
            file = new File(file, string);
        }
        file.getParentFile().mkdirs();
        return new FileWriter(file.getPath(), true);
    }

    private static Writer newWriter(String string, String string2) {
        if (string.equalsIgnoreCase("stderr")) {
            return new OutputStreamWriter(System.err);
        }
        if (string.equalsIgnoreCase("stdout")) {
            return new OutputStreamWriter(System.out);
        }
        File file = new File(string);
        try {
            return Utility.newFileWriter(file, string2);
        }
        catch (Exception exception) {
            System.err.println("com.ibm.rmi.ras.Utility.newWriter: could not write to " + file.getPath() + " : " + exception.toString());
            try {
                file = new File(tmpDir, string);
                return Utility.newFileWriter(file, string2);
            }
            catch (Exception exception2) {
                System.err.println("com.ibm.rmi.ras.Utility.newWriter: could not write to " + file.getPath() + " : " + exception2.toString());
                return new OutputStreamWriter(System.err);
            }
        }
    }

    public static synchronized PrintWriter newPrintWriter(String string, String string2) {
        String string3 = ORBRas.isRunningInApplet ? "stderr" : string2 + "." + customTimestamp.format(new Date()) + ".txt";
        if (string == null || string.length() == 0) {
            string = string3;
        }
        return new PrintWriter(Utility.newWriter(string, string3));
    }

    static {
        bundle = ResourceBundle.getBundle("com.ibm.rmi.ras.ORBMessages");
        tmpDir = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.io.tmpdir");
            }
        });
        customTimestamp = new SimpleDateFormat("ddMMyyyy.HHmm.ss");
    }
}

