/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.ConnectionKeyGenerator;
import com.ibm.CORBA.channel.IIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.channel.giop.GIOPInboundChannelFactory;
import com.ibm.CORBA.channel.orb.ORBInboundChannelFactory;
import com.ibm.CORBA.iiop.ClientDelegate;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.Profile;
import com.ibm.rmi.channel.IIOPChannelPluginImpl;
import com.ibm.rmi.channel.giop.GIOPConnectionTable;
import com.ibm.rmi.channel.orb.ORBChannelHelper;
import com.ibm.rmi.corba.ClientSubcontract;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.GIOPImpl;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.TransportInterface;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChainGroupData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public class TransportService
implements ORBForTransports,
TransportInterface {
    private static final String CLASS = TransportService.class.getName();
    private static ChannelFramework channelFramework = null;
    private static Object initChainLock = new Object();
    private String chainGroupName = null;
    private ORB theORB;
    private Profile serverProfile = null;
    private IIOPChannelPlugin iiopChannelPlugin = null;
    private GIOPConnectionTable connTable;
    private int numberOfGIOPInChainGroup = 0;

    public TransportService(ORB oRB, GIOPImpl gIOPImpl) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "<init>:112");
        }
        this.theORB = oRB;
        this.iiopChannelPlugin = (IIOPChannelPlugin)oRB.getPlugin(IIOPChannelPlugin.class.getName());
        channelFramework = this.iiopChannelPlugin.getChannelFramework();
        this.connTable = new GIOPConnectionTable(oRB);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "<init>:122", (Object)(this.iiopChannelPlugin + " CFW:" + (channelFramework == null ? "null" : "not null")));
        }
    }

    public ChannelFramework getChannelFramework() {
        return this.iiopChannelPlugin.getChannelFramework();
    }

    public int getConnectTimeout() {
        return this.theORB.getConnectTimeout();
    }

    public Connection get(Profile profile, ClientSubcontract clientSubcontract, String string) {
        return null;
    }

    public Connection get(Profile profile, ClientDelegate clientDelegate, String string) {
        return null;
    }

    public Connection getConnection(IOR iOR, ClientDelegate clientDelegate, String string) {
        Trc.begin2(iOR, clientDelegate, CLASS, "getConnection:159");
        ConnectionKeyGenerator connectionKeyGenerator = this.iiopChannelPlugin.getConnectionKeyGenerator(iOR, clientDelegate, string);
        Trc.info(connectionKeyGenerator, CLASS, "getConnection:167");
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4096L, (Object)this, "getConnection:172", "key generator ", (Object)connectionKeyGenerator);
        }
        Connection connection = null;
        GIOPConnectionKey gIOPConnectionKey = connectionKeyGenerator.getNextKey();
        try {
            boolean bl = true;
            while (bl) {
                Object object;
                Trc.info(gIOPConnectionKey, CLASS, "getConnection:185");
                VirtualConnectionFactory virtualConnectionFactory = gIOPConnectionKey.getVirtualConnectionFactory();
                if (virtualConnectionFactory == null) {
                    object = new IOException("Outbound channel chain may not have been initialized");
                    Trc.ffdc((Exception)object, CLASS, "getConnection:194");
                    throw object;
                }
                object = (OutboundVirtualConnection)virtualConnectionFactory.createConnection();
                Map map = object.getStateMap();
                map.put("ORB", this.theORB);
                try {
                    object.connect((Object)gIOPConnectionKey);
                    connection = (Connection)map.get("Connection");
                    bl = false;
                }
                catch (Exception exception) {
                    GIOPConnectionKey gIOPConnectionKey2 = connectionKeyGenerator.getNextKey();
                    if (gIOPConnectionKey2 == null) {
                        throw exception;
                    }
                    gIOPConnectionKey = gIOPConnectionKey2;
                }
            }
        }
        catch (Exception exception) {
            Trc.warn(exception, CLASS, "getConnection:235");
            if (exception instanceof SystemException) {
                throw (SystemException)((Object)exception);
            }
            TRANSIENT tRANSIENT = new TRANSIENT(exception.toString() + ":host=" + gIOPConnectionKey.getRemoteHost() + ",port=" + gIOPConnectionKey.getRemotePort(), 1229127170, CompletionStatus.COMPLETED_NO);
            tRANSIENT.initCause((Throwable)exception);
            throw tRANSIENT;
        }
        Trc.complete(connection, CLASS, "getConnection:252");
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTransports() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "initTransports:268");
        }
        String string = this.theORB.getORBServerHost();
        int n = this.theORB.getListenerPort();
        Object object = initChainLock;
        synchronized (object) {
            block15: {
                if (this.serverProfile != null) {
                    return;
                }
                if (this.iiopChannelPlugin instanceof IIOPChannelPluginImpl) {
                    ((IIOPChannelPluginImpl)this.iiopChannelPlugin).initTCPChainGroup(string, n);
                }
                this.chainGroupName = this.iiopChannelPlugin.getChainGroupName();
                if (this.chainGroupName == null) {
                    this.serverProfile = new Profile(this.theORB, string, n, null);
                    Trc.info(this.iiopChannelPlugin, ": null chainGroupName", CLASS, "initTransports:302");
                    return;
                }
                try {
                    ChainGroupData chainGroupData = channelFramework.getChainGroup(this.chainGroupName);
                    if (chainGroupData == null) {
                        this.serverProfile = new Profile(this.theORB, string, n, null);
                        Trc.ffdc("Chain Group " + this.chainGroupName + " not found in ChannelFramework", CLASS, "initTransports:317");
                        return;
                    }
                    ChainData[] chainDataArray = chainGroupData.getChains();
                    this.setORBConfigForChainGroup(chainDataArray, n);
                    if (n == 0) {
                        ChainEnquirer chainEnquirer;
                        ChainEnquirer chainEnquirer2 = chainEnquirer = new ChainEnquirer(channelFramework, chainDataArray[0].getName());
                        synchronized (chainEnquirer2) {
                            channelFramework.startChainGroup(this.chainGroupName);
                            n = chainEnquirer.getListenerPort();
                            break block15;
                        }
                    }
                    channelFramework.startChainGroup(this.chainGroupName);
                }
                catch (Exception exception) {
                    Trc.ffdc(exception, CLASS, "initTransports:337");
                    INTERNAL iNTERNAL = new INTERNAL(exception.toString(), 1229125000, CompletionStatus.COMPLETED_NO);
                    iNTERNAL.initCause((Throwable)exception);
                    throw iNTERNAL;
                }
            }
            this.serverProfile = new Profile(this.theORB, string, n, null);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "initTransports:353", (Object)("serverHost=" + string + " serverPort=" + n + " listeningPort=" + n));
        }
    }

    public Profile getServerIIOPProfile() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "getServerIIOPProfile:369");
        }
        if (this.serverProfile == null) {
            this.initTransports();
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "getServerIIOPProfile:377");
        }
        return this.serverProfile;
    }

    public String getHostIPAddress(String string) {
        try {
            return InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "getHostIPAddress:392", (Exception)unknownHostException);
            INTERNAL iNTERNAL = new INTERNAL(unknownHostException.toString(), 1229125046, CompletionStatus.COMPLETED_MAYBE);
            iNTERNAL.initCause((Throwable)unknownHostException);
            throw iNTERNAL;
        }
    }

    private void setORBConfigForChainGroup(ChainData[] chainDataArray, int n) {
        Map map = null;
        Map map2 = null;
        Trc.begin(CLASS, "setORBConfigForChainGroup:422");
        for (int i = 0; i < chainDataArray.length; ++i) {
            ORB oRB;
            ChannelData[] channelDataArray = chainDataArray[i].getChannelList();
            for (int j = 0; j < channelDataArray.length; ++j) {
                Class clazz = channelDataArray[j].getFactoryType();
                if (GIOPInboundChannelFactory.class.isAssignableFrom(clazz)) {
                    map2 = channelDataArray[j].getPropertyBag();
                    ++this.numberOfGIOPInChainGroup;
                    continue;
                }
                if (!ORBInboundChannelFactory.class.isAssignableFrom(clazz)) continue;
                map = channelDataArray[j].getPropertyBag();
            }
            if (map != null) {
                oRB = (ORB)map.get(ORBChannelHelper.ORB);
                if (oRB == null) {
                    map.put(ORBChannelHelper.ORB, this.theORB);
                } else if (oRB != this.theORB) {
                    Trc.ffdc("" + this.theORB + " is now set in " + chainDataArray[i].getName() + " which already has ORB " + oRB, CLASS, "setORBConfigForChainGroup:454");
                    map.put(ORBChannelHelper.ORB, this.theORB);
                }
            }
            if (map2 != null) {
                oRB = (ORB)map2.get("ORB");
                if (oRB == null) {
                    map2.put("ORB", this.theORB);
                } else if (oRB != this.theORB) {
                    Trc.ffdc(this.theORB + " is now set in " + chainDataArray[i].getName() + " which already has ORB " + oRB, CLASS, "setORBConfigForChainGroup:471");
                    map2.put("ORB", this.theORB);
                }
            }
            if (!Trc.enabled()) continue;
            for (int j = 0; j < channelDataArray.length; ++j) {
                Map map3 = channelDataArray[j].getPropertyBag();
                Trc.info("Chain=", chainDataArray[i].getName(), " Channel=", channelDataArray[j].getName(), "[", channelDataArray[j].getFactoryType(), "] properties= ", map3, CLASS, "setORBConfigForChainGroup:483");
            }
        }
        Trc.complete(CLASS, "setORBConfigForChainGroup:488");
    }

    public GIOPConnectionTable getConnectionTable() {
        return this.connTable;
    }

    public void shutdown() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4132L, this, "shutdown:513");
        }
        this.connTable.shutdown();
        this.iiopChannelPlugin.shutdown();
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "shutdown:522");
        }
    }

    public String getUserSpecifiedLocalHost() {
        return this.theORB.getUserSpecifiedLocalHost();
    }

    public String getProperty(String string) {
        return null;
    }

    public void setTransportData(Object object) {
    }

    public Object getTransportData() {
        return null;
    }

    public ORBConnection createORBConnection() {
        return null;
    }

    public ORBConnection createORBConnectionForServer() {
        return null;
    }

    public void createListener(int n) {
        ORBRas.orbTrcLogger.exception(4104L, this, "createListener:562", (Exception)new IOException("You should set up the listener in the ORB chain group"));
    }

    public int getNumberOfGIOPInChainGroup() {
        return this.numberOfGIOPInChainGroup;
    }

    private static class ChainEnquirer
    implements ChainEventListener {
        private final ChannelFramework channelFramework;
        private final String chainName;
        private boolean waitForStart = true;
        private int listeningPort = 0;

        ChainEnquirer(ChannelFramework channelFramework, String string) {
            Trc.begin(CLASS, "ChainStartListener:580");
            this.channelFramework = channelFramework;
            this.chainName = string;
            try {
                channelFramework.addChainEventListener((ChainEventListener)this, string);
                Trc.complete(CLASS, "ChainStartListener:585");
            }
            catch (ChainException chainException) {
                this.endWaiting();
                Trc.fail((Object)chainException, CLASS, "ChainStartListener:588");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void chainStarted(ChainData chainData) {
            Trc.begin(CLASS, "chainStarted:594");
            try {
                this.channelFramework.removeChainEventListener((ChainEventListener)this, this.chainName);
            }
            catch (ChainException chainException) {
                // empty catch block
            }
            ChainEnquirer chainEnquirer = this;
            synchronized (chainEnquirer) {
                if (this.waitForStart) {
                    try {
                        this.listeningPort = this.channelFramework.getListeningPort(this.chainName);
                        Trc.complete(Trc.str(this.listeningPort), CLASS, "chainStarted:606");
                    }
                    catch (Exception exception) {
                        Trc.fail(CLASS, "chainStarted:608");
                    }
                    finally {
                        this.endWaiting();
                    }
                }
            }
        }

        int getListenerPort() {
            Trc.begin(CLASS, "getListenerPort:618");
            while (this.waitForStart) {
                try {
                    Trc.info("waiting ...", CLASS, "getListenerPort:621");
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Trc.complete(Trc.str(this.listeningPort), CLASS, "getListenerPort:626");
            return this.listeningPort;
        }

        private synchronized void endWaiting() {
            this.waitForStart = false;
            this.notify();
        }

        public void chainInitialized(ChainData chainData) {
        }

        public void chainStopped(ChainData chainData) {
            Trc.info(CLASS, "chainStopped:638");
            this.endWaiting();
        }

        public void chainDestroyed(ChainData chainData) {
            Trc.info(CLASS, "chainDestroyed:643");
            this.endWaiting();
        }

        public void chainUpdated(ChainData chainData) {
        }
    }
}

