/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.CloseConnectionMessageException;
import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.giop.GIOPReadContext;
import com.ibm.CORBA.channel.giop.GIOPReadSchedulingPolicy;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.rmi.ORB;
import com.ibm.rmi.channel.giop.GIOPChannelConfig;
import com.ibm.rmi.channel.giop.GIOPConnection;
import com.ibm.rmi.channel.giop.GIOPUtil;
import com.ibm.rmi.channel.giop.MessageWriter;
import com.ibm.rmi.channel.giop.NextMessageHandler;
import com.ibm.rmi.iiop.GIOPMessageContextBase;
import com.ibm.rmi.iiop.GIOPVersionException;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.MessageErrorMessage;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.runtime.ThreadPool;
import com.ibm.wsspi.runtime.ThreadPoolRepositoryManager;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPReadRequestContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;

public class MessageReader
extends GIOPReadContext
implements NextMessageHandler,
Runnable {
    private static final String CLASS = MessageReader.class.getName();
    private static final int GIOP_HDR_LEN = 12;
    private static WsByteBufferPoolManager bBPoolManager = WsByteBufferPoolManagerImpl.getRef();
    private static WsByteBuffer[] EMPTY = new WsByteBuffer[0];
    private static WsByteBuffer[][] EMPTY_SPARES = new WsByteBuffer[][]{EMPTY};
    private VirtualConnection virtualConnection;
    private TCPReadRequestContext tcpContext;
    private ThreadPool threadPool;
    private GIOPChannelConfig giopConfig;
    private String threadPoolName;
    private final GIOPChannelPlugin giopPlugin;
    private final GIOPConnection giopConn;
    private HashMap headerFragments = new HashMap();
    private ORB orb;
    private byte[] msgBytes;
    private final byte[] giopHeaderBytes = new byte[12];
    private WsByteBuffer[][] spareBufferArrays = EMPTY_SPARES;
    private int maxBufferCount = this.spareBufferArrays.length - 1;
    private WsByteBuffer[] buffers = this.spareBufferArrays[0];
    private int bytesAvailable;
    private final boolean isServer;
    private final TransportConnection transport;

    MessageReader(VirtualConnection virtualConnection, TransportConnection transportConnection, TCPReadRequestContext tCPReadRequestContext, GIOPConnection gIOPConnection, GIOPChannelConfig gIOPChannelConfig, GIOPChannelPlugin gIOPChannelPlugin, String string, boolean bl) {
        this.virtualConnection = virtualConnection;
        this.transport = transportConnection;
        this.tcpContext = tCPReadRequestContext;
        this.giopConn = gIOPConnection;
        this.giopConfig = gIOPChannelConfig;
        this.threadPoolName = string;
        this.giopPlugin = gIOPChannelPlugin;
        this.isServer = bl;
    }

    public void complete(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext) {
        Trc.begin(CLASS, "complete:176");
        this.postRead();
        this.grabNewBuffers();
        try {
            this.startReading();
        }
        catch (Exception exception) {
            Trc.warn(exception, CLASS, "complete:188");
            this.handleReadError(exception);
        }
        Trc.complete(CLASS, "complete:192");
    }

    private boolean readGIOPMessage() throws Exception {
        Trc.begin(CLASS, "readGIOPMessage:197");
        boolean bl = true;
        try {
            WsByteBuffer[] wsByteBufferArray = this.getJustOneMessage();
            if (wsByteBufferArray == null) {
                Trc.complete("waiting for partial message, readRequired=false", CLASS, "readGIOPMessage:204");
                return false;
            }
            Trc.info("Got whole message ", Trc.array(wsByteBufferArray), " : ", Trc.hex(wsByteBufferArray), CLASS, "readGIOPMessage:208");
            WsByteBuffer[] wsByteBufferArray2 = null;
            try {
                wsByteBufferArray2 = this.giopPlugin.processIncomingMsg(this.giopConn, wsByteBufferArray);
            }
            catch (CloseConnectionMessageException closeConnectionMessageException) {
                this.giopConn.markCloseConnection(closeConnectionMessageException);
                this.giopConn.closeConnection(closeConnectionMessageException);
                Trc.complete("Received GIOPCloseConnection", " - closing down connection", CLASS, "readGIOPMessage:218");
                return false;
            }
            if (wsByteBufferArray2 == wsByteBufferArray) {
                Trc.info("Plugin returned same array.", CLASS, "readGIOPMessage:223");
            } else {
                Trc.info("Plugin returned different array ", Trc.array(wsByteBufferArray2), " : ", Trc.hex(wsByteBufferArray2), CLASS, "readGIOPMessage:227");
            }
            if (wsByteBufferArray2 != null) {
                bl = MessageReader.dealWithMessage(wsByteBufferArray2, this.giopConn, this.transport, this.giopPlugin, this, this.getOrb(), this.isServer);
                this.releaseBufferArray(wsByteBufferArray2);
            } else {
                Trc.info("Nothing to do for this message", CLASS, "readGIOPMessage:236");
            }
            Trc.complete("readRequired=", Trc.str(bl), CLASS, "readGIOPMessage:240");
        }
        catch (GIOPVersionException gIOPVersionException) {
            Trc.ffdc(gIOPVersionException, CLASS, "readGIOPMessage:242");
            this.sendGIOPExceptionMessage(gIOPVersionException);
            throw gIOPVersionException;
        }
        return bl;
    }

    private static boolean dealWithMessage(WsByteBuffer[] wsByteBufferArray, GIOPConnection gIOPConnection, TransportConnection transportConnection, GIOPChannelPlugin gIOPChannelPlugin, NextMessageHandler nextMessageHandler, ORB oRB, boolean bl) throws Exception {
        GIOPMessageContext gIOPMessageContext;
        boolean bl2;
        int n;
        block17: {
            Trc.begin(CLASS, "dealWithMessage:255");
            int n2 = n = gIOPChannelPlugin.getGiopReadSchedulingPolicy() == GIOPReadSchedulingPolicy.LATE ? Integer.MAX_VALUE : 0;
            if (n-- == 0) {
                n = nextMessageHandler.handleNextMessageEarly();
            }
            byte[] byArray = new byte[12];
            Message message = null;
            GIOPMessageContext gIOPMessageContext2 = null;
            try {
                message = MessageReader.peekGIOPHeader(wsByteBufferArray, byArray);
            }
            catch (GIOPVersionException gIOPVersionException) {
                throw gIOPVersionException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            IIOPInputStream iIOPInputStream = new IIOPInputStream(oRB);
            byte[] byArray2 = WsByteBufferUtils.asByteArray((WsByteBuffer[])wsByteBufferArray);
            Trc.info("Reading in header", Trc.str(byArray2.length), CLASS, "dealWithMessage:279");
            byte[] byArray3 = iIOPInputStream.readWholeHeader(message, byArray2, transportConnection);
            if (n-- == 0) {
                n = nextMessageHandler.handleNextMessageEarly();
            }
            bl2 = true;
            gIOPMessageContext = null;
            try {
                gIOPMessageContext2 = message.createMessageContext(byArray3);
                try {
                    if (gIOPMessageContext2.getServiceContexts() != null) {
                        gIOPConnection.consumeServiceContexts(gIOPMessageContext2);
                    }
                    if (gIOPMessageContext2.getSendingContextBytes() == null) {
                        ((GIOPMessageContextBase)gIOPMessageContext2).setSendingContextBytes(gIOPConnection.getCodeBaseRefBytes());
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                gIOPMessageContext = gIOPChannelPlugin.processIncomingContext(gIOPConnection, gIOPMessageContext2);
            }
            catch (Exception exception) {
                bl2 = false;
                if (bl) {
                    if (gIOPMessageContext2.isResponseExpected()) {
                        gIOPConnection.sendExceptionResponse(exception, gIOPMessageContext2, -1);
                    }
                }
                if (message == null) break block17;
                gIOPChannelPlugin.routeErrorResponse(gIOPConnection, message.getRequestId(), exception);
            }
        }
        if (n-- == 0) {
            n = nextMessageHandler.handleNextMessageEarly();
        }
        if (bl2 && gIOPMessageContext != null) {
            if (bl) {
                gIOPChannelPlugin.routeIncomingRequest(gIOPConnection, gIOPMessageContext);
            } else {
                gIOPChannelPlugin.routeIncomingReply(gIOPConnection, gIOPMessageContext);
            }
        }
        boolean bl3 = n >= 0;
        Trc.complete("readRequired=", Trc.str(bl3), CLASS, "dealWithMessage:335");
        return bl3;
    }

    public int handleNextMessageEarly() {
        int n = 0;
        Trc.begin(CLASS, "handleNextMessageEarly:359");
        try {
            int n2 = this.getThreadPool().execute((Runnable)this);
            if (n2 == 0) {
                n = -1;
                Trc.complete(CLASS, "handleNextMessageEarly:364");
            } else {
                Trc.fail("Thread dispatch failed", CLASS, "handleNextMessageEarly:366");
            }
        }
        catch (ChannelException channelException) {
            Trc.fail((Object)channelException, CLASS, "handleNextMessageEarly:369");
        }
        return n;
    }

    private WsByteBuffer[] getJustOneMessage() throws IOException {
        WsByteBuffer[] wsByteBufferArray;
        int n;
        Trc.info(Trc.str(this.bytesAvailable), " bytes available", CLASS, "ensureMessage:383");
        if (this.bytesAvailable < 12) {
            if (!this.retrieveData(12 - this.bytesAvailable)) {
                Trc.info(Trc.str(12 - this.bytesAvailable), " bytes not available for header yet", CLASS, "ensureMessage:389");
                return null;
            }
            MessageReader.peekBuffersInto(this.buffers, this.giopHeaderBytes);
            n = GIOPUtil.msgSize(this.giopHeaderBytes);
        } else {
            assert (this.buffers[0].remaining() >= 12);
            n = GIOPUtil.msgSize(this.buffers[0]);
        }
        Trc.info("buffers=", Trc.array(this.buffers), ", msgSize=", Trc.str(n), CLASS, "ensureMessage:399");
        if (this.bytesAvailable < 12 + n && !this.retrieveData(12 + n - this.bytesAvailable)) {
            Trc.info(Trc.str(12 + n - this.bytesAvailable), " bytes not available for body yet", CLASS, "ensureMessage:407");
            return null;
        }
        if (12 + n == this.bytesAvailable) {
            wsByteBufferArray = this.buffers;
            this.buffers = EMPTY;
            this.bytesAvailable = 0;
        } else {
            WsByteBuffer[] wsByteBufferArray2;
            int n2;
            int n3 = 0;
            int n4 = this.buffers[n3].remaining();
            for (n2 = 12 + n; n2 > n4; n2 -= n4) {
                n4 = this.buffers[++n3].remaining();
            }
            wsByteBufferArray = this.reserveBufferArray(n3 + 1);
            System.arraycopy(this.buffers, 0, wsByteBufferArray, 0, n3 + 1);
            int n5 = this.buffers.length - wsByteBufferArray.length;
            if (n2 == n4) {
                wsByteBufferArray2 = new WsByteBuffer[n5];
                System.arraycopy(this.buffers, n3 + 1, wsByteBufferArray2, 0, n5);
            } else {
                wsByteBufferArray2 = new WsByteBuffer[n5 + 1];
                wsByteBufferArray[n3].position(n2);
                wsByteBufferArray2[0] = wsByteBufferArray[n3].slice();
                wsByteBufferArray[n3].flip();
                System.arraycopy(this.buffers, n3 + 1, wsByteBufferArray2, 1, n5);
            }
            this.emptyBufferArray(this.buffers);
            this.buffers = wsByteBufferArray2;
            this.bytesAvailable -= n + 12;
        }
        return wsByteBufferArray;
    }

    private WsByteBuffer[] reserveBufferArray(int n) {
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[n];
        return wsByteBufferArray;
    }

    private void releaseBufferArray(WsByteBuffer[] wsByteBufferArray) {
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            wsByteBufferArray[i].release();
        }
        this.emptyBufferArray(wsByteBufferArray);
    }

    private void emptyBufferArray(WsByteBuffer[] wsByteBufferArray) {
        Arrays.fill(wsByteBufferArray, null);
        this.reclaimBufferArray(wsByteBufferArray);
    }

    private void reclaimBufferArray(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null && wsByteBufferArray.length <= this.maxBufferCount) {
            this.spareBufferArrays[wsByteBufferArray.length] = wsByteBufferArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getNextBuffer(int n, Object object) {
        Trc.begin1("reqId=", Trc.str(n), CLASS, "getNextBuffer:506");
        int n2 = this.orb instanceof com.ibm.rmi.corba.ORB ? ((com.ibm.rmi.corba.ORB)this.orb).getFragmentTimeout() : 300;
        Integer n3 = new Integer(n);
        this.headerFragments.put(n3, object);
        Object object2 = object;
        synchronized (object2) {
            object.notify();
            try {
                object.wait(n2);
            }
            catch (InterruptedException interruptedException) {
                Trc.ffdc(interruptedException, CLASS, "getNextBuffer:534");
            }
            if (this.headerFragments.containsKey(n3)) {
                Trc.fail("Timed out waiting for fragment", CLASS, "getNextBuffer:542");
                throw new TIMEOUT("Timed out waiting for fragment");
            }
            Trc.complete("got more header data for request id=", Trc.str(n), CLASS, "getNextBuffer:549");
            return this.msgBytes;
        }
    }

    public TCPConnectionContext getInterface() {
        return this.giopConn;
    }

    public void error(VirtualConnection virtualConnection, TCPReadRequestContext tCPReadRequestContext, IOException iOException) {
        Trc.warn("VC=", virtualConnection, " TCP read=", tCPReadRequestContext, iOException.toString(), CLASS, "error:572");
        this.postRead();
        this.handleReadError(iOException);
    }

    protected void readFirstMessage() throws Exception {
        this.grabNewBuffers();
        try {
            this.startReading();
        }
        catch (Exception exception) {
            Trc.warn(exception, CLASS, "readFirstMessage:593");
            this.handleReadError(exception);
            throw exception;
        }
    }

    private void startReading() throws Exception {
        boolean bl;
        do {
            this.giopConn.updateActivityIndicator();
        } while (bl = this.bytesAvailable == 0 ? this.retrieveData(12) : this.readGIOPMessage());
    }

    private static Message peekGIOPHeader(WsByteBuffer[] wsByteBufferArray, byte[] byArray) throws GIOPVersionException, IOException {
        Trc.begin(CLASS, "peekGIOPHeader:630");
        try {
            Message message = null;
            MessageReader.peekBuffersInto(wsByteBufferArray, byArray);
            message = Message.createMessage(byArray, 0);
            Trc.complete("Message = ", message, CLASS, "peekGIOPHeader:635");
            return message;
        }
        catch (SystemException systemException) {
            Trc.ffdc((Exception)((Object)systemException), CLASS, "peekGIOPHeader:638");
            Trc.fail(CLASS, "peekGIOPHeader:639");
            throw systemException;
        }
        catch (IOException iOException) {
            Trc.warn(iOException, CLASS, "peekGIOPHeader:642");
            Trc.fail(CLASS, "peekGIOPHeader:643");
            throw iOException;
        }
    }

    private static void peekBuffersInto(WsByteBuffer[] wsByteBufferArray, byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4 = Math.min(n - n2, wsByteBufferArray[n3].remaining());
            int n5 = wsByteBufferArray[n3].position();
            wsByteBufferArray[n3].get(byArray, n2, n4);
            wsByteBufferArray[n3].position(n5);
            if ((n2 += n4) == n) break;
            ++n3;
        }
    }

    private boolean retrieveData(int n) throws IOException {
        boolean bl;
        Trc.begin1("numBytes=", Trc.str(n), CLASS, "retrieveData:682");
        if (n <= 0) {
            bl = true;
            Trc.complete("Nothing to do!", CLASS, "retrieveData:685");
        } else {
            this.preRead(n);
            VirtualConnection virtualConnection = this.tcpContext.read((long)n, (TCPReadCompletedCallback)this, false, -1);
            if (virtualConnection == null) {
                bl = false;
                Trc.complete("no more bytes yet - call me back later", CLASS, "retrieveData:693");
            } else {
                this.postRead();
                this.grabNewBuffers();
                bl = true;
                Trc.complete("bytes were available", CLASS, "retrieveData:698");
            }
        }
        return bl;
    }

    protected void retrieveDataLater(int n) throws IOException {
        Trc.info("requested callback: numBytes=", Trc.str(n), CLASS, "retrieveDataLater:709");
        this.preRead(n);
        this.tcpContext.read((long)n, (TCPReadCompletedCallback)this, true, -1);
    }

    private void preRead(int n) throws IOException {
        int n2 = this.giopConfig.getGIOPBufferMode();
        if (n2 == 1) {
            this.tcpContext.setBuffers(null);
            this.tcpContext.setJITAllocateSize(n);
        } else if (n2 == 3) {
            WsByteBuffer wsByteBuffer = bBPoolManager.allocateDirect(n);
            wsByteBuffer.limit(n);
            this.tcpContext.setBuffer(wsByteBuffer);
        }
        boolean bl = this.virtualConnection.requestPermissionToRead();
        if (!bl) {
            throw new IOException("request to read failed");
        }
    }

    private void postRead() {
        this.virtualConnection.setReadStateToDone();
    }

    private void discardBuffers(int n) {
        if (n == 0) {
            Trc.info("nothing to do", CLASS, "discardBuffers:764");
        } else {
            Trc.info("discarding ", Trc.str(n), " buffers of ", Trc.str(this.buffers.length), CLASS, "discardBuffers:767");
            int n2 = this.buffers.length - n;
            System.arraycopy(this.buffers, n, this.spareBufferArrays[n2], 0, n2);
            assert (this.buffers != this.spareBufferArrays[n2]);
            Arrays.fill(this.buffers, null);
            this.buffers = this.spareBufferArrays[n2];
        }
    }

    private void grabNewBuffers() {
        Trc.begin(CLASS, "grabNewBuffers:784");
        WsByteBuffer[] wsByteBufferArray = this.tcpContext.getBuffers();
        WsByteBuffer[] wsByteBufferArray2 = this.buffers;
        if (wsByteBufferArray == null || wsByteBufferArray.length == 0) {
            Trc.complete("nothing to do", CLASS, "grabNewBuffers:788");
            return;
        }
        Trc.info("new buffers retrieved: ", Trc.array(wsByteBufferArray), CLASS, "grabNewBuffers:792");
        WsByteBufferUtils.flip((WsByteBuffer[])wsByteBufferArray);
        this.bytesAvailable += WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray);
        Trc.info("adding ", Trc.str(wsByteBufferArray.length), " new buffers to existing ", Trc.str(this.buffers.length), CLASS, "grabNewBuffers:799");
        this.buffers = this.reserveBufferArray(wsByteBufferArray2.length + wsByteBufferArray.length);
        System.arraycopy(wsByteBufferArray2, 0, this.buffers, 0, wsByteBufferArray2.length);
        Trc.info("Copied old buffers into new array", CLASS, "grabNewBuffers:805");
        this.emptyBufferArray(wsByteBufferArray2);
        System.arraycopy(wsByteBufferArray, 0, this.buffers, wsByteBufferArray2.length, wsByteBufferArray.length);
        Trc.info("Copied new buffers into new array", CLASS, "grabNewBuffers:811");
        Trc.complete("buffers.length=", Trc.str(this.buffers.length), " bytesAvailable=", Trc.str(this.bytesAvailable), CLASS, "grabNewBuffers:813");
    }

    private void growSpareBuffers(int n) {
        Trc.begin1("size=", Trc.str(n), CLASS, "growSpareBuffers:818");
        WsByteBuffer[][] wsByteBufferArrayArray = new WsByteBuffer[n + 1][];
        System.arraycopy(this.spareBufferArrays, 0, wsByteBufferArrayArray, 0, this.spareBufferArrays.length);
        while (this.maxBufferCount <= n) {
            wsByteBufferArrayArray[this.maxBufferCount] = new WsByteBuffer[this.maxBufferCount];
            ++this.maxBufferCount;
        }
        this.spareBufferArrays = wsByteBufferArrayArray;
        Trc.complete("created new spare buffer arrays: new max count = ", Trc.str(this.maxBufferCount), CLASS, "growSpareBuffers:829");
    }

    private ORB getOrb() {
        if (this.orb == null) {
            Map map = this.virtualConnection.getStateMap();
            this.orb = (ORB)((Object)map.get("ORB"));
            if (this.orb == null) {
                this.orb = this.giopConfig.getOrb();
            }
        }
        return this.orb;
    }

    private ThreadPool getThreadPool() throws ChannelException {
        Trc.begin1(this.threadPool, CLASS, "getThreadPool:853");
        if (this.threadPool == null) {
            ChannelFramework channelFramework = ChannelFrameworkFactory.getChannelFramework();
            if (this.threadPoolName != null) {
                this.threadPool = ThreadPoolRepositoryManager.getThreadPoolRepository().getThreadPool(this.threadPoolName);
                if (this.threadPool == null) {
                    String string = this.threadPoolName + " not found";
                    Trc.warn(string, CLASS, "getThreadPool:873");
                    throw new ChannelException(string);
                }
            } else {
                this.threadPool = channelFramework.getDefaultThreadPool();
                if (this.threadPool == null) {
                    String string = "default ThreadPool not found";
                    Trc.warn(string, CLASS, "getThreadPool:884");
                    throw new ChannelException(string);
                }
            }
        }
        Trc.complete(this.threadPool, CLASS, "getThreadPool:890");
        return this.threadPool;
    }

    private void handleReadError(Exception exception) {
        this.releaseBuffers();
        this.giopConn.closeConnection(exception);
    }

    private void releaseBuffers() {
        WsByteBuffer[] wsByteBufferArray = this.tcpContext.getBuffers();
        if (wsByteBufferArray != null) {
            WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])wsByteBufferArray);
        }
    }

    private void sendGIOPExceptionMessage(GIOPVersionException gIOPVersionException) {
        IIOPOutputStream iIOPOutputStream = new IIOPOutputStream((com.ibm.rmi.iiop.ORB)this.getOrb(), null);
        MessageErrorMessage messageErrorMessage = new MessageErrorMessage(1, ((com.ibm.rmi.iiop.ORB)this.getOrb()).getMaxGIOPMinor());
        iIOPOutputStream.setMessage(messageErrorMessage);
        try {
            iIOPOutputStream.writeTo((MessageWriter)this.giopConn.getWriteInterface());
        }
        catch (IOException iOException) {
            Trc.ffdc(iOException, CLASS, "sendGIOPExceptionMessage:935");
        }
    }

    public void run() {
        Trc.begin(CLASS, "run:941");
        try {
            this.startReading();
            Trc.complete(CLASS, "run:944");
        }
        catch (Exception exception) {
            Trc.fail(exception, CLASS, "run:946");
            this.handleReadError(exception);
        }
    }
}

