/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.bootstrap;

import com.ibm.security.bootstrap.RSAPublicKeyImpl;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RSAKeyFactory
extends KeyFactorySpi {
    private static final Class rsaPublicKeySpecClass = RSAPublicKeySpec.class;
    private static final Class rsaPrivateKeySpecClass = RSAPrivateKeySpec.class;
    private static final Class rsaPrivateCrtKeySpecClass = RSAPrivateCrtKeySpec.class;
    private static final Class x509KeySpecClass = X509EncodedKeySpec.class;
    private static final Class pkcs8KeySpecClass = PKCS8EncodedKeySpec.class;
    private static final RSAKeyFactory INSTANCE = new RSAKeyFactory();

    public static RSAKey toRSAKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAKey) {
            RSAKey rSAKey = (RSAKey)((Object)key);
            RSAKeyFactory.checkKey(rSAKey);
            return rSAKey;
        }
        return (RSAKey)((Object)INSTANCE.engineTranslateKey(key));
    }

    private static void checkKey(RSAKey rSAKey) throws InvalidKeyException {
        BigInteger bigInteger;
        if (rSAKey instanceof RSAPublicKey) {
            if (rSAKey instanceof RSAPublicKeyImpl) {
                return;
            }
        } else {
            if (rSAKey instanceof RSAPrivateKey) {
                throw new InvalidKeyException("Bootstrap provider does not support Private Keys.");
            }
            throw new InvalidKeyException("Neither a public nor a private key");
        }
        String string = ((Key)((Object)rSAKey)).getAlgorithm();
        if (!string.equals("RSA")) {
            throw new InvalidKeyException("Not an RSA key: " + string);
        }
        try {
            bigInteger = rSAKey.getModulus();
            if (bigInteger == null) {
                throw new InvalidKeyException("Modulus is missing");
            }
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidKeyException(runtimeException);
        }
        RSAKeyFactory.checkKeyLength(bigInteger);
    }

    static void checkKeyLength(BigInteger bigInteger) throws InvalidKeyException {
        if (bigInteger.bitLength() < 505) {
            throw new InvalidKeyException("RSA keys must be at least 512 bits long");
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        String string = key.getAlgorithm();
        if (!string.equals("RSA")) {
            throw new InvalidKeyException("Not an RSA key: " + string);
        }
        if (key instanceof PublicKey) {
            return this.translatePublicKey((PublicKey)key);
        }
        if (key instanceof PrivateKey) {
            throw new InvalidKeyException("Bootstrap provider does not support Private Keys.");
        }
        throw new InvalidKeyException("Neither a public nor a private key");
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeySpecException(generalSecurityException);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("Bootstrap provider does not support Private Keys.");
    }

    private PublicKey translatePublicKey(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof RSAPublicKey) {
            if (publicKey instanceof RSAPublicKeyImpl) {
                return publicKey;
            }
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            try {
                return new RSAPublicKeyImpl(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidKeyException("Invalid key", runtimeException);
            }
        }
        if ("X.509".equals(publicKey.getFormat())) {
            byte[] byArray = publicKey.getEncoded();
            return new RSAPublicKeyImpl(byArray);
        }
        throw new InvalidKeyException("Public keys must be instance of RSAPublicKey or have X.509 encoding");
    }

    private PrivateKey translatePrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        throw new InvalidKeyException("Bootstrap provider does not support Private Keys.");
    }

    private PublicKey generatePublic(KeySpec keySpec) throws GeneralSecurityException {
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
            return new RSAPublicKeyImpl(x509EncodedKeySpec.getEncoded());
        }
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
            return new RSAPublicKeyImpl(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
        }
        throw new InvalidKeySpecException("Only RSAPublicKeySpec and X509EncodedKeySpec supported for RSA public keys");
    }

    private PrivateKey generatePrivate(KeySpec keySpec) throws GeneralSecurityException {
        throw new InvalidKeyException("Bootstrap provider does not support Private Keys.");
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            key = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException);
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            if (rsaPublicKeySpecClass.isAssignableFrom(clazz)) {
                return (T)new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            if (x509KeySpecClass.isAssignableFrom(clazz)) {
                return (T)new X509EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("KeySpec must be RSAPublicKeySpec or X509EncodedKeySpec for RSA public keys");
        }
        if (key instanceof RSAPrivateKey) {
            throw new InvalidKeySpecException("Bootstrap provider does not support Private Keys.");
        }
        throw new InvalidKeySpecException("Neither public nor private key");
    }
}

