/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.panel.AdvancedPanel;
import com.sun.deploy.panel.GeneralPanel;
import com.sun.deploy.panel.JavaPanel;
import com.sun.deploy.panel.SecurityPanel;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.FileTraceListener;
import com.sun.deploy.util.Trace;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ControlPanel
extends JFrame
implements DeploySIListener,
PropertyChangeListener {
    private static final String JCP_ID;
    private JTabbedPane tabbedPane;
    private GeneralPanel generalPanel;
    private SecurityPanel securityPanel;
    private JavaPanel javaPanel;
    private AdvancedPanel advancedPanel;
    private SingleInstanceImpl _sil = new SingleInstanceImpl();
    private JPanel decisionPanel;
    private JButton okButton;
    private static JButton applyButton;
    private JButton cancelButton;

    public ControlPanel() {
        this._sil.addSingleInstanceListener(this, JCP_ID);
        this.initComponents();
        Config.setControlPanel(this);
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.securityPanel = new SecurityPanel();
        this.javaPanel = new JavaPanel();
        this.generalPanel = new GeneralPanel();
        Config.getBrowserSettings();
        this.advancedPanel = new AdvancedPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(0, 0);
            }
        };
        this.setTitle(this.getMessage("control.panel.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ControlPanel.this.exitForm();
            }
        });
        this.tabbedPane.setName(this.getMessage("control.panel.general"));
        this.tabbedPane.addTab(this.getMessage("control.panel.general"), this.generalPanel);
        this.tabbedPane.addTab(this.getMessage("control.panel.java"), this.javaPanel);
        this.tabbedPane.addTab(this.getMessage("control.panel.security"), this.securityPanel);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.decisionPanel = new JPanel();
        this.decisionPanel.setLayout(new FlowLayout(2));
        this.okButton = this.makeButton("common.ok_btn");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.okBtnActionPerformed(actionEvent);
            }
        });
        this.okButton.setToolTipText(this.getMessage("cpl.ok_btn.tooltip"));
        this.decisionPanel.add(this.okButton);
        this.cancelButton = this.makeButton("common.cancel_btn");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.cancelBtnActionPerformed(actionEvent);
            }
        };
        this.cancelButton.addActionListener(abstractAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke('\u001b'), "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        this.cancelButton.setToolTipText(this.getMessage("cpl.cancel_btn.tooltip"));
        this.decisionPanel.add(this.cancelButton);
        applyButton = this.makeButton("common.apply_btn");
        applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.applyBtnActionPerformed(actionEvent);
            }
        });
        applyButton.setToolTipText(this.getMessage("cpl.apply_btn.tooltip"));
        this.decisionPanel.add(applyButton);
        this.getContentPane().add((Component)this.decisionPanel, "South");
        this.getContentPane().invalidate();
        this.getRootPane().setDefaultButton(this.okButton);
        this.tabbedPane.addTab(this.getMessage("control.panel.advanced"), this.advancedPanel);
        applyButton.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ControlPanel.this.resetBounds();
            }
        });
        this.tabbedPane.addPropertyChangeListener(this);
        ControlPanel.checkPreferredSizes(this.tabbedPane);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("font")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ControlPanel.this.resetBounds();
                }
            });
        }
    }

    public void resetBounds() {
        this.pack();
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.width = Math.min(dimension.width, dimension2.width);
        dimension.height = Math.min(dimension.height, dimension2.height);
        if (dimension.width > 440) {
            int n = dimension.width * dimension.height;
            dimension.width = 440;
            dimension.height = n / 440 + 1;
        }
        this.setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
        this.setResizable(false);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        Config.store();
        Config.setBrowserSettings();
        this.exitForm();
    }

    private void applyBtnActionPerformed(ActionEvent actionEvent) {
        Config.store();
        Config.setBrowserSettings();
        applyButton.setEnabled(false);
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.exitForm();
    }

    private void exitForm() {
        this._sil.removeSingleInstanceListener(this);
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + (i > 0 ? " " : "") + stringArray[i];
        }
        if (SingleInstanceManager.isServerRunning(JCP_ID) && SingleInstanceManager.connectToServer(string)) {
            System.exit(0);
        }
        ControlPanel.initTrace();
        final ControlPanel controlPanel = new ControlPanel();
        if (stringArray.length == 2 && stringArray[0].equals("-tab")) {
            int n = ControlPanel.getTabIndex(stringArray[1], controlPanel);
            controlPanel.tabbedPane.setSelectedIndex(n);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                controlPanel.resetBounds();
                controlPanel.setVisible(true);
            }
        });
    }

    public void newActivation(String[] stringArray) {
        String string;
        if (stringArray.length > 0 && (string = stringArray[0]).startsWith("-tab")) {
            int n = ControlPanel.getTabIndex(string.substring(4), this);
            this.tabbedPane.setSelectedIndex(n);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ControlPanel.this.setExtendedState(ControlPanel.this.getExtendedState() & 0xFFFFFFFE);
                ControlPanel.this.toFront();
            }
        });
    }

    public Object getSingleInstanceListener() {
        return this;
    }

    private static int getTabIndex(String string, ControlPanel controlPanel) {
        int n = 0;
        String string2 = string.trim();
        if (string2.equals("general")) {
            n = 0;
        } else if (string2.equals("security")) {
            n = 1;
        } else if (string2.equals("java")) {
            n = 2;
        } else if (string2.equals("advanced")) {
            n = 3;
        }
        return n;
    }

    private static void initTrace() {
        if (Config.getBooleanProperty("deployment.control.panel.log")) {
            try {
                File file = new File(Config.getProperty("deployment.user.logdir"));
                if (file.exists() && file.isDirectory()) {
                    FileTraceListener fileTraceListener = new FileTraceListener(File.createTempFile("jcp", ".log", file), false);
                    Trace.addTraceListener(fileTraceListener);
                }
                Trace.redirectStdioStderr();
                Trace.setBasicTrace(true);
                Trace.setTempTrace(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public JButton makeButton(String string) {
        JButton jButton = new JButton(this.getMessage(string));
        jButton.setMnemonic(ResourceManager.getVKCode(string + ".mnemonic"));
        return jButton;
    }

    public static void propertyHasChanged() {
        ControlPanel.enableApplyButton();
    }

    private static void enableApplyButton() {
        if (applyButton != null) {
            applyButton.setEnabled(true);
        }
    }

    private static void checkPreferredSizes(Component component) {
        Dimension dimension = component.getPreferredSize();
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                ControlPanel.checkPreferredSizes(componentArray[n++]);
            }
        }
    }

    static {
        DeployUIManager.setLookAndFeel();
        JCP_ID = "JavaControlPanel" + Config.getInstance().getSessionSpecificString();
    }
}

